package software.amazon.awscdk.services.resourcegroups;

/**
 * Properties for defining a <code>CfnGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.resourcegroups.*;
 * CfnGroupProps cfnGroupProps = CfnGroupProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .configuration(List.of(ConfigurationItemProperty.builder()
 *                 .parameters(List.of(ConfigurationParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .type("type")
 *                 .build()))
 *         .description("description")
 *         .resourceQuery(ResourceQueryProperty.builder()
 *                 .query(QueryProperty.builder()
 *                         .resourceTypeFilters(List.of("resourceTypeFilters"))
 *                         .stackIdentifier("stackIdentifier")
 *                         .tagFilters(List.of(TagFilterProperty.builder()
 *                                 .key("key")
 *                                 .values(List.of("values"))
 *                                 .build()))
 *                         .build())
 *                 .type("type")
 *                 .build())
 *         .resources(List.of("resources"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:29.191Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resourcegroups.CfnGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of a resource group.
     * <p>
     * The name must be unique within the AWS Region in which you create the resource. To create multiple resource groups based on the same CloudFormation stack, you must generate unique names for each.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The service configuration currently associated with the resource group and in effect for the members of the resource group.
     * <p>
     * A <code>Configuration</code> consists of one or more <code>ConfigurationItem</code> entries. For information about service configurations for resource groups and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a> in the <em>AWS Resource Groups User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * You can include either a <code>Configuration</code> or a <code>ResourceQuery</code> , but not both.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return null;
    }

    /**
     * The description of the resource group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group.
     * <p>
     * For more information about queries and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/userguide/gettingstarted-query.html">Build queries and groups in AWS Resource Groups</a> in the <em>AWS Resource Groups User Guide</em>
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>You can include either a <code>ResourceQuery</code> or a <code>Configuration</code> , but not both.</li>
     * <li>You can specify the group's membership either by using a <code>ResourceQuery</code> or by using a list of <code>Resources</code> , but not both.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resourcequery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resourcequery</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourceQuery() {
        return null;
    }

    /**
     * A list of the Amazon Resource Names (ARNs) of AWS resources that you want to add to the specified group.
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>You can specify the group membership either by using a list of <code>Resources</code> or by using a <code>ResourceQuery</code> , but not both.</li>
     * <li>You can include a <code>Resources</code> property only if you also specify a <code>Configuration</code> property.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
        return null;
    }

    /**
     * The tag key and value pairs that are attached to the resource group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGroupProps> {
        java.lang.String name;
        java.lang.Object configuration;
        java.lang.String description;
        java.lang.Object resourceQuery;
        java.util.List<java.lang.String> resources;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnGroupProps#getName}
         * @param name The name of a resource group. This parameter is required.
         *             The name must be unique within the AWS Region in which you create the resource. To create multiple resource groups based on the same CloudFormation stack, you must generate unique names for each.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getConfiguration}
         * @param configuration The service configuration currently associated with the resource group and in effect for the members of the resource group.
         *                      A <code>Configuration</code> consists of one or more <code>ConfigurationItem</code> entries. For information about service configurations for resource groups and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a> in the <em>AWS Resource Groups User Guide</em> .
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      You can include either a <code>Configuration</code> or a <code>ResourceQuery</code> , but not both.
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getConfiguration}
         * @param configuration The service configuration currently associated with the resource group and in effect for the members of the resource group.
         *                      A <code>Configuration</code> consists of one or more <code>ConfigurationItem</code> entries. For information about service configurations for resource groups and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a> in the <em>AWS Resource Groups User Guide</em> .
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      You can include either a <code>Configuration</code> or a <code>ResourceQuery</code> , but not both.
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(java.util.List<? extends java.lang.Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getDescription}
         * @param description The description of the resource group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getResourceQuery}
         * @param resourceQuery The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group.
         *                      For more information about queries and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/userguide/gettingstarted-query.html">Build queries and groups in AWS Resource Groups</a> in the <em>AWS Resource Groups User Guide</em>
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      <ul>
         *                      <li>You can include either a <code>ResourceQuery</code> or a <code>Configuration</code> , but not both.</li>
         *                      <li>You can specify the group's membership either by using a <code>ResourceQuery</code> or by using a list of <code>Resources</code> , but not both.</li>
         *                      </ul>
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceQuery(software.amazon.awscdk.IResolvable resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getResourceQuery}
         * @param resourceQuery The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group.
         *                      For more information about queries and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/userguide/gettingstarted-query.html">Build queries and groups in AWS Resource Groups</a> in the <em>AWS Resource Groups User Guide</em>
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      <ul>
         *                      <li>You can include either a <code>ResourceQuery</code> or a <code>Configuration</code> , but not both.</li>
         *                      <li>You can specify the group's membership either by using a <code>ResourceQuery</code> or by using a list of <code>Resources</code> , but not both.</li>
         *                      </ul>
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceQuery(software.amazon.awscdk.services.resourcegroups.CfnGroup.ResourceQueryProperty resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getResources}
         * @param resources A list of the Amazon Resource Names (ARNs) of AWS resources that you want to add to the specified group.
         *                  <blockquote>
         *                  <p>
         *                  <ul>
         *                  <li>You can specify the group membership either by using a list of <code>Resources</code> or by using a <code>ResourceQuery</code> , but not both.</li>
         *                  <li>You can include a <code>Resources</code> property only if you also specify a <code>Configuration</code> property.</li>
         *                  </ul>
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(java.util.List<java.lang.String> resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupProps#getTags}
         * @param tags The tag key and value pairs that are attached to the resource group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGroupProps {
        private final java.lang.String name;
        private final java.lang.Object configuration;
        private final java.lang.String description;
        private final java.lang.Object resourceQuery;
        private final java.util.List<java.lang.String> resources;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceQuery = software.amazon.jsii.Kernel.get(this, "resourceQuery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.configuration = builder.configuration;
            this.description = builder.description;
            this.resourceQuery = builder.resourceQuery;
            this.resources = builder.resources;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getResourceQuery() {
            return this.resourceQuery;
        }

        @Override
        public final java.util.List<java.lang.String> getResources() {
            return this.resources;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getConfiguration() != null) {
                data.set("configuration", om.valueToTree(this.getConfiguration()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getResourceQuery() != null) {
                data.set("resourceQuery", om.valueToTree(this.getResourceQuery()));
            }
            if (this.getResources() != null) {
                data.set("resources", om.valueToTree(this.getResources()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resourcegroups.CfnGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGroupProps.Jsii$Proxy that = (CfnGroupProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.resourceQuery != null ? !this.resourceQuery.equals(that.resourceQuery) : that.resourceQuery != null) return false;
            if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.resourceQuery != null ? this.resourceQuery.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
