package software.amazon.awscdk.services.sagemaker;

/**
 * Creates a configuration for running a SageMaker image as a KernelGateway app.
 * <p>
 * The configuration specifies the Amazon Elastic File System storage volume on the image, and a list of the kernels in the image.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnAppImageConfig cfnAppImageConfig = CfnAppImageConfig.Builder.create(this, "MyCfnAppImageConfig")
 *         .appImageConfigName("appImageConfigName")
 *         // the properties below are optional
 *         .jupyterLabAppImageConfig(JupyterLabAppImageConfigProperty.builder()
 *                 .containerConfig(ContainerConfigProperty.builder()
 *                         .containerArguments(List.of("containerArguments"))
 *                         .containerEntrypoint(List.of("containerEntrypoint"))
 *                         .containerEnvironmentVariables(List.of(CustomImageContainerEnvironmentVariableProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .kernelGatewayImageConfig(KernelGatewayImageConfigProperty.builder()
 *                 .kernelSpecs(List.of(KernelSpecProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .displayName("displayName")
 *                         .build()))
 *                 // the properties below are optional
 *                 .fileSystemConfig(FileSystemConfigProperty.builder()
 *                         .defaultGid(123)
 *                         .defaultUid(123)
 *                         .mountPath("mountPath")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:29.629Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnAppImageConfig")
public class CfnAppImageConfig extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnAppImageConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAppImageConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnAppImageConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAppImageConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnAppImageConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the AppImageConfig, such as <code>arn:aws:sagemaker:us-west-2:account-id:app-image-config/my-app-image-config-name</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAppImageConfigArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAppImageConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the AppImageConfig.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAppImageConfigName() {
        return software.amazon.jsii.Kernel.get(this, "appImageConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the AppImageConfig.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppImageConfigName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "appImageConfigName", java.util.Objects.requireNonNull(value, "appImageConfigName is required"));
    }

    /**
     * The configuration for the file system and the runtime, such as the environment variables and entry point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getJupyterLabAppImageConfig() {
        return software.amazon.jsii.Kernel.get(this, "jupyterLabAppImageConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for the file system and the runtime, such as the environment variables and entry point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJupyterLabAppImageConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "jupyterLabAppImageConfig", value);
    }

    /**
     * The configuration for the file system and the runtime, such as the environment variables and entry point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJupyterLabAppImageConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnAppImageConfig.JupyterLabAppImageConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "jupyterLabAppImageConfig", value);
    }

    /**
     * The configuration for the file system and kernels in the SageMaker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKernelGatewayImageConfig() {
        return software.amazon.jsii.Kernel.get(this, "kernelGatewayImageConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for the file system and kernels in the SageMaker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKernelGatewayImageConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kernelGatewayImageConfig", value);
    }

    /**
     * The configuration for the file system and kernels in the SageMaker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKernelGatewayImageConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "kernelGatewayImageConfig", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The configuration used to run the application image container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ContainerConfigProperty containerConfigProperty = ContainerConfigProperty.builder()
     *         .containerArguments(List.of("containerArguments"))
     *         .containerEntrypoint(List.of("containerEntrypoint"))
     *         .containerEnvironmentVariables(List.of(CustomImageContainerEnvironmentVariableProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.ContainerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The arguments for the container when you're running the application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html#cfn-sagemaker-appimageconfig-containerconfig-containerarguments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html#cfn-sagemaker-appimageconfig-containerconfig-containerarguments</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerArguments() {
            return null;
        }

        /**
         * The entrypoint used to run the application in the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html#cfn-sagemaker-appimageconfig-containerconfig-containerentrypoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html#cfn-sagemaker-appimageconfig-containerconfig-containerentrypoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerEntrypoint() {
            return null;
        }

        /**
         * The environment variables to set in the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html#cfn-sagemaker-appimageconfig-containerconfig-containerenvironmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-containerconfig.html#cfn-sagemaker-appimageconfig-containerconfig-containerenvironmentvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainerEnvironmentVariables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerConfigProperty> {
            java.util.List<java.lang.String> containerArguments;
            java.util.List<java.lang.String> containerEntrypoint;
            java.lang.Object containerEnvironmentVariables;

            /**
             * Sets the value of {@link ContainerConfigProperty#getContainerArguments}
             * @param containerArguments The arguments for the container when you're running the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerArguments(java.util.List<java.lang.String> containerArguments) {
                this.containerArguments = containerArguments;
                return this;
            }

            /**
             * Sets the value of {@link ContainerConfigProperty#getContainerEntrypoint}
             * @param containerEntrypoint The entrypoint used to run the application in the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerEntrypoint(java.util.List<java.lang.String> containerEntrypoint) {
                this.containerEntrypoint = containerEntrypoint;
                return this;
            }

            /**
             * Sets the value of {@link ContainerConfigProperty#getContainerEnvironmentVariables}
             * @param containerEnvironmentVariables The environment variables to set in the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerEnvironmentVariables(software.amazon.awscdk.IResolvable containerEnvironmentVariables) {
                this.containerEnvironmentVariables = containerEnvironmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link ContainerConfigProperty#getContainerEnvironmentVariables}
             * @param containerEnvironmentVariables The environment variables to set in the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerEnvironmentVariables(java.util.List<? extends java.lang.Object> containerEnvironmentVariables) {
                this.containerEnvironmentVariables = containerEnvironmentVariables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerConfigProperty {
            private final java.util.List<java.lang.String> containerArguments;
            private final java.util.List<java.lang.String> containerEntrypoint;
            private final java.lang.Object containerEnvironmentVariables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerArguments = software.amazon.jsii.Kernel.get(this, "containerArguments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.containerEntrypoint = software.amazon.jsii.Kernel.get(this, "containerEntrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.containerEnvironmentVariables = software.amazon.jsii.Kernel.get(this, "containerEnvironmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerArguments = builder.containerArguments;
                this.containerEntrypoint = builder.containerEntrypoint;
                this.containerEnvironmentVariables = builder.containerEnvironmentVariables;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerArguments() {
                return this.containerArguments;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerEntrypoint() {
                return this.containerEntrypoint;
            }

            @Override
            public final java.lang.Object getContainerEnvironmentVariables() {
                return this.containerEnvironmentVariables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerArguments() != null) {
                    data.set("containerArguments", om.valueToTree(this.getContainerArguments()));
                }
                if (this.getContainerEntrypoint() != null) {
                    data.set("containerEntrypoint", om.valueToTree(this.getContainerEntrypoint()));
                }
                if (this.getContainerEnvironmentVariables() != null) {
                    data.set("containerEnvironmentVariables", om.valueToTree(this.getContainerEnvironmentVariables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.ContainerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerConfigProperty.Jsii$Proxy that = (ContainerConfigProperty.Jsii$Proxy) o;

                if (this.containerArguments != null ? !this.containerArguments.equals(that.containerArguments) : that.containerArguments != null) return false;
                if (this.containerEntrypoint != null ? !this.containerEntrypoint.equals(that.containerEntrypoint) : that.containerEntrypoint != null) return false;
                return this.containerEnvironmentVariables != null ? this.containerEnvironmentVariables.equals(that.containerEnvironmentVariables) : that.containerEnvironmentVariables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerArguments != null ? this.containerArguments.hashCode() : 0;
                result = 31 * result + (this.containerEntrypoint != null ? this.containerEntrypoint.hashCode() : 0);
                result = 31 * result + (this.containerEnvironmentVariables != null ? this.containerEnvironmentVariables.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The environment variables to set in the container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CustomImageContainerEnvironmentVariableProperty customImageContainerEnvironmentVariableProperty = CustomImageContainerEnvironmentVariableProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-customimagecontainerenvironmentvariable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-customimagecontainerenvironmentvariable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomImageContainerEnvironmentVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomImageContainerEnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key that identifies a container environment variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-customimagecontainerenvironmentvariable.html#cfn-sagemaker-appimageconfig-customimagecontainerenvironmentvariable-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-customimagecontainerenvironmentvariable.html#cfn-sagemaker-appimageconfig-customimagecontainerenvironmentvariable-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value of the container environment variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-customimagecontainerenvironmentvariable.html#cfn-sagemaker-appimageconfig-customimagecontainerenvironmentvariable-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-customimagecontainerenvironmentvariable.html#cfn-sagemaker-appimageconfig-customimagecontainerenvironmentvariable-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link CustomImageContainerEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomImageContainerEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomImageContainerEnvironmentVariableProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link CustomImageContainerEnvironmentVariableProperty#getKey}
             * @param key The key that identifies a container environment variable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link CustomImageContainerEnvironmentVariableProperty#getValue}
             * @param value The value of the container environment variable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomImageContainerEnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomImageContainerEnvironmentVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomImageContainerEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomImageContainerEnvironmentVariableProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.CustomImageContainerEnvironmentVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomImageContainerEnvironmentVariableProperty.Jsii$Proxy that = (CustomImageContainerEnvironmentVariableProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The Amazon Elastic File System storage configuration for a SageMaker image.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * FileSystemConfigProperty fileSystemConfigProperty = FileSystemConfigProperty.builder()
     *         .defaultGid(123)
     *         .defaultUid(123)
     *         .mountPath("mountPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.FileSystemConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FileSystemConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FileSystemConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default POSIX group ID (GID).
         * <p>
         * If not specified, defaults to <code>100</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultgid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultgid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultGid() {
            return null;
        }

        /**
         * The default POSIX user ID (UID).
         * <p>
         * If not specified, defaults to <code>1000</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultuid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultuid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultUid() {
            return null;
        }

        /**
         * The path within the image to mount the user's EFS home directory.
         * <p>
         * The directory should be empty. If not specified, defaults to * /home/sagemaker-user* .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-mountpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-mountpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMountPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FileSystemConfigProperty> {
            java.lang.Number defaultGid;
            java.lang.Number defaultUid;
            java.lang.String mountPath;

            /**
             * Sets the value of {@link FileSystemConfigProperty#getDefaultGid}
             * @param defaultGid The default POSIX group ID (GID).
             *                   If not specified, defaults to <code>100</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultGid(java.lang.Number defaultGid) {
                this.defaultGid = defaultGid;
                return this;
            }

            /**
             * Sets the value of {@link FileSystemConfigProperty#getDefaultUid}
             * @param defaultUid The default POSIX user ID (UID).
             *                   If not specified, defaults to <code>1000</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultUid(java.lang.Number defaultUid) {
                this.defaultUid = defaultUid;
                return this;
            }

            /**
             * Sets the value of {@link FileSystemConfigProperty#getMountPath}
             * @param mountPath The path within the image to mount the user's EFS home directory.
             *                  The directory should be empty. If not specified, defaults to * /home/sagemaker-user* .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPath(java.lang.String mountPath) {
                this.mountPath = mountPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FileSystemConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FileSystemConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemConfigProperty {
            private final java.lang.Number defaultGid;
            private final java.lang.Number defaultUid;
            private final java.lang.String mountPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultGid = software.amazon.jsii.Kernel.get(this, "defaultGid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.defaultUid = software.amazon.jsii.Kernel.get(this, "defaultUid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mountPath = software.amazon.jsii.Kernel.get(this, "mountPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultGid = builder.defaultGid;
                this.defaultUid = builder.defaultUid;
                this.mountPath = builder.mountPath;
            }

            @Override
            public final java.lang.Number getDefaultGid() {
                return this.defaultGid;
            }

            @Override
            public final java.lang.Number getDefaultUid() {
                return this.defaultUid;
            }

            @Override
            public final java.lang.String getMountPath() {
                return this.mountPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultGid() != null) {
                    data.set("defaultGid", om.valueToTree(this.getDefaultGid()));
                }
                if (this.getDefaultUid() != null) {
                    data.set("defaultUid", om.valueToTree(this.getDefaultUid()));
                }
                if (this.getMountPath() != null) {
                    data.set("mountPath", om.valueToTree(this.getMountPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.FileSystemConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FileSystemConfigProperty.Jsii$Proxy that = (FileSystemConfigProperty.Jsii$Proxy) o;

                if (this.defaultGid != null ? !this.defaultGid.equals(that.defaultGid) : that.defaultGid != null) return false;
                if (this.defaultUid != null ? !this.defaultUid.equals(that.defaultUid) : that.defaultUid != null) return false;
                return this.mountPath != null ? this.mountPath.equals(that.mountPath) : that.mountPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultGid != null ? this.defaultGid.hashCode() : 0;
                result = 31 * result + (this.defaultUid != null ? this.defaultUid.hashCode() : 0);
                result = 31 * result + (this.mountPath != null ? this.mountPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the file system and kernels in a SageMaker image running as a JupyterLab app.
     * <p>
     * The <code>FileSystemConfig</code> object is not supported.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * JupyterLabAppImageConfigProperty jupyterLabAppImageConfigProperty = JupyterLabAppImageConfigProperty.builder()
     *         .containerConfig(ContainerConfigProperty.builder()
     *                 .containerArguments(List.of("containerArguments"))
     *                 .containerEntrypoint(List.of("containerEntrypoint"))
     *                 .containerEnvironmentVariables(List.of(CustomImageContainerEnvironmentVariableProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-jupyterlabappimageconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-jupyterlabappimageconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.JupyterLabAppImageConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(JupyterLabAppImageConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JupyterLabAppImageConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration used to run the application image container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-jupyterlabappimageconfig.html#cfn-sagemaker-appimageconfig-jupyterlabappimageconfig-containerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-jupyterlabappimageconfig.html#cfn-sagemaker-appimageconfig-jupyterlabappimageconfig-containerconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainerConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JupyterLabAppImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JupyterLabAppImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JupyterLabAppImageConfigProperty> {
            java.lang.Object containerConfig;

            /**
             * Sets the value of {@link JupyterLabAppImageConfigProperty#getContainerConfig}
             * @param containerConfig The configuration used to run the application image container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerConfig(software.amazon.awscdk.IResolvable containerConfig) {
                this.containerConfig = containerConfig;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppImageConfigProperty#getContainerConfig}
             * @param containerConfig The configuration used to run the application image container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerConfig(software.amazon.awscdk.services.sagemaker.CfnAppImageConfig.ContainerConfigProperty containerConfig) {
                this.containerConfig = containerConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JupyterLabAppImageConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JupyterLabAppImageConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JupyterLabAppImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JupyterLabAppImageConfigProperty {
            private final java.lang.Object containerConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerConfig = software.amazon.jsii.Kernel.get(this, "containerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerConfig = builder.containerConfig;
            }

            @Override
            public final java.lang.Object getContainerConfig() {
                return this.containerConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerConfig() != null) {
                    data.set("containerConfig", om.valueToTree(this.getContainerConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.JupyterLabAppImageConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JupyterLabAppImageConfigProperty.Jsii$Proxy that = (JupyterLabAppImageConfigProperty.Jsii$Proxy) o;

                return this.containerConfig != null ? this.containerConfig.equals(that.containerConfig) : that.containerConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerConfig != null ? this.containerConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * KernelGatewayImageConfigProperty kernelGatewayImageConfigProperty = KernelGatewayImageConfigProperty.builder()
     *         .kernelSpecs(List.of(KernelSpecProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .displayName("displayName")
     *                 .build()))
     *         // the properties below are optional
     *         .fileSystemConfig(FileSystemConfigProperty.builder()
     *                 .defaultGid(123)
     *                 .defaultUid(123)
     *                 .mountPath("mountPath")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(KernelGatewayImageConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KernelGatewayImageConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specification of the Jupyter kernels in the image.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-kernelspecs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-kernelspecs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKernelSpecs();

        /**
         * The Amazon Elastic File System storage configuration for a SageMaker image.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-filesystemconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-filesystemconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KernelGatewayImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KernelGatewayImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KernelGatewayImageConfigProperty> {
            java.lang.Object kernelSpecs;
            java.lang.Object fileSystemConfig;

            /**
             * Sets the value of {@link KernelGatewayImageConfigProperty#getKernelSpecs}
             * @param kernelSpecs The specification of the Jupyter kernels in the image. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelSpecs(software.amazon.awscdk.IResolvable kernelSpecs) {
                this.kernelSpecs = kernelSpecs;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayImageConfigProperty#getKernelSpecs}
             * @param kernelSpecs The specification of the Jupyter kernels in the image. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelSpecs(java.util.List<? extends java.lang.Object> kernelSpecs) {
                this.kernelSpecs = kernelSpecs;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayImageConfigProperty#getFileSystemConfig}
             * @param fileSystemConfig The Amazon Elastic File System storage configuration for a SageMaker image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemConfig(software.amazon.awscdk.IResolvable fileSystemConfig) {
                this.fileSystemConfig = fileSystemConfig;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayImageConfigProperty#getFileSystemConfig}
             * @param fileSystemConfig The Amazon Elastic File System storage configuration for a SageMaker image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemConfig(software.amazon.awscdk.services.sagemaker.CfnAppImageConfig.FileSystemConfigProperty fileSystemConfig) {
                this.fileSystemConfig = fileSystemConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KernelGatewayImageConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KernelGatewayImageConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KernelGatewayImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KernelGatewayImageConfigProperty {
            private final java.lang.Object kernelSpecs;
            private final java.lang.Object fileSystemConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kernelSpecs = software.amazon.jsii.Kernel.get(this, "kernelSpecs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fileSystemConfig = software.amazon.jsii.Kernel.get(this, "fileSystemConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kernelSpecs = java.util.Objects.requireNonNull(builder.kernelSpecs, "kernelSpecs is required");
                this.fileSystemConfig = builder.fileSystemConfig;
            }

            @Override
            public final java.lang.Object getKernelSpecs() {
                return this.kernelSpecs;
            }

            @Override
            public final java.lang.Object getFileSystemConfig() {
                return this.fileSystemConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kernelSpecs", om.valueToTree(this.getKernelSpecs()));
                if (this.getFileSystemConfig() != null) {
                    data.set("fileSystemConfig", om.valueToTree(this.getFileSystemConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KernelGatewayImageConfigProperty.Jsii$Proxy that = (KernelGatewayImageConfigProperty.Jsii$Proxy) o;

                if (!kernelSpecs.equals(that.kernelSpecs)) return false;
                return this.fileSystemConfig != null ? this.fileSystemConfig.equals(that.fileSystemConfig) : that.fileSystemConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kernelSpecs.hashCode();
                result = 31 * result + (this.fileSystemConfig != null ? this.fileSystemConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The specification of a Jupyter kernel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * KernelSpecProperty kernelSpecProperty = KernelSpecProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .displayName("displayName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.KernelSpecProperty")
    @software.amazon.jsii.Jsii.Proxy(KernelSpecProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KernelSpecProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Jupyter kernel in the image.
         * <p>
         * This value is case sensitive.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The display name of the kernel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-displayname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KernelSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KernelSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KernelSpecProperty> {
            java.lang.String name;
            java.lang.String displayName;

            /**
             * Sets the value of {@link KernelSpecProperty#getName}
             * @param name The name of the Jupyter kernel in the image. This parameter is required.
             *             This value is case sensitive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link KernelSpecProperty#getDisplayName}
             * @param displayName The display name of the kernel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayName(java.lang.String displayName) {
                this.displayName = displayName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KernelSpecProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KernelSpecProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KernelSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KernelSpecProperty {
            private final java.lang.String name;
            private final java.lang.String displayName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.displayName = builder.displayName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDisplayName() {
                return this.displayName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getDisplayName() != null) {
                    data.set("displayName", om.valueToTree(this.getDisplayName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnAppImageConfig.KernelSpecProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KernelSpecProperty.Jsii$Proxy that = (KernelSpecProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.displayName != null ? this.displayName.equals(that.displayName) : that.displayName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnAppImageConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnAppImageConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnAppImageConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnAppImageConfigProps.Builder();
        }

        /**
         * The name of the AppImageConfig.
         * <p>
         * Must be unique to your account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-appimageconfigname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-appimageconfigname</a>
         * @param appImageConfigName The name of the AppImageConfig. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appImageConfigName(final java.lang.String appImageConfigName) {
            this.props.appImageConfigName(appImageConfigName);
            return this;
        }

        /**
         * The configuration for the file system and the runtime, such as the environment variables and entry point.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-jupyterlabappimageconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-jupyterlabappimageconfig</a>
         * @param jupyterLabAppImageConfig The configuration for the file system and the runtime, such as the environment variables and entry point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jupyterLabAppImageConfig(final software.amazon.awscdk.IResolvable jupyterLabAppImageConfig) {
            this.props.jupyterLabAppImageConfig(jupyterLabAppImageConfig);
            return this;
        }
        /**
         * The configuration for the file system and the runtime, such as the environment variables and entry point.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-jupyterlabappimageconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-jupyterlabappimageconfig</a>
         * @param jupyterLabAppImageConfig The configuration for the file system and the runtime, such as the environment variables and entry point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jupyterLabAppImageConfig(final software.amazon.awscdk.services.sagemaker.CfnAppImageConfig.JupyterLabAppImageConfigProperty jupyterLabAppImageConfig) {
            this.props.jupyterLabAppImageConfig(jupyterLabAppImageConfig);
            return this;
        }

        /**
         * The configuration for the file system and kernels in the SageMaker image.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig</a>
         * @param kernelGatewayImageConfig The configuration for the file system and kernels in the SageMaker image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kernelGatewayImageConfig(final software.amazon.awscdk.IResolvable kernelGatewayImageConfig) {
            this.props.kernelGatewayImageConfig(kernelGatewayImageConfig);
            return this;
        }
        /**
         * The configuration for the file system and kernels in the SageMaker image.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig</a>
         * @param kernelGatewayImageConfig The configuration for the file system and kernels in the SageMaker image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kernelGatewayImageConfig(final software.amazon.awscdk.services.sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty kernelGatewayImageConfig) {
            this.props.kernelGatewayImageConfig(kernelGatewayImageConfig);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnAppImageConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnAppImageConfig build() {
            return new software.amazon.awscdk.services.sagemaker.CfnAppImageConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
