package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnPipeline</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * Object parallelismConfiguration;
 * Object pipelineDefinition;
 * CfnPipelineProps cfnPipelineProps = CfnPipelineProps.builder()
 *         .pipelineDefinition(pipelineDefinition)
 *         .pipelineName("pipelineName")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .parallelismConfiguration(parallelismConfiguration)
 *         .pipelineDescription("pipelineDescription")
 *         .pipelineDisplayName("pipelineDisplayName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:29.891Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnPipelineProps")
@software.amazon.jsii.Jsii.Proxy(CfnPipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The definition of the pipeline.
     * <p>
     * This can be either a JSON string or an Amazon S3 location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedefinition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPipelineDefinition();

    /**
     * The name of the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPipelineName();

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to execute the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The parallelism configuration applied to the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-parallelismconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-parallelismconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParallelismConfiguration() {
        return null;
    }

    /**
     * The description of the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPipelineDescription() {
        return null;
    }

    /**
     * The display name of the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedisplayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPipelineDisplayName() {
        return null;
    }

    /**
     * The tags of the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPipelineProps> {
        java.lang.Object pipelineDefinition;
        java.lang.String pipelineName;
        java.lang.String roleArn;
        java.lang.Object parallelismConfiguration;
        java.lang.String pipelineDescription;
        java.lang.String pipelineDisplayName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineDefinition}
         * @param pipelineDefinition The definition of the pipeline. This parameter is required.
         *                           This can be either a JSON string or an Amazon S3 location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineDefinition(java.lang.Object pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineName}
         * @param pipelineName The name of the pipeline. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(java.lang.String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role used to execute the pipeline. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getParallelismConfiguration}
         * @param parallelismConfiguration The parallelism configuration applied to the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelismConfiguration(java.lang.Object parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineDescription}
         * @param pipelineDescription The description of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineDescription(java.lang.String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineDisplayName}
         * @param pipelineDisplayName The display name of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineDisplayName(java.lang.String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getTags}
         * @param tags The tags of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPipelineProps {
        private final java.lang.Object pipelineDefinition;
        private final java.lang.String pipelineName;
        private final java.lang.String roleArn;
        private final java.lang.Object parallelismConfiguration;
        private final java.lang.String pipelineDescription;
        private final java.lang.String pipelineDisplayName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.pipelineDefinition = software.amazon.jsii.Kernel.get(this, "pipelineDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pipelineName = software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parallelismConfiguration = software.amazon.jsii.Kernel.get(this, "parallelismConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pipelineDescription = software.amazon.jsii.Kernel.get(this, "pipelineDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pipelineDisplayName = software.amazon.jsii.Kernel.get(this, "pipelineDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.pipelineDefinition = java.util.Objects.requireNonNull(builder.pipelineDefinition, "pipelineDefinition is required");
            this.pipelineName = java.util.Objects.requireNonNull(builder.pipelineName, "pipelineName is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.parallelismConfiguration = builder.parallelismConfiguration;
            this.pipelineDescription = builder.pipelineDescription;
            this.pipelineDisplayName = builder.pipelineDisplayName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getPipelineDefinition() {
            return this.pipelineDefinition;
        }

        @Override
        public final java.lang.String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getParallelismConfiguration() {
            return this.parallelismConfiguration;
        }

        @Override
        public final java.lang.String getPipelineDescription() {
            return this.pipelineDescription;
        }

        @Override
        public final java.lang.String getPipelineDisplayName() {
            return this.pipelineDisplayName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("pipelineDefinition", om.valueToTree(this.getPipelineDefinition()));
            data.set("pipelineName", om.valueToTree(this.getPipelineName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getParallelismConfiguration() != null) {
                data.set("parallelismConfiguration", om.valueToTree(this.getParallelismConfiguration()));
            }
            if (this.getPipelineDescription() != null) {
                data.set("pipelineDescription", om.valueToTree(this.getPipelineDescription()));
            }
            if (this.getPipelineDisplayName() != null) {
                data.set("pipelineDisplayName", om.valueToTree(this.getPipelineDisplayName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnPipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPipelineProps.Jsii$Proxy that = (CfnPipelineProps.Jsii$Proxy) o;

            if (!pipelineDefinition.equals(that.pipelineDefinition)) return false;
            if (!pipelineName.equals(that.pipelineName)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.parallelismConfiguration != null ? !this.parallelismConfiguration.equals(that.parallelismConfiguration) : that.parallelismConfiguration != null) return false;
            if (this.pipelineDescription != null ? !this.pipelineDescription.equals(that.pipelineDescription) : that.pipelineDescription != null) return false;
            if (this.pipelineDisplayName != null ? !this.pipelineDisplayName.equals(that.pipelineDisplayName) : that.pipelineDisplayName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.pipelineDefinition.hashCode();
            result = 31 * result + (this.pipelineName.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.parallelismConfiguration != null ? this.parallelismConfiguration.hashCode() : 0);
            result = 31 * result + (this.pipelineDescription != null ? this.pipelineDescription.hashCode() : 0);
            result = 31 * result + (this.pipelineDisplayName != null ? this.pipelineDisplayName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
