package software.amazon.awscdk.services.shield;

/**
 * Properties for defining a <code>CfnProtection</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.shield.*;
 * Object block;
 * Object count;
 * CfnProtectionProps cfnProtectionProps = CfnProtectionProps.builder()
 *         .name("name")
 *         .resourceArn("resourceArn")
 *         // the properties below are optional
 *         .applicationLayerAutomaticResponseConfiguration(ApplicationLayerAutomaticResponseConfigurationProperty.builder()
 *                 .action(ActionProperty.builder()
 *                         .block(block)
 *                         .count(count)
 *                         .build())
 *                 .status("status")
 *                 .build())
 *         .healthCheckArns(List.of("healthCheckArns"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:30.329Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_shield.CfnProtectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnProtectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProtectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the protection. For example, <code>My CloudFront distributions</code> .
     * <p>
     * <blockquote>
     * <p>
     * If you change the name of an existing protection, Shield Advanced deletes the protection and replaces it with a new one. While this is happening, the protection isn't available on the AWS resource.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The ARN (Amazon Resource Name) of the AWS resource that is protected.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-resourcearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

    /**
     * The automatic application layer DDoS mitigation settings for the protection.
     * <p>
     * This configuration determines whether Shield Advanced automatically manages rules in the web ACL in order to respond to application layer events that Shield Advanced determines to be DDoS attacks.
     * <p>
     * If you use AWS CloudFormation to manage the web ACLs that you use with Shield Advanced automatic mitigation, see the additional guidance about web ACL management in the <code>AWS::WAFv2::WebACL</code> resource description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-applicationlayerautomaticresponseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-applicationlayerautomaticresponseconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationLayerAutomaticResponseConfiguration() {
        return null;
    }

    /**
     * The ARN (Amazon Resource Name) of the health check to associate with the protection.
     * <p>
     * Health-based detection provides improved responsiveness and accuracy in attack detection and mitigation.
     * <p>
     * You can use this option with any resource type except for Route 53 hosted zones.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/ddos-advanced-health-checks.html">Configuring health-based detection using health checks</a> in the <em>AWS Shield Advanced Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-healthcheckarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-healthcheckarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHealthCheckArns() {
        return null;
    }

    /**
     * Key:value pairs associated with an AWS resource.
     * <p>
     * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnProtectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProtectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProtectionProps> {
        java.lang.String name;
        java.lang.String resourceArn;
        java.lang.Object applicationLayerAutomaticResponseConfiguration;
        java.util.List<java.lang.String> healthCheckArns;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnProtectionProps#getName}
         * @param name The name of the protection. For example, <code>My CloudFront distributions</code> . This parameter is required.
         *             <blockquote>
         *             <p>
         *             If you change the name of an existing protection, Shield Advanced deletes the protection and replaces it with a new one. While this is happening, the protection isn't available on the AWS resource.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnProtectionProps#getResourceArn}
         * @param resourceArn The ARN (Amazon Resource Name) of the AWS resource that is protected. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArn(java.lang.String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnProtectionProps#getApplicationLayerAutomaticResponseConfiguration}
         * @param applicationLayerAutomaticResponseConfiguration The automatic application layer DDoS mitigation settings for the protection.
         *                                                       This configuration determines whether Shield Advanced automatically manages rules in the web ACL in order to respond to application layer events that Shield Advanced determines to be DDoS attacks.
         *                                                       <p>
         *                                                       If you use AWS CloudFormation to manage the web ACLs that you use with Shield Advanced automatic mitigation, see the additional guidance about web ACL management in the <code>AWS::WAFv2::WebACL</code> resource description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationLayerAutomaticResponseConfiguration(software.amazon.awscdk.IResolvable applicationLayerAutomaticResponseConfiguration) {
            this.applicationLayerAutomaticResponseConfiguration = applicationLayerAutomaticResponseConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnProtectionProps#getApplicationLayerAutomaticResponseConfiguration}
         * @param applicationLayerAutomaticResponseConfiguration The automatic application layer DDoS mitigation settings for the protection.
         *                                                       This configuration determines whether Shield Advanced automatically manages rules in the web ACL in order to respond to application layer events that Shield Advanced determines to be DDoS attacks.
         *                                                       <p>
         *                                                       If you use AWS CloudFormation to manage the web ACLs that you use with Shield Advanced automatic mitigation, see the additional guidance about web ACL management in the <code>AWS::WAFv2::WebACL</code> resource description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationLayerAutomaticResponseConfiguration(software.amazon.awscdk.services.shield.CfnProtection.ApplicationLayerAutomaticResponseConfigurationProperty applicationLayerAutomaticResponseConfiguration) {
            this.applicationLayerAutomaticResponseConfiguration = applicationLayerAutomaticResponseConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnProtectionProps#getHealthCheckArns}
         * @param healthCheckArns The ARN (Amazon Resource Name) of the health check to associate with the protection.
         *                        Health-based detection provides improved responsiveness and accuracy in attack detection and mitigation.
         *                        <p>
         *                        You can use this option with any resource type except for Route 53 hosted zones.
         *                        <p>
         *                        For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/ddos-advanced-health-checks.html">Configuring health-based detection using health checks</a> in the <em>AWS Shield Advanced Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckArns(java.util.List<java.lang.String> healthCheckArns) {
            this.healthCheckArns = healthCheckArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnProtectionProps#getTags}
         * @param tags Key:value pairs associated with an AWS resource.
         *             The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProtectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProtectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProtectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProtectionProps {
        private final java.lang.String name;
        private final java.lang.String resourceArn;
        private final java.lang.Object applicationLayerAutomaticResponseConfiguration;
        private final java.util.List<java.lang.String> healthCheckArns;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationLayerAutomaticResponseConfiguration = software.amazon.jsii.Kernel.get(this, "applicationLayerAutomaticResponseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.healthCheckArns = software.amazon.jsii.Kernel.get(this, "healthCheckArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            this.applicationLayerAutomaticResponseConfiguration = builder.applicationLayerAutomaticResponseConfiguration;
            this.healthCheckArns = builder.healthCheckArns;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final java.lang.Object getApplicationLayerAutomaticResponseConfiguration() {
            return this.applicationLayerAutomaticResponseConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getHealthCheckArns() {
            return this.healthCheckArns;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("resourceArn", om.valueToTree(this.getResourceArn()));
            if (this.getApplicationLayerAutomaticResponseConfiguration() != null) {
                data.set("applicationLayerAutomaticResponseConfiguration", om.valueToTree(this.getApplicationLayerAutomaticResponseConfiguration()));
            }
            if (this.getHealthCheckArns() != null) {
                data.set("healthCheckArns", om.valueToTree(this.getHealthCheckArns()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_shield.CfnProtectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProtectionProps.Jsii$Proxy that = (CfnProtectionProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!resourceArn.equals(that.resourceArn)) return false;
            if (this.applicationLayerAutomaticResponseConfiguration != null ? !this.applicationLayerAutomaticResponseConfiguration.equals(that.applicationLayerAutomaticResponseConfiguration) : that.applicationLayerAutomaticResponseConfiguration != null) return false;
            if (this.healthCheckArns != null ? !this.healthCheckArns.equals(that.healthCheckArns) : that.healthCheckArns != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.resourceArn.hashCode());
            result = 31 * result + (this.applicationLayerAutomaticResponseConfiguration != null ? this.applicationLayerAutomaticResponseConfiguration.hashCode() : 0);
            result = 31 * result + (this.healthCheckArns != null ? this.healthCheckArns.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
