package software.amazon.awscdk.services.simspaceweaver;

/**
 * Use the <code>AWS::SimSpaceWeaver::Simulation</code> resource to specify a simulation that AWS CloudFormation starts in the AWS Cloud , in your AWS account .
 * <p>
 * In the resource properties section of your template, provide the name of an existing IAM role configured with the proper permissions, and the name of an existing Amazon S3 bucket. Your account must have permissions to read the Amazon S3 bucket. The Amazon S3 bucket must contain a valid schema. The schema must refer to simulation assets that are already uploaded to the AWS Cloud . For more information, see the <a href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/getting-started_detailed.html">detailed tutorial</a> in the <em>AWS SimSpace Weaver User Guide</em> .
 * <p>
 * Specify a <code>SnapshotS3Location</code> to start a simulation from a snapshot instead of from a schema. When you start a simulation from a snapshot, SimSpace Weaver initializes the entity data in the State Fabric with data saved in the snapshot, starts the spatial and service apps that were running when the snapshot was created, and restores the clock to the appropriate tick. Your app zip files must be in the same location in Amazon S3 as they were in for the original simulation. You must start any custom apps separately. For more information about snapshots, see <a href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html">Snapshots</a> in the <em>AWS SimSpace Weaver User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.simspaceweaver.*;
 * CfnSimulation cfnSimulation = CfnSimulation.Builder.create(this, "MyCfnSimulation")
 *         .name("name")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .maximumDuration("maximumDuration")
 *         .schemaS3Location(S3LocationProperty.builder()
 *                 .bucketName("bucketName")
 *                 .objectKey("objectKey")
 *                 .build())
 *         .snapshotS3Location(S3LocationProperty.builder()
 *                 .bucketName("bucketName")
 *                 .objectKey("objectKey")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:30.351Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_simspaceweaver.CfnSimulation")
public class CfnSimulation extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSimulation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSimulation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.simspaceweaver.CfnSimulation.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSimulation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.simspaceweaver.CfnSimulationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The JSON blob that the <a href="https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_DescribeSimulation.html">DescribeSimulation</a> action returns.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDescribePayload() {
        return software.amazon.jsii.Kernel.get(this, "attrDescribePayload", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the simulation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the simulation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management ( IAM ) role that the simulation assumes to perform actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management ( IAM ) role that the simulation assumes to perform actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMaximumDuration() {
        return software.amazon.jsii.Kernel.get(this, "maximumDuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumDuration(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "maximumDuration", value);
    }

    /**
     * The location of the simulation schema in Amazon Simple Storage Service ( Amazon S3 ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchemaS3Location() {
        return software.amazon.jsii.Kernel.get(this, "schemaS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The location of the simulation schema in Amazon Simple Storage Service ( Amazon S3 ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schemaS3Location", value);
    }

    /**
     * The location of the simulation schema in Amazon Simple Storage Service ( Amazon S3 ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.simspaceweaver.CfnSimulation.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "schemaS3Location", value);
    }

    /**
     * The location of the snapshot in Amazon Simple Storage Service ( Amazon S3 ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotS3Location() {
        return software.amazon.jsii.Kernel.get(this, "snapshotS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The location of the snapshot in Amazon Simple Storage Service ( Amazon S3 ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "snapshotS3Location", value);
    }

    /**
     * The location of the snapshot in Amazon Simple Storage Service ( Amazon S3 ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.simspaceweaver.CfnSimulation.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "snapshotS3Location", value);
    }
    /**
     * A location in Amazon Simple Storage Service ( Amazon S3 ) where SimSpace Weaver stores simulation data, such as your app .zip files and schema file. For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.simspaceweaver.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucketName("bucketName")
     *         .objectKey("objectKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-simspaceweaver-simulation-s3location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-simspaceweaver-simulation-s3location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_simspaceweaver.CfnSimulation.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an Amazon S3 bucket.
         * <p>
         * For more information about buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and working with Amazon S3 buckets</a> in the <em>Amazon Simple Storage Service User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-simspaceweaver-simulation-s3location.html#cfn-simspaceweaver-simulation-s3location-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-simspaceweaver-simulation-s3location.html#cfn-simspaceweaver-simulation-s3location-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The key name of an object in Amazon S3 .
         * <p>
         * For more information about Amazon S3 objects and object keys, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/uploading-downloading-objects.html">Uploading, downloading, and working with objects in Amazon S3</a> in the <em>Amazon Simple Storage Service User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-simspaceweaver-simulation-s3location.html#cfn-simspaceweaver-simulation-s3location-objectkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-simspaceweaver-simulation-s3location.html#cfn-simspaceweaver-simulation-s3location-objectkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectKey();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucketName;
            java.lang.String objectKey;

            /**
             * Sets the value of {@link S3LocationProperty#getBucketName}
             * @param bucketName The name of an Amazon S3 bucket. This parameter is required.
             *                   For more information about buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and working with Amazon S3 buckets</a> in the <em>Amazon Simple Storage Service User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getObjectKey}
             * @param objectKey The key name of an object in Amazon S3 . This parameter is required.
             *                  For more information about Amazon S3 objects and object keys, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/uploading-downloading-objects.html">Uploading, downloading, and working with objects in Amazon S3</a> in the <em>Amazon Simple Storage Service User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectKey(java.lang.String objectKey) {
                this.objectKey = objectKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucketName;
            private final java.lang.String objectKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectKey = software.amazon.jsii.Kernel.get(this, "objectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.objectKey = java.util.Objects.requireNonNull(builder.objectKey, "objectKey is required");
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getObjectKey() {
                return this.objectKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("objectKey", om.valueToTree(this.getObjectKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_simspaceweaver.CfnSimulation.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                return this.objectKey.equals(that.objectKey);
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.objectKey.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.simspaceweaver.CfnSimulation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.simspaceweaver.CfnSimulation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.simspaceweaver.CfnSimulationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.simspaceweaver.CfnSimulationProps.Builder();
        }

        /**
         * The name of the simulation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-name</a>
         * @param name The name of the simulation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management ( IAM ) role that the simulation assumes to perform actions.
         * <p>
         * For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <em>AWS General Reference</em> . For more information about IAM roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <em>AWS Identity and Access Management User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the AWS Identity and Access Management ( IAM ) role that the simulation assumes to perform actions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D).
         * <p>
         * The simulation stops when it reaches this limit. The maximum value is <code>14D</code> , or its equivalent in the other units. The default value is <code>14D</code> . A value equivalent to <code>0</code> makes the simulation immediately transition to <code>STOPPING</code> as soon as it reaches <code>STARTED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-maximumduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-maximumduration</a>
         * @param maximumDuration The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumDuration(final java.lang.String maximumDuration) {
            this.props.maximumDuration(maximumDuration);
            return this;
        }

        /**
         * The location of the simulation schema in Amazon Simple Storage Service ( Amazon S3 ).
         * <p>
         * For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
         * <p>
         * Provide a <code>SchemaS3Location</code> to start your simulation from a schema.
         * <p>
         * If you provide a <code>SchemaS3Location</code> then you can't provide a <code>SnapshotS3Location</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-schemas3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-schemas3location</a>
         * @param schemaS3Location The location of the simulation schema in Amazon Simple Storage Service ( Amazon S3 ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaS3Location(final software.amazon.awscdk.IResolvable schemaS3Location) {
            this.props.schemaS3Location(schemaS3Location);
            return this;
        }
        /**
         * The location of the simulation schema in Amazon Simple Storage Service ( Amazon S3 ).
         * <p>
         * For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
         * <p>
         * Provide a <code>SchemaS3Location</code> to start your simulation from a schema.
         * <p>
         * If you provide a <code>SchemaS3Location</code> then you can't provide a <code>SnapshotS3Location</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-schemas3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-schemas3location</a>
         * @param schemaS3Location The location of the simulation schema in Amazon Simple Storage Service ( Amazon S3 ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaS3Location(final software.amazon.awscdk.services.simspaceweaver.CfnSimulation.S3LocationProperty schemaS3Location) {
            this.props.schemaS3Location(schemaS3Location);
            return this;
        }

        /**
         * The location of the snapshot in Amazon Simple Storage Service ( Amazon S3 ).
         * <p>
         * For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
         * <p>
         * Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.
         * <p>
         * If you provide a <code>SnapshotS3Location</code> then you can't provide a <code>SchemaS3Location</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-snapshots3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-snapshots3location</a>
         * @param snapshotS3Location The location of the snapshot in Amazon Simple Storage Service ( Amazon S3 ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotS3Location(final software.amazon.awscdk.IResolvable snapshotS3Location) {
            this.props.snapshotS3Location(snapshotS3Location);
            return this;
        }
        /**
         * The location of the snapshot in Amazon Simple Storage Service ( Amazon S3 ).
         * <p>
         * For more information about Amazon S3 , see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"><em>Amazon Simple Storage Service User Guide</em></a> .
         * <p>
         * Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.
         * <p>
         * If you provide a <code>SnapshotS3Location</code> then you can't provide a <code>SchemaS3Location</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-snapshots3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-simspaceweaver-simulation.html#cfn-simspaceweaver-simulation-snapshots3location</a>
         * @param snapshotS3Location The location of the snapshot in Amazon Simple Storage Service ( Amazon S3 ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotS3Location(final software.amazon.awscdk.services.simspaceweaver.CfnSimulation.S3LocationProperty snapshotS3Location) {
            this.props.snapshotS3Location(snapshotS3Location);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.simspaceweaver.CfnSimulation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.simspaceweaver.CfnSimulation build() {
            return new software.amazon.awscdk.services.simspaceweaver.CfnSimulation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
