package software.amazon.awscdk.services.sns;

/**
 * The <code>AWS::SNS::Topic</code> resource creates a topic to which notifications can be published.
 * <p>
 * <blockquote>
 * <p>
 * One account can create a maximum of 100,000 standard topics and 1,000 FIFO topics. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/sns.html">Amazon SNS endpoints and quotas</a> in the <em>AWS General Reference</em> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sns.*;
 * Object archivePolicy;
 * Object dataProtectionPolicy;
 * CfnTopic cfnTopic = CfnTopic.Builder.create(this, "MyCfnTopic")
 *         .archivePolicy(archivePolicy)
 *         .contentBasedDeduplication(false)
 *         .dataProtectionPolicy(dataProtectionPolicy)
 *         .deliveryStatusLogging(List.of(LoggingConfigProperty.builder()
 *                 .protocol("protocol")
 *                 // the properties below are optional
 *                 .failureFeedbackRoleArn("failureFeedbackRoleArn")
 *                 .successFeedbackRoleArn("successFeedbackRoleArn")
 *                 .successFeedbackSampleRate("successFeedbackSampleRate")
 *                 .build()))
 *         .displayName("displayName")
 *         .fifoTopic(false)
 *         .kmsMasterKeyId("kmsMasterKeyId")
 *         .signatureVersion("signatureVersion")
 *         .subscription(List.of(SubscriptionProperty.builder()
 *                 .endpoint("endpoint")
 *                 .protocol("protocol")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .topicName("topicName")
 *         .tracingConfig("tracingConfig")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:30.360Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.CfnTopic")
public class CfnTopic extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnTopic(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTopic(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sns.CfnTopic.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTopic(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.CfnTopicProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTopic(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the ARN of an Amazon SNS topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the name of an Amazon SNS topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTopicName() {
        return software.amazon.jsii.Kernel.get(this, "attrTopicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The archive policy determines the number of days Amazon SNS retains messages.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getArchivePolicy() {
        return software.amazon.jsii.Kernel.get(this, "archivePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The archive policy determines the number of days Amazon SNS retains messages.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArchivePolicy(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "archivePolicy", value);
    }

    /**
     * Enables content-based deduplication for FIFO topics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContentBasedDeduplication() {
        return software.amazon.jsii.Kernel.get(this, "contentBasedDeduplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables content-based deduplication for FIFO topics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentBasedDeduplication(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "contentBasedDeduplication", value);
    }

    /**
     * Enables content-based deduplication for FIFO topics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentBasedDeduplication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "contentBasedDeduplication", value);
    }

    /**
     * The body of the policy document you want to use for this topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataProtectionPolicy() {
        return software.amazon.jsii.Kernel.get(this, "dataProtectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The body of the policy document you want to use for this topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataProtectionPolicy(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "dataProtectionPolicy", value);
    }

    /**
     * The <code>DeliveryStatusLogging</code> configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryStatusLogging() {
        return software.amazon.jsii.Kernel.get(this, "deliveryStatusLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The <code>DeliveryStatusLogging</code> configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryStatusLogging(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deliveryStatusLogging", value);
    }

    /**
     * The <code>DeliveryStatusLogging</code> configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryStatusLogging(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sns.CfnTopic.LoggingConfigProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sns.CfnTopic.LoggingConfigProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "deliveryStatusLogging", value);
    }

    /**
     * The display name to use for an Amazon SNS topic with SMS subscriptions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The display name to use for an Amazon SNS topic with SMS subscriptions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", value);
    }

    /**
     * Set to true to create a FIFO topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFifoTopic() {
        return software.amazon.jsii.Kernel.get(this, "fifoTopic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Set to true to create a FIFO topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFifoTopic(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "fifoTopic", value);
    }

    /**
     * Set to true to create a FIFO topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFifoTopic(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fifoTopic", value);
    }

    /**
     * The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsMasterKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsMasterKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsMasterKeyId", value);
    }

    /**
     * The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSignatureVersion() {
        return software.amazon.jsii.Kernel.get(this, "signatureVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignatureVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "signatureVersion", value);
    }

    /**
     * The Amazon SNS subscriptions (endpoints) for this topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSubscription() {
        return software.amazon.jsii.Kernel.get(this, "subscription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon SNS subscriptions (endpoints) for this topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubscription(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "subscription", value);
    }

    /**
     * The Amazon SNS subscriptions (endpoints) for this topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubscription(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sns.CfnTopic.SubscriptionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sns.CfnTopic.SubscriptionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "subscription", value);
    }

    /**
     * The list of tags to add to a new topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of tags to add to a new topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The name of the topic you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTopicName() {
        return software.amazon.jsii.Kernel.get(this, "topicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the topic you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTopicName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "topicName", value);
    }

    /**
     * Tracing mode of an Amazon SNS topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTracingConfig() {
        return software.amazon.jsii.Kernel.get(this, "tracingConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tracing mode of an Amazon SNS topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTracingConfig(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tracingConfig", value);
    }
    /**
     * The <code>LoggingConfig</code> property type specifies the <code>Delivery</code> status logging configuration for an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html"><code>AWS::SNS::Topic</code></a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sns.*;
     * LoggingConfigProperty loggingConfigProperty = LoggingConfigProperty.builder()
     *         .protocol("protocol")
     *         // the properties below are optional
     *         .failureFeedbackRoleArn("failureFeedbackRoleArn")
     *         .successFeedbackRoleArn("successFeedbackRoleArn")
     *         .successFeedbackSampleRate("successFeedbackSampleRate")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-loggingconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-loggingconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.CfnTopic.LoggingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates one of the supported protocols for the Amazon SNS topic.
         * <p>
         * <blockquote>
         * <p>
         * At least one of the other three <code>LoggingConfig</code> properties is recommend along with <code>Protocol</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-loggingconfig.html#cfn-sns-topic-loggingconfig-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-loggingconfig.html#cfn-sns-topic-loggingconfig-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * The IAM role ARN to be used when logging failed message deliveries in Amazon CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-loggingconfig.html#cfn-sns-topic-loggingconfig-failurefeedbackrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-loggingconfig.html#cfn-sns-topic-loggingconfig-failurefeedbackrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFailureFeedbackRoleArn() {
            return null;
        }

        /**
         * The IAM role ARN to be used when logging successful message deliveries in Amazon CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-loggingconfig.html#cfn-sns-topic-loggingconfig-successfeedbackrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-loggingconfig.html#cfn-sns-topic-loggingconfig-successfeedbackrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuccessFeedbackRoleArn() {
            return null;
        }

        /**
         * The percentage of successful message deliveries to be logged in Amazon CloudWatch.
         * <p>
         * Valid percentage values range from 0 to 100.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-loggingconfig.html#cfn-sns-topic-loggingconfig-successfeedbacksamplerate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-loggingconfig.html#cfn-sns-topic-loggingconfig-successfeedbacksamplerate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuccessFeedbackSampleRate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingConfigProperty> {
            java.lang.String protocol;
            java.lang.String failureFeedbackRoleArn;
            java.lang.String successFeedbackRoleArn;
            java.lang.String successFeedbackSampleRate;

            /**
             * Sets the value of {@link LoggingConfigProperty#getProtocol}
             * @param protocol Indicates one of the supported protocols for the Amazon SNS topic. This parameter is required.
             *                 <blockquote>
             *                 <p>
             *                 At least one of the other three <code>LoggingConfig</code> properties is recommend along with <code>Protocol</code> .
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigProperty#getFailureFeedbackRoleArn}
             * @param failureFeedbackRoleArn The IAM role ARN to be used when logging failed message deliveries in Amazon CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureFeedbackRoleArn(java.lang.String failureFeedbackRoleArn) {
                this.failureFeedbackRoleArn = failureFeedbackRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigProperty#getSuccessFeedbackRoleArn}
             * @param successFeedbackRoleArn The IAM role ARN to be used when logging successful message deliveries in Amazon CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successFeedbackRoleArn(java.lang.String successFeedbackRoleArn) {
                this.successFeedbackRoleArn = successFeedbackRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigProperty#getSuccessFeedbackSampleRate}
             * @param successFeedbackSampleRate The percentage of successful message deliveries to be logged in Amazon CloudWatch.
             *                                  Valid percentage values range from 0 to 100.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successFeedbackSampleRate(java.lang.String successFeedbackSampleRate) {
                this.successFeedbackSampleRate = successFeedbackSampleRate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingConfigProperty {
            private final java.lang.String protocol;
            private final java.lang.String failureFeedbackRoleArn;
            private final java.lang.String successFeedbackRoleArn;
            private final java.lang.String successFeedbackSampleRate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.failureFeedbackRoleArn = software.amazon.jsii.Kernel.get(this, "failureFeedbackRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.successFeedbackRoleArn = software.amazon.jsii.Kernel.get(this, "successFeedbackRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.successFeedbackSampleRate = software.amazon.jsii.Kernel.get(this, "successFeedbackSampleRate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
                this.failureFeedbackRoleArn = builder.failureFeedbackRoleArn;
                this.successFeedbackRoleArn = builder.successFeedbackRoleArn;
                this.successFeedbackSampleRate = builder.successFeedbackSampleRate;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.String getFailureFeedbackRoleArn() {
                return this.failureFeedbackRoleArn;
            }

            @Override
            public final java.lang.String getSuccessFeedbackRoleArn() {
                return this.successFeedbackRoleArn;
            }

            @Override
            public final java.lang.String getSuccessFeedbackSampleRate() {
                return this.successFeedbackSampleRate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("protocol", om.valueToTree(this.getProtocol()));
                if (this.getFailureFeedbackRoleArn() != null) {
                    data.set("failureFeedbackRoleArn", om.valueToTree(this.getFailureFeedbackRoleArn()));
                }
                if (this.getSuccessFeedbackRoleArn() != null) {
                    data.set("successFeedbackRoleArn", om.valueToTree(this.getSuccessFeedbackRoleArn()));
                }
                if (this.getSuccessFeedbackSampleRate() != null) {
                    data.set("successFeedbackSampleRate", om.valueToTree(this.getSuccessFeedbackSampleRate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.CfnTopic.LoggingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingConfigProperty.Jsii$Proxy that = (LoggingConfigProperty.Jsii$Proxy) o;

                if (!protocol.equals(that.protocol)) return false;
                if (this.failureFeedbackRoleArn != null ? !this.failureFeedbackRoleArn.equals(that.failureFeedbackRoleArn) : that.failureFeedbackRoleArn != null) return false;
                if (this.successFeedbackRoleArn != null ? !this.successFeedbackRoleArn.equals(that.successFeedbackRoleArn) : that.successFeedbackRoleArn != null) return false;
                return this.successFeedbackSampleRate != null ? this.successFeedbackSampleRate.equals(that.successFeedbackSampleRate) : that.successFeedbackSampleRate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.protocol.hashCode();
                result = 31 * result + (this.failureFeedbackRoleArn != null ? this.failureFeedbackRoleArn.hashCode() : 0);
                result = 31 * result + (this.successFeedbackRoleArn != null ? this.successFeedbackRoleArn.hashCode() : 0);
                result = 31 * result + (this.successFeedbackSampleRate != null ? this.successFeedbackSampleRate.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>Subscription</code> is an embedded property that describes the subscription endpoints of an Amazon SNS topic.
     * <p>
     * <blockquote>
     * <p>
     * For full control over subscription behavior (for example, delivery policy, filtering, raw message delivery, and cross-region subscriptions), use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html">AWS::SNS::Subscription</a> resource.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sns.*;
     * SubscriptionProperty subscriptionProperty = SubscriptionProperty.builder()
     *         .endpoint("endpoint")
     *         .protocol("protocol")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-subscription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-subscription.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.CfnTopic.SubscriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(SubscriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubscriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint that receives notifications from the Amazon SNS topic.
         * <p>
         * The endpoint value depends on the protocol that you specify. For more information, see the <code>Endpoint</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-subscription.html#cfn-sns-topic-subscription-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-subscription.html#cfn-sns-topic-subscription-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

        /**
         * The subscription's protocol.
         * <p>
         * For more information, see the <code>Protocol</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-subscription.html#cfn-sns-topic-subscription-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic-subscription.html#cfn-sns-topic-subscription-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * @return a {@link Builder} of {@link SubscriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubscriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubscriptionProperty> {
            java.lang.String endpoint;
            java.lang.String protocol;

            /**
             * Sets the value of {@link SubscriptionProperty#getEndpoint}
             * @param endpoint The endpoint that receives notifications from the Amazon SNS topic. This parameter is required.
             *                 The endpoint value depends on the protocol that you specify. For more information, see the <code>Endpoint</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Sets the value of {@link SubscriptionProperty#getProtocol}
             * @param protocol The subscription's protocol. This parameter is required.
             *                 For more information, see the <code>Protocol</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubscriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubscriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubscriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriptionProperty {
            private final java.lang.String endpoint;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpoint", om.valueToTree(this.getEndpoint()));
                data.set("protocol", om.valueToTree(this.getProtocol()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.CfnTopic.SubscriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubscriptionProperty.Jsii$Proxy that = (SubscriptionProperty.Jsii$Proxy) o;

                if (!endpoint.equals(that.endpoint)) return false;
                return this.protocol.equals(that.protocol);
            }

            @Override
            public final int hashCode() {
                int result = this.endpoint.hashCode();
                result = 31 * result + (this.protocol.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sns.CfnTopic}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sns.CfnTopic> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sns.CfnTopicProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The archive policy determines the number of days Amazon SNS retains messages.
         * <p>
         * You can set a retention period from 1 to 365 days.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-archivepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-archivepolicy</a>
         * @param archivePolicy The archive policy determines the number of days Amazon SNS retains messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archivePolicy(final java.lang.Object archivePolicy) {
            this.props().archivePolicy(archivePolicy);
            return this;
        }

        /**
         * Enables content-based deduplication for FIFO topics.
         * <p>
         * <ul>
         * <li>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code> . If you create a FIFO topic and this attribute is <code>false</code> , you must specify a value for the <code>MessageDeduplicationId</code> parameter for the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action.</li>
         * <li>When you set <code>ContentBasedDeduplication</code> to <code>true</code> , Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</li>
         * </ul>
         * <p>
         * (Optional) To override the generated value, you can specify a value for the the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code> action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-contentbaseddeduplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-contentbaseddeduplication</a>
         * @param contentBasedDeduplication Enables content-based deduplication for FIFO topics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(final java.lang.Boolean contentBasedDeduplication) {
            this.props().contentBasedDeduplication(contentBasedDeduplication);
            return this;
        }
        /**
         * Enables content-based deduplication for FIFO topics.
         * <p>
         * <ul>
         * <li>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code> . If you create a FIFO topic and this attribute is <code>false</code> , you must specify a value for the <code>MessageDeduplicationId</code> parameter for the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action.</li>
         * <li>When you set <code>ContentBasedDeduplication</code> to <code>true</code> , Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</li>
         * </ul>
         * <p>
         * (Optional) To override the generated value, you can specify a value for the the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code> action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-contentbaseddeduplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-contentbaseddeduplication</a>
         * @param contentBasedDeduplication Enables content-based deduplication for FIFO topics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(final software.amazon.awscdk.IResolvable contentBasedDeduplication) {
            this.props().contentBasedDeduplication(contentBasedDeduplication);
            return this;
        }

        /**
         * The body of the policy document you want to use for this topic.
         * <p>
         * You can only add one policy per topic.
         * <p>
         * The policy must be in JSON string format.
         * <p>
         * Length Constraints: Maximum length of 30,720.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-dataprotectionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-dataprotectionpolicy</a>
         * @param dataProtectionPolicy The body of the policy document you want to use for this topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProtectionPolicy(final java.lang.Object dataProtectionPolicy) {
            this.props().dataProtectionPolicy(dataProtectionPolicy);
            return this;
        }

        /**
         * The <code>DeliveryStatusLogging</code> configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:.
         * <p>
         * <ul>
         * <li>HTTP</li>
         * <li>Amazon Kinesis Data Firehose</li>
         * <li>AWS Lambda</li>
         * <li>Platform application endpoint</li>
         * <li>Amazon Simple Queue Service</li>
         * </ul>
         * <p>
         * Once configured, log entries are sent to Amazon CloudWatch Logs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-deliverystatuslogging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-deliverystatuslogging</a>
         * @param deliveryStatusLogging The <code>DeliveryStatusLogging</code> configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStatusLogging(final software.amazon.awscdk.IResolvable deliveryStatusLogging) {
            this.props().deliveryStatusLogging(deliveryStatusLogging);
            return this;
        }
        /**
         * The <code>DeliveryStatusLogging</code> configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:.
         * <p>
         * <ul>
         * <li>HTTP</li>
         * <li>Amazon Kinesis Data Firehose</li>
         * <li>AWS Lambda</li>
         * <li>Platform application endpoint</li>
         * <li>Amazon Simple Queue Service</li>
         * </ul>
         * <p>
         * Once configured, log entries are sent to Amazon CloudWatch Logs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-deliverystatuslogging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-deliverystatuslogging</a>
         * @param deliveryStatusLogging The <code>DeliveryStatusLogging</code> configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStatusLogging(final java.util.List<? extends java.lang.Object> deliveryStatusLogging) {
            this.props().deliveryStatusLogging(deliveryStatusLogging);
            return this;
        }

        /**
         * The display name to use for an Amazon SNS topic with SMS subscriptions.
         * <p>
         * The display name must be maximum 100 characters long, including hyphens (-), underscores (_), spaces, and tabs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-displayname</a>
         * @param displayName The display name to use for an Amazon SNS topic with SMS subscriptions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props().displayName(displayName);
            return this;
        }

        /**
         * Set to true to create a FIFO topic.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-fifotopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-fifotopic</a>
         * @param fifoTopic Set to true to create a FIFO topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoTopic(final java.lang.Boolean fifoTopic) {
            this.props().fifoTopic(fifoTopic);
            return this;
        }
        /**
         * Set to true to create a FIFO topic.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-fifotopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-fifotopic</a>
         * @param fifoTopic Set to true to create a FIFO topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoTopic(final software.amazon.awscdk.IResolvable fifoTopic) {
            this.props().fifoTopic(fifoTopic);
            return this;
        }

        /**
         * The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key terms</a> . For more examples, see <code>[KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)</code> in the <em>AWS Key Management Service API Reference</em> .
         * <p>
         * This property applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-kmsmasterkeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-kmsmasterkeyid</a>
         * @param kmsMasterKeyId The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsMasterKeyId(final java.lang.String kmsMasterKeyId) {
            this.props().kmsMasterKeyId(kmsMasterKeyId);
            return this;
        }

        /**
         * The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
         * <p>
         * By default, <code>SignatureVersion</code> is set to <code>1</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-signatureversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-signatureversion</a>
         * @param signatureVersion The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signatureVersion(final java.lang.String signatureVersion) {
            this.props().signatureVersion(signatureVersion);
            return this;
        }

        /**
         * The Amazon SNS subscriptions (endpoints) for this topic.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>Subscription</code> property in the <code>AWS::SNS::Topic</code> resource and it creates an associated subscription resource, the associated subscription is not deleted when the <code>AWS::SNS::Topic</code> resource is deleted.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-subscription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-subscription</a>
         * @param subscription The Amazon SNS subscriptions (endpoints) for this topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscription(final software.amazon.awscdk.IResolvable subscription) {
            this.props().subscription(subscription);
            return this;
        }
        /**
         * The Amazon SNS subscriptions (endpoints) for this topic.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>Subscription</code> property in the <code>AWS::SNS::Topic</code> resource and it creates an associated subscription resource, the associated subscription is not deleted when the <code>AWS::SNS::Topic</code> resource is deleted.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-subscription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-subscription</a>
         * @param subscription The Amazon SNS subscriptions (endpoints) for this topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscription(final java.util.List<? extends java.lang.Object> subscription) {
            this.props().subscription(subscription);
            return this;
        }

        /**
         * The list of tags to add to a new topic.
         * <p>
         * <blockquote>
         * <p>
         * To be able to tag a topic on creation, you must have the <code>sns:CreateTopic</code> and <code>sns:TagResource</code> permissions.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-tags</a>
         * @param tags The list of tags to add to a new topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The name of the topic you want to create.
         * <p>
         * Topic names must include only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. FIFO topic names must end with <code>.fifo</code> .
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the topic name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-topicname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-topicname</a>
         * @param topicName The name of the topic you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicName(final java.lang.String topicName) {
            this.props().topicName(topicName);
            return this;
        }

        /**
         * Tracing mode of an Amazon SNS topic.
         * <p>
         * By default <code>TracingConfig</code> is set to <code>PassThrough</code> , and the topic passes through the tracing header it receives from an Amazon SNS publisher to its subscriptions. If set to <code>Active</code> , Amazon SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-tracingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-tracingconfig</a>
         * @param tracingConfig Tracing mode of an Amazon SNS topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingConfig(final java.lang.String tracingConfig) {
            this.props().tracingConfig(tracingConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sns.CfnTopic}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sns.CfnTopic build() {
            return new software.amazon.awscdk.services.sns.CfnTopic(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sns.CfnTopicProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sns.CfnTopicProps.Builder();
            }
            return this.props;
        }
    }
}
