package software.amazon.awscdk.services.sns.subscriptions;

/**
 * Use an email address as a subscription target.
 * <p>
 * Email subscriptions require confirmation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic myTopic = new Topic(this, "Topic");
 * CfnParameter emailAddress = new CfnParameter(this, "email-param");
 * myTopic.addSubscription(new EmailSubscription(emailAddress.getValueAsString()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:30.396Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns_subscriptions.EmailSubscription")
public class EmailSubscription extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sns.ITopicSubscription {

    protected EmailSubscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmailSubscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param emailAddress This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EmailSubscription(final @org.jetbrains.annotations.NotNull java.lang.String emailAddress, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.subscriptions.EmailSubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(emailAddress, "emailAddress is required"), props });
    }

    /**
     * @param emailAddress This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EmailSubscription(final @org.jetbrains.annotations.NotNull java.lang.String emailAddress) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(emailAddress, "emailAddress is required") });
    }

    /**
     * Returns a configuration for an email address to subscribe to an SNS topic.
     * <p>
     * @param _topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.TopicSubscriptionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic _topic) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.TopicSubscriptionConfig.class), new Object[] { java.util.Objects.requireNonNull(_topic, "_topic is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sns.subscriptions.EmailSubscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sns.subscriptions.EmailSubscription> {
        /**
         * @return a new instance of {@link Builder}.
         * @param emailAddress This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String emailAddress) {
            return new Builder(emailAddress);
        }

        private final java.lang.String emailAddress;
        private software.amazon.awscdk.services.sns.subscriptions.EmailSubscriptionProps.Builder props;

        private Builder(final java.lang.String emailAddress) {
            this.emailAddress = emailAddress;
        }

        /**
         * Queue to be used as dead letter queue.
         * <p>
         * If not passed no dead letter queue is enabled.
         * <p>
         * Default: - No dead letter queue enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueue Queue to be used as dead letter queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The filter policy.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicy The filter policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.props().filterPolicy(filterPolicy);
            return this;
        }

        /**
         * The filter policy that is applied on the message body.
         * <p>
         * To apply a filter policy to the message attributes, use <code>filterPolicy</code>. A maximum of one of <code>filterPolicyWithMessageBody</code> and <code>filterPolicy</code> may be used.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicyWithMessageBody The filter policy that is applied on the message body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicyWithMessageBody(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody) {
            this.props().filterPolicyWithMessageBody(filterPolicyWithMessageBody);
            return this;
        }

        /**
         * Indicates if the full notification JSON should be sent to the email address or just the message text.
         * <p>
         * Default: false (Message text)
         * <p>
         * @return {@code this}
         * @param json Indicates if the full notification JSON should be sent to the email address or just the message text. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder json(final java.lang.Boolean json) {
            this.props().json(json);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sns.subscriptions.EmailSubscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sns.subscriptions.EmailSubscription build() {
            return new software.amazon.awscdk.services.sns.subscriptions.EmailSubscription(
                this.emailAddress,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sns.subscriptions.EmailSubscriptionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sns.subscriptions.EmailSubscriptionProps.Builder();
            }
            return this.props;
        }
    }
}
