package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a <code>CfnStateMachineAlias</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * CfnStateMachineAliasProps cfnStateMachineAliasProps = CfnStateMachineAliasProps.builder()
 *         .deploymentPreference(DeploymentPreferenceProperty.builder()
 *                 .stateMachineVersionArn("stateMachineVersionArn")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .alarms(List.of("alarms"))
 *                 .interval(123)
 *                 .percentage(123)
 *                 .build())
 *         .description("description")
 *         .name("name")
 *         .routingConfiguration(List.of(RoutingConfigurationVersionProperty.builder()
 *                 .stateMachineVersionArn("stateMachineVersionArn")
 *                 .weight(123)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:30.575Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CfnStateMachineAliasProps")
@software.amazon.jsii.Jsii.Proxy(CfnStateMachineAliasProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStateMachineAliasProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The settings that enable gradual state machine deployments.
     * <p>
     * These settings include <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-alarms">Alarms</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-interval">Interval</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-percentage">Percentage</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-statemachineversionarn">StateMachineVersionArn</a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-type">Type</a> .
     * <p>
     * CloudFormation automatically shifts traffic from the version an alias currently points to, to a new state machine version that you specify.
     * <p>
     * <blockquote>
     * <p>
     * <code>RoutingConfiguration</code> and <code>DeploymentPreference</code> are mutually exclusive properties. You must define only one of these properties.
     * <p>
     * </blockquote>
     * <p>
     * Based on the type of deployment you want to perform, you can specify one of the following settings:
     * <p>
     * <ul>
     * <li><code>LINEAR</code> - Shifts traffic to the new version in equal increments with an equal number of minutes between each increment.</li>
     * </ul>
     * <p>
     * For example, if you specify the increment percent as <code>20</code> with an interval of <code>600</code> minutes, this deployment increases traffic by 20 percent every 600 minutes until the new version receives 100 percent of the traffic. This deployment immediately rolls back the new version if any Amazon CloudWatch alarms are triggered.
     * <p>
     * <ul>
     * <li><code>ALL_AT_ONCE</code> - Shifts 100 percent of traffic to the new version immediately. CloudFormation monitors the new version and rolls it back automatically to the previous version if any CloudWatch alarms are triggered.</li>
     * <li><code>CANARY</code> - Shifts traffic in two increments.</li>
     * </ul>
     * <p>
     * In the first increment, a small percentage of traffic, for example, 10 percent is shifted to the new version. In the second increment, before a specified time interval in seconds gets over, the remaining traffic is shifted to the new version. The shift to the new version for the remaining traffic takes place only if no CloudWatch alarms are triggered during the specified time interval.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-deploymentpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-deploymentpreference</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentPreference() {
        return null;
    }

    /**
     * An optional description of the state machine alias.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the state machine alias.
     * <p>
     * If you don't provide a name, it uses an automatically generated name based on the logical ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The routing configuration of an alias.
     * <p>
     * Routing configuration splits <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html">StartExecution</a> requests between one or two versions of the same state machine.
     * <p>
     * Use <code>RoutingConfiguration</code> if you want to explicitly set the alias <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_RoutingConfigurationListItem.html#StepFunctions-Type-RoutingConfigurationListItem-weight">weights</a> . Weight is the percentage of traffic you want to route to a state machine version.
     * <p>
     * <blockquote>
     * <p>
     * <code>RoutingConfiguration</code> and <code>DeploymentPreference</code> are mutually exclusive properties. You must define only one of these properties.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-routingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-routingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRoutingConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStateMachineAliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStateMachineAliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStateMachineAliasProps> {
        java.lang.Object deploymentPreference;
        java.lang.String description;
        java.lang.String name;
        java.lang.Object routingConfiguration;

        /**
         * Sets the value of {@link CfnStateMachineAliasProps#getDeploymentPreference}
         * @param deploymentPreference The settings that enable gradual state machine deployments.
         *                             These settings include <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-alarms">Alarms</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-interval">Interval</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-percentage">Percentage</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-statemachineversionarn">StateMachineVersionArn</a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-type">Type</a> .
         *                             <p>
         *                             CloudFormation automatically shifts traffic from the version an alias currently points to, to a new state machine version that you specify.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             <code>RoutingConfiguration</code> and <code>DeploymentPreference</code> are mutually exclusive properties. You must define only one of these properties.
         *                             <p>
         *                             </blockquote>
         *                             <p>
         *                             Based on the type of deployment you want to perform, you can specify one of the following settings:
         *                             <p>
         *                             <ul>
         *                             <li><code>LINEAR</code> - Shifts traffic to the new version in equal increments with an equal number of minutes between each increment.</li>
         *                             </ul>
         *                             <p>
         *                             For example, if you specify the increment percent as <code>20</code> with an interval of <code>600</code> minutes, this deployment increases traffic by 20 percent every 600 minutes until the new version receives 100 percent of the traffic. This deployment immediately rolls back the new version if any Amazon CloudWatch alarms are triggered.
         *                             <p>
         *                             <ul>
         *                             <li><code>ALL_AT_ONCE</code> - Shifts 100 percent of traffic to the new version immediately. CloudFormation monitors the new version and rolls it back automatically to the previous version if any CloudWatch alarms are triggered.</li>
         *                             <li><code>CANARY</code> - Shifts traffic in two increments.</li>
         *                             </ul>
         *                             <p>
         *                             In the first increment, a small percentage of traffic, for example, 10 percent is shifted to the new version. In the second increment, before a specified time interval in seconds gets over, the remaining traffic is shifted to the new version. The shift to the new version for the remaining traffic takes place only if no CloudWatch alarms are triggered during the specified time interval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPreference(software.amazon.awscdk.IResolvable deploymentPreference) {
            this.deploymentPreference = deploymentPreference;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineAliasProps#getDeploymentPreference}
         * @param deploymentPreference The settings that enable gradual state machine deployments.
         *                             These settings include <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-alarms">Alarms</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-interval">Interval</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-percentage">Percentage</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-statemachineversionarn">StateMachineVersionArn</a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-type">Type</a> .
         *                             <p>
         *                             CloudFormation automatically shifts traffic from the version an alias currently points to, to a new state machine version that you specify.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             <code>RoutingConfiguration</code> and <code>DeploymentPreference</code> are mutually exclusive properties. You must define only one of these properties.
         *                             <p>
         *                             </blockquote>
         *                             <p>
         *                             Based on the type of deployment you want to perform, you can specify one of the following settings:
         *                             <p>
         *                             <ul>
         *                             <li><code>LINEAR</code> - Shifts traffic to the new version in equal increments with an equal number of minutes between each increment.</li>
         *                             </ul>
         *                             <p>
         *                             For example, if you specify the increment percent as <code>20</code> with an interval of <code>600</code> minutes, this deployment increases traffic by 20 percent every 600 minutes until the new version receives 100 percent of the traffic. This deployment immediately rolls back the new version if any Amazon CloudWatch alarms are triggered.
         *                             <p>
         *                             <ul>
         *                             <li><code>ALL_AT_ONCE</code> - Shifts 100 percent of traffic to the new version immediately. CloudFormation monitors the new version and rolls it back automatically to the previous version if any CloudWatch alarms are triggered.</li>
         *                             <li><code>CANARY</code> - Shifts traffic in two increments.</li>
         *                             </ul>
         *                             <p>
         *                             In the first increment, a small percentage of traffic, for example, 10 percent is shifted to the new version. In the second increment, before a specified time interval in seconds gets over, the remaining traffic is shifted to the new version. The shift to the new version for the remaining traffic takes place only if no CloudWatch alarms are triggered during the specified time interval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPreference(software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias.DeploymentPreferenceProperty deploymentPreference) {
            this.deploymentPreference = deploymentPreference;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineAliasProps#getDescription}
         * @param description An optional description of the state machine alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineAliasProps#getName}
         * @param name The name of the state machine alias.
         *             If you don't provide a name, it uses an automatically generated name based on the logical ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineAliasProps#getRoutingConfiguration}
         * @param routingConfiguration The routing configuration of an alias.
         *                             Routing configuration splits <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html">StartExecution</a> requests between one or two versions of the same state machine.
         *                             <p>
         *                             Use <code>RoutingConfiguration</code> if you want to explicitly set the alias <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_RoutingConfigurationListItem.html#StepFunctions-Type-RoutingConfigurationListItem-weight">weights</a> . Weight is the percentage of traffic you want to route to a state machine version.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             <code>RoutingConfiguration</code> and <code>DeploymentPreference</code> are mutually exclusive properties. You must define only one of these properties.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingConfiguration(software.amazon.awscdk.IResolvable routingConfiguration) {
            this.routingConfiguration = routingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineAliasProps#getRoutingConfiguration}
         * @param routingConfiguration The routing configuration of an alias.
         *                             Routing configuration splits <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html">StartExecution</a> requests between one or two versions of the same state machine.
         *                             <p>
         *                             Use <code>RoutingConfiguration</code> if you want to explicitly set the alias <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_RoutingConfigurationListItem.html#StepFunctions-Type-RoutingConfigurationListItem-weight">weights</a> . Weight is the percentage of traffic you want to route to a state machine version.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             <code>RoutingConfiguration</code> and <code>DeploymentPreference</code> are mutually exclusive properties. You must define only one of these properties.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingConfiguration(java.util.List<? extends java.lang.Object> routingConfiguration) {
            this.routingConfiguration = routingConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStateMachineAliasProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStateMachineAliasProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStateMachineAliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStateMachineAliasProps {
        private final java.lang.Object deploymentPreference;
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.lang.Object routingConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploymentPreference = software.amazon.jsii.Kernel.get(this, "deploymentPreference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routingConfiguration = software.amazon.jsii.Kernel.get(this, "routingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploymentPreference = builder.deploymentPreference;
            this.description = builder.description;
            this.name = builder.name;
            this.routingConfiguration = builder.routingConfiguration;
        }

        @Override
        public final java.lang.Object getDeploymentPreference() {
            return this.deploymentPreference;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRoutingConfiguration() {
            return this.routingConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeploymentPreference() != null) {
                data.set("deploymentPreference", om.valueToTree(this.getDeploymentPreference()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRoutingConfiguration() != null) {
                data.set("routingConfiguration", om.valueToTree(this.getRoutingConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.CfnStateMachineAliasProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStateMachineAliasProps.Jsii$Proxy that = (CfnStateMachineAliasProps.Jsii$Proxy) o;

            if (this.deploymentPreference != null ? !this.deploymentPreference.equals(that.deploymentPreference) : that.deploymentPreference != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.routingConfiguration != null ? this.routingConfiguration.equals(that.routingConfiguration) : that.routingConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deploymentPreference != null ? this.deploymentPreference.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.routingConfiguration != null ? this.routingConfiguration.hashCode() : 0);
            return result;
        }
    }
}
