package software.amazon.awscdk.services.stepfunctions;

/**
 * A Condition for use in a Choice state branch.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Map map = Map.Builder.create(this, "Map State")
 *         .maxConcurrency(1)
 *         .itemsPath(JsonPath.stringAt("$.inputForMap"))
 *         .itemSelector(Map.of(
 *                 "item", JsonPath.stringAt("$.Map.Item.Value")))
 *         .resultPath("$.mapOutput")
 *         .build();
 * // The Map iterator can contain a IChainable, which can be an individual or multiple steps chained together.
 * // Below example is with a Choice and Pass step
 * Choice choice = new Choice(this, "Choice");
 * Condition condition1 = Condition.stringEquals("$.item.status", "SUCCESS");
 * Pass step1 = new Pass(this, "Step1");
 * Pass step2 = new Pass(this, "Step2");
 * Pass finish = new Pass(this, "Finish");
 * Chain definition = choice.when(condition1, step1).otherwise(step2).afterwards().next(finish);
 * map.itemProcessor(definition);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:30.582Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Condition")
public abstract class Condition extends software.amazon.jsii.JsiiObject {

    protected Condition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Condition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Condition() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Combine two or more conditions with a logical AND.
     * <p>
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition and(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition... conditions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "and", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), java.util.Arrays.<Object>stream(conditions).toArray(Object[]::new));
    }

    /**
     * Matches if a boolean field has the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition booleanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "booleanEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a boolean field equals to a value at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition booleanEqualsJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "booleanEqualsJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if variable is boolean.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isBoolean(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isBoolean", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is not boolean.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isNotBoolean(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isNotBoolean", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is not null.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isNotNull(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isNotNull", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is not numeric.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isNotNumeric(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isNotNumeric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is not present.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isNotPresent(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isNotPresent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is not a string.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isNotString(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isNotString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is not a timestamp.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isNotTimestamp(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isNotTimestamp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is Null.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isNull(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isNull", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is numeric.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isNumeric(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isNumeric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is present.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isPresent(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isPresent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is a string.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isString(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Matches if variable is a timestamp.
     * <p>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition isTimestamp(final @org.jetbrains.annotations.NotNull java.lang.String variable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "isTimestamp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Negate a condition.
     * <p>
     * @param condition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition not(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition condition) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "not", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(condition, "condition is required") });
    }

    /**
     * Matches if a numeric field has the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field has the value in a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberEqualsJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberEqualsJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is greater than the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberGreaterThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberGreaterThan", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is greater than or equal to the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberGreaterThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberGreaterThanEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is greater than or equal to the value at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberGreaterThanEqualsJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberGreaterThanEqualsJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is greater than the value at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberGreaterThanJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberGreaterThanJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is less than the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberLessThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberLessThan", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is less than or equal to the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberLessThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberLessThanEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is less than or equal to the numeric value at given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberLessThanEqualsJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberLessThanEqualsJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is less than the value at the given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberLessThanJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberLessThanJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Combine two or more conditions with a logical OR.
     * <p>
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition or(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition... conditions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "or", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), java.util.Arrays.<Object>stream(conditions).toArray(Object[]::new));
    }

    /**
     * Matches if a string field has the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field equals to a value at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringEqualsJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringEqualsJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts after a given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringGreaterThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringGreaterThan", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts after or equal to a given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringGreaterThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringGreaterThanEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts after or equal to value at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringGreaterThanEqualsJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringGreaterThanEqualsJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts after a value at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringGreaterThanJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringGreaterThanJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts before a given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringLessThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringLessThan", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts equal to or before a given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringLessThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringLessThanEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts equal to or before a given mapping.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringLessThanEqualsJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringLessThanEqualsJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts before a given value at a particular mapping.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringLessThanJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringLessThanJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a field matches a string pattern that can contain a wild card (<em>) e.g: log-</em>.txt or <em>LATEST</em>. No other characters other than "<em>" have any special meaning - * can be escaped: \</em>.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringMatches(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringMatches", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is the same time as the given timestamp.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is the same time as the timestamp at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampEqualsJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampEqualsJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is after the given timestamp.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampGreaterThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampGreaterThan", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is after or equal to the given timestamp.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampGreaterThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampGreaterThanEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is after or equal to the timestamp at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampGreaterThanEqualsJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampGreaterThanEqualsJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is after the timestamp at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampGreaterThanJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampGreaterThanJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is before the given timestamp.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampLessThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampLessThan", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is before or equal to the given timestamp.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampLessThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampLessThanEquals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is before or equal to the timestamp at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampLessThanEqualsJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampLessThanEqualsJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is before the timestamp at a given mapping path.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampLessThanJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampLessThanJsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Condition.class), new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Render Amazon States Language JSON for the condition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Object renderCondition();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.Condition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Render Amazon States Language JSON for the condition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Object renderCondition() {
            return software.amazon.jsii.Kernel.call(this, "renderCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }
    }
}
