package software.amazon.awscdk.services.stepfunctions;

/**
 * Options for finding reachable states.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * FindStateOptions findStateOptions = FindStateOptions.builder()
 *         .includeErrorHandlers(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:30.591Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.FindStateOptions")
@software.amazon.jsii.Jsii.Proxy(FindStateOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FindStateOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether or not to follow error-handling transitions.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeErrorHandlers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FindStateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FindStateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FindStateOptions> {
        java.lang.Boolean includeErrorHandlers;

        /**
         * Sets the value of {@link FindStateOptions#getIncludeErrorHandlers}
         * @param includeErrorHandlers Whether or not to follow error-handling transitions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeErrorHandlers(java.lang.Boolean includeErrorHandlers) {
            this.includeErrorHandlers = includeErrorHandlers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FindStateOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FindStateOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FindStateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FindStateOptions {
        private final java.lang.Boolean includeErrorHandlers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.includeErrorHandlers = software.amazon.jsii.Kernel.get(this, "includeErrorHandlers", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.includeErrorHandlers = builder.includeErrorHandlers;
        }

        @Override
        public final java.lang.Boolean getIncludeErrorHandlers() {
            return this.includeErrorHandlers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIncludeErrorHandlers() != null) {
                data.set("includeErrorHandlers", om.valueToTree(this.getIncludeErrorHandlers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.FindStateOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FindStateOptions.Jsii$Proxy that = (FindStateOptions.Jsii$Proxy) o;

            return this.includeErrorHandlers != null ? this.includeErrorHandlers.equals(that.includeErrorHandlers) : that.includeErrorHandlers == null;
        }

        @Override
        public final int hashCode() {
            int result = this.includeErrorHandlers != null ? this.includeErrorHandlers.hashCode() : 0;
            return result;
        }
    }
}
