package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Starts a job run.
 * <p>
 * A job is a unit of work that you submit to Amazon EMR on EKS for execution.
 * The work performed by the job can be defined by a Spark jar, PySpark script, or SparkSQL query.
 * A job run is an execution of the job on the virtual cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrContainersStartJobRun.Builder.create(this, "EMR Containers Start Job Run")
 *         .virtualCluster(VirtualClusterInput.fromVirtualClusterId("de92jdei2910fwedz"))
 *         .releaseLabel(ReleaseLabel.EMR_6_2_0)
 *         .jobName("EMR-Containers-Job")
 *         .jobDriver(JobDriver.builder()
 *                 .sparkSubmitJobDriver(SparkSubmitJobDriver.builder()
 *                         .entryPoint(TaskInput.fromText("local:///usr/lib/spark/examples/src/main/python/pi.py"))
 *                         .build())
 *                 .build())
 *         .applicationConfig(List.of(ApplicationConfiguration.builder()
 *                 .classification(Classification.SPARK_DEFAULTS)
 *                 .properties(Map.of(
 *                         "spark.executor.instances", "1",
 *                         "spark.executor.memory", "512M"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-emr-eks.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-emr-eks.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:30.754Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EmrContainersStartJobRun")
public class EmrContainersStartJobRun extends software.amazon.awscdk.services.stepfunctions.TaskStateBase implements software.amazon.awscdk.services.iam.IGrantable {

    protected EmrContainersStartJobRun(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmrContainersStartJobRun(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EmrContainersStartJobRun(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrContainersStartJobRunProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return software.amazon.jsii.Kernel.get(this, "taskMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrContainersStartJobRun}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.EmrContainersStartJobRun> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id Descriptive identifier for this chainable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrContainersStartJobRunProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.EmrContainersStartJobRunProps.Builder();
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: - No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * Credentials for an IAM Role that the State Machine assumes for executing the task.
         * <p>
         * This enables cross-account resource invocations.
         * <p>
         * Default: - None (Task is executed using the State Machine's execution role)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html</a>
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * (deprecated) Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>heartbeatTimeout</code>
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(final software.amazon.awscdk.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * Timeout for the heartbeat.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeatTimeout Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: - The entire task input (JSON path '$')
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns.
         * <p>
         * Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * <p>
         * Default: - `IntegrationPattern.REQUEST_RESPONSE` for most tasks.
         * `IntegrationPattern.RUN_JOB` for the following exceptions:
         * `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html</a>
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * JSONPath expression to select select a portion of the state output to pass to the next state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: - The entire JSON node determined by the state input, the task result,
         * and resultPath is passed to the next state (JSON path '$')
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: - Replaces the entire input with the result (JSON path '$')
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        /**
         * Optional name for this state.
         * <p>
         * Default: - The construct ID will be used as state name
         * <p>
         * @return {@code this}
         * @param stateName Optional name for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(final java.lang.String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        /**
         * Timeout for the task.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param taskTimeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.props.taskTimeout(taskTimeout);
            return this;
        }

        /**
         * (deprecated) Timeout for the task.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>taskTimeout</code>
         * @param timeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * The job driver for the job run.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_JobDriver.html">https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_JobDriver.html</a>
         * @param jobDriver The job driver for the job run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDriver(final software.amazon.awscdk.services.stepfunctions.tasks.JobDriver jobDriver) {
            this.props.jobDriver(jobDriver);
            return this;
        }

        /**
         * The Amazon EMR release version to use for the job run.
         * <p>
         * @return {@code this}
         * @param releaseLabel The Amazon EMR release version to use for the job run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseLabel(final software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel releaseLabel) {
            this.props.releaseLabel(releaseLabel);
            return this;
        }

        /**
         * The ID of the virtual cluster where the job will be run.
         * <p>
         * @return {@code this}
         * @param virtualCluster The ID of the virtual cluster where the job will be run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualCluster(final software.amazon.awscdk.services.stepfunctions.tasks.VirtualClusterInput virtualCluster) {
            this.props.virtualCluster(virtualCluster);
            return this;
        }

        /**
         * The configurations for the application running in the job run.
         * <p>
         * Maximum of 100 items
         * <p>
         * Default: - No application config
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_Configuration.html">https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_Configuration.html</a>
         * @param applicationConfig The configurations for the application running in the job run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationConfig(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.ApplicationConfiguration> applicationConfig) {
            this.props.applicationConfig(applicationConfig);
            return this;
        }

        /**
         * The execution role for the job run.
         * <p>
         * If <code>virtualClusterId</code> is from a JSON input path, an execution role must be provided.
         * If an execution role is provided, follow the documentation to update the role trust policy.
         * <p>
         * Default: - Automatically generated only when the provided `virtualClusterId` is not an encoded JSON path
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/setting-up-trust-policy.html">https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/setting-up-trust-policy.html</a>
         * @param executionRole The execution role for the job run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final software.amazon.awscdk.services.iam.IRole executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        /**
         * The name of the job run.
         * <p>
         * Default: - No job run name
         * <p>
         * @return {@code this}
         * @param jobName The name of the job run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobName(final java.lang.String jobName) {
            this.props.jobName(jobName);
            return this;
        }

        /**
         * Configuration for monitoring the job run.
         * <p>
         * Default: - logging enabled and resources automatically generated if `monitoring.logging` is set to `true`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_MonitoringConfiguration.html">https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_MonitoringConfiguration.html</a>
         * @param monitoring Configuration for monitoring the job run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoring(final software.amazon.awscdk.services.stepfunctions.tasks.Monitoring monitoring) {
            this.props.monitoring(monitoring);
            return this;
        }

        /**
         * The tags assigned to job runs.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param tags The tags assigned to job runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrContainersStartJobRun}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.EmrContainersStartJobRun build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.EmrContainersStartJobRun(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
