package software.amazon.awscdk.services.verifiedpermissions;

/**
 * Creates or updates a reference to Amazon Cognito as an external identity provider.
 * <p>
 * If you are creating a new identity source, then you must specify a <code>Configuration</code> . If you are updating an existing identity source, then you must specify an <code>UpdateConfiguration</code> .
 * <p>
 * After you create an identity source, you can use the identities provided by the IdP as proxies for the principal in authorization queries that use the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">IsAuthorizedWithToken</a> operation. These identities take the form of tokens that contain claims about the user, such as IDs, attributes and group memberships. Amazon Cognito provides both identity tokens and access tokens, and Verified Permissions can use either or both. Any combination of identity and access tokens results in the same Cedar principal. Verified Permissions automatically translates the information about the identities into the standard Cedar attributes that can be evaluated by your policies. Because the Amazon Cognito identity and access tokens can contain different information, the tokens you choose to use determine the attributes that are available to access in the Cedar principal from your policies.
 * <p>
 * Amazon Cognito Identity is not available in all of the same AWS Regions as Amazon Verified Permissions . Because of this, the <code>AWS::VerifiedPermissions::IdentitySource</code> type is not available to create from AWS CloudFormation in Regions where Amazon Cognito Identity is not currently available. Users can still create <code>AWS::VerifiedPermissions::IdentitySource</code> in those Regions, but only from the AWS CLI , Amazon Verified Permissions SDK, or from the AWS console.
 * <p>
 * <blockquote>
 * <p>
 * To reference a user from this identity source in your Cedar policies, use the following syntax.
 * <p>
 * <em>IdentityType::"<CognitoUserPoolIdentifier>|<CognitoClientId></em>
 * <p>
 * Where <code>IdentityType</code> is the string that you provide to the <code>PrincipalEntityType</code> parameter for this operation. The <code>CognitoUserPoolId</code> and <code>CognitoClientId</code> are defined by the Amazon Cognito user pool.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.verifiedpermissions.*;
 * CfnIdentitySource cfnIdentitySource = CfnIdentitySource.Builder.create(this, "MyCfnIdentitySource")
 *         .configuration(IdentitySourceConfigurationProperty.builder()
 *                 .cognitoUserPoolConfiguration(CognitoUserPoolConfigurationProperty.builder()
 *                         .userPoolArn("userPoolArn")
 *                         // the properties below are optional
 *                         .clientIds(List.of("clientIds"))
 *                         .build())
 *                 .build())
 *         .policyStoreId("policyStoreId")
 *         // the properties below are optional
 *         .principalEntityType("principalEntityType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:31.283Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource")
public class CfnIdentitySource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnIdentitySource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentitySource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdentitySource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrDetails() {
        return software.amazon.jsii.Kernel.get(this, "attrDetails", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrDetailsClientIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrDetailsClientIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDetailsDiscoveryUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrDetailsDiscoveryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDetailsOpenIdIssuer() {
        return software.amazon.jsii.Kernel.get(this, "attrDetailsOpenIdIssuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDetailsUserPoolArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDetailsUserPoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of the new or updated identity store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentitySourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentitySourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains configuration information used when creating a new identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains configuration information used when creating a new identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * Contains configuration information used when creating a new identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.IdentitySourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * Specifies the ID of the policy store in which you want to store this identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyStoreId() {
        return software.amazon.jsii.Kernel.get(this, "policyStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the ID of the policy store in which you want to store this identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyStoreId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyStoreId", java.util.Objects.requireNonNull(value, "policyStoreId is required"));
    }

    /**
     * Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrincipalEntityType() {
        return software.amazon.jsii.Kernel.get(this, "principalEntityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrincipalEntityType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "principalEntityType", value);
    }
    /**
     * A structure that contains configuration information used when creating or updating an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * CognitoUserPoolConfigurationProperty cognitoUserPoolConfigurationProperty = CognitoUserPoolConfigurationProperty.builder()
     *         .userPoolArn("userPoolArn")
     *         // the properties below are optional
     *         .clientIds(List.of("clientIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.CognitoUserPoolConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoUserPoolConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoUserPoolConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool that contains the identities to be authorized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html#cfn-verifiedpermissions-identitysource-cognitouserpoolconfiguration-userpoolarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html#cfn-verifiedpermissions-identitysource-cognitouserpoolconfiguration-userpoolarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolArn();

        /**
         * The unique application client IDs that are associated with the specified Amazon Cognito user pool.
         * <p>
         * Example: <code>"ClientIds": ["&amp;ExampleCogClientId;"]</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html#cfn-verifiedpermissions-identitysource-cognitouserpoolconfiguration-clientids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html#cfn-verifiedpermissions-identitysource-cognitouserpoolconfiguration-clientids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClientIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoUserPoolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoUserPoolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoUserPoolConfigurationProperty> {
            java.lang.String userPoolArn;
            java.util.List<java.lang.String> clientIds;

            /**
             * Sets the value of {@link CognitoUserPoolConfigurationProperty#getUserPoolArn}
             * @param userPoolArn The <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool that contains the identities to be authorized. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolArn(java.lang.String userPoolArn) {
                this.userPoolArn = userPoolArn;
                return this;
            }

            /**
             * Sets the value of {@link CognitoUserPoolConfigurationProperty#getClientIds}
             * @param clientIds The unique application client IDs that are associated with the specified Amazon Cognito user pool.
             *                  Example: <code>"ClientIds": ["&amp;ExampleCogClientId;"]</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientIds(java.util.List<java.lang.String> clientIds) {
                this.clientIds = clientIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoUserPoolConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoUserPoolConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoUserPoolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoUserPoolConfigurationProperty {
            private final java.lang.String userPoolArn;
            private final java.util.List<java.lang.String> clientIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.userPoolArn = software.amazon.jsii.Kernel.get(this, "userPoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientIds = software.amazon.jsii.Kernel.get(this, "clientIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.userPoolArn = java.util.Objects.requireNonNull(builder.userPoolArn, "userPoolArn is required");
                this.clientIds = builder.clientIds;
            }

            @Override
            public final java.lang.String getUserPoolArn() {
                return this.userPoolArn;
            }

            @Override
            public final java.util.List<java.lang.String> getClientIds() {
                return this.clientIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("userPoolArn", om.valueToTree(this.getUserPoolArn()));
                if (this.getClientIds() != null) {
                    data.set("clientIds", om.valueToTree(this.getClientIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.CognitoUserPoolConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoUserPoolConfigurationProperty.Jsii$Proxy that = (CognitoUserPoolConfigurationProperty.Jsii$Proxy) o;

                if (!userPoolArn.equals(that.userPoolArn)) return false;
                return this.clientIds != null ? this.clientIds.equals(that.clientIds) : that.clientIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.userPoolArn.hashCode();
                result = 31 * result + (this.clientIds != null ? this.clientIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains configuration information used when creating or updating a new identity source.
     * <p>
     * <blockquote>
     * <p>
     * At this time, the only valid member of this structure is a Amazon Cognito user pool configuration.
     * <p>
     * You must specify a <code>userPoolArn</code> , and optionally, a <code>ClientId</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * IdentitySourceConfigurationProperty identitySourceConfigurationProperty = IdentitySourceConfigurationProperty.builder()
     *         .cognitoUserPoolConfiguration(CognitoUserPoolConfigurationProperty.builder()
     *                 .userPoolArn("userPoolArn")
     *                 // the properties below are optional
     *                 .clientIds(List.of("clientIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.IdentitySourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentitySourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentitySourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that contains configuration information used when creating or updating an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourceconfiguration.html#cfn-verifiedpermissions-identitysource-identitysourceconfiguration-cognitouserpoolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourceconfiguration.html#cfn-verifiedpermissions-identitysource-identitysourceconfiguration-cognitouserpoolconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCognitoUserPoolConfiguration();

        /**
         * @return a {@link Builder} of {@link IdentitySourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentitySourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentitySourceConfigurationProperty> {
            java.lang.Object cognitoUserPoolConfiguration;

            /**
             * Sets the value of {@link IdentitySourceConfigurationProperty#getCognitoUserPoolConfiguration}
             * @param cognitoUserPoolConfiguration A structure that contains configuration information used when creating or updating an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoUserPoolConfiguration(software.amazon.awscdk.IResolvable cognitoUserPoolConfiguration) {
                this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceConfigurationProperty#getCognitoUserPoolConfiguration}
             * @param cognitoUserPoolConfiguration A structure that contains configuration information used when creating or updating an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoUserPoolConfiguration(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.CognitoUserPoolConfigurationProperty cognitoUserPoolConfiguration) {
                this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentitySourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentitySourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentitySourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentitySourceConfigurationProperty {
            private final java.lang.Object cognitoUserPoolConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cognitoUserPoolConfiguration = software.amazon.jsii.Kernel.get(this, "cognitoUserPoolConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cognitoUserPoolConfiguration = java.util.Objects.requireNonNull(builder.cognitoUserPoolConfiguration, "cognitoUserPoolConfiguration is required");
            }

            @Override
            public final java.lang.Object getCognitoUserPoolConfiguration() {
                return this.cognitoUserPoolConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cognitoUserPoolConfiguration", om.valueToTree(this.getCognitoUserPoolConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.IdentitySourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentitySourceConfigurationProperty.Jsii$Proxy that = (IdentitySourceConfigurationProperty.Jsii$Proxy) o;

                return this.cognitoUserPoolConfiguration.equals(that.cognitoUserPoolConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.cognitoUserPoolConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * A structure that contains configuration of the identity source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * IdentitySourceDetailsProperty identitySourceDetailsProperty = IdentitySourceDetailsProperty.builder()
     *         .clientIds(List.of("clientIds"))
     *         .discoveryUrl("discoveryUrl")
     *         .openIdIssuer("openIdIssuer")
     *         .userPoolArn("userPoolArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.IdentitySourceDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentitySourceDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentitySourceDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The application client IDs associated with the specified Amazon Cognito user pool that are enabled for this identity source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-clientids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-clientids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClientIds() {
            return null;
        }

        /**
         * The well-known URL that points to this user pool's OIDC discovery endpoint.
         * <p>
         * This is a URL string in the following format. This URL replaces the placeholders for both the AWS Region and the user pool identifier with those appropriate for this user pool.
         * <p>
         * <code>https://cognito-idp. *&lt;region&gt;* .amazonaws.com/ *&lt;user-pool-id&gt;* /.well-known/openid-configuration</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-discoveryurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-discoveryurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDiscoveryUrl() {
            return null;
        }

        /**
         * A string that identifies the type of OIDC service represented by this identity source.
         * <p>
         * At this time, the only valid value is <code>cognito</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-openidissuer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-openidissuer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOpenIdIssuer() {
            return null;
        }

        /**
         * The <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool whose identities are accessible to this Verified Permissions policy store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-userpoolarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-userpoolarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdentitySourceDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentitySourceDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentitySourceDetailsProperty> {
            java.util.List<java.lang.String> clientIds;
            java.lang.String discoveryUrl;
            java.lang.String openIdIssuer;
            java.lang.String userPoolArn;

            /**
             * Sets the value of {@link IdentitySourceDetailsProperty#getClientIds}
             * @param clientIds The application client IDs associated with the specified Amazon Cognito user pool that are enabled for this identity source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientIds(java.util.List<java.lang.String> clientIds) {
                this.clientIds = clientIds;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceDetailsProperty#getDiscoveryUrl}
             * @param discoveryUrl The well-known URL that points to this user pool's OIDC discovery endpoint.
             *                     This is a URL string in the following format. This URL replaces the placeholders for both the AWS Region and the user pool identifier with those appropriate for this user pool.
             *                     <p>
             *                     <code>https://cognito-idp. *&lt;region&gt;* .amazonaws.com/ *&lt;user-pool-id&gt;* /.well-known/openid-configuration</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder discoveryUrl(java.lang.String discoveryUrl) {
                this.discoveryUrl = discoveryUrl;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceDetailsProperty#getOpenIdIssuer}
             * @param openIdIssuer A string that identifies the type of OIDC service represented by this identity source.
             *                     At this time, the only valid value is <code>cognito</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdIssuer(java.lang.String openIdIssuer) {
                this.openIdIssuer = openIdIssuer;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceDetailsProperty#getUserPoolArn}
             * @param userPoolArn The <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool whose identities are accessible to this Verified Permissions policy store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolArn(java.lang.String userPoolArn) {
                this.userPoolArn = userPoolArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentitySourceDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentitySourceDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentitySourceDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentitySourceDetailsProperty {
            private final java.util.List<java.lang.String> clientIds;
            private final java.lang.String discoveryUrl;
            private final java.lang.String openIdIssuer;
            private final java.lang.String userPoolArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientIds = software.amazon.jsii.Kernel.get(this, "clientIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.discoveryUrl = software.amazon.jsii.Kernel.get(this, "discoveryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.openIdIssuer = software.amazon.jsii.Kernel.get(this, "openIdIssuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolArn = software.amazon.jsii.Kernel.get(this, "userPoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientIds = builder.clientIds;
                this.discoveryUrl = builder.discoveryUrl;
                this.openIdIssuer = builder.openIdIssuer;
                this.userPoolArn = builder.userPoolArn;
            }

            @Override
            public final java.util.List<java.lang.String> getClientIds() {
                return this.clientIds;
            }

            @Override
            public final java.lang.String getDiscoveryUrl() {
                return this.discoveryUrl;
            }

            @Override
            public final java.lang.String getOpenIdIssuer() {
                return this.openIdIssuer;
            }

            @Override
            public final java.lang.String getUserPoolArn() {
                return this.userPoolArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientIds() != null) {
                    data.set("clientIds", om.valueToTree(this.getClientIds()));
                }
                if (this.getDiscoveryUrl() != null) {
                    data.set("discoveryUrl", om.valueToTree(this.getDiscoveryUrl()));
                }
                if (this.getOpenIdIssuer() != null) {
                    data.set("openIdIssuer", om.valueToTree(this.getOpenIdIssuer()));
                }
                if (this.getUserPoolArn() != null) {
                    data.set("userPoolArn", om.valueToTree(this.getUserPoolArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.IdentitySourceDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentitySourceDetailsProperty.Jsii$Proxy that = (IdentitySourceDetailsProperty.Jsii$Proxy) o;

                if (this.clientIds != null ? !this.clientIds.equals(that.clientIds) : that.clientIds != null) return false;
                if (this.discoveryUrl != null ? !this.discoveryUrl.equals(that.discoveryUrl) : that.discoveryUrl != null) return false;
                if (this.openIdIssuer != null ? !this.openIdIssuer.equals(that.openIdIssuer) : that.openIdIssuer != null) return false;
                return this.userPoolArn != null ? this.userPoolArn.equals(that.userPoolArn) : that.userPoolArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientIds != null ? this.clientIds.hashCode() : 0;
                result = 31 * result + (this.discoveryUrl != null ? this.discoveryUrl.hashCode() : 0);
                result = 31 * result + (this.openIdIssuer != null ? this.openIdIssuer.hashCode() : 0);
                result = 31 * result + (this.userPoolArn != null ? this.userPoolArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySourceProps.Builder();
        }

        /**
         * Contains configuration information used when creating a new identity source.
         * <p>
         * <blockquote>
         * <p>
         * At this time, the only valid member of this structure is a Amazon Cognito user pool configuration.
         * <p>
         * You must specify a <code>userPoolArn</code> , and optionally, a <code>ClientId</code> .
         * <p>
         * </blockquote>
         * <p>
         * This data type is used as a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a> operation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-configuration</a>
         * @param configuration Contains configuration information used when creating a new identity source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * Contains configuration information used when creating a new identity source.
         * <p>
         * <blockquote>
         * <p>
         * At this time, the only valid member of this structure is a Amazon Cognito user pool configuration.
         * <p>
         * You must specify a <code>userPoolArn</code> , and optionally, a <code>ClientId</code> .
         * <p>
         * </blockquote>
         * <p>
         * This data type is used as a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a> operation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-configuration</a>
         * @param configuration Contains configuration information used when creating a new identity source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.IdentitySourceConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * Specifies the ID of the policy store in which you want to store this identity source.
         * <p>
         * Only policies and requests made using this policy store can reference identities from the identity provider configured in the new identity source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-policystoreid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-policystoreid</a>
         * @param policyStoreId Specifies the ID of the policy store in which you want to store this identity source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStoreId(final java.lang.String policyStoreId) {
            this.props.policyStoreId(policyStoreId);
            return this;
        }

        /**
         * Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-principalentitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-principalentitytype</a>
         * @param principalEntityType Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principalEntityType(final java.lang.String principalEntityType) {
            this.props.principalEntityType(principalEntityType);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource build() {
            return new software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
