/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.aws_apigatewayv2_integrations;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegrationProps;
import software.amazon.awscdk.services.apigatewayv2.HttpConnectionType;
import software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType;
import software.amazon.awscdk.services.apigatewayv2.HttpMethod;
import software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration;
import software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationBindOptions;
import software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig;
import software.amazon.awscdk.services.apigatewayv2.IVpcLink;
import software.amazon.awscdk.services.apigatewayv2.ParameterMapping;
import software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion;
import software.amazon.awscdk.services.servicediscovery.IService;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apigatewayv2_integrations.HttpServiceDiscoveryIntegration")
public class HttpServiceDiscoveryIntegration
extends HttpRouteIntegration {
    protected HttpServiceDiscoveryIntegration(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpServiceDiscoveryIntegration(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public HttpServiceDiscoveryIntegration(@NotNull String id, @NotNull IService service, @Nullable HttpServiceDiscoveryIntegrationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(service, "service is required"), props});
    }

    public HttpServiceDiscoveryIntegration(@NotNull String id, @NotNull IService service) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(service, "service is required")});
    }

    @Override
    @NotNull
    public HttpRouteIntegrationConfig bind(@NotNull HttpRouteIntegrationBindOptions _options) {
        return (HttpRouteIntegrationConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(HttpRouteIntegrationConfig.class), (Object[])new Object[]{Objects.requireNonNull(_options, "_options is required")});
    }

    @NotNull
    protected HttpConnectionType getConnectionType() {
        return (HttpConnectionType)((Object)Kernel.get((Object)((Object)this), (String)"connectionType", (NativeType)NativeType.forClass(HttpConnectionType.class)));
    }

    protected void setConnectionType(@NotNull HttpConnectionType value) {
        Kernel.set((Object)((Object)this), (String)"connectionType", (Object)((Object)Objects.requireNonNull(value, "connectionType is required")));
    }

    @NotNull
    protected HttpMethod getHttpMethod() {
        return (HttpMethod)((Object)Kernel.get((Object)((Object)this), (String)"httpMethod", (NativeType)NativeType.forClass(HttpMethod.class)));
    }

    protected void setHttpMethod(@NotNull HttpMethod value) {
        Kernel.set((Object)((Object)this), (String)"httpMethod", (Object)((Object)Objects.requireNonNull(value, "httpMethod is required")));
    }

    @NotNull
    protected HttpIntegrationType getIntegrationType() {
        return (HttpIntegrationType)((Object)Kernel.get((Object)((Object)this), (String)"integrationType", (NativeType)NativeType.forClass(HttpIntegrationType.class)));
    }

    protected void setIntegrationType(@NotNull HttpIntegrationType value) {
        Kernel.set((Object)((Object)this), (String)"integrationType", (Object)((Object)Objects.requireNonNull(value, "integrationType is required")));
    }

    @NotNull
    protected PayloadFormatVersion getPayloadFormatVersion() {
        return (PayloadFormatVersion)((Object)Kernel.get((Object)((Object)this), (String)"payloadFormatVersion", (NativeType)NativeType.forClass(PayloadFormatVersion.class)));
    }

    protected void setPayloadFormatVersion(@NotNull PayloadFormatVersion value) {
        Kernel.set((Object)((Object)this), (String)"payloadFormatVersion", (Object)((Object)Objects.requireNonNull(value, "payloadFormatVersion is required")));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<HttpServiceDiscoveryIntegration> {
        private final String id;
        private final IService service;
        private HttpServiceDiscoveryIntegrationProps.Builder props;

        public static Builder create(String id, IService service) {
            return new Builder(id, service);
        }

        private Builder(String id, IService service) {
            this.id = id;
            this.service = service;
        }

        public Builder method(HttpMethod method) {
            this.props().method(method);
            return this;
        }

        public Builder parameterMapping(ParameterMapping parameterMapping) {
            this.props().parameterMapping(parameterMapping);
            return this;
        }

        public Builder secureServerName(String secureServerName) {
            this.props().secureServerName(secureServerName);
            return this;
        }

        public Builder vpcLink(IVpcLink vpcLink) {
            this.props().vpcLink(vpcLink);
            return this;
        }

        public HttpServiceDiscoveryIntegration build() {
            return new HttpServiceDiscoveryIntegration(this.id, this.service, this.props != null ? this.props.build() : null);
        }

        private HttpServiceDiscoveryIntegrationProps.Builder props() {
            if (this.props == null) {
                this.props = new HttpServiceDiscoveryIntegrationProps.Builder();
            }
            return this.props;
        }
    }
}

