/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appintegrations;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.appintegrations.CfnApplication;
import software.amazon.awscdk.services.appintegrations.CfnApplicationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appintegrations.CfnApplication")
public class CfnApplication
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplication.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApplication(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplication(@NotNull Construct scope, @NotNull String id, @NotNull CfnApplicationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrApplicationArn() {
        return (String)Kernel.get((Object)this, (String)"attrApplicationArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getApplicationSourceConfig() {
        return Kernel.get((Object)this, (String)"applicationSourceConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setApplicationSourceConfig(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"applicationSourceConfig", (Object)Objects.requireNonNull(value, "applicationSourceConfig is required"));
    }

    public void setApplicationSourceConfig(@NotNull ApplicationSourceConfigProperty value) {
        Kernel.set((Object)this, (String)"applicationSourceConfig", (Object)Objects.requireNonNull(value, "applicationSourceConfig is required"));
    }

    @NotNull
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@NotNull String value) {
        Kernel.set((Object)this, (String)"description", (Object)Objects.requireNonNull(value, "description is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getNamespace() {
        return (String)Kernel.get((Object)this, (String)"namespace", (NativeType)NativeType.forClass(String.class));
    }

    public void setNamespace(@Nullable String value) {
        Kernel.set((Object)this, (String)"namespace", (Object)value);
    }

    @Nullable
    public List<String> getPermissions() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"permissions", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setPermissions(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"permissions", value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApplication> {
        private final Construct scope;
        private final String id;
        private final CfnApplicationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApplicationProps.Builder();
        }

        public Builder applicationSourceConfig(IResolvable applicationSourceConfig) {
            this.props.applicationSourceConfig(applicationSourceConfig);
            return this;
        }

        public Builder applicationSourceConfig(ApplicationSourceConfigProperty applicationSourceConfig) {
            this.props.applicationSourceConfig(applicationSourceConfig);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder namespace(String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        public Builder permissions(List<String> permissions) {
            this.props.permissions(permissions);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnApplication build() {
            return new CfnApplication(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appintegrations.CfnApplication.ExternalUrlConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExternalUrlConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAccessUrl();

        @Nullable
        default public List<String> getApprovedOrigins() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExternalUrlConfigProperty> {
            String accessUrl;
            List<String> approvedOrigins;

            public Builder accessUrl(String accessUrl) {
                this.accessUrl = accessUrl;
                return this;
            }

            public Builder approvedOrigins(List<String> approvedOrigins) {
                this.approvedOrigins = approvedOrigins;
                return this;
            }

            public ExternalUrlConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appintegrations.CfnApplication.ApplicationSourceConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationSourceConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getExternalUrlConfig();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationSourceConfigProperty> {
            Object externalUrlConfig;

            public Builder externalUrlConfig(IResolvable externalUrlConfig) {
                this.externalUrlConfig = externalUrlConfig;
                return this;
            }

            public Builder externalUrlConfig(ExternalUrlConfigProperty externalUrlConfig) {
                this.externalUrlConfig = externalUrlConfig;
                return this;
            }

            public ApplicationSourceConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

