/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.docdb;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.docdb.BackupProps;
import software.amazon.awscdk.services.docdb.DatabaseClusterAttributes;
import software.amazon.awscdk.services.docdb.DatabaseClusterProps;
import software.amazon.awscdk.services.docdb.Endpoint;
import software.amazon.awscdk.services.docdb.IClusterParameterGroup;
import software.amazon.awscdk.services.docdb.IDatabaseCluster;
import software.amazon.awscdk.services.docdb.Login;
import software.amazon.awscdk.services.docdb.RotationMultiUserOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps;
import software.amazon.awscdk.services.secretsmanager.SecretRotation;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_docdb.DatabaseCluster")
public class DatabaseCluster
extends Resource
implements IDatabaseCluster {
    public static final Number DEFAULT_NUM_INSTANCES = (Number)JsiiObject.jsiiStaticGet(DatabaseCluster.class, (String)"DEFAULT_NUM_INSTANCES", (NativeType)NativeType.forClass(Number.class));
    public static final Number DEFAULT_PORT = (Number)JsiiObject.jsiiStaticGet(DatabaseCluster.class, (String)"DEFAULT_PORT", (NativeType)NativeType.forClass(Number.class));

    protected DatabaseCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DatabaseCluster(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDatabaseCluster fromDatabaseClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseClusterAttributes attrs) {
        return (IDatabaseCluster)JsiiObject.jsiiStaticCall(DatabaseCluster.class, (String)"fromDatabaseClusterAttributes", (NativeType)NativeType.forClass(IDatabaseCluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public SecretRotation addRotationMultiUser(@NotNull String id, @NotNull RotationMultiUserOptions options) {
        return (SecretRotation)((Object)Kernel.call((Object)this, (String)"addRotationMultiUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")}));
    }

    @NotNull
    public SecretRotation addRotationSingleUser(@Nullable Duration automaticallyAfter) {
        return (SecretRotation)((Object)Kernel.call((Object)this, (String)"addRotationSingleUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[]{automaticallyAfter}));
    }

    @NotNull
    public SecretRotation addRotationSingleUser() {
        return (SecretRotation)((Object)Kernel.call((Object)this, (String)"addRotationSingleUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[0]));
    }

    public void addSecurityGroups(ISecurityGroup ... securityGroups) {
        Kernel.call((Object)this, (String)"addSecurityGroups", (NativeType)NativeType.VOID, (Object[])Arrays.stream(securityGroups).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public SecretAttachmentTargetProps asSecretAttachmentTarget() {
        return (SecretAttachmentTargetProps)Kernel.call((Object)this, (String)"asSecretAttachmentTarget", (NativeType)NativeType.forClass(SecretAttachmentTargetProps.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Endpoint getClusterEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"clusterEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @Override
    @NotNull
    public String getClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"clusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Endpoint getClusterReadEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"clusterReadEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @NotNull
    public String getClusterResourceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"clusterResourceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public List<Endpoint> getInstanceEndpoints() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"instanceEndpoints", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Endpoint.class))));
    }

    @Override
    @NotNull
    public List<String> getInstanceIdentifiers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"instanceIdentifiers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Override
    @NotNull
    public String getSecurityGroupId() {
        return (String)Kernel.get((Object)this, (String)"securityGroupId", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public ISecret getSecret() {
        return (ISecret)Kernel.get((Object)this, (String)"secret", (NativeType)NativeType.forClass(ISecret.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseCluster> {
        private final Construct scope;
        private final String id;
        private final DatabaseClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DatabaseClusterProps.Builder();
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder masterUser(Login masterUser) {
            this.props.masterUser(masterUser);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder backup(BackupProps backup) {
            this.props.backup(backup);
            return this;
        }

        public Builder cloudWatchLogsRetention(RetentionDays cloudWatchLogsRetention) {
            this.props.cloudWatchLogsRetention(cloudWatchLogsRetention);
            return this;
        }

        public Builder cloudWatchLogsRetentionRole(IRole cloudWatchLogsRetentionRole) {
            this.props.cloudWatchLogsRetentionRole(cloudWatchLogsRetentionRole);
            return this;
        }

        public Builder dbClusterName(String dbClusterName) {
            this.props.dbClusterName(dbClusterName);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.props.enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        public Builder engineVersion(String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        public Builder exportAuditLogsToCloudWatch(Boolean exportAuditLogsToCloudWatch) {
            this.props.exportAuditLogsToCloudWatch(exportAuditLogsToCloudWatch);
            return this;
        }

        public Builder exportProfilerLogsToCloudWatch(Boolean exportProfilerLogsToCloudWatch) {
            this.props.exportProfilerLogsToCloudWatch(exportProfilerLogsToCloudWatch);
            return this;
        }

        public Builder instanceIdentifierBase(String instanceIdentifierBase) {
            this.props.instanceIdentifierBase(instanceIdentifierBase);
            return this;
        }

        public Builder instanceRemovalPolicy(RemovalPolicy instanceRemovalPolicy) {
            this.props.instanceRemovalPolicy(instanceRemovalPolicy);
            return this;
        }

        public Builder instances(Number instances) {
            this.props.instances(instances);
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        public Builder parameterGroup(IClusterParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder securityGroupRemovalPolicy(RemovalPolicy securityGroupRemovalPolicy) {
            this.props.securityGroupRemovalPolicy(securityGroupRemovalPolicy);
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public DatabaseCluster build() {
            return new DatabaseCluster(this.scope, this.id, this.props.build());
        }
    }
}

