/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.securitylake;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.securitylake.CfnDataLake;
import software.amazon.awscdk.services.securitylake.CfnDataLakeProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securitylake.CfnDataLake")
public class CfnDataLake
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataLake.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDataLake(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataLake(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataLake(@NotNull Construct scope, @NotNull String id, @Nullable CfnDataLakeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnDataLake(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrS3BucketArn() {
        return (String)Kernel.get((Object)this, (String)"attrS3BucketArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public Object getEncryptionConfiguration() {
        return Kernel.get((Object)this, (String)"encryptionConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncryptionConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"encryptionConfiguration", (Object)value);
    }

    public void setEncryptionConfiguration(@Nullable EncryptionConfigurationProperty value) {
        Kernel.set((Object)this, (String)"encryptionConfiguration", (Object)value);
    }

    @Nullable
    public Object getLifecycleConfiguration() {
        return Kernel.get((Object)this, (String)"lifecycleConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLifecycleConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"lifecycleConfiguration", (Object)value);
    }

    public void setLifecycleConfiguration(@Nullable LifecycleConfigurationProperty value) {
        Kernel.set((Object)this, (String)"lifecycleConfiguration", (Object)value);
    }

    @Nullable
    public String getMetaStoreManagerRoleArn() {
        return (String)Kernel.get((Object)this, (String)"metaStoreManagerRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setMetaStoreManagerRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"metaStoreManagerRoleArn", (Object)value);
    }

    @Nullable
    public Object getReplicationConfiguration() {
        return Kernel.get((Object)this, (String)"replicationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setReplicationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"replicationConfiguration", (Object)value);
    }

    public void setReplicationConfiguration(@Nullable ReplicationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"replicationConfiguration", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataLake> {
        private final Construct scope;
        private final String id;
        private CfnDataLakeProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder encryptionConfiguration(IResolvable encryptionConfiguration) {
            this.props().encryptionConfiguration(encryptionConfiguration);
            return this;
        }

        public Builder encryptionConfiguration(EncryptionConfigurationProperty encryptionConfiguration) {
            this.props().encryptionConfiguration(encryptionConfiguration);
            return this;
        }

        public Builder lifecycleConfiguration(IResolvable lifecycleConfiguration) {
            this.props().lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }

        public Builder lifecycleConfiguration(LifecycleConfigurationProperty lifecycleConfiguration) {
            this.props().lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }

        public Builder metaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
            this.props().metaStoreManagerRoleArn(metaStoreManagerRoleArn);
            return this;
        }

        public Builder replicationConfiguration(IResolvable replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }

        public Builder replicationConfiguration(ReplicationConfigurationProperty replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public CfnDataLake build() {
            return new CfnDataLake(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnDataLakeProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnDataLakeProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securitylake.CfnDataLake.TransitionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransitionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDays() {
            return null;
        }

        @Nullable
        default public String getStorageClass() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransitionsProperty> {
            Number days;
            String storageClass;

            public Builder days(Number days) {
                this.days = days;
                return this;
            }

            public Builder storageClass(String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            public TransitionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securitylake.CfnDataLake.ReplicationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getRegions() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReplicationConfigurationProperty> {
            List<String> regions;
            String roleArn;

            public Builder regions(List<String> regions) {
                this.regions = regions;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public ReplicationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securitylake.CfnDataLake.LifecycleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LifecycleConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getExpiration() {
            return null;
        }

        @Nullable
        default public Object getTransitions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LifecycleConfigurationProperty> {
            Object expiration;
            Object transitions;

            public Builder expiration(IResolvable expiration) {
                this.expiration = expiration;
                return this;
            }

            public Builder expiration(ExpirationProperty expiration) {
                this.expiration = expiration;
                return this;
            }

            public Builder transitions(IResolvable transitions) {
                this.transitions = transitions;
                return this;
            }

            public Builder transitions(List<? extends Object> transitions) {
                this.transitions = transitions;
                return this;
            }

            public LifecycleConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securitylake.CfnDataLake.ExpirationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExpirationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDays() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExpirationProperty> {
            Number days;

            public Builder days(Number days) {
                this.days = days;
                return this;
            }

            public ExpirationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securitylake.CfnDataLake.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            String kmsKeyId;

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

