/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.bedrock;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.bedrock.CfnDataSource;
import software.amazon.awscdk.services.bedrock.CfnDataSourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource")
public class CfnDataSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataSource.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDataSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataSource(@NotNull Construct scope, @NotNull String id, @NotNull CfnDataSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDataSourceId() {
        return (String)Kernel.get((Object)this, (String)"attrDataSourceId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDataSourceStatus() {
        return (String)Kernel.get((Object)this, (String)"attrDataSourceStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAttrFailureReasons() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"attrFailureReasons", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getAttrUpdatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrUpdatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getDataSourceConfiguration() {
        return Kernel.get((Object)this, (String)"dataSourceConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDataSourceConfiguration(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"dataSourceConfiguration", (Object)Objects.requireNonNull(value, "dataSourceConfiguration is required"));
    }

    public void setDataSourceConfiguration(@NotNull DataSourceConfigurationProperty value) {
        Kernel.set((Object)this, (String)"dataSourceConfiguration", (Object)Objects.requireNonNull(value, "dataSourceConfiguration is required"));
    }

    @NotNull
    public String getKnowledgeBaseId() {
        return (String)Kernel.get((Object)this, (String)"knowledgeBaseId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKnowledgeBaseId(@NotNull String value) {
        Kernel.set((Object)this, (String)"knowledgeBaseId", (Object)Objects.requireNonNull(value, "knowledgeBaseId is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getDataDeletionPolicy() {
        return (String)Kernel.get((Object)this, (String)"dataDeletionPolicy", (NativeType)NativeType.forClass(String.class));
    }

    public void setDataDeletionPolicy(@Nullable String value) {
        Kernel.set((Object)this, (String)"dataDeletionPolicy", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getServerSideEncryptionConfiguration() {
        return Kernel.get((Object)this, (String)"serverSideEncryptionConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setServerSideEncryptionConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"serverSideEncryptionConfiguration", (Object)value);
    }

    public void setServerSideEncryptionConfiguration(@Nullable ServerSideEncryptionConfigurationProperty value) {
        Kernel.set((Object)this, (String)"serverSideEncryptionConfiguration", (Object)value);
    }

    @Nullable
    public Object getVectorIngestionConfiguration() {
        return Kernel.get((Object)this, (String)"vectorIngestionConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVectorIngestionConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"vectorIngestionConfiguration", (Object)value);
    }

    public void setVectorIngestionConfiguration(@Nullable VectorIngestionConfigurationProperty value) {
        Kernel.set((Object)this, (String)"vectorIngestionConfiguration", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataSource> {
        private final Construct scope;
        private final String id;
        private final CfnDataSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDataSourceProps.Builder();
        }

        public Builder dataSourceConfiguration(IResolvable dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        public Builder dataSourceConfiguration(DataSourceConfigurationProperty dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        public Builder knowledgeBaseId(String knowledgeBaseId) {
            this.props.knowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder dataDeletionPolicy(String dataDeletionPolicy) {
            this.props.dataDeletionPolicy(dataDeletionPolicy);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder serverSideEncryptionConfiguration(IResolvable serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }

        public Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfigurationProperty serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }

        public Builder vectorIngestionConfiguration(IResolvable vectorIngestionConfiguration) {
            this.props.vectorIngestionConfiguration(vectorIngestionConfiguration);
            return this;
        }

        public Builder vectorIngestionConfiguration(VectorIngestionConfigurationProperty vectorIngestionConfiguration) {
            this.props.vectorIngestionConfiguration(vectorIngestionConfiguration);
            return this;
        }

        public CfnDataSource build() {
            return new CfnDataSource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.VectorIngestionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VectorIngestionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getChunkingConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VectorIngestionConfigurationProperty> {
            Object chunkingConfiguration;

            public Builder chunkingConfiguration(IResolvable chunkingConfiguration) {
                this.chunkingConfiguration = chunkingConfiguration;
                return this;
            }

            public Builder chunkingConfiguration(ChunkingConfigurationProperty chunkingConfiguration) {
                this.chunkingConfiguration = chunkingConfiguration;
                return this;
            }

            public VectorIngestionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServerSideEncryptionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKmsKeyArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServerSideEncryptionConfigurationProperty> {
            String kmsKeyArn;

            public Builder kmsKeyArn(String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            public ServerSideEncryptionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.S3DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3DataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @Nullable
        default public String getBucketOwnerAccountId() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPrefixes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3DataSourceConfigurationProperty> {
            String bucketArn;
            String bucketOwnerAccountId;
            List<String> inclusionPrefixes;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder bucketOwnerAccountId(String bucketOwnerAccountId) {
                this.bucketOwnerAccountId = bucketOwnerAccountId;
                return this;
            }

            public Builder inclusionPrefixes(List<String> inclusionPrefixes) {
                this.inclusionPrefixes = inclusionPrefixes;
                return this;
            }

            public S3DataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.FixedSizeChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FixedSizeChunkingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxTokens();

        @NotNull
        public Number getOverlapPercentage();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FixedSizeChunkingConfigurationProperty> {
            Number maxTokens;
            Number overlapPercentage;

            public Builder maxTokens(Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder overlapPercentage(Number overlapPercentage) {
                this.overlapPercentage = overlapPercentage;
                return this;
            }

            public FixedSizeChunkingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3Configuration();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceConfigurationProperty> {
            Object s3Configuration;
            String type;

            public Builder s3Configuration(IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder s3Configuration(S3DataSourceConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.ChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ChunkingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getChunkingStrategy();

        @Nullable
        default public Object getFixedSizeChunkingConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ChunkingConfigurationProperty> {
            String chunkingStrategy;
            Object fixedSizeChunkingConfiguration;

            public Builder chunkingStrategy(String chunkingStrategy) {
                this.chunkingStrategy = chunkingStrategy;
                return this;
            }

            public Builder fixedSizeChunkingConfiguration(IResolvable fixedSizeChunkingConfiguration) {
                this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
                return this;
            }

            public Builder fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty fixedSizeChunkingConfiguration) {
                this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
                return this;
            }

            public ChunkingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

