/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.services.batch.AllocationStrategy;
import software.amazon.awscdk.services.batch.EksMachineImage;
import software.amazon.awscdk.services.batch.IComputeEnvironment;
import software.amazon.awscdk.services.batch.IManagedComputeEnvironment;
import software.amazon.awscdk.services.batch.ManagedEc2EksComputeEnvironmentProps;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ILaunchTemplate;
import software.amazon.awscdk.services.ec2.IPlacementGroup;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceClass;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.ICluster;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_batch.ManagedEc2EksComputeEnvironment")
public class ManagedEc2EksComputeEnvironment
extends Resource
implements IManagedComputeEnvironment,
IComputeEnvironment {
    protected ManagedEc2EksComputeEnvironment(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedEc2EksComputeEnvironment(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ManagedEc2EksComputeEnvironment(@NotNull Construct scope, @NotNull String id, @NotNull ManagedEc2EksComputeEnvironmentProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addInstanceClass(@NotNull InstanceClass instanceClass) {
        Kernel.call((Object)this, (String)"addInstanceClass", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(instanceClass, "instanceClass is required")});
    }

    public void addInstanceType(@NotNull InstanceType instanceType) {
        Kernel.call((Object)this, (String)"addInstanceType", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(instanceType, "instanceType is required")});
    }

    @Override
    @NotNull
    public String getComputeEnvironmentArn() {
        return (String)Kernel.get((Object)this, (String)"computeEnvironmentArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getComputeEnvironmentName() {
        return (String)Kernel.get((Object)this, (String)"computeEnvironmentName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @NotNull
    public ICluster getEksCluster() {
        return (ICluster)Kernel.get((Object)this, (String)"eksCluster", (NativeType)NativeType.forClass(ICluster.class));
    }

    @Override
    @NotNull
    public Boolean getEnabled() {
        return (Boolean)Kernel.get((Object)this, (String)"enabled", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public List<InstanceClass> getInstanceClasses() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"instanceClasses", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(InstanceClass.class))));
    }

    @NotNull
    public List<InstanceType> getInstanceTypes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"instanceTypes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(InstanceType.class))));
    }

    @Override
    @NotNull
    public Number getMaxvCpus() {
        return (Number)Kernel.get((Object)this, (String)"maxvCpus", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @NotNull
    public List<ISecurityGroup> getSecurityGroups() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"securityGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ISecurityGroup.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public AllocationStrategy getAllocationStrategy() {
        return (AllocationStrategy)((Object)Kernel.get((Object)this, (String)"allocationStrategy", (NativeType)NativeType.forClass(AllocationStrategy.class)));
    }

    @Nullable
    public List<EksMachineImage> getImages() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"images", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(EksMachineImage.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public IRole getInstanceRole() {
        return (IRole)Kernel.get((Object)this, (String)"instanceRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Nullable
    public String getKubernetesNamespace() {
        return (String)Kernel.get((Object)this, (String)"kubernetesNamespace", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public ILaunchTemplate getLaunchTemplate() {
        return (ILaunchTemplate)Kernel.get((Object)this, (String)"launchTemplate", (NativeType)NativeType.forClass(ILaunchTemplate.class));
    }

    @Nullable
    public Number getMinvCpus() {
        return (Number)Kernel.get((Object)this, (String)"minvCpus", (NativeType)NativeType.forClass(Number.class));
    }

    @Nullable
    public IPlacementGroup getPlacementGroup() {
        return (IPlacementGroup)Kernel.get((Object)this, (String)"placementGroup", (NativeType)NativeType.forClass(IPlacementGroup.class));
    }

    @Override
    @Nullable
    public Boolean getReplaceComputeEnvironment() {
        return (Boolean)Kernel.get((Object)this, (String)"replaceComputeEnvironment", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public IRole getServiceRole() {
        return (IRole)Kernel.get((Object)this, (String)"serviceRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @Nullable
    public Boolean getSpot() {
        return (Boolean)Kernel.get((Object)this, (String)"spot", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Nullable
    public Number getSpotBidPercentage() {
        return (Number)Kernel.get((Object)this, (String)"spotBidPercentage", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Boolean getTerminateOnUpdate() {
        return (Boolean)Kernel.get((Object)this, (String)"terminateOnUpdate", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public Duration getUpdateTimeout() {
        return (Duration)((Object)Kernel.get((Object)this, (String)"updateTimeout", (NativeType)NativeType.forClass(Duration.class)));
    }

    @Override
    @Nullable
    public Boolean getUpdateToLatestImageVersion() {
        return (Boolean)Kernel.get((Object)this, (String)"updateToLatestImageVersion", (NativeType)NativeType.forClass(Boolean.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ManagedEc2EksComputeEnvironment> {
        private final Construct scope;
        private final String id;
        private final ManagedEc2EksComputeEnvironmentProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ManagedEc2EksComputeEnvironmentProps.Builder();
        }

        public Builder computeEnvironmentName(String computeEnvironmentName) {
            this.props.computeEnvironmentName(computeEnvironmentName);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder serviceRole(IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder maxvCpus(Number maxvCpus) {
            this.props.maxvCpus(maxvCpus);
            return this;
        }

        public Builder replaceComputeEnvironment(Boolean replaceComputeEnvironment) {
            this.props.replaceComputeEnvironment(replaceComputeEnvironment);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder spot(Boolean spot) {
            this.props.spot(spot);
            return this;
        }

        public Builder terminateOnUpdate(Boolean terminateOnUpdate) {
            this.props.terminateOnUpdate(terminateOnUpdate);
            return this;
        }

        public Builder updateTimeout(Duration updateTimeout) {
            this.props.updateTimeout(updateTimeout);
            return this;
        }

        public Builder updateToLatestImageVersion(Boolean updateToLatestImageVersion) {
            this.props.updateToLatestImageVersion(updateToLatestImageVersion);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder eksCluster(ICluster eksCluster) {
            this.props.eksCluster(eksCluster);
            return this;
        }

        public Builder kubernetesNamespace(String kubernetesNamespace) {
            this.props.kubernetesNamespace(kubernetesNamespace);
            return this;
        }

        public Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.props.allocationStrategy(allocationStrategy);
            return this;
        }

        public Builder images(List<? extends EksMachineImage> images) {
            this.props.images(images);
            return this;
        }

        public Builder instanceClasses(List<? extends InstanceClass> instanceClasses) {
            this.props.instanceClasses(instanceClasses);
            return this;
        }

        public Builder instanceRole(IRole instanceRole) {
            this.props.instanceRole(instanceRole);
            return this;
        }

        public Builder instanceTypes(List<? extends InstanceType> instanceTypes) {
            this.props.instanceTypes(instanceTypes);
            return this;
        }

        public Builder launchTemplate(ILaunchTemplate launchTemplate) {
            this.props.launchTemplate(launchTemplate);
            return this;
        }

        public Builder minvCpus(Number minvCpus) {
            this.props.minvCpus(minvCpus);
            return this;
        }

        public Builder placementGroup(IPlacementGroup placementGroup) {
            this.props.placementGroup(placementGroup);
            return this;
        }

        public Builder spotBidPercentage(Number spotBidPercentage) {
            this.props.spotBidPercentage(spotBidPercentage);
            return this;
        }

        public Builder useOptimalInstanceClasses(Boolean useOptimalInstanceClasses) {
            this.props.useOptimalInstanceClasses(useOptimalInstanceClasses);
            return this;
        }

        public ManagedEc2EksComputeEnvironment build() {
            return new ManagedEc2EksComputeEnvironment(this.scope, this.id, this.props.build());
        }
    }
}

