/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.AwsLogDriver;
import software.amazon.awscdk.services.ecs.Cluster;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBaseProps;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.events.targets.EcsTask;
import software.amazon.awscdk.services.events.targets.Tag;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs_patterns.ScheduledTaskBase")
public abstract class ScheduledTaskBase
extends Construct {
    protected ScheduledTaskBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduledTaskBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected ScheduledTaskBase(@NotNull Construct scope, @NotNull String id, @NotNull ScheduledTaskBaseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    protected void addTaskAsTarget(@NotNull EcsTask ecsTaskTarget) {
        Kernel.call((Object)((Object)this), (String)"addTaskAsTarget", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(ecsTaskTarget, "ecsTaskTarget is required")});
    }

    @NotNull
    protected EcsTask addTaskDefinitionToEventTarget(@NotNull TaskDefinition taskDefinition) {
        return (EcsTask)Kernel.call((Object)((Object)this), (String)"addTaskDefinitionToEventTarget", (NativeType)NativeType.forClass(EcsTask.class), (Object[])new Object[]{Objects.requireNonNull(taskDefinition, "taskDefinition is required")});
    }

    @NotNull
    protected AwsLogDriver createAWSLogDriver(@NotNull String prefix) {
        return (AwsLogDriver)((Object)Kernel.call((Object)((Object)this), (String)"createAWSLogDriver", (NativeType)NativeType.forClass(AwsLogDriver.class), (Object[])new Object[]{Objects.requireNonNull(prefix, "prefix is required")}));
    }

    @NotNull
    protected Cluster getDefaultCluster(@NotNull Construct scope, @Nullable IVpc vpc) {
        return (Cluster)Kernel.call((Object)((Object)this), (String)"getDefaultCluster", (NativeType)NativeType.forClass(Cluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), vpc});
    }

    @NotNull
    protected Cluster getDefaultCluster(@NotNull Construct scope) {
        return (Cluster)Kernel.call((Object)((Object)this), (String)"getDefaultCluster", (NativeType)NativeType.forClass(Cluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    @NotNull
    public ICluster getCluster() {
        return (ICluster)Kernel.get((Object)((Object)this), (String)"cluster", (NativeType)NativeType.forClass(ICluster.class));
    }

    @NotNull
    public Number getDesiredTaskCount() {
        return (Number)Kernel.get((Object)((Object)this), (String)"desiredTaskCount", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public Rule getEventRule() {
        return (Rule)Kernel.get((Object)((Object)this), (String)"eventRule", (NativeType)NativeType.forClass(Rule.class));
    }

    @NotNull
    public SubnetSelection getSubnetSelection() {
        return (SubnetSelection)Kernel.get((Object)((Object)this), (String)"subnetSelection", (NativeType)NativeType.forClass(SubnetSelection.class));
    }

    @Nullable
    public PropagatedTagSource getPropagateTags() {
        return (PropagatedTagSource)((Object)Kernel.get((Object)((Object)this), (String)"propagateTags", (NativeType)NativeType.forClass(PropagatedTagSource.class)));
    }

    @Nullable
    public List<Tag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Tag.class)))).map(Collections::unmodifiableList).orElse(null);
    }
}

