/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.eks.CfnAccessEntry;
import software.amazon.awscdk.services.eks.CfnAccessEntryProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_eks.CfnAccessEntry")
public class CfnAccessEntry
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAccessEntry.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAccessEntry(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAccessEntry(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAccessEntry(@NotNull Construct scope, @NotNull String id, @NotNull CfnAccessEntryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAccessEntryArn() {
        return (String)Kernel.get((Object)this, (String)"attrAccessEntryArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getClusterName() {
        return (String)Kernel.get((Object)this, (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterName(@NotNull String value) {
        Kernel.set((Object)this, (String)"clusterName", (Object)Objects.requireNonNull(value, "clusterName is required"));
    }

    @NotNull
    public String getPrincipalArn() {
        return (String)Kernel.get((Object)this, (String)"principalArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setPrincipalArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"principalArn", (Object)Objects.requireNonNull(value, "principalArn is required"));
    }

    @Nullable
    public Object getAccessPolicies() {
        return Kernel.get((Object)this, (String)"accessPolicies", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAccessPolicies(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"accessPolicies", (Object)value);
    }

    public void setAccessPolicies(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof AccessPolicyProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.eks.CfnAccessEntry.AccessPolicyProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"accessPolicies", value);
    }

    @Nullable
    public List<String> getKubernetesGroups() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"kubernetesGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setKubernetesGroups(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"kubernetesGroups", value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Nullable
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@Nullable String value) {
        Kernel.set((Object)this, (String)"type", (Object)value);
    }

    @Nullable
    public String getUsername() {
        return (String)Kernel.get((Object)this, (String)"username", (NativeType)NativeType.forClass(String.class));
    }

    public void setUsername(@Nullable String value) {
        Kernel.set((Object)this, (String)"username", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_eks.CfnAccessEntry.AccessPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAccessScope();

        @NotNull
        public String getPolicyArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccessPolicyProperty> {
            Object accessScope;
            String policyArn;

            public Builder accessScope(IResolvable accessScope) {
                this.accessScope = accessScope;
                return this;
            }

            public Builder accessScope(AccessScopeProperty accessScope) {
                this.accessScope = accessScope;
                return this;
            }

            public Builder policyArn(String policyArn) {
                this.policyArn = policyArn;
                return this;
            }

            public AccessPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAccessEntry> {
        private final Construct scope;
        private final String id;
        private final CfnAccessEntryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAccessEntryProps.Builder();
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder principalArn(String principalArn) {
            this.props.principalArn(principalArn);
            return this;
        }

        public Builder accessPolicies(IResolvable accessPolicies) {
            this.props.accessPolicies(accessPolicies);
            return this;
        }

        public Builder accessPolicies(List<? extends Object> accessPolicies) {
            this.props.accessPolicies(accessPolicies);
            return this;
        }

        public Builder kubernetesGroups(List<String> kubernetesGroups) {
            this.props.kubernetesGroups(kubernetesGroups);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder username(String username) {
            this.props.username(username);
            return this;
        }

        public CfnAccessEntry build() {
            return new CfnAccessEntry(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_eks.CfnAccessEntry.AccessScopeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessScopeProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public List<String> getNamespaces() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccessScopeProperty> {
            String type;
            List<String> namespaces;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder namespaces(List<String> namespaces) {
                this.namespaces = namespaces;
                return this;
            }

            public AccessScopeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

