/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.lambda.Architecture;
import software.amazon.awscdk.services.lambda.Code;
import software.amazon.awscdk.services.lambda.ILayerVersion;
import software.amazon.awscdk.services.lambda.LayerVersionAttributes;
import software.amazon.awscdk.services.lambda.LayerVersionPermission;
import software.amazon.awscdk.services.lambda.LayerVersionProps;
import software.amazon.awscdk.services.lambda.Runtime;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lambda.LayerVersion")
public class LayerVersion
extends Resource
implements ILayerVersion {
    protected LayerVersion(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LayerVersion(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LayerVersion(@NotNull Construct scope, @NotNull String id, @NotNull LayerVersionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ILayerVersion fromLayerVersionArn(@NotNull Construct scope, @NotNull String id, @NotNull String layerVersionArn) {
        return (ILayerVersion)JsiiObject.jsiiStaticCall(LayerVersion.class, (String)"fromLayerVersionArn", (NativeType)NativeType.forClass(ILayerVersion.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(layerVersionArn, "layerVersionArn is required")});
    }

    @NotNull
    public static ILayerVersion fromLayerVersionAttributes(@NotNull Construct scope, @NotNull String id, @NotNull LayerVersionAttributes attrs) {
        return (ILayerVersion)JsiiObject.jsiiStaticCall(LayerVersion.class, (String)"fromLayerVersionAttributes", (NativeType)NativeType.forClass(ILayerVersion.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    public void addPermission(@NotNull String id, @NotNull LayerVersionPermission permission) {
        Kernel.call((Object)this, (String)"addPermission", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(permission, "permission is required")});
    }

    @Override
    @NotNull
    public String getLayerVersionArn() {
        return (String)Kernel.get((Object)this, (String)"layerVersionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public List<Runtime> getCompatibleRuntimes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"compatibleRuntimes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Runtime.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LayerVersion> {
        private final Construct scope;
        private final String id;
        private final LayerVersionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new LayerVersionProps.Builder();
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder layerVersionName(String layerVersionName) {
            this.props.layerVersionName(layerVersionName);
            return this;
        }

        public Builder license(String license) {
            this.props.license(license);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder code(Code code) {
            this.props.code(code);
            return this;
        }

        public Builder compatibleArchitectures(List<? extends Architecture> compatibleArchitectures) {
            this.props.compatibleArchitectures(compatibleArchitectures);
            return this;
        }

        public Builder compatibleRuntimes(List<? extends Runtime> compatibleRuntimes) {
            this.props.compatibleRuntimes(compatibleRuntimes);
            return this;
        }

        public LayerVersion build() {
            return new LayerVersion(this.scope, this.id, this.props.build());
        }
    }
}

