/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.ecs.CfnService;
import software.amazon.awscdk.services.ecs.CfnServiceProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService")
public class CfnService
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnService.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnService(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnService(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnService(@NotNull Construct scope, @NotNull String id, @Nullable CfnServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnService(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)this, (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrServiceArn() {
        return (String)Kernel.get((Object)this, (String)"attrServiceArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public Object getCapacityProviderStrategy() {
        return Kernel.get((Object)this, (String)"capacityProviderStrategy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCapacityProviderStrategy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"capacityProviderStrategy", (Object)value);
    }

    public void setCapacityProviderStrategy(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof CapacityProviderStrategyItemProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.CapacityProviderStrategyItemProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"capacityProviderStrategy", value);
    }

    @Nullable
    public String getCluster() {
        return (String)Kernel.get((Object)this, (String)"cluster", (NativeType)NativeType.forClass(String.class));
    }

    public void setCluster(@Nullable String value) {
        Kernel.set((Object)this, (String)"cluster", (Object)value);
    }

    @Nullable
    public Object getDeploymentConfiguration() {
        return Kernel.get((Object)this, (String)"deploymentConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeploymentConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deploymentConfiguration", (Object)value);
    }

    public void setDeploymentConfiguration(@Nullable DeploymentConfigurationProperty value) {
        Kernel.set((Object)this, (String)"deploymentConfiguration", (Object)value);
    }

    @Nullable
    public Object getDeploymentController() {
        return Kernel.get((Object)this, (String)"deploymentController", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeploymentController(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deploymentController", (Object)value);
    }

    public void setDeploymentController(@Nullable DeploymentControllerProperty value) {
        Kernel.set((Object)this, (String)"deploymentController", (Object)value);
    }

    @Nullable
    public Number getDesiredCount() {
        return (Number)Kernel.get((Object)this, (String)"desiredCount", (NativeType)NativeType.forClass(Number.class));
    }

    public void setDesiredCount(@Nullable Number value) {
        Kernel.set((Object)this, (String)"desiredCount", (Object)value);
    }

    @Nullable
    public Object getEnableEcsManagedTags() {
        return Kernel.get((Object)this, (String)"enableEcsManagedTags", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableEcsManagedTags(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableEcsManagedTags", (Object)value);
    }

    public void setEnableEcsManagedTags(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableEcsManagedTags", (Object)value);
    }

    @Nullable
    public Object getEnableExecuteCommand() {
        return Kernel.get((Object)this, (String)"enableExecuteCommand", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableExecuteCommand(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableExecuteCommand", (Object)value);
    }

    public void setEnableExecuteCommand(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableExecuteCommand", (Object)value);
    }

    @Nullable
    public Number getHealthCheckGracePeriodSeconds() {
        return (Number)Kernel.get((Object)this, (String)"healthCheckGracePeriodSeconds", (NativeType)NativeType.forClass(Number.class));
    }

    public void setHealthCheckGracePeriodSeconds(@Nullable Number value) {
        Kernel.set((Object)this, (String)"healthCheckGracePeriodSeconds", (Object)value);
    }

    @Nullable
    public String getLaunchType() {
        return (String)Kernel.get((Object)this, (String)"launchType", (NativeType)NativeType.forClass(String.class));
    }

    public void setLaunchType(@Nullable String value) {
        Kernel.set((Object)this, (String)"launchType", (Object)value);
    }

    @Nullable
    public Object getLoadBalancers() {
        return Kernel.get((Object)this, (String)"loadBalancers", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLoadBalancers(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"loadBalancers", (Object)value);
    }

    public void setLoadBalancers(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof LoadBalancerProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"loadBalancers", value);
    }

    @Nullable
    public Object getNetworkConfiguration() {
        return Kernel.get((Object)this, (String)"networkConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNetworkConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"networkConfiguration", (Object)value);
    }

    public void setNetworkConfiguration(@Nullable NetworkConfigurationProperty value) {
        Kernel.set((Object)this, (String)"networkConfiguration", (Object)value);
    }

    @Nullable
    public Object getPlacementConstraints() {
        return Kernel.get((Object)this, (String)"placementConstraints", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPlacementConstraints(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"placementConstraints", (Object)value);
    }

    public void setPlacementConstraints(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof PlacementConstraintProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.PlacementConstraintProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"placementConstraints", value);
    }

    @Nullable
    public Object getPlacementStrategies() {
        return Kernel.get((Object)this, (String)"placementStrategies", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPlacementStrategies(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"placementStrategies", (Object)value);
    }

    public void setPlacementStrategies(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof PlacementStrategyProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.PlacementStrategyProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"placementStrategies", value);
    }

    @Nullable
    public String getPlatformVersion() {
        return (String)Kernel.get((Object)this, (String)"platformVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setPlatformVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"platformVersion", (Object)value);
    }

    @Nullable
    public String getPropagateTags() {
        return (String)Kernel.get((Object)this, (String)"propagateTags", (NativeType)NativeType.forClass(String.class));
    }

    public void setPropagateTags(@Nullable String value) {
        Kernel.set((Object)this, (String)"propagateTags", (Object)value);
    }

    @Nullable
    public String getRole() {
        return (String)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(String.class));
    }

    public void setRole(@Nullable String value) {
        Kernel.set((Object)this, (String)"role", (Object)value);
    }

    @Nullable
    public String getSchedulingStrategy() {
        return (String)Kernel.get((Object)this, (String)"schedulingStrategy", (NativeType)NativeType.forClass(String.class));
    }

    public void setSchedulingStrategy(@Nullable String value) {
        Kernel.set((Object)this, (String)"schedulingStrategy", (Object)value);
    }

    @Nullable
    public Object getServiceConnectConfiguration() {
        return Kernel.get((Object)this, (String)"serviceConnectConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setServiceConnectConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"serviceConnectConfiguration", (Object)value);
    }

    public void setServiceConnectConfiguration(@Nullable ServiceConnectConfigurationProperty value) {
        Kernel.set((Object)this, (String)"serviceConnectConfiguration", (Object)value);
    }

    @Nullable
    public String getServiceName() {
        return (String)Kernel.get((Object)this, (String)"serviceName", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceName(@Nullable String value) {
        Kernel.set((Object)this, (String)"serviceName", (Object)value);
    }

    @Nullable
    public Object getServiceRegistries() {
        return Kernel.get((Object)this, (String)"serviceRegistries", (NativeType)NativeType.forClass(Object.class));
    }

    public void setServiceRegistries(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"serviceRegistries", (Object)value);
    }

    public void setServiceRegistries(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ServiceRegistryProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"serviceRegistries", value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public String getTaskDefinition() {
        return (String)Kernel.get((Object)this, (String)"taskDefinition", (NativeType)NativeType.forClass(String.class));
    }

    public void setTaskDefinition(@Nullable String value) {
        Kernel.set((Object)this, (String)"taskDefinition", (Object)value);
    }

    @Nullable
    public Object getVolumeConfigurations() {
        return Kernel.get((Object)this, (String)"volumeConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVolumeConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"volumeConfigurations", (Object)value);
    }

    public void setVolumeConfigurations(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ServiceVolumeConfigurationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.ServiceVolumeConfigurationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"volumeConfigurations", value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityProviderStrategyItemProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBase() {
            return null;
        }

        @Nullable
        default public String getCapacityProvider() {
            return null;
        }

        @Nullable
        default public Number getWeight() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            Number base;
            String capacityProvider;
            Number weight;

            public Builder base(Number base) {
                this.base = base;
                return this;
            }

            public Builder capacityProvider(String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            public Builder weight(Number weight) {
                this.weight = weight;
                return this;
            }

            public CapacityProviderStrategyItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.LoadBalancerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoadBalancerProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerName() {
            return null;
        }

        @Nullable
        default public Number getContainerPort() {
            return null;
        }

        @Nullable
        default public String getLoadBalancerName() {
            return null;
        }

        @Nullable
        default public String getTargetGroupArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoadBalancerProperty> {
            String containerName;
            Number containerPort;
            String loadBalancerName;
            String targetGroupArn;

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public Builder containerPort(Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            public Builder loadBalancerName(String loadBalancerName) {
                this.loadBalancerName = loadBalancerName;
                return this;
            }

            public Builder targetGroupArn(String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            public LoadBalancerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.PlacementConstraintProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementConstraintProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public String getExpression() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementConstraintProperty> {
            String type;
            String expression;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public PlacementConstraintProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.PlacementStrategyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementStrategyProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public String getField() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementStrategyProperty> {
            String type;
            String field;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder field(String field) {
                this.field = field;
                return this;
            }

            public PlacementStrategyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.ServiceRegistryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceRegistryProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerName() {
            return null;
        }

        @Nullable
        default public Number getContainerPort() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        @Nullable
        default public String getRegistryArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceRegistryProperty> {
            String containerName;
            Number containerPort;
            Number port;
            String registryArn;

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public Builder containerPort(Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder registryArn(String registryArn) {
                this.registryArn = registryArn;
                return this;
            }

            public ServiceRegistryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.ServiceVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceVolumeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public Object getManagedEbsVolume() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceVolumeConfigurationProperty> {
            String name;
            Object managedEbsVolume;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder managedEbsVolume(IResolvable managedEbsVolume) {
                this.managedEbsVolume = managedEbsVolume;
                return this;
            }

            public Builder managedEbsVolume(ServiceManagedEBSVolumeConfigurationProperty managedEbsVolume) {
                this.managedEbsVolume = managedEbsVolume;
                return this;
            }

            public ServiceVolumeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnService> {
        private final Construct scope;
        private final String id;
        private CfnServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder capacityProviderStrategy(IResolvable capacityProviderStrategy) {
            this.props().capacityProviderStrategy(capacityProviderStrategy);
            return this;
        }

        public Builder capacityProviderStrategy(List<? extends Object> capacityProviderStrategy) {
            this.props().capacityProviderStrategy(capacityProviderStrategy);
            return this;
        }

        public Builder cluster(String cluster) {
            this.props().cluster(cluster);
            return this;
        }

        public Builder deploymentConfiguration(IResolvable deploymentConfiguration) {
            this.props().deploymentConfiguration(deploymentConfiguration);
            return this;
        }

        public Builder deploymentConfiguration(DeploymentConfigurationProperty deploymentConfiguration) {
            this.props().deploymentConfiguration(deploymentConfiguration);
            return this;
        }

        public Builder deploymentController(IResolvable deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        public Builder deploymentController(DeploymentControllerProperty deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.props().desiredCount(desiredCount);
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder enableEcsManagedTags(IResolvable enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.props().enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        public Builder enableExecuteCommand(IResolvable enableExecuteCommand) {
            this.props().enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        public Builder healthCheckGracePeriodSeconds(Number healthCheckGracePeriodSeconds) {
            this.props().healthCheckGracePeriodSeconds(healthCheckGracePeriodSeconds);
            return this;
        }

        public Builder launchType(String launchType) {
            this.props().launchType(launchType);
            return this;
        }

        public Builder loadBalancers(IResolvable loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }

        public Builder loadBalancers(List<? extends Object> loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }

        public Builder networkConfiguration(IResolvable networkConfiguration) {
            this.props().networkConfiguration(networkConfiguration);
            return this;
        }

        public Builder networkConfiguration(NetworkConfigurationProperty networkConfiguration) {
            this.props().networkConfiguration(networkConfiguration);
            return this;
        }

        public Builder placementConstraints(IResolvable placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        public Builder placementConstraints(List<? extends Object> placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        public Builder placementStrategies(IResolvable placementStrategies) {
            this.props().placementStrategies(placementStrategies);
            return this;
        }

        public Builder placementStrategies(List<? extends Object> placementStrategies) {
            this.props().placementStrategies(placementStrategies);
            return this;
        }

        public Builder platformVersion(String platformVersion) {
            this.props().platformVersion(platformVersion);
            return this;
        }

        public Builder propagateTags(String propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        public Builder role(String role) {
            this.props().role(role);
            return this;
        }

        public Builder schedulingStrategy(String schedulingStrategy) {
            this.props().schedulingStrategy(schedulingStrategy);
            return this;
        }

        public Builder serviceConnectConfiguration(IResolvable serviceConnectConfiguration) {
            this.props().serviceConnectConfiguration(serviceConnectConfiguration);
            return this;
        }

        public Builder serviceConnectConfiguration(ServiceConnectConfigurationProperty serviceConnectConfiguration) {
            this.props().serviceConnectConfiguration(serviceConnectConfiguration);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        public Builder serviceRegistries(IResolvable serviceRegistries) {
            this.props().serviceRegistries(serviceRegistries);
            return this;
        }

        public Builder serviceRegistries(List<? extends Object> serviceRegistries) {
            this.props().serviceRegistries(serviceRegistries);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder taskDefinition(String taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        public Builder volumeConfigurations(IResolvable volumeConfigurations) {
            this.props().volumeConfigurations(volumeConfigurations);
            return this;
        }

        public Builder volumeConfigurations(List<? extends Object> volumeConfigurations) {
            this.props().volumeConfigurations(volumeConfigurations);
            return this;
        }

        public CfnService build() {
            return new CfnService(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnServiceProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.TimeoutConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimeoutConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getIdleTimeoutSeconds() {
            return null;
        }

        @Nullable
        default public Number getPerRequestTimeoutSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimeoutConfigurationProperty> {
            Number idleTimeoutSeconds;
            Number perRequestTimeoutSeconds;

            public Builder idleTimeoutSeconds(Number idleTimeoutSeconds) {
                this.idleTimeoutSeconds = idleTimeoutSeconds;
                return this;
            }

            public Builder perRequestTimeoutSeconds(Number perRequestTimeoutSeconds) {
                this.perRequestTimeoutSeconds = perRequestTimeoutSeconds;
                return this;
            }

            public TimeoutConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.ServiceManagedEBSVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceManagedEBSVolumeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getEncrypted() {
            return null;
        }

        @Nullable
        default public String getFilesystemType() {
            return null;
        }

        @Nullable
        default public Number getIops() {
            return null;
        }

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        @Nullable
        default public Number getSizeInGiB() {
            return null;
        }

        @Nullable
        default public String getSnapshotId() {
            return null;
        }

        @Nullable
        default public Object getTagSpecifications() {
            return null;
        }

        @Nullable
        default public Number getThroughput() {
            return null;
        }

        @Nullable
        default public String getVolumeType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceManagedEBSVolumeConfigurationProperty> {
            String roleArn;
            Object encrypted;
            String filesystemType;
            Number iops;
            String kmsKeyId;
            Number sizeInGiB;
            String snapshotId;
            Object tagSpecifications;
            Number throughput;
            String volumeType;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder encrypted(Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder encrypted(IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder filesystemType(String filesystemType) {
                this.filesystemType = filesystemType;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder sizeInGiB(Number sizeInGiB) {
                this.sizeInGiB = sizeInGiB;
                return this;
            }

            public Builder snapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public Builder tagSpecifications(IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder tagSpecifications(List<? extends Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder throughput(Number throughput) {
                this.throughput = throughput;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public ServiceManagedEBSVolumeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.ServiceConnectTlsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceConnectTlsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getIssuerCertificateAuthority();

        @Nullable
        default public String getKmsKey() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceConnectTlsConfigurationProperty> {
            Object issuerCertificateAuthority;
            String kmsKey;
            String roleArn;

            public Builder issuerCertificateAuthority(IResolvable issuerCertificateAuthority) {
                this.issuerCertificateAuthority = issuerCertificateAuthority;
                return this;
            }

            public Builder issuerCertificateAuthority(ServiceConnectTlsCertificateAuthorityProperty issuerCertificateAuthority) {
                this.issuerCertificateAuthority = issuerCertificateAuthority;
                return this;
            }

            public Builder kmsKey(String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public ServiceConnectTlsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.ServiceConnectTlsCertificateAuthorityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceConnectTlsCertificateAuthorityProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAwsPcaAuthorityArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceConnectTlsCertificateAuthorityProperty> {
            String awsPcaAuthorityArn;

            public Builder awsPcaAuthorityArn(String awsPcaAuthorityArn) {
                this.awsPcaAuthorityArn = awsPcaAuthorityArn;
                return this;
            }

            public ServiceConnectTlsCertificateAuthorityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.ServiceConnectServiceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceConnectServiceProperty
    extends JsiiSerializable {
        @NotNull
        public String getPortName();

        @Nullable
        default public Object getClientAliases() {
            return null;
        }

        @Nullable
        default public String getDiscoveryName() {
            return null;
        }

        @Nullable
        default public Number getIngressPortOverride() {
            return null;
        }

        @Nullable
        default public Object getTimeout() {
            return null;
        }

        @Nullable
        default public Object getTls() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceConnectServiceProperty> {
            String portName;
            Object clientAliases;
            String discoveryName;
            Number ingressPortOverride;
            Object timeout;
            Object tls;

            public Builder portName(String portName) {
                this.portName = portName;
                return this;
            }

            public Builder clientAliases(IResolvable clientAliases) {
                this.clientAliases = clientAliases;
                return this;
            }

            public Builder clientAliases(List<? extends Object> clientAliases) {
                this.clientAliases = clientAliases;
                return this;
            }

            public Builder discoveryName(String discoveryName) {
                this.discoveryName = discoveryName;
                return this;
            }

            public Builder ingressPortOverride(Number ingressPortOverride) {
                this.ingressPortOverride = ingressPortOverride;
                return this;
            }

            public Builder timeout(IResolvable timeout) {
                this.timeout = timeout;
                return this;
            }

            public Builder timeout(TimeoutConfigurationProperty timeout) {
                this.timeout = timeout;
                return this;
            }

            public Builder tls(IResolvable tls) {
                this.tls = tls;
                return this;
            }

            public Builder tls(ServiceConnectTlsConfigurationProperty tls) {
                this.tls = tls;
                return this;
            }

            public ServiceConnectServiceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.ServiceConnectConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceConnectConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public Object getLogConfiguration() {
            return null;
        }

        @Nullable
        default public String getNamespace() {
            return null;
        }

        @Nullable
        default public Object getServices() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceConnectConfigurationProperty> {
            Object enabled;
            Object logConfiguration;
            String namespace;
            Object services;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder logConfiguration(IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder logConfiguration(LogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder services(IResolvable services) {
                this.services = services;
                return this;
            }

            public Builder services(List<? extends Object> services) {
                this.services = services;
                return this;
            }

            public ServiceConnectConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.ServiceConnectClientAliasProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceConnectClientAliasProperty
    extends JsiiSerializable {
        @NotNull
        public Number getPort();

        @Nullable
        default public String getDnsName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceConnectClientAliasProperty> {
            Number port;
            String dnsName;

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder dnsName(String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            public ServiceConnectClientAliasProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.SecretProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SecretProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValueFrom();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SecretProperty> {
            String name;
            String valueFrom;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder valueFrom(String valueFrom) {
                this.valueFrom = valueFrom;
                return this;
            }

            public SecretProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAwsvpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            Object awsvpcConfiguration;

            public Builder awsvpcConfiguration(IResolvable awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            public Builder awsvpcConfiguration(AwsVpcConfigurationProperty awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            public NetworkConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.LogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLogDriver() {
            return null;
        }

        @Nullable
        default public Object getOptions() {
            return null;
        }

        @Nullable
        default public Object getSecretOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogConfigurationProperty> {
            String logDriver;
            Object options;
            Object secretOptions;

            public Builder logDriver(String logDriver) {
                this.logDriver = logDriver;
                return this;
            }

            public Builder options(IResolvable options) {
                this.options = options;
                return this;
            }

            public Builder options(Map<String, String> options) {
                this.options = options;
                return this;
            }

            public Builder secretOptions(IResolvable secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            public Builder secretOptions(List<? extends Object> secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            public LogConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.EBSTagSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EBSTagSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceType();

        @Nullable
        default public String getPropagateTags() {
            return null;
        }

        @Nullable
        default public List<CfnTag> getTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EBSTagSpecificationProperty> {
            String resourceType;
            String propagateTags;
            List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder propagateTags(String propagateTags) {
                this.propagateTags = propagateTags;
                return this;
            }

            public Builder tags(List<? extends CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public EBSTagSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.DeploymentControllerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentControllerProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentControllerProperty> {
            String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DeploymentControllerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.DeploymentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAlarms() {
            return null;
        }

        @Nullable
        default public Object getDeploymentCircuitBreaker() {
            return null;
        }

        @Nullable
        default public Number getMaximumPercent() {
            return null;
        }

        @Nullable
        default public Number getMinimumHealthyPercent() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentConfigurationProperty> {
            Object alarms;
            Object deploymentCircuitBreaker;
            Number maximumPercent;
            Number minimumHealthyPercent;

            public Builder alarms(IResolvable alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder alarms(DeploymentAlarmsProperty alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder deploymentCircuitBreaker(IResolvable deploymentCircuitBreaker) {
                this.deploymentCircuitBreaker = deploymentCircuitBreaker;
                return this;
            }

            public Builder deploymentCircuitBreaker(DeploymentCircuitBreakerProperty deploymentCircuitBreaker) {
                this.deploymentCircuitBreaker = deploymentCircuitBreaker;
                return this;
            }

            public Builder maximumPercent(Number maximumPercent) {
                this.maximumPercent = maximumPercent;
                return this;
            }

            public Builder minimumHealthyPercent(Number minimumHealthyPercent) {
                this.minimumHealthyPercent = minimumHealthyPercent;
                return this;
            }

            public DeploymentConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.DeploymentCircuitBreakerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentCircuitBreakerProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnable();

        @NotNull
        public Object getRollback();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentCircuitBreakerProperty> {
            Object enable;
            Object rollback;

            public Builder enable(Boolean enable) {
                this.enable = enable;
                return this;
            }

            public Builder enable(IResolvable enable) {
                this.enable = enable;
                return this;
            }

            public Builder rollback(Boolean rollback) {
                this.rollback = rollback;
                return this;
            }

            public Builder rollback(IResolvable rollback) {
                this.rollback = rollback;
                return this;
            }

            public DeploymentCircuitBreakerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.DeploymentAlarmsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentAlarmsProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getAlarmNames();

        @NotNull
        public Object getEnable();

        @NotNull
        public Object getRollback();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentAlarmsProperty> {
            List<String> alarmNames;
            Object enable;
            Object rollback;

            public Builder alarmNames(List<String> alarmNames) {
                this.alarmNames = alarmNames;
                return this;
            }

            public Builder enable(Boolean enable) {
                this.enable = enable;
                return this;
            }

            public Builder enable(IResolvable enable) {
                this.enable = enable;
                return this;
            }

            public Builder rollback(Boolean rollback) {
                this.rollback = rollback;
                return this;
            }

            public Builder rollback(IResolvable rollback) {
                this.rollback = rollback;
                return this;
            }

            public DeploymentAlarmsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.CfnService.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsVpcConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAssignPublicIp() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        @Nullable
        default public List<String> getSubnets() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AwsVpcConfigurationProperty> {
            String assignPublicIp;
            List<String> securityGroups;
            List<String> subnets;

            public Builder assignPublicIp(String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public AwsVpcConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

