package software.amazon.awscdk;

/**
 * Traffic routing configuration settings.
 * <p>
 * The type of the <code>CfnCodeDeployBlueGreenHookProps.trafficRoutingConfig</code> property.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnTrafficRoutingConfig cfnTrafficRoutingConfig = CfnTrafficRoutingConfig.builder()
 *         .type(CfnTrafficRoutingType.ALL_AT_ONCE)
 *         // the properties below are optional
 *         .timeBasedCanary(CfnTrafficRoutingTimeBasedCanary.builder()
 *                 .bakeTimeMins(123)
 *                 .stepPercentage(123)
 *                 .build())
 *         .timeBasedLinear(CfnTrafficRoutingTimeBasedLinear.builder()
 *                 .bakeTimeMins(123)
 *                 .stepPercentage(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:46.198Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnTrafficRoutingConfig")
@software.amazon.jsii.Jsii.Proxy(CfnTrafficRoutingConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrafficRoutingConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of traffic shifting used by the blue-green deployment configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnTrafficRoutingType getType();

    /**
     * The configuration for traffic routing when <code>type</code> is <code>CfnTrafficRoutingType.TIME_BASED_CANARY</code>.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnTrafficRoutingTimeBasedCanary getTimeBasedCanary() {
        return null;
    }

    /**
     * The configuration for traffic routing when <code>type</code> is <code>CfnTrafficRoutingType.TIME_BASED_LINEAR</code>.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnTrafficRoutingTimeBasedLinear getTimeBasedLinear() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrafficRoutingConfig> {
        software.amazon.awscdk.CfnTrafficRoutingType type;
        software.amazon.awscdk.CfnTrafficRoutingTimeBasedCanary timeBasedCanary;
        software.amazon.awscdk.CfnTrafficRoutingTimeBasedLinear timeBasedLinear;

        /**
         * Sets the value of {@link CfnTrafficRoutingConfig#getType}
         * @param type The type of traffic shifting used by the blue-green deployment configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.CfnTrafficRoutingType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficRoutingConfig#getTimeBasedCanary}
         * @param timeBasedCanary The configuration for traffic routing when <code>type</code> is <code>CfnTrafficRoutingType.TIME_BASED_CANARY</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeBasedCanary(software.amazon.awscdk.CfnTrafficRoutingTimeBasedCanary timeBasedCanary) {
            this.timeBasedCanary = timeBasedCanary;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficRoutingConfig#getTimeBasedLinear}
         * @param timeBasedLinear The configuration for traffic routing when <code>type</code> is <code>CfnTrafficRoutingType.TIME_BASED_LINEAR</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeBasedLinear(software.amazon.awscdk.CfnTrafficRoutingTimeBasedLinear timeBasedLinear) {
            this.timeBasedLinear = timeBasedLinear;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrafficRoutingConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrafficRoutingConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrafficRoutingConfig {
        private final software.amazon.awscdk.CfnTrafficRoutingType type;
        private final software.amazon.awscdk.CfnTrafficRoutingTimeBasedCanary timeBasedCanary;
        private final software.amazon.awscdk.CfnTrafficRoutingTimeBasedLinear timeBasedLinear;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTrafficRoutingType.class));
            this.timeBasedCanary = software.amazon.jsii.Kernel.get(this, "timeBasedCanary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTrafficRoutingTimeBasedCanary.class));
            this.timeBasedLinear = software.amazon.jsii.Kernel.get(this, "timeBasedLinear", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTrafficRoutingTimeBasedLinear.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.timeBasedCanary = builder.timeBasedCanary;
            this.timeBasedLinear = builder.timeBasedLinear;
        }

        @Override
        public final software.amazon.awscdk.CfnTrafficRoutingType getType() {
            return this.type;
        }

        @Override
        public final software.amazon.awscdk.CfnTrafficRoutingTimeBasedCanary getTimeBasedCanary() {
            return this.timeBasedCanary;
        }

        @Override
        public final software.amazon.awscdk.CfnTrafficRoutingTimeBasedLinear getTimeBasedLinear() {
            return this.timeBasedLinear;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getTimeBasedCanary() != null) {
                data.set("timeBasedCanary", om.valueToTree(this.getTimeBasedCanary()));
            }
            if (this.getTimeBasedLinear() != null) {
                data.set("timeBasedLinear", om.valueToTree(this.getTimeBasedLinear()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnTrafficRoutingConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrafficRoutingConfig.Jsii$Proxy that = (CfnTrafficRoutingConfig.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.timeBasedCanary != null ? !this.timeBasedCanary.equals(that.timeBasedCanary) : that.timeBasedCanary != null) return false;
            return this.timeBasedLinear != null ? this.timeBasedLinear.equals(that.timeBasedLinear) : that.timeBasedLinear == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.timeBasedCanary != null ? this.timeBasedCanary.hashCode() : 0);
            result = 31 * result + (this.timeBasedLinear != null ? this.timeBasedLinear.hashCode() : 0);
            return result;
        }
    }
}
