package software.amazon.awscdk;

/**
 * Token subclass that represents values intrinsic to the target document language.
 * <p>
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 * <p>
 * This class will disappear in a future release and should not be used.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * Object value;
 * Intrinsic intrinsic = Intrinsic.Builder.create(value)
 *         .stackTrace(false)
 *         .typeHint(ResolutionTypeHint.STRING)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:46.271Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Intrinsic")
public class Intrinsic extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.IResolvable {

    protected Intrinsic(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Intrinsic(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param value This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Intrinsic(final @org.jetbrains.annotations.NotNull java.lang.Object value, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IntrinsicProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { value, options });
    }

    /**
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Intrinsic(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { value });
    }

    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     * <p>
     * @param message Error message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object newError(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        return software.amazon.jsii.Kernel.call(this, "newError", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Produce the Token's value at resolution time.
     * <p>
     * @param _context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolveContext _context) {
        return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(_context, "_context is required") });
    }

    /**
     * Turn this Token into JSON.
     * <p>
     * Called automatically when JSON.stringify() is called on a Token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Convert an instance of this Token to a string.
     * <p>
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Convert an instance of this Token to a string list.
     * <p>
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a list. We treat it the same as an explicit
     * stringification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> toStringList() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toStringList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The captured stack trace which represents the location in which this token was created.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreationStack() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "creationStack", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Type that the Intrinsic is expected to evaluate to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.ResolutionTypeHint getTypeHint() {
        return software.amazon.jsii.Kernel.get(this, "typeHint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResolutionTypeHint.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.Intrinsic}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.Intrinsic> {
        /**
         * @return a new instance of {@link Builder}.
         * @param value This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.Object value) {
            return new Builder(value);
        }

        private final java.lang.Object value;
        private software.amazon.awscdk.IntrinsicProps.Builder options;

        private Builder(final java.lang.Object value) {
            this.value = value;
        }

        /**
         * Capture the stack trace of where this token is created.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param stackTrace Capture the stack trace of where this token is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackTrace(final java.lang.Boolean stackTrace) {
            this.options().stackTrace(stackTrace);
            return this;
        }

        /**
         * Type that this token is expected to evaluate to.
         * <p>
         * Default: ResolutionTypeHint.STRING
         * <p>
         * @return {@code this}
         * @param typeHint Type that this token is expected to evaluate to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeHint(final software.amazon.awscdk.ResolutionTypeHint typeHint) {
            this.options().typeHint(typeHint);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.Intrinsic}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.Intrinsic build() {
            return new software.amazon.awscdk.Intrinsic(
                this.value,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.IntrinsicProps.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.IntrinsicProps.Builder();
            }
            return this.options;
        }
    }
}
