package software.amazon.awscdk;

/**
 * A construct which represents an AWS resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * public class MyConstruct extends Resource implements ITaggable {
 *     public final Object tags;
 *     public MyConstruct(Construct scope, String id) {
 *         super(scope, id);
 *         CfnResource.Builder.create(this, "Resource")
 *                 .type("Whatever::The::Type")
 *                 .properties(Map.of(
 *                         // ...
 *                         "Tags", this.tags.getRenderedTags()))
 *                 .build();
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:46.285Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Resource")
public abstract class Resource extends software.constructs.Construct implements software.amazon.awscdk.IResource {

    protected Resource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Resource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Resource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.ResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Resource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Returns true if the construct was created by CDK, and false otherwise.
     * <p>
     * @param construct This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isOwnedResource(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct construct) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Resource.class, "isOwnedResource", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * Check whether the given construct is a Resource.
     * <p>
     * @param construct This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isResource(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct construct) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Resource.class, "isResource", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * Apply the given removal policy to this resource.
     * <p>
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     * <p>
     * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
     * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
     * <p>
     * @param policy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
        software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String generatePhysicalName() {
        return software.amazon.jsii.Kernel.call(this, "generatePhysicalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns an environment-sensitive token that should be used for the resource's "ARN" attribute (e.g. <code>bucket.bucketArn</code>).
     * <p>
     * Normally, this token will resolve to <code>arnAttr</code>, but if the resource is
     * referenced across environments, <code>arnComponents</code> will be used to synthesize
     * a concrete ARN with the resource's physical name. Make sure to reference
     * <code>this.physicalName</code> in <code>arnComponents</code>.
     * <p>
     * @param arnAttr The CFN attribute which resolves to the ARN of the resource. This parameter is required.
     * @param arnComponents The format of the ARN of this resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getResourceArnAttribute(final @org.jetbrains.annotations.NotNull java.lang.String arnAttr, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ArnComponents arnComponents) {
        return software.amazon.jsii.Kernel.call(this, "getResourceArnAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(arnAttr, "arnAttr is required"), java.util.Objects.requireNonNull(arnComponents, "arnComponents is required") });
    }

    /**
     * Returns an environment-sensitive token that should be used for the resource's "name" attribute (e.g. <code>bucket.bucketName</code>).
     * <p>
     * Normally, this token will resolve to <code>nameAttr</code>, but if the resource is
     * referenced across environments, it will be resolved to <code>this.physicalName</code>,
     * which will be a concrete name.
     * <p>
     * @param nameAttr The CFN attribute which resolves to the resource's name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getResourceNameAttribute(final @org.jetbrains.annotations.NotNull java.lang.String nameAttr) {
        return software.amazon.jsii.Kernel.call(this, "getResourceNameAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(nameAttr, "nameAttr is required") });
    }

    /**
     * The environment this resource belongs to.
     * <p>
     * For resources that are created and managed by the CDK
     * (generally, those created by creating new class instances like Role, Bucket, etc.),
     * this is always the same as the environment of the stack they belong to;
     * however, for imported resources
     * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
     * that might be different than the stack they were imported into.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
        return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
    }

    /**
     * Returns a string-encoded token that resolves to the physical name that should be passed to the CloudFormation resource.
     * <p>
     * This value will resolve to one of the following:
     * <p>
     * <ul>
     * <li>a concrete value (e.g. <code>"my-awesome-bucket"</code>)</li>
     * <li><code>undefined</code>, when a name should be generated by CloudFormation</li>
     * <li>a concrete name generated automatically during synthesis, in
     * cross-environment scenarios.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getPhysicalName() {
        return software.amazon.jsii.Kernel.get(this, "physicalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stack in which this resource is defined.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
        return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.Resource implements software.amazon.awscdk.IResource.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
