package software.amazon.awscdk;

/**
 * An abstract application modeling unit consisting of Stacks that should be deployed together.
 * <p>
 * Derive a subclass of <code>Stage</code> and use it to model a single instance of your
 * application.
 * <p>
 * You can then instantiate your subclass multiple times to model multiple
 * copies of your application which should be be deployed to different
 * environments.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline;
 * MyApplicationStage preprod = new MyApplicationStage(this, "PreProd");
 * MyApplicationStage prod = new MyApplicationStage(this, "Prod");
 * pipeline.addStage(preprod, AddStageOpts.builder()
 *         .post(List.of(
 *             ShellStep.Builder.create("Validate Endpoint")
 *                     .commands(List.of("curl -Ssf https://my.webservice.com/"))
 *                     .build()))
 *         .build());
 * pipeline.addStage(prod, AddStageOpts.builder()
 *         .pre(List.of(
 *             new ManualApprovalStep("PromoteToProd")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:46.307Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Stage")
public class Stage extends software.constructs.Construct {

    protected Stage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.StageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Test whether the given construct is a stage.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isStage(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Stage.class, "isStage", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Return the stage this construct is contained with, if available.
     * <p>
     * If called
     * on a nested stage, returns its parent.
     * <p>
     * @param construct This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.Nullable software.amazon.awscdk.Stage of(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct construct) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Stage.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stage.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * Synthesize this stage into a cloud assembly.
     * <p>
     * Once an assembly has been synthesized, it cannot be modified. Subsequent
     * calls will return the same assembly.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly synth(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.StageSynthesisOptions options) {
        return software.amazon.jsii.Kernel.call(this, "synth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudAssembly.class), new Object[] { options });
    }

    /**
     * Synthesize this stage into a cloud assembly.
     * <p>
     * Once an assembly has been synthesized, it cannot be modified. Subsequent
     * calls will return the same assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly synth() {
        return software.amazon.jsii.Kernel.call(this, "synth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudAssembly.class));
    }

    /**
     * Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string.
     * <p>
     * Derived from the construct path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getArtifactId() {
        return software.amazon.jsii.Kernel.get(this, "artifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cloud assembly asset output directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetOutdir() {
        return software.amazon.jsii.Kernel.get(this, "assetOutdir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cloud assembly output directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOutdir() {
        return software.amazon.jsii.Kernel.get(this, "outdir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Validation plugins to run during synthesis.
     * <p>
     * If any plugin reports any violation,
     * synthesis will be interrupted and the report displayed to the user.
     * <p>
     * Default: - no validation plugins are used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.IPolicyValidationPluginBeta1> getPolicyValidationBeta1() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "policyValidationBeta1", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IPolicyValidationPluginBeta1.class))));
    }

    /**
     * The name of the stage.
     * <p>
     * Based on names of the parent stages separated by
     * hypens.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStageName() {
        return software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default account for all resources defined within this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
        return software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The parent stage or <code>undefined</code> if this is the app.
     * <p>
     * <ul>
     * <li></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Stage getParentStage() {
        return software.amazon.jsii.Kernel.get(this, "parentStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stage.class));
    }

    /**
     * The default region for all resources defined within this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.Stage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.Stage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.StageProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Default AWS environment (account/region) for <code>Stack</code>s in this <code>Stage</code>.
         * <p>
         * Stacks defined inside this <code>Stage</code> with either <code>region</code> or <code>account</code> missing
         * from its env will use the corresponding field given here.
         * <p>
         * If either <code>region</code> or <code>account</code>is is not configured for <code>Stack</code> (either on
         * the <code>Stack</code> itself or on the containing <code>Stage</code>), the Stack will be
         * <em>environment-agnostic</em>.
         * <p>
         * Environment-agnostic stacks can be deployed to any environment, may not be
         * able to take advantage of all features of the CDK. For example, they will
         * not be able to use environmental context lookups, will not automatically
         * translate Service Principals to the right format based on the environment's
         * AWS partition, and other such enhancements.
         * <p>
         * Default: - The environments should be configured on the `Stack`s.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * // Use a concrete account and region to deploy this Stage to
         * // Use a concrete account and region to deploy this Stage to
         * Stage.Builder.create(app, "Stage1")
         *         .env(Environment.builder().account("123456789012").region("us-east-1").build())
         *         .build();
         * // Use the CLI's current credentials to determine the target environment
         * // Use the CLI's current credentials to determine the target environment
         * Stage.Builder.create(app, "Stage2")
         *         .env(Environment.builder().account(process.getEnv().getCDK_DEFAULT_ACCOUNT()).region(process.getEnv().getCDK_DEFAULT_REGION()).build())
         *         .build();
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param env Default AWS environment (account/region) for <code>Stack</code>s in this <code>Stage</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(final software.amazon.awscdk.Environment env) {
            this.props().env(env);
            return this;
        }

        /**
         * The output directory into which to emit synthesized artifacts.
         * <p>
         * Can only be specified if this stage is the root stage (the app). If this is
         * specified and this stage is nested within another stage, an error will be
         * thrown.
         * <p>
         * Default: - for nested stages, outdir will be determined as a relative
         * directory to the outdir of the app. For apps, if outdir is not specified, a
         * temporary directory will be created.
         * <p>
         * @return {@code this}
         * @param outdir The output directory into which to emit synthesized artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outdir(final java.lang.String outdir) {
            this.props().outdir(outdir);
            return this;
        }

        /**
         * Options for applying a permissions boundary to all IAM Roles and Users created within this Stage.
         * <p>
         * Default: - no permissions boundary is applied
         * <p>
         * @return {@code this}
         * @param permissionsBoundary Options for applying a permissions boundary to all IAM Roles and Users created within this Stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(final software.amazon.awscdk.PermissionsBoundary permissionsBoundary) {
            this.props().permissionsBoundary(permissionsBoundary);
            return this;
        }

        /**
         * Validation plugins to run during synthesis.
         * <p>
         * If any plugin reports any violation,
         * synthesis will be interrupted and the report displayed to the user.
         * <p>
         * Default: - no validation plugins are used
         * <p>
         * @return {@code this}
         * @param policyValidationBeta1 Validation plugins to run during synthesis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyValidationBeta1(final java.util.List<? extends software.amazon.awscdk.IPolicyValidationPluginBeta1> policyValidationBeta1) {
            this.props().policyValidationBeta1(policyValidationBeta1);
            return this;
        }

        /**
         * Name of this stage.
         * <p>
         * Default: - Derived from the id.
         * <p>
         * @return {@code this}
         * @param stageName Name of this stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(final java.lang.String stageName) {
            this.props().stageName(stageName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.Stage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.Stage build() {
            return new software.amazon.awscdk.Stage(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.StageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.StageProps.Builder();
            }
            return this.props;
        }
    }
}
