package software.amazon.awscdk.cloudassembly.schema;

/**
 * Query input for looking up a VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * VpcContextQuery vpcContextQuery = VpcContextQuery.builder()
 *         .account("account")
 *         .filter(Map.of(
 *                 "filterKey", "filter"))
 *         .region("region")
 *         // the properties below are optional
 *         .lookupRoleArn("lookupRoleArn")
 *         .returnAsymmetricSubnets(false)
 *         .returnVpnGateways(false)
 *         .subnetGroupNameTag("subnetGroupNameTag")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:59.619Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.VpcContextQuery")
@software.amazon.jsii.Jsii.Proxy(VpcContextQuery.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcContextQuery extends software.amazon.jsii.JsiiSerializable {

    /**
     * Query account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccount();

    /**
     * Filters to apply to the VPC.
     * <p>
     * Filter parameters are the same as passed to DescribeVpcs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html">https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getFilter();

    /**
     * Query region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegion();

    /**
     * The ARN of the role that should be used to look up the missing values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLookupRoleArn() {
        return null;
    }

    /**
     * Whether to populate the subnetGroups field of the <code>VpcContextResponse</code>, which contains potentially asymmetric subnet groups.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReturnAsymmetricSubnets() {
        return null;
    }

    /**
     * Whether to populate the <code>vpnGatewayId</code> field of the <code>VpcContextResponse</code>, which contains the VPN Gateway ID, if one exists.
     * <p>
     * You can explicitly
     * disable this in order to avoid the lookup if you know the VPC does not have
     * a VPN Gatway attached.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReturnVpnGateways() {
        return null;
    }

    /**
     * Optional tag for subnet group name.
     * <p>
     * If not provided, we'll look at the aws-cdk:subnet-name tag.
     * If the subnet does not have the specified tag,
     * we'll use its type as the name.
     * <p>
     * Default: 'aws-cdk:subnet-name'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetGroupNameTag() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcContextQuery> {
        java.lang.String account;
        java.util.Map<java.lang.String, java.lang.String> filter;
        java.lang.String region;
        java.lang.String lookupRoleArn;
        java.lang.Boolean returnAsymmetricSubnets;
        java.lang.Boolean returnVpnGateways;
        java.lang.String subnetGroupNameTag;

        /**
         * Sets the value of {@link VpcContextQuery#getAccount}
         * @param account Query account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextQuery#getFilter}
         * @param filter Filters to apply to the VPC. This parameter is required.
         *               Filter parameters are the same as passed to DescribeVpcs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filter(java.util.Map<java.lang.String, java.lang.String> filter) {
            this.filter = filter;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextQuery#getRegion}
         * @param region Query region. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextQuery#getLookupRoleArn}
         * @param lookupRoleArn The ARN of the role that should be used to look up the missing values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleArn(java.lang.String lookupRoleArn) {
            this.lookupRoleArn = lookupRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextQuery#getReturnAsymmetricSubnets}
         * @param returnAsymmetricSubnets Whether to populate the subnetGroups field of the <code>VpcContextResponse</code>, which contains potentially asymmetric subnet groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnAsymmetricSubnets(java.lang.Boolean returnAsymmetricSubnets) {
            this.returnAsymmetricSubnets = returnAsymmetricSubnets;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextQuery#getReturnVpnGateways}
         * @param returnVpnGateways Whether to populate the <code>vpnGatewayId</code> field of the <code>VpcContextResponse</code>, which contains the VPN Gateway ID, if one exists.
         *                          You can explicitly
         *                          disable this in order to avoid the lookup if you know the VPC does not have
         *                          a VPN Gatway attached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnVpnGateways(java.lang.Boolean returnVpnGateways) {
            this.returnVpnGateways = returnVpnGateways;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextQuery#getSubnetGroupNameTag}
         * @param subnetGroupNameTag Optional tag for subnet group name.
         *                           If not provided, we'll look at the aws-cdk:subnet-name tag.
         *                           If the subnet does not have the specified tag,
         *                           we'll use its type as the name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroupNameTag(java.lang.String subnetGroupNameTag) {
            this.subnetGroupNameTag = subnetGroupNameTag;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcContextQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcContextQuery build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcContextQuery {
        private final java.lang.String account;
        private final java.util.Map<java.lang.String, java.lang.String> filter;
        private final java.lang.String region;
        private final java.lang.String lookupRoleArn;
        private final java.lang.Boolean returnAsymmetricSubnets;
        private final java.lang.Boolean returnVpnGateways;
        private final java.lang.String subnetGroupNameTag;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lookupRoleArn = software.amazon.jsii.Kernel.get(this, "lookupRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.returnAsymmetricSubnets = software.amazon.jsii.Kernel.get(this, "returnAsymmetricSubnets", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.returnVpnGateways = software.amazon.jsii.Kernel.get(this, "returnVpnGateways", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.subnetGroupNameTag = software.amazon.jsii.Kernel.get(this, "subnetGroupNameTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.account = java.util.Objects.requireNonNull(builder.account, "account is required");
            this.filter = java.util.Objects.requireNonNull(builder.filter, "filter is required");
            this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            this.lookupRoleArn = builder.lookupRoleArn;
            this.returnAsymmetricSubnets = builder.returnAsymmetricSubnets;
            this.returnVpnGateways = builder.returnVpnGateways;
            this.subnetGroupNameTag = builder.subnetGroupNameTag;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getFilter() {
            return this.filter;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getLookupRoleArn() {
            return this.lookupRoleArn;
        }

        @Override
        public final java.lang.Boolean getReturnAsymmetricSubnets() {
            return this.returnAsymmetricSubnets;
        }

        @Override
        public final java.lang.Boolean getReturnVpnGateways() {
            return this.returnVpnGateways;
        }

        @Override
        public final java.lang.String getSubnetGroupNameTag() {
            return this.subnetGroupNameTag;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("account", om.valueToTree(this.getAccount()));
            data.set("filter", om.valueToTree(this.getFilter()));
            data.set("region", om.valueToTree(this.getRegion()));
            if (this.getLookupRoleArn() != null) {
                data.set("lookupRoleArn", om.valueToTree(this.getLookupRoleArn()));
            }
            if (this.getReturnAsymmetricSubnets() != null) {
                data.set("returnAsymmetricSubnets", om.valueToTree(this.getReturnAsymmetricSubnets()));
            }
            if (this.getReturnVpnGateways() != null) {
                data.set("returnVpnGateways", om.valueToTree(this.getReturnVpnGateways()));
            }
            if (this.getSubnetGroupNameTag() != null) {
                data.set("subnetGroupNameTag", om.valueToTree(this.getSubnetGroupNameTag()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.VpcContextQuery"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcContextQuery.Jsii$Proxy that = (VpcContextQuery.Jsii$Proxy) o;

            if (!account.equals(that.account)) return false;
            if (!filter.equals(that.filter)) return false;
            if (!region.equals(that.region)) return false;
            if (this.lookupRoleArn != null ? !this.lookupRoleArn.equals(that.lookupRoleArn) : that.lookupRoleArn != null) return false;
            if (this.returnAsymmetricSubnets != null ? !this.returnAsymmetricSubnets.equals(that.returnAsymmetricSubnets) : that.returnAsymmetricSubnets != null) return false;
            if (this.returnVpnGateways != null ? !this.returnVpnGateways.equals(that.returnVpnGateways) : that.returnVpnGateways != null) return false;
            return this.subnetGroupNameTag != null ? this.subnetGroupNameTag.equals(that.subnetGroupNameTag) : that.subnetGroupNameTag == null;
        }

        @Override
        public final int hashCode() {
            int result = this.account.hashCode();
            result = 31 * result + (this.filter.hashCode());
            result = 31 * result + (this.region.hashCode());
            result = 31 * result + (this.lookupRoleArn != null ? this.lookupRoleArn.hashCode() : 0);
            result = 31 * result + (this.returnAsymmetricSubnets != null ? this.returnAsymmetricSubnets.hashCode() : 0);
            result = 31 * result + (this.returnVpnGateways != null ? this.returnVpnGateways.hashCode() : 0);
            result = 31 * result + (this.subnetGroupNameTag != null ? this.subnetGroupNameTag.hashCode() : 0);
            return result;
        }
    }
}
