package software.amazon.awscdk.services.apigateway;

/**
 * Configure the response received by clients, produced from the API Gateway backend.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * ResponseType responseType;
 * RestApi restApi;
 * GatewayResponse gatewayResponse = GatewayResponse.Builder.create(this, "MyGatewayResponse")
 *         .restApi(restApi)
 *         .type(responseType)
 *         // the properties below are optional
 *         .responseHeaders(Map.of(
 *                 "responseHeadersKey", "responseHeaders"))
 *         .statusCode("statusCode")
 *         .templates(Map.of(
 *                 "templatesKey", "templates"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:46.625Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.GatewayResponse")
public class GatewayResponse extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigateway.IGatewayResponse {

    protected GatewayResponse(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GatewayResponse(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GatewayResponse(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.GatewayResponseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.GatewayResponse}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.GatewayResponse> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.GatewayResponseProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.GatewayResponseProps.Builder();
        }

        /**
         * Response type to associate with gateway response.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html</a>
         * @param type Response type to associate with gateway response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.apigateway.ResponseType type) {
            this.props.type(type);
            return this;
        }

        /**
         * Custom headers parameters for response.
         * <p>
         * Default: - no headers
         * <p>
         * @return {@code this}
         * @param responseHeaders Custom headers parameters for response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseHeaders(final java.util.Map<java.lang.String, java.lang.String> responseHeaders) {
            this.props.responseHeaders(responseHeaders);
            return this;
        }

        /**
         * Http status code for response.
         * <p>
         * Default: - standard http status code for the response type.
         * <p>
         * @return {@code this}
         * @param statusCode Http status code for response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusCode(final java.lang.String statusCode) {
            this.props.statusCode(statusCode);
            return this;
        }

        /**
         * Custom templates to get mapped as response.
         * <p>
         * Default: - Response from api will be returned without applying any transformation.
         * <p>
         * @return {@code this}
         * @param templates Custom templates to get mapped as response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templates(final java.util.Map<java.lang.String, java.lang.String> templates) {
            this.props.templates(templates);
            return this;
        }

        /**
         * Rest api resource to target.
         * <p>
         * @return {@code this}
         * @param restApi Rest api resource to target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApi(final software.amazon.awscdk.services.apigateway.IRestApi restApi) {
            this.props.restApi(restApi);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigateway.GatewayResponse}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.GatewayResponse build() {
            return new software.amazon.awscdk.services.apigateway.GatewayResponse(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
