package software.amazon.awscdk.services.appconfig;

/**
 * Defines the deployment strategy ID's of AWS AppConfig deployment strategies.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DeploymentStrategy.fromDeploymentStrategyId(this, "MyImportedDeploymentStrategy", DeploymentStrategyId.fromString("abc123"));
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html">https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:46.939Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.DeploymentStrategyId")
public abstract class DeploymentStrategyId extends software.amazon.jsii.JsiiObject {

    protected DeploymentStrategyId(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DeploymentStrategyId(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL_AT_ONCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.DeploymentStrategyId.class, "ALL_AT_ONCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.DeploymentStrategyId.class));
        CANARY_10_PERCENT_20_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.DeploymentStrategyId.class, "CANARY_10_PERCENT_20_MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.DeploymentStrategyId.class));
        LINEAR_20_PERCENT_EVERY_6_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.DeploymentStrategyId.class, "LINEAR_20_PERCENT_EVERY_6_MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.DeploymentStrategyId.class));
        LINEAR_50_PERCENT_EVERY_30_SECONDS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.DeploymentStrategyId.class, "LINEAR_50_PERCENT_EVERY_30_SECONDS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.DeploymentStrategyId.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected DeploymentStrategyId() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Builds a deployment strategy ID from a string.
     * <p>
     * @param deploymentStrategyId The deployment strategy ID. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.DeploymentStrategyId fromString(final @org.jetbrains.annotations.NotNull java.lang.String deploymentStrategyId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.DeploymentStrategyId.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.DeploymentStrategyId.class), new Object[] { java.util.Objects.requireNonNull(deploymentStrategyId, "deploymentStrategyId is required") });
    }

    /**
     * <strong>Quick</strong>.
     * <p>
     * This strategy deploys the configuration to all targets immediately.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.appconfig.DeploymentStrategyId ALL_AT_ONCE;

    /**
     * <strong>AWS Recommended</strong>.
     * <p>
     * This strategy processes the deployment exponentially using a 10% growth factor over 20 minutes.
     * AWS AppConfig recommends using this strategy for production deployments because it aligns with AWS best practices
     * for configuration deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.appconfig.DeploymentStrategyId CANARY_10_PERCENT_20_MINUTES;

    /**
     * <strong>AWS Recommended</strong>.
     * <p>
     * This strategy deploys the configuration to 20% of all targets every six minutes for a 30 minute deployment.
     * AWS AppConfig recommends using this strategy for production deployments because it aligns with AWS best practices
     * for configuration deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.appconfig.DeploymentStrategyId LINEAR_20_PERCENT_EVERY_6_MINUTES;

    /**
     * <strong>Testing/Demonstration</strong>.
     * <p>
     * This strategy deploys the configuration to half of all targets every 30 seconds for a
     * one-minute deployment. AWS AppConfig recommends using this strategy only for testing or demonstration purposes because
     * it has a short duration and bake time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.appconfig.DeploymentStrategyId LINEAR_50_PERCENT_EVERY_30_SECONDS;

    /**
     * The deployment strategy ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getId();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appconfig.DeploymentStrategyId {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The deployment strategy ID.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getId() {
            return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
