package software.amazon.awscdk.services.appconfig;

/**
 * Properties for the Extension construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * Extension.Builder.create(this, "MyExtension")
 *         .actions(List.of(
 *             Action.Builder.create()
 *                     .actionPoints(List.of(ActionPoint.ON_DEPLOYMENT_START))
 *                     .eventDestination(new LambdaDestination(fn))
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:46.945Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.ExtensionProps")
@software.amazon.jsii.Jsii.Proxy(ExtensionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExtensionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appconfig.ExtensionOptions {

    /**
     * The actions for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appconfig.Action> getActions();

    /**
     * @return a {@link Builder} of {@link ExtensionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExtensionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExtensionProps> {
        java.util.List<software.amazon.awscdk.services.appconfig.Action> actions;
        java.lang.String description;
        java.lang.String extensionName;
        java.lang.Number latestVersionNumber;
        java.util.List<software.amazon.awscdk.services.appconfig.Parameter> parameters;

        /**
         * Sets the value of {@link ExtensionProps#getActions}
         * @param actions The actions for the extension. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder actions(java.util.List<? extends software.amazon.awscdk.services.appconfig.Action> actions) {
            this.actions = (java.util.List<software.amazon.awscdk.services.appconfig.Action>)actions;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionProps#getDescription}
         * @param description A description of the extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionProps#getExtensionName}
         * @param extensionName The name of the extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extensionName(java.lang.String extensionName) {
            this.extensionName = extensionName;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionProps#getLatestVersionNumber}
         * @param latestVersionNumber The latest version number of the extension.
         *                            When you create a new version,
         *                            specify the most recent current version number. For example, you create version 3,
         *                            enter 2 for this field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latestVersionNumber(java.lang.Number latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionProps#getParameters}
         * @param parameters The parameters accepted for the extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.List<? extends software.amazon.awscdk.services.appconfig.Parameter> parameters) {
            this.parameters = (java.util.List<software.amazon.awscdk.services.appconfig.Parameter>)parameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExtensionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExtensionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExtensionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtensionProps {
        private final java.util.List<software.amazon.awscdk.services.appconfig.Action> actions;
        private final java.lang.String description;
        private final java.lang.String extensionName;
        private final java.lang.Number latestVersionNumber;
        private final java.util.List<software.amazon.awscdk.services.appconfig.Parameter> parameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Action.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extensionName = software.amazon.jsii.Kernel.get(this, "extensionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.latestVersionNumber = software.amazon.jsii.Kernel.get(this, "latestVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Parameter.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = (java.util.List<software.amazon.awscdk.services.appconfig.Action>)java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.description = builder.description;
            this.extensionName = builder.extensionName;
            this.latestVersionNumber = builder.latestVersionNumber;
            this.parameters = (java.util.List<software.amazon.awscdk.services.appconfig.Parameter>)builder.parameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appconfig.Action> getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExtensionName() {
            return this.extensionName;
        }

        @Override
        public final java.lang.Number getLatestVersionNumber() {
            return this.latestVersionNumber;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appconfig.Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExtensionName() != null) {
                data.set("extensionName", om.valueToTree(this.getExtensionName()));
            }
            if (this.getLatestVersionNumber() != null) {
                data.set("latestVersionNumber", om.valueToTree(this.getLatestVersionNumber()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appconfig.ExtensionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExtensionProps.Jsii$Proxy that = (ExtensionProps.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.extensionName != null ? !this.extensionName.equals(that.extensionName) : that.extensionName != null) return false;
            if (this.latestVersionNumber != null ? !this.latestVersionNumber.equals(that.latestVersionNumber) : that.latestVersionNumber != null) return false;
            return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.extensionName != null ? this.extensionName.hashCode() : 0);
            result = 31 * result + (this.latestVersionNumber != null ? this.latestVersionNumber.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            return result;
        }
    }
}
