package software.amazon.awscdk.services.appmesh;

/**
 * All Properties for GatewayRoute Specs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * GatewayRouteSpecConfig gatewayRouteSpecConfig = GatewayRouteSpecConfig.builder()
 *         .grpcSpecConfig(GrpcGatewayRouteProperty.builder()
 *                 .action(GrpcGatewayRouteActionProperty.builder()
 *                         .target(GatewayRouteTargetProperty.builder()
 *                                 .virtualService(GatewayRouteVirtualServiceProperty.builder()
 *                                         .virtualServiceName("virtualServiceName")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .port(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .rewrite(GrpcGatewayRouteRewriteProperty.builder()
 *                                 .hostname(GatewayRouteHostnameRewriteProperty.builder()
 *                                         .defaultTargetHostname("defaultTargetHostname")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .match(GrpcGatewayRouteMatchProperty.builder()
 *                         .hostname(GatewayRouteHostnameMatchProperty.builder()
 *                                 .exact("exact")
 *                                 .suffix("suffix")
 *                                 .build())
 *                         .metadata(List.of(GrpcGatewayRouteMetadataProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .invert(false)
 *                                 .match(GatewayRouteMetadataMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .prefix("prefix")
 *                                         .range(GatewayRouteRangeMatchProperty.builder()
 *                                                 .end(123)
 *                                                 .start(123)
 *                                                 .build())
 *                                         .regex("regex")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .build()))
 *                         .port(123)
 *                         .serviceName("serviceName")
 *                         .build())
 *                 .build())
 *         .http2SpecConfig(HttpGatewayRouteProperty.builder()
 *                 .action(HttpGatewayRouteActionProperty.builder()
 *                         .target(GatewayRouteTargetProperty.builder()
 *                                 .virtualService(GatewayRouteVirtualServiceProperty.builder()
 *                                         .virtualServiceName("virtualServiceName")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .port(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .rewrite(HttpGatewayRouteRewriteProperty.builder()
 *                                 .hostname(GatewayRouteHostnameRewriteProperty.builder()
 *                                         .defaultTargetHostname("defaultTargetHostname")
 *                                         .build())
 *                                 .path(HttpGatewayRoutePathRewriteProperty.builder()
 *                                         .exact("exact")
 *                                         .build())
 *                                 .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
 *                                         .defaultPrefix("defaultPrefix")
 *                                         .value("value")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .match(HttpGatewayRouteMatchProperty.builder()
 *                         .headers(List.of(HttpGatewayRouteHeaderProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .invert(false)
 *                                 .match(HttpGatewayRouteHeaderMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .prefix("prefix")
 *                                         .range(GatewayRouteRangeMatchProperty.builder()
 *                                                 .end(123)
 *                                                 .start(123)
 *                                                 .build())
 *                                         .regex("regex")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .build()))
 *                         .hostname(GatewayRouteHostnameMatchProperty.builder()
 *                                 .exact("exact")
 *                                 .suffix("suffix")
 *                                 .build())
 *                         .method("method")
 *                         .path(HttpPathMatchProperty.builder()
 *                                 .exact("exact")
 *                                 .regex("regex")
 *                                 .build())
 *                         .port(123)
 *                         .prefix("prefix")
 *                         .queryParameters(List.of(QueryParameterProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .match(HttpQueryParameterMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .httpSpecConfig(HttpGatewayRouteProperty.builder()
 *                 .action(HttpGatewayRouteActionProperty.builder()
 *                         .target(GatewayRouteTargetProperty.builder()
 *                                 .virtualService(GatewayRouteVirtualServiceProperty.builder()
 *                                         .virtualServiceName("virtualServiceName")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .port(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .rewrite(HttpGatewayRouteRewriteProperty.builder()
 *                                 .hostname(GatewayRouteHostnameRewriteProperty.builder()
 *                                         .defaultTargetHostname("defaultTargetHostname")
 *                                         .build())
 *                                 .path(HttpGatewayRoutePathRewriteProperty.builder()
 *                                         .exact("exact")
 *                                         .build())
 *                                 .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
 *                                         .defaultPrefix("defaultPrefix")
 *                                         .value("value")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .match(HttpGatewayRouteMatchProperty.builder()
 *                         .headers(List.of(HttpGatewayRouteHeaderProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .invert(false)
 *                                 .match(HttpGatewayRouteHeaderMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .prefix("prefix")
 *                                         .range(GatewayRouteRangeMatchProperty.builder()
 *                                                 .end(123)
 *                                                 .start(123)
 *                                                 .build())
 *                                         .regex("regex")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .build()))
 *                         .hostname(GatewayRouteHostnameMatchProperty.builder()
 *                                 .exact("exact")
 *                                 .suffix("suffix")
 *                                 .build())
 *                         .method("method")
 *                         .path(HttpPathMatchProperty.builder()
 *                                 .exact("exact")
 *                                 .regex("regex")
 *                                 .build())
 *                         .port(123)
 *                         .prefix("prefix")
 *                         .queryParameters(List.of(QueryParameterProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .match(HttpQueryParameterMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .priority(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:47.294Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GatewayRouteSpecConfig")
@software.amazon.jsii.Jsii.Proxy(GatewayRouteSpecConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GatewayRouteSpecConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The spec for a grpc gateway route.
     * <p>
     * Default: - no grpc spec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteProperty getGrpcSpecConfig() {
        return null;
    }

    /**
     * The spec for an http2 gateway route.
     * <p>
     * Default: - no http2 spec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty getHttp2SpecConfig() {
        return null;
    }

    /**
     * The spec for an http gateway route.
     * <p>
     * Default: - no http spec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty getHttpSpecConfig() {
        return null;
    }

    /**
     * The priority for the gateway route.
     * <p>
     * When a Virtual Gateway has multiple gateway routes, gateway route match
     * is performed in the order of specified value, where 0 is the highest priority,
     * and first matched gateway route is selected.
     * <p>
     * Default: - no particular priority
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GatewayRouteSpecConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayRouteSpecConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteSpecConfig> {
        software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteProperty grpcSpecConfig;
        software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty http2SpecConfig;
        software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty httpSpecConfig;
        java.lang.Number priority;

        /**
         * Sets the value of {@link GatewayRouteSpecConfig#getGrpcSpecConfig}
         * @param grpcSpecConfig The spec for a grpc gateway route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grpcSpecConfig(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteProperty grpcSpecConfig) {
            this.grpcSpecConfig = grpcSpecConfig;
            return this;
        }

        /**
         * Sets the value of {@link GatewayRouteSpecConfig#getHttp2SpecConfig}
         * @param http2SpecConfig The spec for an http2 gateway route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder http2SpecConfig(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty http2SpecConfig) {
            this.http2SpecConfig = http2SpecConfig;
            return this;
        }

        /**
         * Sets the value of {@link GatewayRouteSpecConfig#getHttpSpecConfig}
         * @param httpSpecConfig The spec for an http gateway route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpSpecConfig(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty httpSpecConfig) {
            this.httpSpecConfig = httpSpecConfig;
            return this;
        }

        /**
         * Sets the value of {@link GatewayRouteSpecConfig#getPriority}
         * @param priority The priority for the gateway route.
         *                 When a Virtual Gateway has multiple gateway routes, gateway route match
         *                 is performed in the order of specified value, where 0 is the highest priority,
         *                 and first matched gateway route is selected.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayRouteSpecConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GatewayRouteSpecConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GatewayRouteSpecConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteSpecConfig {
        private final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteProperty grpcSpecConfig;
        private final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty http2SpecConfig;
        private final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty httpSpecConfig;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.grpcSpecConfig = software.amazon.jsii.Kernel.get(this, "grpcSpecConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteProperty.class));
            this.http2SpecConfig = software.amazon.jsii.Kernel.get(this, "http2SpecConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty.class));
            this.httpSpecConfig = software.amazon.jsii.Kernel.get(this, "httpSpecConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.grpcSpecConfig = builder.grpcSpecConfig;
            this.http2SpecConfig = builder.http2SpecConfig;
            this.httpSpecConfig = builder.httpSpecConfig;
            this.priority = builder.priority;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteProperty getGrpcSpecConfig() {
            return this.grpcSpecConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty getHttp2SpecConfig() {
            return this.http2SpecConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty getHttpSpecConfig() {
            return this.httpSpecConfig;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getGrpcSpecConfig() != null) {
                data.set("grpcSpecConfig", om.valueToTree(this.getGrpcSpecConfig()));
            }
            if (this.getHttp2SpecConfig() != null) {
                data.set("http2SpecConfig", om.valueToTree(this.getHttp2SpecConfig()));
            }
            if (this.getHttpSpecConfig() != null) {
                data.set("httpSpecConfig", om.valueToTree(this.getHttpSpecConfig()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.GatewayRouteSpecConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayRouteSpecConfig.Jsii$Proxy that = (GatewayRouteSpecConfig.Jsii$Proxy) o;

            if (this.grpcSpecConfig != null ? !this.grpcSpecConfig.equals(that.grpcSpecConfig) : that.grpcSpecConfig != null) return false;
            if (this.http2SpecConfig != null ? !this.http2SpecConfig.equals(that.http2SpecConfig) : that.http2SpecConfig != null) return false;
            if (this.httpSpecConfig != null ? !this.httpSpecConfig.equals(that.httpSpecConfig) : that.httpSpecConfig != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public final int hashCode() {
            int result = this.grpcSpecConfig != null ? this.grpcSpecConfig.hashCode() : 0;
            result = 31 * result + (this.http2SpecConfig != null ? this.http2SpecConfig.hashCode() : 0);
            result = 31 * result + (this.httpSpecConfig != null ? this.httpSpecConfig.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
