package software.amazon.awscdk.services.appmesh;

/**
 * The criterion for determining a request match for this GatewayRoute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualGateway gateway;
 * VirtualService virtualService;
 * gateway.addGatewayRoute("gateway-route-grpc", GatewayRouteBaseProps.builder()
 *         .routeSpec(GatewayRouteSpec.grpc(GrpcGatewayRouteSpecOptions.builder()
 *                 .routeTarget(virtualService)
 *                 .match(GrpcGatewayRouteMatch.builder()
 *                         .hostname(GatewayRouteHostnameMatch.endsWith(".example.com"))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:47.296Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GrpcGatewayRouteMatch")
@software.amazon.jsii.Jsii.Proxy(GrpcGatewayRouteMatch.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrpcGatewayRouteMatch extends software.amazon.jsii.JsiiSerializable {

    /**
     * Create host name based gRPC gateway route match.
     * <p>
     * Default: - no matching on host name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch getHostname() {
        return null;
    }

    /**
     * Create metadata based gRPC gateway route match.
     * <p>
     * All specified metadata must match for the route to match.
     * <p>
     * Default: - no matching on metadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> getMetadata() {
        return null;
    }

    /**
     * The port to match from the request.
     * <p>
     * Default: - do not match on port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * When <code>true</code>, rewrites the original request received at the Virtual Gateway to the destination Virtual Service name.
     * <p>
     * When <code>false</code>, retains the original hostname from the request.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRewriteRequestHostname() {
        return null;
    }

    /**
     * Create service name based gRPC gateway route match.
     * <p>
     * Default: - no matching on service name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GrpcGatewayRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrpcGatewayRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrpcGatewayRouteMatch> {
        software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch hostname;
        java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> metadata;
        java.lang.Number port;
        java.lang.Boolean rewriteRequestHostname;
        java.lang.String serviceName;

        /**
         * Sets the value of {@link GrpcGatewayRouteMatch#getHostname}
         * @param hostname Create host name based gRPC gateway route match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostname(software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Sets the value of {@link GrpcGatewayRouteMatch#getMetadata}
         * @param metadata Create metadata based gRPC gateway route match.
         *                 All specified metadata must match for the route to match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder metadata(java.util.List<? extends software.amazon.awscdk.services.appmesh.HeaderMatch> metadata) {
            this.metadata = (java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch>)metadata;
            return this;
        }

        /**
         * Sets the value of {@link GrpcGatewayRouteMatch#getPort}
         * @param port The port to match from the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link GrpcGatewayRouteMatch#getRewriteRequestHostname}
         * @param rewriteRequestHostname When <code>true</code>, rewrites the original request received at the Virtual Gateway to the destination Virtual Service name.
         *                               When <code>false</code>, retains the original hostname from the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rewriteRequestHostname(java.lang.Boolean rewriteRequestHostname) {
            this.rewriteRequestHostname = rewriteRequestHostname;
            return this;
        }

        /**
         * Sets the value of {@link GrpcGatewayRouteMatch#getServiceName}
         * @param serviceName Create service name based gRPC gateway route match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrpcGatewayRouteMatch}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrpcGatewayRouteMatch build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrpcGatewayRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcGatewayRouteMatch {
        private final software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch hostname;
        private final java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> metadata;
        private final java.lang.Number port;
        private final java.lang.Boolean rewriteRequestHostname;
        private final java.lang.String serviceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch.class));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class)));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.rewriteRequestHostname = software.amazon.jsii.Kernel.get(this, "rewriteRequestHostname", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostname = builder.hostname;
            this.metadata = (java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch>)builder.metadata;
            this.port = builder.port;
            this.rewriteRequestHostname = builder.rewriteRequestHostname;
            this.serviceName = builder.serviceName;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch getHostname() {
            return this.hostname;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> getMetadata() {
            return this.metadata;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.Boolean getRewriteRequestHostname() {
            return this.rewriteRequestHostname;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHostname() != null) {
                data.set("hostname", om.valueToTree(this.getHostname()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getRewriteRequestHostname() != null) {
                data.set("rewriteRequestHostname", om.valueToTree(this.getRewriteRequestHostname()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.GrpcGatewayRouteMatch"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrpcGatewayRouteMatch.Jsii$Proxy that = (GrpcGatewayRouteMatch.Jsii$Proxy) o;

            if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
            if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.rewriteRequestHostname != null ? !this.rewriteRequestHostname.equals(that.rewriteRequestHostname) : that.rewriteRequestHostname != null) return false;
            return this.serviceName != null ? this.serviceName.equals(that.serviceName) : that.serviceName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hostname != null ? this.hostname.hashCode() : 0;
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.rewriteRequestHostname != null ? this.rewriteRequestHostname.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            return result;
        }
    }
}
