package software.amazon.awscdk.services.appmesh;

/**
 * Connection pool properties for HTTP listeners.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // A Virtual Node with a gRPC listener with a connection pool set
 * Mesh mesh;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         // DNS service discovery can optionally specify the DNS response type as either LOAD_BALANCER or ENDPOINTS.
 *         // LOAD_BALANCER means that the DNS resolver returns a loadbalanced set of endpoints,
 *         // whereas ENDPOINTS means that the DNS resolver is returning all the endpoints.
 *         // By default, the response type is assumed to be LOAD_BALANCER
 *         .serviceDiscovery(ServiceDiscovery.dns("node", DnsResponseType.ENDPOINTS))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(80)
 *                 .connectionPool(HttpConnectionPool.builder()
 *                         .maxConnections(100)
 *                         .maxPendingRequests(10)
 *                         .build())
 *                 .build())))
 *         .build();
 * // A Virtual Gateway with a gRPC listener with a connection pool set
 * VirtualGateway gateway = VirtualGateway.Builder.create(this, "gateway")
 *         .mesh(mesh)
 *         .listeners(List.of(VirtualGatewayListener.grpc(GrpcGatewayListenerOptions.builder()
 *                 .port(8080)
 *                 .connectionPool(GrpcConnectionPool.builder()
 *                         .maxRequests(10)
 *                         .build())
 *                 .build())))
 *         .virtualGatewayName("gateway")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:47.304Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HttpConnectionPool")
@software.amazon.jsii.Jsii.Proxy(HttpConnectionPool.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpConnectionPool extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum connections in the pool.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxConnections();

    /**
     * The maximum pending requests in the pool.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxPendingRequests();

    /**
     * @return a {@link Builder} of {@link HttpConnectionPool}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpConnectionPool}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpConnectionPool> {
        java.lang.Number maxConnections;
        java.lang.Number maxPendingRequests;

        /**
         * Sets the value of {@link HttpConnectionPool#getMaxConnections}
         * @param maxConnections The maximum connections in the pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConnections(java.lang.Number maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        /**
         * Sets the value of {@link HttpConnectionPool#getMaxPendingRequests}
         * @param maxPendingRequests The maximum pending requests in the pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxPendingRequests(java.lang.Number maxPendingRequests) {
            this.maxPendingRequests = maxPendingRequests;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpConnectionPool}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpConnectionPool build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpConnectionPool}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpConnectionPool {
        private final java.lang.Number maxConnections;
        private final java.lang.Number maxPendingRequests;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxConnections = software.amazon.jsii.Kernel.get(this, "maxConnections", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxPendingRequests = software.amazon.jsii.Kernel.get(this, "maxPendingRequests", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxConnections = java.util.Objects.requireNonNull(builder.maxConnections, "maxConnections is required");
            this.maxPendingRequests = java.util.Objects.requireNonNull(builder.maxPendingRequests, "maxPendingRequests is required");
        }

        @Override
        public final java.lang.Number getMaxConnections() {
            return this.maxConnections;
        }

        @Override
        public final java.lang.Number getMaxPendingRequests() {
            return this.maxPendingRequests;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxConnections", om.valueToTree(this.getMaxConnections()));
            data.set("maxPendingRequests", om.valueToTree(this.getMaxPendingRequests()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.HttpConnectionPool"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpConnectionPool.Jsii$Proxy that = (HttpConnectionPool.Jsii$Proxy) o;

            if (!maxConnections.equals(that.maxConnections)) return false;
            return this.maxPendingRequests.equals(that.maxPendingRequests);
        }

        @Override
        public final int hashCode() {
            int result = this.maxConnections.hashCode();
            result = 31 * result + (this.maxPendingRequests.hashCode());
            return result;
        }
    }
}
