package software.amazon.awscdk.services.appsync;

/**
 * Configuration for OpenID Connect authorization in AppSync.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * OpenIdConnectConfig openIdConnectConfig = OpenIdConnectConfig.builder()
 *         .oidcProvider("oidcProvider")
 *         // the properties below are optional
 *         .clientId("clientId")
 *         .tokenExpiryFromAuth(123)
 *         .tokenExpiryFromIssue(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:47.583Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.OpenIdConnectConfig")
@software.amazon.jsii.Jsii.Proxy(OpenIdConnectConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OpenIdConnectConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The issuer for the OIDC configuration.
     * <p>
     * The issuer returned by discovery must exactly match the value of <code>iss</code> in the OIDC token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOidcProvider();

    /**
     * The client identifier of the Relying party at the OpenID identity provider.
     * <p>
     * A regular expression can be specified so AppSync can validate against multiple client identifiers at a time.
     * <p>
     * Default: - * (All)
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * -"ABCD|CDEF";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
        return null;
    }

    /**
     * The number of milliseconds an OIDC token is valid after being authenticated by OIDC provider.
     * <p>
     * <code>auth_time</code> claim in OIDC token is required for this validation to work.
     * <p>
     * Default: - no validation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTokenExpiryFromAuth() {
        return null;
    }

    /**
     * The number of milliseconds an OIDC token is valid after being issued to a user.
     * <p>
     * This validation uses <code>iat</code> claim of OIDC token.
     * <p>
     * Default: - no validation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTokenExpiryFromIssue() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OpenIdConnectConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OpenIdConnectConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OpenIdConnectConfig> {
        java.lang.String oidcProvider;
        java.lang.String clientId;
        java.lang.Number tokenExpiryFromAuth;
        java.lang.Number tokenExpiryFromIssue;

        /**
         * Sets the value of {@link OpenIdConnectConfig#getOidcProvider}
         * @param oidcProvider The issuer for the OIDC configuration. This parameter is required.
         *                     The issuer returned by discovery must exactly match the value of <code>iss</code> in the OIDC token.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oidcProvider(java.lang.String oidcProvider) {
            this.oidcProvider = oidcProvider;
            return this;
        }

        /**
         * Sets the value of {@link OpenIdConnectConfig#getClientId}
         * @param clientId The client identifier of the Relying party at the OpenID identity provider.
         *                 A regular expression can be specified so AppSync can validate against multiple client identifiers at a time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link OpenIdConnectConfig#getTokenExpiryFromAuth}
         * @param tokenExpiryFromAuth The number of milliseconds an OIDC token is valid after being authenticated by OIDC provider.
         *                            <code>auth_time</code> claim in OIDC token is required for this validation to work.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenExpiryFromAuth(java.lang.Number tokenExpiryFromAuth) {
            this.tokenExpiryFromAuth = tokenExpiryFromAuth;
            return this;
        }

        /**
         * Sets the value of {@link OpenIdConnectConfig#getTokenExpiryFromIssue}
         * @param tokenExpiryFromIssue The number of milliseconds an OIDC token is valid after being issued to a user.
         *                             This validation uses <code>iat</code> claim of OIDC token.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenExpiryFromIssue(java.lang.Number tokenExpiryFromIssue) {
            this.tokenExpiryFromIssue = tokenExpiryFromIssue;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OpenIdConnectConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OpenIdConnectConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OpenIdConnectConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIdConnectConfig {
        private final java.lang.String oidcProvider;
        private final java.lang.String clientId;
        private final java.lang.Number tokenExpiryFromAuth;
        private final java.lang.Number tokenExpiryFromIssue;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.oidcProvider = software.amazon.jsii.Kernel.get(this, "oidcProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tokenExpiryFromAuth = software.amazon.jsii.Kernel.get(this, "tokenExpiryFromAuth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tokenExpiryFromIssue = software.amazon.jsii.Kernel.get(this, "tokenExpiryFromIssue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.oidcProvider = java.util.Objects.requireNonNull(builder.oidcProvider, "oidcProvider is required");
            this.clientId = builder.clientId;
            this.tokenExpiryFromAuth = builder.tokenExpiryFromAuth;
            this.tokenExpiryFromIssue = builder.tokenExpiryFromIssue;
        }

        @Override
        public final java.lang.String getOidcProvider() {
            return this.oidcProvider;
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public final java.lang.Number getTokenExpiryFromAuth() {
            return this.tokenExpiryFromAuth;
        }

        @Override
        public final java.lang.Number getTokenExpiryFromIssue() {
            return this.tokenExpiryFromIssue;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("oidcProvider", om.valueToTree(this.getOidcProvider()));
            if (this.getClientId() != null) {
                data.set("clientId", om.valueToTree(this.getClientId()));
            }
            if (this.getTokenExpiryFromAuth() != null) {
                data.set("tokenExpiryFromAuth", om.valueToTree(this.getTokenExpiryFromAuth()));
            }
            if (this.getTokenExpiryFromIssue() != null) {
                data.set("tokenExpiryFromIssue", om.valueToTree(this.getTokenExpiryFromIssue()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.OpenIdConnectConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OpenIdConnectConfig.Jsii$Proxy that = (OpenIdConnectConfig.Jsii$Proxy) o;

            if (!oidcProvider.equals(that.oidcProvider)) return false;
            if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
            if (this.tokenExpiryFromAuth != null ? !this.tokenExpiryFromAuth.equals(that.tokenExpiryFromAuth) : that.tokenExpiryFromAuth != null) return false;
            return this.tokenExpiryFromIssue != null ? this.tokenExpiryFromIssue.equals(that.tokenExpiryFromIssue) : that.tokenExpiryFromIssue == null;
        }

        @Override
        public final int hashCode() {
            int result = this.oidcProvider.hashCode();
            result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
            result = 31 * result + (this.tokenExpiryFromAuth != null ? this.tokenExpiryFromAuth.hashCode() : 0);
            result = 31 * result + (this.tokenExpiryFromIssue != null ? this.tokenExpiryFromIssue.hashCode() : 0);
            return result;
        }
    }
}
