package software.amazon.awscdk.services.athena;

/**
 * Properties for defining a <code>CfnPreparedStatement</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.athena.*;
 * CfnPreparedStatementProps cfnPreparedStatementProps = CfnPreparedStatementProps.builder()
 *         .queryStatement("queryStatement")
 *         .statementName("statementName")
 *         .workGroup("workGroup")
 *         // the properties below are optional
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:47.640Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnPreparedStatementProps")
@software.amazon.jsii.Jsii.Proxy(CfnPreparedStatementProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPreparedStatementProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The query string for the prepared statement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html#cfn-athena-preparedstatement-querystatement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html#cfn-athena-preparedstatement-querystatement</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueryStatement();

    /**
     * The name of the prepared statement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html#cfn-athena-preparedstatement-statementname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html#cfn-athena-preparedstatement-statementname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatementName();

    /**
     * The workgroup to which the prepared statement belongs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html#cfn-athena-preparedstatement-workgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html#cfn-athena-preparedstatement-workgroup</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkGroup();

    /**
     * The description of the prepared statement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html#cfn-athena-preparedstatement-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html#cfn-athena-preparedstatement-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPreparedStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPreparedStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPreparedStatementProps> {
        java.lang.String queryStatement;
        java.lang.String statementName;
        java.lang.String workGroup;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnPreparedStatementProps#getQueryStatement}
         * @param queryStatement The query string for the prepared statement. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryStatement(java.lang.String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        /**
         * Sets the value of {@link CfnPreparedStatementProps#getStatementName}
         * @param statementName The name of the prepared statement. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statementName(java.lang.String statementName) {
            this.statementName = statementName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPreparedStatementProps#getWorkGroup}
         * @param workGroup The workgroup to which the prepared statement belongs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroup(java.lang.String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnPreparedStatementProps#getDescription}
         * @param description The description of the prepared statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPreparedStatementProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPreparedStatementProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPreparedStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPreparedStatementProps {
        private final java.lang.String queryStatement;
        private final java.lang.String statementName;
        private final java.lang.String workGroup;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.queryStatement = software.amazon.jsii.Kernel.get(this, "queryStatement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statementName = software.amazon.jsii.Kernel.get(this, "statementName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workGroup = software.amazon.jsii.Kernel.get(this, "workGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.queryStatement = java.util.Objects.requireNonNull(builder.queryStatement, "queryStatement is required");
            this.statementName = java.util.Objects.requireNonNull(builder.statementName, "statementName is required");
            this.workGroup = java.util.Objects.requireNonNull(builder.workGroup, "workGroup is required");
            this.description = builder.description;
        }

        @Override
        public final java.lang.String getQueryStatement() {
            return this.queryStatement;
        }

        @Override
        public final java.lang.String getStatementName() {
            return this.statementName;
        }

        @Override
        public final java.lang.String getWorkGroup() {
            return this.workGroup;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("queryStatement", om.valueToTree(this.getQueryStatement()));
            data.set("statementName", om.valueToTree(this.getStatementName()));
            data.set("workGroup", om.valueToTree(this.getWorkGroup()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnPreparedStatementProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPreparedStatementProps.Jsii$Proxy that = (CfnPreparedStatementProps.Jsii$Proxy) o;

            if (!queryStatement.equals(that.queryStatement)) return false;
            if (!statementName.equals(that.statementName)) return false;
            if (!workGroup.equals(that.workGroup)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.queryStatement.hashCode();
            result = 31 * result + (this.statementName.hashCode());
            result = 31 * result + (this.workGroup.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
