package software.amazon.awscdk.services.auditmanager;

/**
 * Properties for defining a <code>CfnAssessment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.auditmanager.*;
 * CfnAssessmentProps cfnAssessmentProps = CfnAssessmentProps.builder()
 *         .assessmentReportsDestination(AssessmentReportsDestinationProperty.builder()
 *                 .destination("destination")
 *                 .destinationType("destinationType")
 *                 .build())
 *         .awsAccount(AWSAccountProperty.builder()
 *                 .emailAddress("emailAddress")
 *                 .id("id")
 *                 .name("name")
 *                 .build())
 *         .delegations(List.of(DelegationProperty.builder()
 *                 .assessmentId("assessmentId")
 *                 .assessmentName("assessmentName")
 *                 .comment("comment")
 *                 .controlSetId("controlSetId")
 *                 .createdBy("createdBy")
 *                 .creationTime(123)
 *                 .id("id")
 *                 .lastUpdated(123)
 *                 .roleArn("roleArn")
 *                 .roleType("roleType")
 *                 .status("status")
 *                 .build()))
 *         .description("description")
 *         .frameworkId("frameworkId")
 *         .name("name")
 *         .roles(List.of(RoleProperty.builder()
 *                 .roleArn("roleArn")
 *                 .roleType("roleType")
 *                 .build()))
 *         .scope(ScopeProperty.builder()
 *                 .awsAccounts(List.of(AWSAccountProperty.builder()
 *                         .emailAddress("emailAddress")
 *                         .id("id")
 *                         .name("name")
 *                         .build()))
 *                 .awsServices(List.of(AWSServiceProperty.builder()
 *                         .serviceName("serviceName")
 *                         .build()))
 *                 .build())
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:47.667Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_auditmanager.CfnAssessmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnAssessmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAssessmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The destination that evidence reports are stored in for the assessment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-assessmentreportsdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-assessmentreportsdestination</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssessmentReportsDestination() {
        return null;
    }

    /**
     * The AWS account that's associated with the assessment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-awsaccount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-awsaccount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAwsAccount() {
        return null;
    }

    /**
     * The delegations that are associated with the assessment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-delegations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-delegations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDelegations() {
        return null;
    }

    /**
     * The description of the assessment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The unique identifier for the framework.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-frameworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-frameworkid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFrameworkId() {
        return null;
    }

    /**
     * The name of the assessment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The roles that are associated with the assessment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-roles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-roles</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRoles() {
        return null;
    }

    /**
     * The wrapper of AWS accounts and services that are in scope for the assessment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-scope</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScope() {
        return null;
    }

    /**
     * The overall status of the assessment.
     * <p>
     * When you create a new assessment, the initial <code>Status</code> value is always <code>ACTIVE</code> . When you create an assessment, even if you specify the value as <code>INACTIVE</code> , the value overrides to <code>ACTIVE</code> .
     * <p>
     * After you create an assessment, you can change the value of the <code>Status</code> property at any time. For example, when you want to stop collecting evidence for your assessment, you can change the assessment status to <code>INACTIVE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * The tags that are associated with the assessment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAssessmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAssessmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAssessmentProps> {
        java.lang.Object assessmentReportsDestination;
        java.lang.Object awsAccount;
        java.lang.Object delegations;
        java.lang.String description;
        java.lang.String frameworkId;
        java.lang.String name;
        java.lang.Object roles;
        java.lang.Object scope;
        java.lang.String status;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAssessmentProps#getAssessmentReportsDestination}
         * @param assessmentReportsDestination The destination that evidence reports are stored in for the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assessmentReportsDestination(software.amazon.awscdk.IResolvable assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getAssessmentReportsDestination}
         * @param assessmentReportsDestination The destination that evidence reports are stored in for the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assessmentReportsDestination(software.amazon.awscdk.services.auditmanager.CfnAssessment.AssessmentReportsDestinationProperty assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getAwsAccount}
         * @param awsAccount The AWS account that's associated with the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccount(software.amazon.awscdk.IResolvable awsAccount) {
            this.awsAccount = awsAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getAwsAccount}
         * @param awsAccount The AWS account that's associated with the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccount(software.amazon.awscdk.services.auditmanager.CfnAssessment.AWSAccountProperty awsAccount) {
            this.awsAccount = awsAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getDelegations}
         * @param delegations The delegations that are associated with the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delegations(software.amazon.awscdk.IResolvable delegations) {
            this.delegations = delegations;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getDelegations}
         * @param delegations The delegations that are associated with the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delegations(java.util.List<? extends java.lang.Object> delegations) {
            this.delegations = delegations;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getDescription}
         * @param description The description of the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getFrameworkId}
         * @param frameworkId The unique identifier for the framework.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkId(java.lang.String frameworkId) {
            this.frameworkId = frameworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getName}
         * @param name The name of the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getRoles}
         * @param roles The roles that are associated with the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(software.amazon.awscdk.IResolvable roles) {
            this.roles = roles;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getRoles}
         * @param roles The roles that are associated with the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(java.util.List<? extends java.lang.Object> roles) {
            this.roles = roles;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getScope}
         * @param scope The wrapper of AWS accounts and services that are in scope for the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.amazon.awscdk.IResolvable scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getScope}
         * @param scope The wrapper of AWS accounts and services that are in scope for the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.amazon.awscdk.services.auditmanager.CfnAssessment.ScopeProperty scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getStatus}
         * @param status The overall status of the assessment.
         *               When you create a new assessment, the initial <code>Status</code> value is always <code>ACTIVE</code> . When you create an assessment, even if you specify the value as <code>INACTIVE</code> , the value overrides to <code>ACTIVE</code> .
         *               <p>
         *               After you create an assessment, you can change the value of the <code>Status</code> property at any time. For example, when you want to stop collecting evidence for your assessment, you can change the assessment status to <code>INACTIVE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentProps#getTags}
         * @param tags The tags that are associated with the assessment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAssessmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAssessmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAssessmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAssessmentProps {
        private final java.lang.Object assessmentReportsDestination;
        private final java.lang.Object awsAccount;
        private final java.lang.Object delegations;
        private final java.lang.String description;
        private final java.lang.String frameworkId;
        private final java.lang.String name;
        private final java.lang.Object roles;
        private final java.lang.Object scope;
        private final java.lang.String status;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assessmentReportsDestination = software.amazon.jsii.Kernel.get(this, "assessmentReportsDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.awsAccount = software.amazon.jsii.Kernel.get(this, "awsAccount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.delegations = software.amazon.jsii.Kernel.get(this, "delegations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.frameworkId = software.amazon.jsii.Kernel.get(this, "frameworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roles = software.amazon.jsii.Kernel.get(this, "roles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assessmentReportsDestination = builder.assessmentReportsDestination;
            this.awsAccount = builder.awsAccount;
            this.delegations = builder.delegations;
            this.description = builder.description;
            this.frameworkId = builder.frameworkId;
            this.name = builder.name;
            this.roles = builder.roles;
            this.scope = builder.scope;
            this.status = builder.status;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAssessmentReportsDestination() {
            return this.assessmentReportsDestination;
        }

        @Override
        public final java.lang.Object getAwsAccount() {
            return this.awsAccount;
        }

        @Override
        public final java.lang.Object getDelegations() {
            return this.delegations;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getFrameworkId() {
            return this.frameworkId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRoles() {
            return this.roles;
        }

        @Override
        public final java.lang.Object getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssessmentReportsDestination() != null) {
                data.set("assessmentReportsDestination", om.valueToTree(this.getAssessmentReportsDestination()));
            }
            if (this.getAwsAccount() != null) {
                data.set("awsAccount", om.valueToTree(this.getAwsAccount()));
            }
            if (this.getDelegations() != null) {
                data.set("delegations", om.valueToTree(this.getDelegations()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFrameworkId() != null) {
                data.set("frameworkId", om.valueToTree(this.getFrameworkId()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRoles() != null) {
                data.set("roles", om.valueToTree(this.getRoles()));
            }
            if (this.getScope() != null) {
                data.set("scope", om.valueToTree(this.getScope()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_auditmanager.CfnAssessmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAssessmentProps.Jsii$Proxy that = (CfnAssessmentProps.Jsii$Proxy) o;

            if (this.assessmentReportsDestination != null ? !this.assessmentReportsDestination.equals(that.assessmentReportsDestination) : that.assessmentReportsDestination != null) return false;
            if (this.awsAccount != null ? !this.awsAccount.equals(that.awsAccount) : that.awsAccount != null) return false;
            if (this.delegations != null ? !this.delegations.equals(that.delegations) : that.delegations != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.frameworkId != null ? !this.frameworkId.equals(that.frameworkId) : that.frameworkId != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) return false;
            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assessmentReportsDestination != null ? this.assessmentReportsDestination.hashCode() : 0;
            result = 31 * result + (this.awsAccount != null ? this.awsAccount.hashCode() : 0);
            result = 31 * result + (this.delegations != null ? this.delegations.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.frameworkId != null ? this.frameworkId.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
