package software.amazon.awscdk.services.autoscaling;

/**
 * AutoScalingGroup fleet change notifications configurations.
 * <p>
 * You can configure AutoScaling to send an SNS notification whenever your Auto Scaling group scales.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.sns.*;
 * ScalingEvents scalingEvents;
 * Topic topic;
 * NotificationConfiguration notificationConfiguration = NotificationConfiguration.builder()
 *         .topic(topic)
 *         // the properties below are optional
 *         .scalingEvents(scalingEvents)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:47.801Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.NotificationConfiguration")
@software.amazon.jsii.Jsii.Proxy(NotificationConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NotificationConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * SNS topic to send notifications about fleet scaling events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic getTopic();

    /**
     * Which fleet scaling events triggers a notification.
     * <p>
     * Default: ScalingEvents.ALL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.ScalingEvents getScalingEvents() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NotificationConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NotificationConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NotificationConfiguration> {
        software.amazon.awscdk.services.sns.ITopic topic;
        software.amazon.awscdk.services.autoscaling.ScalingEvents scalingEvents;

        /**
         * Sets the value of {@link NotificationConfiguration#getTopic}
         * @param topic SNS topic to send notifications about fleet scaling events. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
            return this;
        }

        /**
         * Sets the value of {@link NotificationConfiguration#getScalingEvents}
         * @param scalingEvents Which fleet scaling events triggers a notification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingEvents(software.amazon.awscdk.services.autoscaling.ScalingEvents scalingEvents) {
            this.scalingEvents = scalingEvents;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NotificationConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NotificationConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NotificationConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationConfiguration {
        private final software.amazon.awscdk.services.sns.ITopic topic;
        private final software.amazon.awscdk.services.autoscaling.ScalingEvents scalingEvents;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
            this.scalingEvents = software.amazon.jsii.Kernel.get(this, "scalingEvents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScalingEvents.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.topic = java.util.Objects.requireNonNull(builder.topic, "topic is required");
            this.scalingEvents = builder.scalingEvents;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getTopic() {
            return this.topic;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.ScalingEvents getScalingEvents() {
            return this.scalingEvents;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("topic", om.valueToTree(this.getTopic()));
            if (this.getScalingEvents() != null) {
                data.set("scalingEvents", om.valueToTree(this.getScalingEvents()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.NotificationConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NotificationConfiguration.Jsii$Proxy that = (NotificationConfiguration.Jsii$Proxy) o;

            if (!topic.equals(that.topic)) return false;
            return this.scalingEvents != null ? this.scalingEvents.equals(that.scalingEvents) : that.scalingEvents == null;
        }

        @Override
        public final int hashCode() {
            int result = this.topic.hashCode();
            result = 31 * result + (this.scalingEvents != null ? this.scalingEvents.hashCode() : 0);
            return result;
        }
    }
}
