package software.amazon.awscdk.services.batch;

/**
 * The <code>AWS::Batch::SchedulingPolicy</code> resource specifies the parameters for an AWS Batch scheduling policy.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/scheduling_policies.html">Scheduling Policies</a> in the ** .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * CfnSchedulingPolicy cfnSchedulingPolicy = CfnSchedulingPolicy.Builder.create(this, "MyCfnSchedulingPolicy")
 *         .fairsharePolicy(FairsharePolicyProperty.builder()
 *                 .computeReservation(123)
 *                 .shareDecaySeconds(123)
 *                 .shareDistribution(List.of(ShareAttributesProperty.builder()
 *                         .shareIdentifier("shareIdentifier")
 *                         .weightFactor(123)
 *                         .build()))
 *                 .build())
 *         .name("name")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.006Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnSchedulingPolicy")
public class CfnSchedulingPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnSchedulingPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSchedulingPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.CfnSchedulingPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSchedulingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnSchedulingPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSchedulingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the scheduling policy ARN, such as <code>batch: *us-east-1* : *111122223333* :scheduling-policy/ *HighPriority*</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The fair share policy of the scheduling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFairsharePolicy() {
        return software.amazon.jsii.Kernel.get(this, "fairsharePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The fair share policy of the scheduling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFairsharePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fairsharePolicy", value);
    }

    /**
     * The fair share policy of the scheduling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFairsharePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnSchedulingPolicy.FairsharePolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "fairsharePolicy", value);
    }

    /**
     * The name of the scheduling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the scheduling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The tags that you apply to the scheduling policy to help you categorize and organize your resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The tags that you apply to the scheduling policy to help you categorize and organize your resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The fair share policy for a scheduling policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * FairsharePolicyProperty fairsharePolicyProperty = FairsharePolicyProperty.builder()
     *         .computeReservation(123)
     *         .shareDecaySeconds(123)
     *         .shareDistribution(List.of(ShareAttributesProperty.builder()
     *                 .shareIdentifier("shareIdentifier")
     *                 .weightFactor(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnSchedulingPolicy.FairsharePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(FairsharePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FairsharePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value used to reserve some of the available maximum vCPU for fair share identifiers that aren't already used.
         * <p>
         * The reserved ratio is <code>( *computeReservation* /100)^ *ActiveFairShares*</code> where <code>*ActiveFairShares*</code> is the number of active fair share identifiers.
         * <p>
         * For example, a <code>computeReservation</code> value of 50 indicates that AWS Batch reserves 50% of the maximum available vCPU if there's only one fair share identifier. It reserves 25% if there are two fair share identifiers. It reserves 12.5% if there are three fair share identifiers. A <code>computeReservation</code> value of 25 indicates that AWS Batch should reserve 25% of the maximum available vCPU if there's only one fair share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three fair share identifiers.
         * <p>
         * The minimum value is 0 and the maximum value is 99.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy-computereservation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy-computereservation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getComputeReservation() {
            return null;
        }

        /**
         * The amount of time (in seconds) to use to calculate a fair share percentage for each fair share identifier in use.
         * <p>
         * A value of zero (0) indicates that only current usage is measured. The decay allows for more recently run jobs to have more weight than jobs that ran earlier. The maximum supported value is 604800 (1 week).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy-sharedecayseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy-sharedecayseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShareDecaySeconds() {
            return null;
        }

        /**
         * An array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers for the fair share policy.
         * <p>
         * Fair share identifiers that aren't included have a default weight of <code>1.0</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy-sharedistribution">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-fairsharepolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy-sharedistribution</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShareDistribution() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FairsharePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FairsharePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FairsharePolicyProperty> {
            java.lang.Number computeReservation;
            java.lang.Number shareDecaySeconds;
            java.lang.Object shareDistribution;

            /**
             * Sets the value of {@link FairsharePolicyProperty#getComputeReservation}
             * @param computeReservation A value used to reserve some of the available maximum vCPU for fair share identifiers that aren't already used.
             *                           The reserved ratio is <code>( *computeReservation* /100)^ *ActiveFairShares*</code> where <code>*ActiveFairShares*</code> is the number of active fair share identifiers.
             *                           <p>
             *                           For example, a <code>computeReservation</code> value of 50 indicates that AWS Batch reserves 50% of the maximum available vCPU if there's only one fair share identifier. It reserves 25% if there are two fair share identifiers. It reserves 12.5% if there are three fair share identifiers. A <code>computeReservation</code> value of 25 indicates that AWS Batch should reserve 25% of the maximum available vCPU if there's only one fair share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three fair share identifiers.
             *                           <p>
             *                           The minimum value is 0 and the maximum value is 99.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeReservation(java.lang.Number computeReservation) {
                this.computeReservation = computeReservation;
                return this;
            }

            /**
             * Sets the value of {@link FairsharePolicyProperty#getShareDecaySeconds}
             * @param shareDecaySeconds The amount of time (in seconds) to use to calculate a fair share percentage for each fair share identifier in use.
             *                          A value of zero (0) indicates that only current usage is measured. The decay allows for more recently run jobs to have more weight than jobs that ran earlier. The maximum supported value is 604800 (1 week).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareDecaySeconds(java.lang.Number shareDecaySeconds) {
                this.shareDecaySeconds = shareDecaySeconds;
                return this;
            }

            /**
             * Sets the value of {@link FairsharePolicyProperty#getShareDistribution}
             * @param shareDistribution An array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers for the fair share policy.
             *                          Fair share identifiers that aren't included have a default weight of <code>1.0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareDistribution(software.amazon.awscdk.IResolvable shareDistribution) {
                this.shareDistribution = shareDistribution;
                return this;
            }

            /**
             * Sets the value of {@link FairsharePolicyProperty#getShareDistribution}
             * @param shareDistribution An array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers for the fair share policy.
             *                          Fair share identifiers that aren't included have a default weight of <code>1.0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareDistribution(java.util.List<? extends java.lang.Object> shareDistribution) {
                this.shareDistribution = shareDistribution;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FairsharePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FairsharePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FairsharePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FairsharePolicyProperty {
            private final java.lang.Number computeReservation;
            private final java.lang.Number shareDecaySeconds;
            private final java.lang.Object shareDistribution;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.computeReservation = software.amazon.jsii.Kernel.get(this, "computeReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shareDecaySeconds = software.amazon.jsii.Kernel.get(this, "shareDecaySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shareDistribution = software.amazon.jsii.Kernel.get(this, "shareDistribution", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.computeReservation = builder.computeReservation;
                this.shareDecaySeconds = builder.shareDecaySeconds;
                this.shareDistribution = builder.shareDistribution;
            }

            @Override
            public final java.lang.Number getComputeReservation() {
                return this.computeReservation;
            }

            @Override
            public final java.lang.Number getShareDecaySeconds() {
                return this.shareDecaySeconds;
            }

            @Override
            public final java.lang.Object getShareDistribution() {
                return this.shareDistribution;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComputeReservation() != null) {
                    data.set("computeReservation", om.valueToTree(this.getComputeReservation()));
                }
                if (this.getShareDecaySeconds() != null) {
                    data.set("shareDecaySeconds", om.valueToTree(this.getShareDecaySeconds()));
                }
                if (this.getShareDistribution() != null) {
                    data.set("shareDistribution", om.valueToTree(this.getShareDistribution()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnSchedulingPolicy.FairsharePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FairsharePolicyProperty.Jsii$Proxy that = (FairsharePolicyProperty.Jsii$Proxy) o;

                if (this.computeReservation != null ? !this.computeReservation.equals(that.computeReservation) : that.computeReservation != null) return false;
                if (this.shareDecaySeconds != null ? !this.shareDecaySeconds.equals(that.shareDecaySeconds) : that.shareDecaySeconds != null) return false;
                return this.shareDistribution != null ? this.shareDistribution.equals(that.shareDistribution) : that.shareDistribution == null;
            }

            @Override
            public final int hashCode() {
                int result = this.computeReservation != null ? this.computeReservation.hashCode() : 0;
                result = 31 * result + (this.shareDecaySeconds != null ? this.shareDecaySeconds.hashCode() : 0);
                result = 31 * result + (this.shareDistribution != null ? this.shareDistribution.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the weights for the fair share identifiers for the fair share policy.
     * <p>
     * Fair share identifiers that aren't included have a default weight of <code>1.0</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * ShareAttributesProperty shareAttributesProperty = ShareAttributesProperty.builder()
     *         .shareIdentifier("shareIdentifier")
     *         .weightFactor(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-shareattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-shareattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnSchedulingPolicy.ShareAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(ShareAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ShareAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A fair share identifier or fair share identifier prefix.
         * <p>
         * If the string ends with an asterisk (*), this entry specifies the weight factor to use for fair share identifiers that start with that prefix. The list of fair share identifiers in a fair share policy can't overlap. For example, you can't have one that specifies a <code>shareIdentifier</code> of <code>UserA*</code> and another that specifies a <code>shareIdentifier</code> of <code>UserA-1</code> .
         * <p>
         * There can be no more than 500 fair share identifiers active in a job queue.
         * <p>
         * The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-shareattributes.html#cfn-batch-schedulingpolicy-shareattributes-shareidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-shareattributes.html#cfn-batch-schedulingpolicy-shareattributes-shareidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShareIdentifier() {
            return null;
        }

        /**
         * The weight factor for the fair share identifier.
         * <p>
         * The default value is 1.0. A lower value has a higher priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.
         * <p>
         * The smallest supported value is 0.0001, and the largest supported value is 999.9999.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-shareattributes.html#cfn-batch-schedulingpolicy-shareattributes-weightfactor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-schedulingpolicy-shareattributes.html#cfn-batch-schedulingpolicy-shareattributes-weightfactor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightFactor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ShareAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ShareAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ShareAttributesProperty> {
            java.lang.String shareIdentifier;
            java.lang.Number weightFactor;

            /**
             * Sets the value of {@link ShareAttributesProperty#getShareIdentifier}
             * @param shareIdentifier A fair share identifier or fair share identifier prefix.
             *                        If the string ends with an asterisk (*), this entry specifies the weight factor to use for fair share identifiers that start with that prefix. The list of fair share identifiers in a fair share policy can't overlap. For example, you can't have one that specifies a <code>shareIdentifier</code> of <code>UserA*</code> and another that specifies a <code>shareIdentifier</code> of <code>UserA-1</code> .
             *                        <p>
             *                        There can be no more than 500 fair share identifiers active in a job queue.
             *                        <p>
             *                        The string is limited to 255 alphanumeric characters, and can be followed by an asterisk (*).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareIdentifier(java.lang.String shareIdentifier) {
                this.shareIdentifier = shareIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ShareAttributesProperty#getWeightFactor}
             * @param weightFactor The weight factor for the fair share identifier.
             *                     The default value is 1.0. A lower value has a higher priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.
             *                     <p>
             *                     The smallest supported value is 0.0001, and the largest supported value is 999.9999.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightFactor(java.lang.Number weightFactor) {
                this.weightFactor = weightFactor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ShareAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ShareAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ShareAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShareAttributesProperty {
            private final java.lang.String shareIdentifier;
            private final java.lang.Number weightFactor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.shareIdentifier = software.amazon.jsii.Kernel.get(this, "shareIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weightFactor = software.amazon.jsii.Kernel.get(this, "weightFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.shareIdentifier = builder.shareIdentifier;
                this.weightFactor = builder.weightFactor;
            }

            @Override
            public final java.lang.String getShareIdentifier() {
                return this.shareIdentifier;
            }

            @Override
            public final java.lang.Number getWeightFactor() {
                return this.weightFactor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getShareIdentifier() != null) {
                    data.set("shareIdentifier", om.valueToTree(this.getShareIdentifier()));
                }
                if (this.getWeightFactor() != null) {
                    data.set("weightFactor", om.valueToTree(this.getWeightFactor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnSchedulingPolicy.ShareAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ShareAttributesProperty.Jsii$Proxy that = (ShareAttributesProperty.Jsii$Proxy) o;

                if (this.shareIdentifier != null ? !this.shareIdentifier.equals(that.shareIdentifier) : that.shareIdentifier != null) return false;
                return this.weightFactor != null ? this.weightFactor.equals(that.weightFactor) : that.weightFactor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.shareIdentifier != null ? this.shareIdentifier.hashCode() : 0;
                result = 31 * result + (this.weightFactor != null ? this.weightFactor.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.CfnSchedulingPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.CfnSchedulingPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.batch.CfnSchedulingPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The fair share policy of the scheduling policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy</a>
         * @param fairsharePolicy The fair share policy of the scheduling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fairsharePolicy(final software.amazon.awscdk.IResolvable fairsharePolicy) {
            this.props().fairsharePolicy(fairsharePolicy);
            return this;
        }
        /**
         * The fair share policy of the scheduling policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-fairsharepolicy</a>
         * @param fairsharePolicy The fair share policy of the scheduling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fairsharePolicy(final software.amazon.awscdk.services.batch.CfnSchedulingPolicy.FairsharePolicyProperty fairsharePolicy) {
            this.props().fairsharePolicy(fairsharePolicy);
            return this;
        }

        /**
         * The name of the scheduling policy.
         * <p>
         * It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-name</a>
         * @param name The name of the scheduling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The tags that you apply to the scheduling policy to help you categorize and organize your resources.
         * <p>
         * Each tag consists of a key and an optional value. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in <em>AWS General Reference</em> .
         * <p>
         * These tags can be updated or removed using the <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a> API operations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-schedulingpolicy.html#cfn-batch-schedulingpolicy-tags</a>
         * @param tags The tags that you apply to the scheduling policy to help you categorize and organize your resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.CfnSchedulingPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.CfnSchedulingPolicy build() {
            return new software.amazon.awscdk.services.batch.CfnSchedulingPolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.batch.CfnSchedulingPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.batch.CfnSchedulingPolicyProps.Builder();
            }
            return this.props;
        }
    }
}
