package software.amazon.awscdk.services.batch;

/**
 * A JobDefinition that uses Eks orchestration.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.063Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.IEksJobDefinition")
@software.amazon.jsii.Jsii.Proxy(IEksJobDefinition.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEksJobDefinition extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.IJobDefinition {

    /**
     * The container this Job Definition will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksContainerDefinition getContainer();

    /**
     * The DNS Policy of the pod used by this Job Definition.
     * <p>
     * Default: `DnsPolicy.CLUSTER_FIRST`
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.DnsPolicy getDnsPolicy() {
        return null;
    }

    /**
     * The name of the service account that's used to run the container.
     * <p>
     * service accounts are Kubernetes method of identification and authentication,
     * roughly analogous to IAM users.
     * <p>
     * Default: - the default service account of the container
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccount() {
        return null;
    }

    /**
     * If specified, the Pod used by this Job Definition will use the host's network IP address.
     * <p>
     * Otherwise, the Kubernetes pod networking model is enabled.
     * Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseHostNetwork() {
        return null;
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.batch.IEksJobDefinition.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ARN of this job definition.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionArn() {
            return software.amazon.jsii.Kernel.get(this, "jobDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of this job definition.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionName() {
            return software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Defines the retry behavior for this job.
         * <p>
         * Default: - no `RetryStrategy`
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> getRetryStrategies() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "retryStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.RetryStrategy.class))));
        }

        /**
         * The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
         * <p>
         * Default: none
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters">https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.Object>)(software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The number of times to retry a job.
         * <p>
         * The job is retried on failure the same number of attempts as the value.
         * <p>
         * Default: 1
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
            return software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The priority of this Job.
         * <p>
         * Only used in Fairshare Scheduling
         * to decide which job to run first when there are multiple jobs
         * with the same share identifier.
         * <p>
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingPriority() {
            return software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The timeout time for jobs that are submitted with this job definition.
         * <p>
         * After the amount of time you specify passes,
         * Batch terminates your jobs if they aren't finished.
         * <p>
         * Default: - no timeout
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
            return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * The container this Job Definition will run.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksContainerDefinition getContainer() {
            return software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EksContainerDefinition.class));
        }

        /**
         * The DNS Policy of the pod used by this Job Definition.
         * <p>
         * Default: `DnsPolicy.CLUSTER_FIRST`
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.DnsPolicy getDnsPolicy() {
            return software.amazon.jsii.Kernel.get(this, "dnsPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.DnsPolicy.class));
        }

        /**
         * The name of the service account that's used to run the container.
         * <p>
         * service accounts are Kubernetes method of identification and authentication,
         * roughly analogous to IAM users.
         * <p>
         * Default: - the default service account of the container
         * <p>
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getServiceAccount() {
            return software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * If specified, the Pod used by this Job Definition will use the host's network IP address.
         * <p>
         * Otherwise, the Kubernetes pod networking model is enabled.
         * Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
         * <p>
         * Default: true
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getUseHostNetwork() {
            return software.amazon.jsii.Kernel.get(this, "useHostNetwork", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Add a RetryStrategy to this JobDefinition.
         * <p>
         * @param strategy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addRetryStrategy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.RetryStrategy strategy) {
            software.amazon.jsii.Kernel.call(this, "addRetryStrategy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(strategy, "strategy is required") });
        }
    }

    /**
     * Internal default implementation for {@link IEksJobDefinition}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEksJobDefinition, software.amazon.awscdk.services.batch.IJobDefinition.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ARN of this job definition.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionArn() {
            return software.amazon.jsii.Kernel.get(this, "jobDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of this job definition.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionName() {
            return software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Defines the retry behavior for this job.
         * <p>
         * Default: - no `RetryStrategy`
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> getRetryStrategies() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "retryStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.RetryStrategy.class))));
        }

        /**
         * The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
         * <p>
         * Default: none
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters">https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.Object>)(software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The number of times to retry a job.
         * <p>
         * The job is retried on failure the same number of attempts as the value.
         * <p>
         * Default: 1
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
            return software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The priority of this Job.
         * <p>
         * Only used in Fairshare Scheduling
         * to decide which job to run first when there are multiple jobs
         * with the same share identifier.
         * <p>
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingPriority() {
            return software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The timeout time for jobs that are submitted with this job definition.
         * <p>
         * After the amount of time you specify passes,
         * Batch terminates your jobs if they aren't finished.
         * <p>
         * Default: - no timeout
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
            return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * The container this Job Definition will run.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksContainerDefinition getContainer() {
            return software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EksContainerDefinition.class));
        }

        /**
         * The DNS Policy of the pod used by this Job Definition.
         * <p>
         * Default: `DnsPolicy.CLUSTER_FIRST`
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.DnsPolicy getDnsPolicy() {
            return software.amazon.jsii.Kernel.get(this, "dnsPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.DnsPolicy.class));
        }

        /**
         * The name of the service account that's used to run the container.
         * <p>
         * service accounts are Kubernetes method of identification and authentication,
         * roughly analogous to IAM users.
         * <p>
         * Default: - the default service account of the container
         * <p>
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccount() {
            return software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * If specified, the Pod used by this Job Definition will use the host's network IP address.
         * <p>
         * Otherwise, the Kubernetes pod networking model is enabled.
         * Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
         * <p>
         * Default: true
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseHostNetwork() {
            return software.amazon.jsii.Kernel.get(this, "useHostNetwork", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Add a RetryStrategy to this JobDefinition.
         * <p>
         * @param strategy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addRetryStrategy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.RetryStrategy strategy) {
            software.amazon.jsii.Kernel.call(this, "addRetryStrategy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(strategy, "strategy is required") });
        }
    }
}
