package software.amazon.awscdk.services.batch;

/**
 * A ManagedComputeEnvironment that uses ECS orchestration on Fargate instances.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.065Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.IFargateComputeEnvironment")
@software.amazon.jsii.Jsii.Proxy(IFargateComputeEnvironment.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IFargateComputeEnvironment extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.IManagedComputeEnvironment {

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.batch.IFargateComputeEnvironment.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ARN of this compute environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentArn() {
            return software.amazon.jsii.Kernel.get(this, "computeEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the ComputeEnvironment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentName() {
            return software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Whether or not this ComputeEnvironment can accept jobs from a Queue.
         * <p>
         * Enabled ComputeEnvironments can accept jobs from a Queue and
         * can scale instances up or down.
         * Disabled ComputeEnvironments cannot accept jobs from a Queue or
         * scale instances up or down.
         * <p>
         * If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
         * Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
         * be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
         * <p>
         * To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean getEnabled() {
            return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
         * <p>
         * Default: - a serviceRole will be created for managed CEs, none for unmanaged CEs
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * TagManager to set, remove and format tags.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
            return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
        }

        /**
         * The maximum vCpus this <code>ManagedComputeEnvironment</code> can scale up to.
         * <p>
         * <em>Note</em>: if this Compute Environment uses EC2 resources (not Fargate) with either <code>AllocationStrategy.BEST_FIT_PROGRESSIVE</code> or
         * <code>AllocationStrategy.SPOT_CAPACITY_OPTIMIZED</code>, or <code>AllocationStrategy.BEST_FIT</code> with Spot instances,
         * The scheduler may exceed this number by at most one of the instances specified in <code>instanceTypes</code>
         * or <code>instanceClasses</code>.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Number getMaxvCpus() {
            return software.amazon.jsii.Kernel.get(this, "maxvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The security groups this Compute Environment will launch instances in.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class))));
        }

        /**
         * Specifies whether this Compute Environment is replaced if an update is made that requires replacing its instances.
         * <p>
         * To enable more properties to be updated,
         * set this property to <code>false</code>. When changing the value of this property to false,
         * do not change any other properties at the same time.
         * If other properties are changed at the same time,
         * and the change needs to be rolled back but it can't,
         * it's possible for the stack to go into the UPDATE_ROLLBACK_FAILED state.
         * You can't update a stack that is in the UPDATE_ROLLBACK_FAILED state.
         * However, if you can continue to roll it back,
         * you can return the stack to its original settings and then try to update it again.
         * <p>
         * The properties which require a replacement of the Compute Environment are:
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getReplaceComputeEnvironment() {
            return software.amazon.jsii.Kernel.get(this, "replaceComputeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Whether or not to use spot instances.
         * <p>
         * Spot instances are less expensive EC2 instances that can be
         * reclaimed by EC2 at any time; your job will be given two minutes
         * of notice before reclamation.
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getSpot() {
            return software.amazon.jsii.Kernel.get(this, "spot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Whether or not any running jobs will be immediately terminated when an infrastructure update occurs.
         * <p>
         * If this is enabled, any terminated jobs may be retried, depending on the job's
         * retry policy.
         * <p>
         * Default: false
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminateOnUpdate() {
            return software.amazon.jsii.Kernel.get(this, "terminateOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Only meaningful if <code>terminateOnUpdate</code> is <code>false</code>.
         * <p>
         * If so,
         * when an infrastructure update is triggered, any running jobs
         * will be allowed to run until <code>updateTimeout</code> has expired.
         * <p>
         * Default: 30 minutes
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getUpdateTimeout() {
            return software.amazon.jsii.Kernel.get(this, "updateTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Whether or not the AMI is updated to the latest one supported by Batch when an infrastructure update occurs.
         * <p>
         * If you specify a specific AMI, this property will be ignored.
         * <p>
         * Note: the CDK will never set this value by default, <code>false</code> will set by CFN.
         * This is to avoid a deployment failure that occurs when this value is set.
         * <p>
         * Default: false
         * <p>
         * @see <a href="https://github.com/aws/aws-cdk/issues/27054">https://github.com/aws/aws-cdk/issues/27054</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getUpdateToLatestImageVersion() {
            return software.amazon.jsii.Kernel.get(this, "updateToLatestImageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The VPC Subnets this Compute Environment will launch instances in.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }
    }

    /**
     * Internal default implementation for {@link IFargateComputeEnvironment}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IFargateComputeEnvironment, software.amazon.awscdk.services.batch.IManagedComputeEnvironment.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ARN of this compute environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentArn() {
            return software.amazon.jsii.Kernel.get(this, "computeEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the ComputeEnvironment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentName() {
            return software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Whether or not this ComputeEnvironment can accept jobs from a Queue.
         * <p>
         * Enabled ComputeEnvironments can accept jobs from a Queue and
         * can scale instances up or down.
         * Disabled ComputeEnvironments cannot accept jobs from a Queue or
         * scale instances up or down.
         * <p>
         * If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
         * Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
         * be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
         * <p>
         * To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.Boolean getEnabled() {
            return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
         * <p>
         * Default: - a serviceRole will be created for managed CEs, none for unmanaged CEs
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * TagManager to set, remove and format tags.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
            return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
        }

        /**
         * The maximum vCpus this <code>ManagedComputeEnvironment</code> can scale up to.
         * <p>
         * <em>Note</em>: if this Compute Environment uses EC2 resources (not Fargate) with either <code>AllocationStrategy.BEST_FIT_PROGRESSIVE</code> or
         * <code>AllocationStrategy.SPOT_CAPACITY_OPTIMIZED</code>, or <code>AllocationStrategy.BEST_FIT</code> with Spot instances,
         * The scheduler may exceed this number by at most one of the instances specified in <code>instanceTypes</code>
         * or <code>instanceClasses</code>.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.Number getMaxvCpus() {
            return software.amazon.jsii.Kernel.get(this, "maxvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The security groups this Compute Environment will launch instances in.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class))));
        }

        /**
         * Specifies whether this Compute Environment is replaced if an update is made that requires replacing its instances.
         * <p>
         * To enable more properties to be updated,
         * set this property to <code>false</code>. When changing the value of this property to false,
         * do not change any other properties at the same time.
         * If other properties are changed at the same time,
         * and the change needs to be rolled back but it can't,
         * it's possible for the stack to go into the UPDATE_ROLLBACK_FAILED state.
         * You can't update a stack that is in the UPDATE_ROLLBACK_FAILED state.
         * However, if you can continue to roll it back,
         * you can return the stack to its original settings and then try to update it again.
         * <p>
         * The properties which require a replacement of the Compute Environment are:
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getReplaceComputeEnvironment() {
            return software.amazon.jsii.Kernel.get(this, "replaceComputeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Whether or not to use spot instances.
         * <p>
         * Spot instances are less expensive EC2 instances that can be
         * reclaimed by EC2 at any time; your job will be given two minutes
         * of notice before reclamation.
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getSpot() {
            return software.amazon.jsii.Kernel.get(this, "spot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Whether or not any running jobs will be immediately terminated when an infrastructure update occurs.
         * <p>
         * If this is enabled, any terminated jobs may be retried, depending on the job's
         * retry policy.
         * <p>
         * Default: false
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminateOnUpdate() {
            return software.amazon.jsii.Kernel.get(this, "terminateOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Only meaningful if <code>terminateOnUpdate</code> is <code>false</code>.
         * <p>
         * If so,
         * when an infrastructure update is triggered, any running jobs
         * will be allowed to run until <code>updateTimeout</code> has expired.
         * <p>
         * Default: 30 minutes
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getUpdateTimeout() {
            return software.amazon.jsii.Kernel.get(this, "updateTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Whether or not the AMI is updated to the latest one supported by Batch when an infrastructure update occurs.
         * <p>
         * If you specify a specific AMI, this property will be ignored.
         * <p>
         * Note: the CDK will never set this value by default, <code>false</code> will set by CFN.
         * This is to avoid a deployment failure that occurs when this value is set.
         * <p>
         * Default: false
         * <p>
         * @see <a href="https://github.com/aws/aws-cdk/issues/27054">https://github.com/aws/aws-cdk/issues/27054</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getUpdateToLatestImageVersion() {
            return software.amazon.jsii.Kernel.get(this, "updateToLatestImageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The VPC Subnets this Compute Environment will launch instances in.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }
    }
}
