package software.amazon.awscdk.services.batch;

/**
 * A ManagedComputeEnvironment that uses ECS orchestration on EC2 instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IManagedEc2EcsComputeEnvironment computeEnv;
 * Vpc vpc = new Vpc(this, "VPC");
 * computeEnv.addInstanceClass(InstanceClass.M5AD);
 * // Or, specify it on the constructor:
 * // Or, specify it on the constructor:
 * ManagedEc2EcsComputeEnvironment.Builder.create(this, "myEc2ComputeEnv")
 *         .vpc(vpc)
 *         .instanceClasses(List.of(InstanceClass.R4))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.081Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.ManagedEc2EcsComputeEnvironment")
public class ManagedEc2EcsComputeEnvironment extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.batch.IManagedEc2EcsComputeEnvironment, software.amazon.awscdk.services.batch.IManagedComputeEnvironment, software.amazon.awscdk.services.batch.IComputeEnvironment {

    protected ManagedEc2EcsComputeEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedEc2EcsComputeEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManagedEc2EcsComputeEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.ManagedEc2EcsComputeEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * refer to an existing ComputeEnvironment by its arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param managedEc2EcsComputeEnvironmentArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IManagedEc2EcsComputeEnvironment fromManagedEc2EcsComputeEnvironmentArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String managedEc2EcsComputeEnvironmentArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.ManagedEc2EcsComputeEnvironment.class, "fromManagedEc2EcsComputeEnvironmentArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IManagedEc2EcsComputeEnvironment.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(managedEc2EcsComputeEnvironmentArn, "managedEc2EcsComputeEnvironmentArn is required") });
    }

    /**
     * Add an instance class to this compute environment.
     * <p>
     * @param instanceClass This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addInstanceClass(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceClass instanceClass) {
        software.amazon.jsii.Kernel.call(this, "addInstanceClass", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(instanceClass, "instanceClass is required") });
    }

    /**
     * Add an instance type to this compute environment.
     * <p>
     * @param instanceType This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addInstanceType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType instanceType) {
        software.amazon.jsii.Kernel.call(this, "addInstanceType", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(instanceType, "instanceType is required") });
    }

    /**
     * The ARN of this compute environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentArn() {
        return software.amazon.jsii.Kernel.get(this, "computeEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the ComputeEnvironment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentName() {
        return software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The network connections associated with this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Whether or not this ComputeEnvironment can accept jobs from a Queue.
     * <p>
     * Enabled ComputeEnvironments can accept jobs from a Queue and
     * can scale instances up or down.
     * Disabled ComputeEnvironments cannot accept jobs from a Queue or
     * scale instances up or down.
     * <p>
     * If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
     * Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
     * be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
     * <p>
     * To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The instance classes that this Compute Environment can launch.
     * <p>
     * Which one is chosen depends on the <code>AllocationStrategy</code> used.
     * Batch will automatically choose the size.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.InstanceClass> getInstanceClasses() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceClasses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceClass.class))));
    }

    /**
     * The instance types that this Compute Environment can launch.
     * <p>
     * Which one is chosen depends on the <code>AllocationStrategy</code> used.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.InstanceType> getInstanceTypes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class))));
    }

    /**
     * The maximum vCpus this <code>ManagedComputeEnvironment</code> can scale up to.
     * <p>
     * <em>Note</em>: if this Compute Environment uses EC2 resources (not Fargate) with either <code>AllocationStrategy.BEST_FIT_PROGRESSIVE</code> or
     * <code>AllocationStrategy.SPOT_CAPACITY_OPTIMIZED</code>, or <code>AllocationStrategy.BEST_FIT</code> with Spot instances,
     * The scheduler may exceed this number by at most one of the instances specified in <code>instanceTypes</code>
     * or <code>instanceClasses</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxvCpus() {
        return software.amazon.jsii.Kernel.get(this, "maxvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The security groups this Compute Environment will launch instances in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class))));
    }

    /**
     * TagManager to set, remove and format tags.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The allocation strategy to use if not enough instances of the best fitting instance type can be allocated.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.AllocationStrategy getAllocationStrategy() {
        return software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.AllocationStrategy.class));
    }

    /**
     * Configure which AMIs this Compute Environment can launch.
     * <p>
     * Leave this <code>undefined</code> to allow Batch to choose the latest AMIs it supports for each instance that it launches.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.batch.EcsMachineImage> getImages() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.batch.EcsMachineImage>)(software.amazon.jsii.Kernel.get(this, "images", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EcsMachineImage.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The execution Role that instances launched by this Compute Environment will use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getInstanceRole() {
        return software.amazon.jsii.Kernel.get(this, "instanceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The Launch Template that this Compute Environment will use to provision EC2 Instances.
     * <p>
     * <em>Note</em>: if <code>securityGroups</code> is specified on both your
     * launch template and this Compute Environment, **the
     * <code>securityGroup</code>s on the Compute Environment override the
     * ones on the launch template.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ILaunchTemplate getLaunchTemplate() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ILaunchTemplate.class));
    }

    /**
     * The minimum vCPUs that an environment should maintain, even if the compute environment is DISABLED.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinvCpus() {
        return software.amazon.jsii.Kernel.get(this, "minvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The EC2 placement group to associate with your compute resources.
     * <p>
     * If you intend to submit multi-node parallel jobs to this Compute Environment,
     * you should consider creating a cluster placement group and associate it with your compute resources.
     * This keeps your multi-node parallel job on a logical grouping of instances
     * within a single Availability Zone with high network flow potential.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IPlacementGroup getPlacementGroup() {
        return software.amazon.jsii.Kernel.get(this, "placementGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPlacementGroup.class));
    }

    /**
     * Specifies whether this Compute Environment is replaced if an update is made that requires replacing its instances.
     * <p>
     * To enable more properties to be updated,
     * set this property to <code>false</code>. When changing the value of this property to false,
     * do not change any other properties at the same time.
     * If other properties are changed at the same time,
     * and the change needs to be rolled back but it can't,
     * it's possible for the stack to go into the UPDATE_ROLLBACK_FAILED state.
     * You can't update a stack that is in the UPDATE_ROLLBACK_FAILED state.
     * However, if you can continue to roll it back,
     * you can return the stack to its original settings and then try to update it again.
     * <p>
     * The properties which require a replacement of the Compute Environment are:
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getReplaceComputeEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "replaceComputeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * Whether or not to use spot instances.
     * <p>
     * Spot instances are less expensive EC2 instances that can be
     * reclaimed by EC2 at any time; your job will be given two minutes
     * of notice before reclamation.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getSpot() {
        return software.amazon.jsii.Kernel.get(this, "spot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched.
     * <p>
     * For example, if your maximum percentage is 20%, the Spot price must be
     * less than 20% of the current On-Demand price for that Instance.
     * You always pay the lowest market price and never more than your maximum percentage.
     * For most use cases, Batch recommends leaving this field empty.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSpotBidPercentage() {
        return software.amazon.jsii.Kernel.get(this, "spotBidPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The service-linked role that Spot Fleet needs to launch instances on your behalf.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getSpotFleetRole() {
        return software.amazon.jsii.Kernel.get(this, "spotFleetRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * Whether or not any running jobs will be immediately terminated when an infrastructure update occurs.
     * <p>
     * If this is enabled, any terminated jobs may be retried, depending on the job's
     * retry policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminateOnUpdate() {
        return software.amazon.jsii.Kernel.get(this, "terminateOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Only meaningful if <code>terminateOnUpdate</code> is <code>false</code>.
     * <p>
     * If so,
     * when an infrastructure update is triggered, any running jobs
     * will be allowed to run until <code>updateTimeout</code> has expired.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getUpdateTimeout() {
        return software.amazon.jsii.Kernel.get(this, "updateTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * Whether or not the AMI is updated to the latest one supported by Batch when an infrastructure update occurs.
     * <p>
     * If you specify a specific AMI, this property will be ignored.
     * <p>
     * Note: the CDK will never set this value by default, <code>false</code> will set by CFN.
     * This is to avoid a deployment failure that occurs when this value is set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getUpdateToLatestImageVersion() {
        return software.amazon.jsii.Kernel.get(this, "updateToLatestImageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.ManagedEc2EcsComputeEnvironment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.ManagedEc2EcsComputeEnvironment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.ManagedEc2EcsComputeEnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.ManagedEc2EcsComputeEnvironmentProps.Builder();
        }

        /**
         * The name of the ComputeEnvironment.
         * <p>
         * Default: - generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param computeEnvironmentName The name of the ComputeEnvironment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentName(final java.lang.String computeEnvironmentName) {
            this.props.computeEnvironmentName(computeEnvironmentName);
            return this;
        }

        /**
         * Whether or not this ComputeEnvironment can accept jobs from a Queue.
         * <p>
         * Enabled ComputeEnvironments can accept jobs from a Queue and
         * can scale instances up or down.
         * Disabled ComputeEnvironments cannot accept jobs from a Queue or
         * scale instances up or down.
         * <p>
         * If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
         * Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
         * be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
         * <p>
         * To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Whether or not this ComputeEnvironment can accept jobs from a Queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
         * <p>
         * Default: - a serviceRole will be created for managed CEs, none for unmanaged CEs
         * <p>
         * @return {@code this}
         * @param serviceRole The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * VPC in which this Compute Environment will launch Instances.
         * <p>
         * @return {@code this}
         * @param vpc VPC in which this Compute Environment will launch Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The maximum vCpus this <code>ManagedComputeEnvironment</code> can scale up to. Each vCPU is equivalent to 1024 CPU shares.
         * <p>
         * <em>Note</em>: if this Compute Environment uses EC2 resources (not Fargate) with either <code>AllocationStrategy.BEST_FIT_PROGRESSIVE</code> or
         * <code>AllocationStrategy.SPOT_CAPACITY_OPTIMIZED</code>, or <code>AllocationStrategy.BEST_FIT</code> with Spot instances,
         * The scheduler may exceed this number by at most one of the instances specified in <code>instanceTypes</code>
         * or <code>instanceClasses</code>.
         * <p>
         * Default: 256
         * <p>
         * @return {@code this}
         * @param maxvCpus The maximum vCpus this <code>ManagedComputeEnvironment</code> can scale up to. Each vCPU is equivalent to 1024 CPU shares. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxvCpus(final java.lang.Number maxvCpus) {
            this.props.maxvCpus(maxvCpus);
            return this;
        }

        /**
         * Specifies whether this Compute Environment is replaced if an update is made that requires replacing its instances.
         * <p>
         * To enable more properties to be updated,
         * set this property to <code>false</code>. When changing the value of this property to false,
         * do not change any other properties at the same time.
         * If other properties are changed at the same time,
         * and the change needs to be rolled back but it can't,
         * it's possible for the stack to go into the UPDATE_ROLLBACK_FAILED state.
         * You can't update a stack that is in the UPDATE_ROLLBACK_FAILED state.
         * However, if you can continue to roll it back,
         * you can return the stack to its original settings and then try to update it again.
         * <p>
         * The properties which require a replacement of the Compute Environment are:
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html</a>
         * @param replaceComputeEnvironment Specifies whether this Compute Environment is replaced if an update is made that requires replacing its instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceComputeEnvironment(final java.lang.Boolean replaceComputeEnvironment) {
            this.props.replaceComputeEnvironment(replaceComputeEnvironment);
            return this;
        }

        /**
         * The security groups this Compute Environment will launch instances in.
         * <p>
         * Default: new security groups will be created
         * <p>
         * @return {@code this}
         * @param securityGroups The security groups this Compute Environment will launch instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Whether or not to use spot instances.
         * <p>
         * Spot instances are less expensive EC2 instances that can be
         * reclaimed by EC2 at any time; your job will be given two minutes
         * of notice before reclamation.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param spot Whether or not to use spot instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spot(final java.lang.Boolean spot) {
            this.props.spot(spot);
            return this;
        }

        /**
         * Whether or not any running jobs will be immediately terminated when an infrastructure update occurs.
         * <p>
         * If this is enabled, any terminated jobs may be retried, depending on the job's
         * retry policy.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html</a>
         * @param terminateOnUpdate Whether or not any running jobs will be immediately terminated when an infrastructure update occurs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateOnUpdate(final java.lang.Boolean terminateOnUpdate) {
            this.props.terminateOnUpdate(terminateOnUpdate);
            return this;
        }

        /**
         * Only meaningful if <code>terminateOnUpdate</code> is <code>false</code>.
         * <p>
         * If so,
         * when an infrastructure update is triggered, any running jobs
         * will be allowed to run until <code>updateTimeout</code> has expired.
         * <p>
         * Default: 30 minutes
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html</a>
         * @param updateTimeout Only meaningful if <code>terminateOnUpdate</code> is <code>false</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateTimeout(final software.amazon.awscdk.Duration updateTimeout) {
            this.props.updateTimeout(updateTimeout);
            return this;
        }

        /**
         * Whether or not the AMI is updated to the latest one supported by Batch when an infrastructure update occurs.
         * <p>
         * If you specify a specific AMI, this property will be ignored.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param updateToLatestImageVersion Whether or not the AMI is updated to the latest one supported by Batch when an infrastructure update occurs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateToLatestImageVersion(final java.lang.Boolean updateToLatestImageVersion) {
            this.props.updateToLatestImageVersion(updateToLatestImageVersion);
            return this;
        }

        /**
         * The VPC Subnets this Compute Environment will launch instances in.
         * <p>
         * Default: new subnets will be created
         * <p>
         * @return {@code this}
         * @param vpcSubnets The VPC Subnets this Compute Environment will launch instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * The allocation strategy to use if not enough instances of the best fitting instance type can be allocated.
         * <p>
         * Default: - `BEST_FIT_PROGRESSIVE` if not using Spot instances,
         * `SPOT_CAPACITY_OPTIMIZED` if using Spot instances.
         * <p>
         * @return {@code this}
         * @param allocationStrategy The allocation strategy to use if not enough instances of the best fitting instance type can be allocated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationStrategy(final software.amazon.awscdk.services.batch.AllocationStrategy allocationStrategy) {
            this.props.allocationStrategy(allocationStrategy);
            return this;
        }

        /**
         * Configure which AMIs this Compute Environment can launch.
         * <p>
         * If you specify this property with only <code>image</code> specified, then the
         * <code>imageType</code> will default to <code>ECS_AL2</code>. <em>If your image needs GPU resources,
         * specify <code>ECS_AL2_NVIDIA</code>; otherwise, the instances will not be able to properly
         * join the ComputeEnvironment</em>.
         * <p>
         * Default: - ECS_AL2 for non-GPU instances, ECS_AL2_NVIDIA for GPU instances
         * <p>
         * @return {@code this}
         * @param images Configure which AMIs this Compute Environment can launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder images(final java.util.List<? extends software.amazon.awscdk.services.batch.EcsMachineImage> images) {
            this.props.images(images);
            return this;
        }

        /**
         * The instance classes that this Compute Environment can launch.
         * <p>
         * Which one is chosen depends on the <code>AllocationStrategy</code> used.
         * Batch will automatically choose the instance size.
         * <p>
         * Default: - the instances Batch considers will be used (currently C4, M4, and R4)
         * <p>
         * @return {@code this}
         * @param instanceClasses The instance classes that this Compute Environment can launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceClasses(final java.util.List<? extends software.amazon.awscdk.services.ec2.InstanceClass> instanceClasses) {
            this.props.instanceClasses(instanceClasses);
            return this;
        }

        /**
         * The execution Role that instances launched by this Compute Environment will use.
         * <p>
         * Default: - a role will be created
         * <p>
         * @return {@code this}
         * @param instanceRole The execution Role that instances launched by this Compute Environment will use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRole(final software.amazon.awscdk.services.iam.IRole instanceRole) {
            this.props.instanceRole(instanceRole);
            return this;
        }

        /**
         * The instance types that this Compute Environment can launch.
         * <p>
         * Which one is chosen depends on the <code>AllocationStrategy</code> used.
         * <p>
         * Default: - the instances Batch considers will be used (currently C4, M4, and R4)
         * <p>
         * @return {@code this}
         * @param instanceTypes The instance types that this Compute Environment can launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypes(final java.util.List<? extends software.amazon.awscdk.services.ec2.InstanceType> instanceTypes) {
            this.props.instanceTypes(instanceTypes);
            return this;
        }

        /**
         * The Launch Template that this Compute Environment will use to provision EC2 Instances.
         * <p>
         * <em>Note</em>: if <code>securityGroups</code> is specified on both your
         * launch template and this Compute Environment, **the
         * <code>securityGroup</code>s on the Compute Environment override the
         * ones on the launch template.
         * <p>
         * Default: no launch template
         * <p>
         * @return {@code this}
         * @param launchTemplate The Launch Template that this Compute Environment will use to provision EC2 Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(final software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate) {
            this.props.launchTemplate(launchTemplate);
            return this;
        }

        /**
         * The minimum vCPUs that an environment should maintain, even if the compute environment is DISABLED.
         * <p>
         * Default: 0
         * <p>
         * @return {@code this}
         * @param minvCpus The minimum vCPUs that an environment should maintain, even if the compute environment is DISABLED. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minvCpus(final java.lang.Number minvCpus) {
            this.props.minvCpus(minvCpus);
            return this;
        }

        /**
         * The EC2 placement group to associate with your compute resources.
         * <p>
         * If you intend to submit multi-node parallel jobs to this Compute Environment,
         * you should consider creating a cluster placement group and associate it with your compute resources.
         * This keeps your multi-node parallel job on a logical grouping of instances
         * within a single Availability Zone with high network flow potential.
         * <p>
         * Default: - no placement group
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html</a>
         * @param placementGroup The EC2 placement group to associate with your compute resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroup(final software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup) {
            this.props.placementGroup(placementGroup);
            return this;
        }

        /**
         * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched.
         * <p>
         * For example, if your maximum percentage is 20%, the Spot price must be
         * less than 20% of the current On-Demand price for that Instance.
         * You always pay the lowest market price and never more than your maximum percentage.
         * For most use cases, Batch recommends leaving this field empty.
         * <p>
         * Implies <code>spot == true</code> if set
         * <p>
         * Default: 100%
         * <p>
         * @return {@code this}
         * @param spotBidPercentage The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotBidPercentage(final java.lang.Number spotBidPercentage) {
            this.props.spotBidPercentage(spotBidPercentage);
            return this;
        }

        /**
         * The service-linked role that Spot Fleet needs to launch instances on your behalf.
         * <p>
         * Default: - a new role will be created
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html</a>
         * @param spotFleetRole The service-linked role that Spot Fleet needs to launch instances on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotFleetRole(final software.amazon.awscdk.services.iam.IRole spotFleetRole) {
            this.props.spotFleetRole(spotFleetRole);
            return this;
        }

        /**
         * Whether or not to use batch's optimal instance type.
         * <p>
         * The optimal instance type is equivalent to adding the
         * C4, M4, and R4 instance classes. You can specify other instance classes
         * (of the same architecture) in addition to the optimal instance classes.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param useOptimalInstanceClasses Whether or not to use batch's optimal instance type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useOptimalInstanceClasses(final java.lang.Boolean useOptimalInstanceClasses) {
            this.props.useOptimalInstanceClasses(useOptimalInstanceClasses);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.ManagedEc2EcsComputeEnvironment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.ManagedEc2EcsComputeEnvironment build() {
            return new software.amazon.awscdk.services.batch.ManagedEc2EcsComputeEnvironment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
