package software.amazon.awscdk.services.batch;

/**
 * Sets limits for a resource with <code>ulimit</code> on linux systems.
 * <p>
 * Used by the Docker daemon.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * Ulimit ulimit = Ulimit.builder()
 *         .hardLimit(123)
 *         .name(UlimitName.CORE)
 *         .softLimit(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.107Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.Ulimit")
@software.amazon.jsii.Jsii.Proxy(Ulimit.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Ulimit extends software.amazon.jsii.JsiiSerializable {

    /**
     * The hard limit for this resource.
     * <p>
     * The container will
     * be terminated if it exceeds this limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getHardLimit();

    /**
     * The resource to limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.UlimitName getName();

    /**
     * The reservation for this resource.
     * <p>
     * The container will
     * not be terminated if it exceeds this limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getSoftLimit();

    /**
     * @return a {@link Builder} of {@link Ulimit}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Ulimit}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Ulimit> {
        java.lang.Number hardLimit;
        software.amazon.awscdk.services.batch.UlimitName name;
        java.lang.Number softLimit;

        /**
         * Sets the value of {@link Ulimit#getHardLimit}
         * @param hardLimit The hard limit for this resource. This parameter is required.
         *                  The container will
         *                  be terminated if it exceeds this limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hardLimit(java.lang.Number hardLimit) {
            this.hardLimit = hardLimit;
            return this;
        }

        /**
         * Sets the value of {@link Ulimit#getName}
         * @param name The resource to limit. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(software.amazon.awscdk.services.batch.UlimitName name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link Ulimit#getSoftLimit}
         * @param softLimit The reservation for this resource. This parameter is required.
         *                  The container will
         *                  not be terminated if it exceeds this limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder softLimit(java.lang.Number softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Ulimit}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Ulimit build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Ulimit}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ulimit {
        private final java.lang.Number hardLimit;
        private final software.amazon.awscdk.services.batch.UlimitName name;
        private final java.lang.Number softLimit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hardLimit = software.amazon.jsii.Kernel.get(this, "hardLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.UlimitName.class));
            this.softLimit = software.amazon.jsii.Kernel.get(this, "softLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hardLimit = java.util.Objects.requireNonNull(builder.hardLimit, "hardLimit is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.softLimit = java.util.Objects.requireNonNull(builder.softLimit, "softLimit is required");
        }

        @Override
        public final java.lang.Number getHardLimit() {
            return this.hardLimit;
        }

        @Override
        public final software.amazon.awscdk.services.batch.UlimitName getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getSoftLimit() {
            return this.softLimit;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hardLimit", om.valueToTree(this.getHardLimit()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("softLimit", om.valueToTree(this.getSoftLimit()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.Ulimit"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Ulimit.Jsii$Proxy that = (Ulimit.Jsii$Proxy) o;

            if (!hardLimit.equals(that.hardLimit)) return false;
            if (!name.equals(that.name)) return false;
            return this.softLimit.equals(that.softLimit);
        }

        @Override
        public final int hashCode() {
            int result = this.hardLimit.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.softLimit.hashCode());
            return result;
        }
    }
}
