package software.amazon.awscdk.services.bedrock;

/**
 * Specifies a data source as a resource in a top-level template. Minimally, you must specify the following properties:.
 * <p>
 * <ul>
 * <li>Name – Specify a name for the data source.</li>
 * <li>KnowledgeBaseId – Specify the ID of the knowledge base for the data source to belong to.</li>
 * <li>DataSourceConfiguration – Specify information about the Amazon S3 bucket containing the data source. The following sub-properties are required:</li>
 * <li>Type – Specify the value <code>S3</code> .</li>
 * </ul>
 * <p>
 * For more information about setting up data sources in Amazon Bedrock , see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html">Set up a data source for your knowledge base</a> .
 * <p>
 * See the <em>Properties</em> section below for descriptions of both the required and optional properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnDataSource cfnDataSource = CfnDataSource.Builder.create(this, "MyCfnDataSource")
 *         .dataSourceConfiguration(DataSourceConfigurationProperty.builder()
 *                 .s3Configuration(S3DataSourceConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         // the properties below are optional
 *                         .bucketOwnerAccountId("bucketOwnerAccountId")
 *                         .inclusionPrefixes(List.of("inclusionPrefixes"))
 *                         .build())
 *                 .type("type")
 *                 .build())
 *         .knowledgeBaseId("knowledgeBaseId")
 *         .name("name")
 *         // the properties below are optional
 *         .dataDeletionPolicy("dataDeletionPolicy")
 *         .description("description")
 *         .serverSideEncryptionConfiguration(ServerSideEncryptionConfigurationProperty.builder()
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .vectorIngestionConfiguration(VectorIngestionConfigurationProperty.builder()
 *                 .chunkingConfiguration(ChunkingConfigurationProperty.builder()
 *                         .chunkingStrategy("chunkingStrategy")
 *                         // the properties below are optional
 *                         .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
 *                                 .maxTokens(123)
 *                                 .overlapPercentage(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.141Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource")
public class CfnDataSource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnDataSource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time at which the data source was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataSourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrDataSourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the data source. The following statuses are possible:.
     * <p>
     * <ul>
     * <li>Available – The data source has been created and is ready for ingestion into the knowledge base.</li>
     * <li>Deleting – The data source is being deleted.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataSourceStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrDataSourceStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The detailed reasons on the failure to delete a data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrFailureReasons() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrFailureReasons", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The time at which the data source was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The connection configuration for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDataSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "dataSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The connection configuration for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSourceConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSourceConfiguration", java.util.Objects.requireNonNull(value, "dataSourceConfiguration is required"));
    }

    /**
     * The connection configuration for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSourceConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnDataSource.DataSourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSourceConfiguration", java.util.Objects.requireNonNull(value, "dataSourceConfiguration is required"));
    }

    /**
     * The unique identifier of the knowledge base to which the data source belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseId() {
        return software.amazon.jsii.Kernel.get(this, "knowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the knowledge base to which the data source belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBaseId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "knowledgeBaseId", java.util.Objects.requireNonNull(value, "knowledgeBaseId is required"));
    }

    /**
     * The name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The data deletion policy for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataDeletionPolicy() {
        return software.amazon.jsii.Kernel.get(this, "dataDeletionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The data deletion policy for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataDeletionPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataDeletionPolicy", value);
    }

    /**
     * The description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Contains details about the configuration of the server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "serverSideEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about the configuration of the server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serverSideEncryptionConfiguration", value);
    }

    /**
     * Contains details about the configuration of the server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "serverSideEncryptionConfiguration", value);
    }

    /**
     * Contains details about how to ingest the documents in the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVectorIngestionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "vectorIngestionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about how to ingest the documents in the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorIngestionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vectorIngestionConfiguration", value);
    }

    /**
     * Contains details about how to ingest the documents in the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorIngestionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnDataSource.VectorIngestionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "vectorIngestionConfiguration", value);
    }
    /**
     * Details about how to chunk the documents in the data source.
     * <p>
     * A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ChunkingConfigurationProperty chunkingConfigurationProperty = ChunkingConfigurationProperty.builder()
     *         .chunkingStrategy("chunkingStrategy")
     *         // the properties below are optional
     *         .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
     *                 .maxTokens(123)
     *                 .overlapPercentage(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.ChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ChunkingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChunkingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Knowledge base can split your source data into chunks.
         * <p>
         * A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for <code>NONE</code> , then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.
         * <p>
         * <ul>
         * <li><code>FIXED_SIZE</code> – Amazon Bedrock splits your source data into chunks of the approximate size that you set in the <code>fixedSizeChunkingConfiguration</code> .</li>
         * <li><code>HIERARCHICAL</code> – Split documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.</li>
         * <li><code>SEMANTIC</code> – Split documents into chunks based on groups of similar content derived with natural language processing.</li>
         * <li><code>NONE</code> – Amazon Bedrock treats each file as one chunk. If you choose this option, you may want to pre-process your documents by splitting them into separate files.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-chunkingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-chunkingstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChunkingStrategy();

        /**
         * Configurations for when you choose fixed-size chunking.
         * <p>
         * If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-fixedsizechunkingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-chunkingconfiguration.html#cfn-bedrock-datasource-chunkingconfiguration-fixedsizechunkingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFixedSizeChunkingConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChunkingConfigurationProperty> {
            java.lang.String chunkingStrategy;
            java.lang.Object fixedSizeChunkingConfiguration;

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getChunkingStrategy}
             * @param chunkingStrategy Knowledge base can split your source data into chunks. This parameter is required.
             *                         A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for <code>NONE</code> , then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.
             *                         <p>
             *                         <ul>
             *                         <li><code>FIXED_SIZE</code> – Amazon Bedrock splits your source data into chunks of the approximate size that you set in the <code>fixedSizeChunkingConfiguration</code> .</li>
             *                         <li><code>HIERARCHICAL</code> – Split documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.</li>
             *                         <li><code>SEMANTIC</code> – Split documents into chunks based on groups of similar content derived with natural language processing.</li>
             *                         <li><code>NONE</code> – Amazon Bedrock treats each file as one chunk. If you choose this option, you may want to pre-process your documents by splitting them into separate files.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chunkingStrategy(java.lang.String chunkingStrategy) {
                this.chunkingStrategy = chunkingStrategy;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getFixedSizeChunkingConfiguration}
             * @param fixedSizeChunkingConfiguration Configurations for when you choose fixed-size chunking.
             *                                       If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedSizeChunkingConfiguration(software.amazon.awscdk.IResolvable fixedSizeChunkingConfiguration) {
                this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getFixedSizeChunkingConfiguration}
             * @param fixedSizeChunkingConfiguration Configurations for when you choose fixed-size chunking.
             *                                       If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedSizeChunkingConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.FixedSizeChunkingConfigurationProperty fixedSizeChunkingConfiguration) {
                this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChunkingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChunkingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChunkingConfigurationProperty {
            private final java.lang.String chunkingStrategy;
            private final java.lang.Object fixedSizeChunkingConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.chunkingStrategy = software.amazon.jsii.Kernel.get(this, "chunkingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fixedSizeChunkingConfiguration = software.amazon.jsii.Kernel.get(this, "fixedSizeChunkingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.chunkingStrategy = java.util.Objects.requireNonNull(builder.chunkingStrategy, "chunkingStrategy is required");
                this.fixedSizeChunkingConfiguration = builder.fixedSizeChunkingConfiguration;
            }

            @Override
            public final java.lang.String getChunkingStrategy() {
                return this.chunkingStrategy;
            }

            @Override
            public final java.lang.Object getFixedSizeChunkingConfiguration() {
                return this.fixedSizeChunkingConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("chunkingStrategy", om.valueToTree(this.getChunkingStrategy()));
                if (this.getFixedSizeChunkingConfiguration() != null) {
                    data.set("fixedSizeChunkingConfiguration", om.valueToTree(this.getFixedSizeChunkingConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.ChunkingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChunkingConfigurationProperty.Jsii$Proxy that = (ChunkingConfigurationProperty.Jsii$Proxy) o;

                if (!chunkingStrategy.equals(that.chunkingStrategy)) return false;
                return this.fixedSizeChunkingConfiguration != null ? this.fixedSizeChunkingConfiguration.equals(that.fixedSizeChunkingConfiguration) : that.fixedSizeChunkingConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.chunkingStrategy.hashCode();
                result = 31 * result + (this.fixedSizeChunkingConfiguration != null ? this.fixedSizeChunkingConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connection configuration for the data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DataSourceConfigurationProperty dataSourceConfigurationProperty = DataSourceConfigurationProperty.builder()
     *         .s3Configuration(S3DataSourceConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 // the properties below are optional
     *                 .bucketOwnerAccountId("bucketOwnerAccountId")
     *                 .inclusionPrefixes(List.of("inclusionPrefixes"))
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration information to connect to Amazon S3 as your data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * The type of data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-datasourceconfiguration.html#cfn-bedrock-datasource-datasourceconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceConfigurationProperty> {
            java.lang.Object s3Configuration;
            java.lang.String type;

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getS3Configuration}
             * @param s3Configuration The configuration information to connect to Amazon S3 as your data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getS3Configuration}
             * @param s3Configuration The configuration information to connect to Amazon S3 as your data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.bedrock.CfnDataSource.S3DataSourceConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getType}
             * @param type The type of data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceConfigurationProperty {
            private final java.lang.Object s3Configuration;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.DataSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceConfigurationProperty.Jsii$Proxy that = (DataSourceConfigurationProperty.Jsii$Proxy) o;

                if (!s3Configuration.equals(that.s3Configuration)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Configuration.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Configurations for when you choose fixed-size chunking.
     * <p>
     * If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FixedSizeChunkingConfigurationProperty fixedSizeChunkingConfigurationProperty = FixedSizeChunkingConfigurationProperty.builder()
     *         .maxTokens(123)
     *         .overlapPercentage(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.FixedSizeChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FixedSizeChunkingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FixedSizeChunkingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of tokens to include in a chunk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html#cfn-bedrock-datasource-fixedsizechunkingconfiguration-maxtokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html#cfn-bedrock-datasource-fixedsizechunkingconfiguration-maxtokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxTokens();

        /**
         * The percentage of overlap between adjacent chunks of a data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html#cfn-bedrock-datasource-fixedsizechunkingconfiguration-overlappercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-fixedsizechunkingconfiguration.html#cfn-bedrock-datasource-fixedsizechunkingconfiguration-overlappercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getOverlapPercentage();

        /**
         * @return a {@link Builder} of {@link FixedSizeChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FixedSizeChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FixedSizeChunkingConfigurationProperty> {
            java.lang.Number maxTokens;
            java.lang.Number overlapPercentage;

            /**
             * Sets the value of {@link FixedSizeChunkingConfigurationProperty#getMaxTokens}
             * @param maxTokens The maximum number of tokens to include in a chunk. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTokens(java.lang.Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            /**
             * Sets the value of {@link FixedSizeChunkingConfigurationProperty#getOverlapPercentage}
             * @param overlapPercentage The percentage of overlap between adjacent chunks of a data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overlapPercentage(java.lang.Number overlapPercentage) {
                this.overlapPercentage = overlapPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FixedSizeChunkingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FixedSizeChunkingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FixedSizeChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FixedSizeChunkingConfigurationProperty {
            private final java.lang.Number maxTokens;
            private final java.lang.Number overlapPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxTokens = software.amazon.jsii.Kernel.get(this, "maxTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.overlapPercentage = software.amazon.jsii.Kernel.get(this, "overlapPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxTokens = java.util.Objects.requireNonNull(builder.maxTokens, "maxTokens is required");
                this.overlapPercentage = java.util.Objects.requireNonNull(builder.overlapPercentage, "overlapPercentage is required");
            }

            @Override
            public final java.lang.Number getMaxTokens() {
                return this.maxTokens;
            }

            @Override
            public final java.lang.Number getOverlapPercentage() {
                return this.overlapPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxTokens", om.valueToTree(this.getMaxTokens()));
                data.set("overlapPercentage", om.valueToTree(this.getOverlapPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.FixedSizeChunkingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FixedSizeChunkingConfigurationProperty.Jsii$Proxy that = (FixedSizeChunkingConfigurationProperty.Jsii$Proxy) o;

                if (!maxTokens.equals(that.maxTokens)) return false;
                return this.overlapPercentage.equals(that.overlapPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.maxTokens.hashCode();
                result = 31 * result + (this.overlapPercentage.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration information to connect to Amazon S3 as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * S3DataSourceConfigurationProperty s3DataSourceConfigurationProperty = S3DataSourceConfigurationProperty.builder()
     *         .bucketArn("bucketArn")
     *         // the properties below are optional
     *         .bucketOwnerAccountId("bucketOwnerAccountId")
     *         .inclusionPrefixes(List.of("inclusionPrefixes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.S3DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DataSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DataSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the S3 bucket that contains your data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-bucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-bucketarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * The account ID for the owner of the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-bucketowneraccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-bucketowneraccountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketOwnerAccountId() {
            return null;
        }

        /**
         * A list of S3 prefixes to include certain files or content.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-inclusionprefixes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-s3datasourceconfiguration.html#cfn-bedrock-datasource-s3datasourceconfiguration-inclusionprefixes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionPrefixes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DataSourceConfigurationProperty> {
            java.lang.String bucketArn;
            java.lang.String bucketOwnerAccountId;
            java.util.List<java.lang.String> inclusionPrefixes;

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getBucketArn}
             * @param bucketArn The Amazon Resource Name (ARN) of the S3 bucket that contains your data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getBucketOwnerAccountId}
             * @param bucketOwnerAccountId The account ID for the owner of the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketOwnerAccountId(java.lang.String bucketOwnerAccountId) {
                this.bucketOwnerAccountId = bucketOwnerAccountId;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getInclusionPrefixes}
             * @param inclusionPrefixes A list of S3 prefixes to include certain files or content.
             *                          For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionPrefixes(java.util.List<java.lang.String> inclusionPrefixes) {
                this.inclusionPrefixes = inclusionPrefixes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DataSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DataSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DataSourceConfigurationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String bucketOwnerAccountId;
            private final java.util.List<java.lang.String> inclusionPrefixes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketOwnerAccountId = software.amazon.jsii.Kernel.get(this, "bucketOwnerAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inclusionPrefixes = software.amazon.jsii.Kernel.get(this, "inclusionPrefixes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.bucketOwnerAccountId = builder.bucketOwnerAccountId;
                this.inclusionPrefixes = builder.inclusionPrefixes;
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getBucketOwnerAccountId() {
                return this.bucketOwnerAccountId;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionPrefixes() {
                return this.inclusionPrefixes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                if (this.getBucketOwnerAccountId() != null) {
                    data.set("bucketOwnerAccountId", om.valueToTree(this.getBucketOwnerAccountId()));
                }
                if (this.getInclusionPrefixes() != null) {
                    data.set("inclusionPrefixes", om.valueToTree(this.getInclusionPrefixes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.S3DataSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DataSourceConfigurationProperty.Jsii$Proxy that = (S3DataSourceConfigurationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (this.bucketOwnerAccountId != null ? !this.bucketOwnerAccountId.equals(that.bucketOwnerAccountId) : that.bucketOwnerAccountId != null) return false;
                return this.inclusionPrefixes != null ? this.inclusionPrefixes.equals(that.inclusionPrefixes) : that.inclusionPrefixes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.bucketOwnerAccountId != null ? this.bucketOwnerAccountId.hashCode() : 0);
                result = 31 * result + (this.inclusionPrefixes != null ? this.inclusionPrefixes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the configuration for server-side encryption.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ServerSideEncryptionConfigurationProperty serverSideEncryptionConfigurationProperty = ServerSideEncryptionConfigurationProperty.builder()
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-serversideencryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-serversideencryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS key used to encrypt the resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-serversideencryptionconfiguration.html#cfn-bedrock-datasource-serversideencryptionconfiguration-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-serversideencryptionconfiguration.html#cfn-bedrock-datasource-serversideencryptionconfiguration-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionConfigurationProperty> {
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link ServerSideEncryptionConfigurationProperty#getKmsKeyArn}
             * @param kmsKeyArn The Amazon Resource Name (ARN) of the AWS KMS key used to encrypt the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionConfigurationProperty {
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionConfigurationProperty.Jsii$Proxy that = (ServerSideEncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains details about how to ingest the documents in a data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * VectorIngestionConfigurationProperty vectorIngestionConfigurationProperty = VectorIngestionConfigurationProperty.builder()
     *         .chunkingConfiguration(ChunkingConfigurationProperty.builder()
     *                 .chunkingStrategy("chunkingStrategy")
     *                 // the properties below are optional
     *                 .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
     *                         .maxTokens(123)
     *                         .overlapPercentage(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSource.VectorIngestionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VectorIngestionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VectorIngestionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details about how to chunk the documents in the data source.
         * <p>
         * A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html#cfn-bedrock-datasource-vectoringestionconfiguration-chunkingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-datasource-vectoringestionconfiguration.html#cfn-bedrock-datasource-vectoringestionconfiguration-chunkingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChunkingConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VectorIngestionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VectorIngestionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VectorIngestionConfigurationProperty> {
            java.lang.Object chunkingConfiguration;

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getChunkingConfiguration}
             * @param chunkingConfiguration Details about how to chunk the documents in the data source.
             *                              A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chunkingConfiguration(software.amazon.awscdk.IResolvable chunkingConfiguration) {
                this.chunkingConfiguration = chunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getChunkingConfiguration}
             * @param chunkingConfiguration Details about how to chunk the documents in the data source.
             *                              A <em>chunk</em> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chunkingConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.ChunkingConfigurationProperty chunkingConfiguration) {
                this.chunkingConfiguration = chunkingConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VectorIngestionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VectorIngestionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VectorIngestionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VectorIngestionConfigurationProperty {
            private final java.lang.Object chunkingConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.chunkingConfiguration = software.amazon.jsii.Kernel.get(this, "chunkingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.chunkingConfiguration = builder.chunkingConfiguration;
            }

            @Override
            public final java.lang.Object getChunkingConfiguration() {
                return this.chunkingConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChunkingConfiguration() != null) {
                    data.set("chunkingConfiguration", om.valueToTree(this.getChunkingConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSource.VectorIngestionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VectorIngestionConfigurationProperty.Jsii$Proxy that = (VectorIngestionConfigurationProperty.Jsii$Proxy) o;

                return this.chunkingConfiguration != null ? this.chunkingConfiguration.equals(that.chunkingConfiguration) : that.chunkingConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.chunkingConfiguration != null ? this.chunkingConfiguration.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnDataSourceProps.Builder();
        }

        /**
         * The connection configuration for the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datasourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datasourceconfiguration</a>
         * @param dataSourceConfiguration The connection configuration for the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(final software.amazon.awscdk.IResolvable dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }
        /**
         * The connection configuration for the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datasourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datasourceconfiguration</a>
         * @param dataSourceConfiguration The connection configuration for the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(final software.amazon.awscdk.services.bedrock.CfnDataSource.DataSourceConfigurationProperty dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        /**
         * The unique identifier of the knowledge base to which the data source belongs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-knowledgebaseid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-knowledgebaseid</a>
         * @param knowledgeBaseId The unique identifier of the knowledge base to which the data source belongs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseId(final java.lang.String knowledgeBaseId) {
            this.props.knowledgeBaseId(knowledgeBaseId);
            return this;
        }

        /**
         * The name of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-name</a>
         * @param name The name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The data deletion policy for the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datadeletionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datadeletionpolicy</a>
         * @param dataDeletionPolicy The data deletion policy for the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDeletionPolicy(final java.lang.String dataDeletionPolicy) {
            this.props.dataDeletionPolicy(dataDeletionPolicy);
            return this;
        }

        /**
         * The description of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-description</a>
         * @param description The description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Contains details about the configuration of the server-side encryption.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-serversideencryptionconfiguration</a>
         * @param serverSideEncryptionConfiguration Contains details about the configuration of the server-side encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(final software.amazon.awscdk.IResolvable serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }
        /**
         * Contains details about the configuration of the server-side encryption.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-serversideencryptionconfiguration</a>
         * @param serverSideEncryptionConfiguration Contains details about the configuration of the server-side encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(final software.amazon.awscdk.services.bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }

        /**
         * Contains details about how to ingest the documents in the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-vectoringestionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-vectoringestionconfiguration</a>
         * @param vectorIngestionConfiguration Contains details about how to ingest the documents in the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorIngestionConfiguration(final software.amazon.awscdk.IResolvable vectorIngestionConfiguration) {
            this.props.vectorIngestionConfiguration(vectorIngestionConfiguration);
            return this;
        }
        /**
         * Contains details about how to ingest the documents in the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-vectoringestionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-vectoringestionconfiguration</a>
         * @param vectorIngestionConfiguration Contains details about how to ingest the documents in the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorIngestionConfiguration(final software.amazon.awscdk.services.bedrock.CfnDataSource.VectorIngestionConfigurationProperty vectorIngestionConfiguration) {
            this.props.vectorIngestionConfiguration(vectorIngestionConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnDataSource build() {
            return new software.amazon.awscdk.services.bedrock.CfnDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
