package software.amazon.awscdk.services.bedrock;

/**
 * Properties for defining a <code>CfnGuardrail</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnGuardrailProps cfnGuardrailProps = CfnGuardrailProps.builder()
 *         .blockedInputMessaging("blockedInputMessaging")
 *         .blockedOutputsMessaging("blockedOutputsMessaging")
 *         .name("name")
 *         // the properties below are optional
 *         .contentPolicyConfig(ContentPolicyConfigProperty.builder()
 *                 .filtersConfig(List.of(ContentFilterConfigProperty.builder()
 *                         .inputStrength("inputStrength")
 *                         .outputStrength("outputStrength")
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .description("description")
 *         .kmsKeyArn("kmsKeyArn")
 *         .sensitiveInformationPolicyConfig(SensitiveInformationPolicyConfigProperty.builder()
 *                 .piiEntitiesConfig(List.of(PiiEntityConfigProperty.builder()
 *                         .action("action")
 *                         .type("type")
 *                         .build()))
 *                 .regexesConfig(List.of(RegexConfigProperty.builder()
 *                         .action("action")
 *                         .name("name")
 *                         .pattern("pattern")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .topicPolicyConfig(TopicPolicyConfigProperty.builder()
 *                 .topicsConfig(List.of(TopicConfigProperty.builder()
 *                         .definition("definition")
 *                         .name("name")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .examples(List.of("examples"))
 *                         .build()))
 *                 .build())
 *         .wordPolicyConfig(WordPolicyConfigProperty.builder()
 *                 .managedWordListsConfig(List.of(ManagedWordsConfigProperty.builder()
 *                         .type("type")
 *                         .build()))
 *                 .wordsConfig(List.of(WordConfigProperty.builder()
 *                         .text("text")
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.153Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrailProps")
@software.amazon.jsii.Jsii.Proxy(CfnGuardrailProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGuardrailProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The message to return when the guardrail blocks a prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-blockedinputmessaging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-blockedinputmessaging</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBlockedInputMessaging();

    /**
     * The message to return when the guardrail blocks a model response.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-blockedoutputsmessaging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-blockedoutputsmessaging</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBlockedOutputsMessaging();

    /**
     * The name of the guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The content filter policies to configure for the guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-contentpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-contentpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContentPolicyConfig() {
        return null;
    }

    /**
     * A description of the guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The ARN of the AWS KMS key that you use to encrypt the guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-kmskeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * The sensitive information policy to configure for the guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-sensitiveinformationpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-sensitiveinformationpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSensitiveInformationPolicyConfig() {
        return null;
    }

    /**
     * The tags that you want to attach to the guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The topic policies to configure for the guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-topicpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-topicpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTopicPolicyConfig() {
        return null;
    }

    /**
     * The word policy you configure for the guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-wordpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-wordpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWordPolicyConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGuardrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGuardrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGuardrailProps> {
        java.lang.String blockedInputMessaging;
        java.lang.String blockedOutputsMessaging;
        java.lang.String name;
        java.lang.Object contentPolicyConfig;
        java.lang.String description;
        java.lang.String kmsKeyArn;
        java.lang.Object sensitiveInformationPolicyConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object topicPolicyConfig;
        java.lang.Object wordPolicyConfig;

        /**
         * Sets the value of {@link CfnGuardrailProps#getBlockedInputMessaging}
         * @param blockedInputMessaging The message to return when the guardrail blocks a prompt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockedInputMessaging(java.lang.String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getBlockedOutputsMessaging}
         * @param blockedOutputsMessaging The message to return when the guardrail blocks a model response. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockedOutputsMessaging(java.lang.String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getName}
         * @param name The name of the guardrail. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getContentPolicyConfig}
         * @param contentPolicyConfig The content filter policies to configure for the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentPolicyConfig(software.amazon.awscdk.IResolvable contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getContentPolicyConfig}
         * @param contentPolicyConfig The content filter policies to configure for the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentPolicyConfig(software.amazon.awscdk.services.bedrock.CfnGuardrail.ContentPolicyConfigProperty contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getDescription}
         * @param description A description of the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getKmsKeyArn}
         * @param kmsKeyArn The ARN of the AWS KMS key that you use to encrypt the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getSensitiveInformationPolicyConfig}
         * @param sensitiveInformationPolicyConfig The sensitive information policy to configure for the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sensitiveInformationPolicyConfig(software.amazon.awscdk.IResolvable sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getSensitiveInformationPolicyConfig}
         * @param sensitiveInformationPolicyConfig The sensitive information policy to configure for the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sensitiveInformationPolicyConfig(software.amazon.awscdk.services.bedrock.CfnGuardrail.SensitiveInformationPolicyConfigProperty sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getTags}
         * @param tags The tags that you want to attach to the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getTopicPolicyConfig}
         * @param topicPolicyConfig The topic policies to configure for the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicPolicyConfig(software.amazon.awscdk.IResolvable topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getTopicPolicyConfig}
         * @param topicPolicyConfig The topic policies to configure for the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicPolicyConfig(software.amazon.awscdk.services.bedrock.CfnGuardrail.TopicPolicyConfigProperty topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getWordPolicyConfig}
         * @param wordPolicyConfig The word policy you configure for the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wordPolicyConfig(software.amazon.awscdk.IResolvable wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardrailProps#getWordPolicyConfig}
         * @param wordPolicyConfig The word policy you configure for the guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wordPolicyConfig(software.amazon.awscdk.services.bedrock.CfnGuardrail.WordPolicyConfigProperty wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGuardrailProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGuardrailProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGuardrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGuardrailProps {
        private final java.lang.String blockedInputMessaging;
        private final java.lang.String blockedOutputsMessaging;
        private final java.lang.String name;
        private final java.lang.Object contentPolicyConfig;
        private final java.lang.String description;
        private final java.lang.String kmsKeyArn;
        private final java.lang.Object sensitiveInformationPolicyConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object topicPolicyConfig;
        private final java.lang.Object wordPolicyConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.blockedInputMessaging = software.amazon.jsii.Kernel.get(this, "blockedInputMessaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.blockedOutputsMessaging = software.amazon.jsii.Kernel.get(this, "blockedOutputsMessaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentPolicyConfig = software.amazon.jsii.Kernel.get(this, "contentPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sensitiveInformationPolicyConfig = software.amazon.jsii.Kernel.get(this, "sensitiveInformationPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.topicPolicyConfig = software.amazon.jsii.Kernel.get(this, "topicPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.wordPolicyConfig = software.amazon.jsii.Kernel.get(this, "wordPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.blockedInputMessaging = java.util.Objects.requireNonNull(builder.blockedInputMessaging, "blockedInputMessaging is required");
            this.blockedOutputsMessaging = java.util.Objects.requireNonNull(builder.blockedOutputsMessaging, "blockedOutputsMessaging is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.contentPolicyConfig = builder.contentPolicyConfig;
            this.description = builder.description;
            this.kmsKeyArn = builder.kmsKeyArn;
            this.sensitiveInformationPolicyConfig = builder.sensitiveInformationPolicyConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.topicPolicyConfig = builder.topicPolicyConfig;
            this.wordPolicyConfig = builder.wordPolicyConfig;
        }

        @Override
        public final java.lang.String getBlockedInputMessaging() {
            return this.blockedInputMessaging;
        }

        @Override
        public final java.lang.String getBlockedOutputsMessaging() {
            return this.blockedOutputsMessaging;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getContentPolicyConfig() {
            return this.contentPolicyConfig;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.lang.Object getSensitiveInformationPolicyConfig() {
            return this.sensitiveInformationPolicyConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTopicPolicyConfig() {
            return this.topicPolicyConfig;
        }

        @Override
        public final java.lang.Object getWordPolicyConfig() {
            return this.wordPolicyConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("blockedInputMessaging", om.valueToTree(this.getBlockedInputMessaging()));
            data.set("blockedOutputsMessaging", om.valueToTree(this.getBlockedOutputsMessaging()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getContentPolicyConfig() != null) {
                data.set("contentPolicyConfig", om.valueToTree(this.getContentPolicyConfig()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getSensitiveInformationPolicyConfig() != null) {
                data.set("sensitiveInformationPolicyConfig", om.valueToTree(this.getSensitiveInformationPolicyConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTopicPolicyConfig() != null) {
                data.set("topicPolicyConfig", om.valueToTree(this.getTopicPolicyConfig()));
            }
            if (this.getWordPolicyConfig() != null) {
                data.set("wordPolicyConfig", om.valueToTree(this.getWordPolicyConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrailProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGuardrailProps.Jsii$Proxy that = (CfnGuardrailProps.Jsii$Proxy) o;

            if (!blockedInputMessaging.equals(that.blockedInputMessaging)) return false;
            if (!blockedOutputsMessaging.equals(that.blockedOutputsMessaging)) return false;
            if (!name.equals(that.name)) return false;
            if (this.contentPolicyConfig != null ? !this.contentPolicyConfig.equals(that.contentPolicyConfig) : that.contentPolicyConfig != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            if (this.sensitiveInformationPolicyConfig != null ? !this.sensitiveInformationPolicyConfig.equals(that.sensitiveInformationPolicyConfig) : that.sensitiveInformationPolicyConfig != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.topicPolicyConfig != null ? !this.topicPolicyConfig.equals(that.topicPolicyConfig) : that.topicPolicyConfig != null) return false;
            return this.wordPolicyConfig != null ? this.wordPolicyConfig.equals(that.wordPolicyConfig) : that.wordPolicyConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.blockedInputMessaging.hashCode();
            result = 31 * result + (this.blockedOutputsMessaging.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.contentPolicyConfig != null ? this.contentPolicyConfig.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.sensitiveInformationPolicyConfig != null ? this.sensitiveInformationPolicyConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.topicPolicyConfig != null ? this.topicPolicyConfig.hashCode() : 0);
            result = 31 * result + (this.wordPolicyConfig != null ? this.wordPolicyConfig.hashCode() : 0);
            return result;
        }
    }
}
