package software.amazon.awscdk.services.cleanrooms;

/**
 * Creates a new configured table resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnConfiguredTable cfnConfiguredTable = CfnConfiguredTable.Builder.create(this, "MyCfnConfiguredTable")
 *         .allowedColumns(List.of("allowedColumns"))
 *         .analysisMethod("analysisMethod")
 *         .name("name")
 *         .tableReference(TableReferenceProperty.builder()
 *                 .glue(GlueTableReferenceProperty.builder()
 *                         .databaseName("databaseName")
 *                         .tableName("tableName")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .analysisRules(List.of(AnalysisRuleProperty.builder()
 *                 .policy(ConfiguredTableAnalysisRulePolicyProperty.builder()
 *                         .v1(ConfiguredTableAnalysisRulePolicyV1Property.builder()
 *                                 .aggregation(AnalysisRuleAggregationProperty.builder()
 *                                         .aggregateColumns(List.of(AggregateColumnProperty.builder()
 *                                                 .columnNames(List.of("columnNames"))
 *                                                 .function("function")
 *                                                 .build()))
 *                                         .dimensionColumns(List.of("dimensionColumns"))
 *                                         .joinColumns(List.of("joinColumns"))
 *                                         .outputConstraints(List.of(AggregationConstraintProperty.builder()
 *                                                 .columnName("columnName")
 *                                                 .minimum(123)
 *                                                 .type("type")
 *                                                 .build()))
 *                                         .scalarFunctions(List.of("scalarFunctions"))
 *                                         // the properties below are optional
 *                                         .allowedJoinOperators(List.of("allowedJoinOperators"))
 *                                         .joinRequired("joinRequired")
 *                                         .build())
 *                                 .custom(AnalysisRuleCustomProperty.builder()
 *                                         .allowedAnalyses(List.of("allowedAnalyses"))
 *                                         // the properties below are optional
 *                                         .allowedAnalysisProviders(List.of("allowedAnalysisProviders"))
 *                                         .differentialPrivacy(DifferentialPrivacyProperty.builder()
 *                                                 .columns(List.of(DifferentialPrivacyColumnProperty.builder()
 *                                                         .name("name")
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .list(AnalysisRuleListProperty.builder()
 *                                         .joinColumns(List.of("joinColumns"))
 *                                         .listColumns(List.of("listColumns"))
 *                                         // the properties below are optional
 *                                         .allowedJoinOperators(List.of("allowedJoinOperators"))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .type("type")
 *                 .build()))
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.289Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable")
public class CfnConfiguredTable extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnConfiguredTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfiguredTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfiguredTable(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the specified configured table.
     * <p>
     * Example: <code>arn:aws:cleanrooms:us-east-1:111122223333:configuredtable/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the unique identifier of the specified configured table.
     * <p>
     * Example: <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE33333</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfiguredTableIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrConfiguredTableIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The columns within the underlying AWS Glue table that can be utilized within collaborations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowedColumns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "allowedColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The columns within the underlying AWS Glue table that can be utilized within collaborations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedColumns(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "allowedColumns", java.util.Objects.requireNonNull(value, "allowedColumns is required"));
    }

    /**
     * The analysis method for the configured table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAnalysisMethod() {
        return software.amazon.jsii.Kernel.get(this, "analysisMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The analysis method for the configured table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalysisMethod(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "analysisMethod", java.util.Objects.requireNonNull(value, "analysisMethod is required"));
    }

    /**
     * A name for the configured table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the configured table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The AWS Glue table that this configured table represents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTableReference() {
        return software.amazon.jsii.Kernel.get(this, "tableReference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The AWS Glue table that this configured table represents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableReference(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tableReference", java.util.Objects.requireNonNull(value, "tableReference is required"));
    }

    /**
     * The AWS Glue table that this configured table represents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableReference(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.TableReferenceProperty value) {
        software.amazon.jsii.Kernel.set(this, "tableReference", java.util.Objects.requireNonNull(value, "tableReference is required"));
    }

    /**
     * The entire created analysis rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAnalysisRules() {
        return software.amazon.jsii.Kernel.get(this, "analysisRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The entire created analysis rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalysisRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "analysisRules", value);
    }

    /**
     * The entire created analysis rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalysisRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.AnalysisRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.AnalysisRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "analysisRules", value);
    }

    /**
     * A description for the configured table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the configured table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Column in configured table that can be used in aggregate function in query.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * AggregateColumnProperty aggregateColumnProperty = AggregateColumnProperty.builder()
     *         .columnNames(List.of("columnNames"))
     *         .function("function")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregatecolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregatecolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AggregateColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(AggregateColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AggregateColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Column names in configured table of aggregate columns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregatecolumn.html#cfn-cleanrooms-configuredtable-aggregatecolumn-columnnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregatecolumn.html#cfn-cleanrooms-configuredtable-aggregatecolumn-columnnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getColumnNames();

        /**
         * Aggregation function that can be applied to aggregate column in query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregatecolumn.html#cfn-cleanrooms-configuredtable-aggregatecolumn-function">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregatecolumn.html#cfn-cleanrooms-configuredtable-aggregatecolumn-function</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunction();

        /**
         * @return a {@link Builder} of {@link AggregateColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AggregateColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AggregateColumnProperty> {
            java.util.List<java.lang.String> columnNames;
            java.lang.String function;

            /**
             * Sets the value of {@link AggregateColumnProperty#getColumnNames}
             * @param columnNames Column names in configured table of aggregate columns. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnNames(java.util.List<java.lang.String> columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            /**
             * Sets the value of {@link AggregateColumnProperty#getFunction}
             * @param function Aggregation function that can be applied to aggregate column in query. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder function(java.lang.String function) {
                this.function = function;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AggregateColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AggregateColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AggregateColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregateColumnProperty {
            private final java.util.List<java.lang.String> columnNames;
            private final java.lang.String function;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnNames = software.amazon.jsii.Kernel.get(this, "columnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.function = software.amazon.jsii.Kernel.get(this, "function", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnNames = java.util.Objects.requireNonNull(builder.columnNames, "columnNames is required");
                this.function = java.util.Objects.requireNonNull(builder.function, "function is required");
            }

            @Override
            public final java.util.List<java.lang.String> getColumnNames() {
                return this.columnNames;
            }

            @Override
            public final java.lang.String getFunction() {
                return this.function;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnNames", om.valueToTree(this.getColumnNames()));
                data.set("function", om.valueToTree(this.getFunction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AggregateColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AggregateColumnProperty.Jsii$Proxy that = (AggregateColumnProperty.Jsii$Proxy) o;

                if (!columnNames.equals(that.columnNames)) return false;
                return this.function.equals(that.function);
            }

            @Override
            public final int hashCode() {
                int result = this.columnNames.hashCode();
                result = 31 * result + (this.function.hashCode());
                return result;
            }
        }
    }
    /**
     * Constraint on query output removing output rows that do not meet a minimum number of distinct values of a specified column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * AggregationConstraintProperty aggregationConstraintProperty = AggregationConstraintProperty.builder()
     *         .columnName("columnName")
     *         .minimum(123)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AggregationConstraintProperty")
    @software.amazon.jsii.Jsii.Proxy(AggregationConstraintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AggregationConstraintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Column in aggregation constraint for which there must be a minimum number of distinct values in an output row for it to be in the query output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html#cfn-cleanrooms-configuredtable-aggregationconstraint-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html#cfn-cleanrooms-configuredtable-aggregationconstraint-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The minimum number of distinct values that an output row must be an aggregation of.
         * <p>
         * Minimum threshold of distinct values for a specified column that must exist in an output row for it to be in the query output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html#cfn-cleanrooms-configuredtable-aggregationconstraint-minimum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html#cfn-cleanrooms-configuredtable-aggregationconstraint-minimum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimum();

        /**
         * The type of aggregation the constraint allows.
         * <p>
         * The only valid value is currently <code>COUNT_DISTINCT</code>.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html#cfn-cleanrooms-configuredtable-aggregationconstraint-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-aggregationconstraint.html#cfn-cleanrooms-configuredtable-aggregationconstraint-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link AggregationConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AggregationConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AggregationConstraintProperty> {
            java.lang.String columnName;
            java.lang.Number minimum;
            java.lang.String type;

            /**
             * Sets the value of {@link AggregationConstraintProperty#getColumnName}
             * @param columnName Column in aggregation constraint for which there must be a minimum number of distinct values in an output row for it to be in the query output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link AggregationConstraintProperty#getMinimum}
             * @param minimum The minimum number of distinct values that an output row must be an aggregation of. This parameter is required.
             *                Minimum threshold of distinct values for a specified column that must exist in an output row for it to be in the query output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimum(java.lang.Number minimum) {
                this.minimum = minimum;
                return this;
            }

            /**
             * Sets the value of {@link AggregationConstraintProperty#getType}
             * @param type The type of aggregation the constraint allows. This parameter is required.
             *             The only valid value is currently <code>COUNT_DISTINCT</code>.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AggregationConstraintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AggregationConstraintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AggregationConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregationConstraintProperty {
            private final java.lang.String columnName;
            private final java.lang.Number minimum;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minimum = software.amazon.jsii.Kernel.get(this, "minimum", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.minimum = java.util.Objects.requireNonNull(builder.minimum, "minimum is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.Number getMinimum() {
                return this.minimum;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("minimum", om.valueToTree(this.getMinimum()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AggregationConstraintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AggregationConstraintProperty.Jsii$Proxy that = (AggregationConstraintProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                if (!minimum.equals(that.minimum)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.minimum.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * A type of analysis rule that enables query structure and specified queries that produce aggregate statistics.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * AnalysisRuleAggregationProperty analysisRuleAggregationProperty = AnalysisRuleAggregationProperty.builder()
     *         .aggregateColumns(List.of(AggregateColumnProperty.builder()
     *                 .columnNames(List.of("columnNames"))
     *                 .function("function")
     *                 .build()))
     *         .dimensionColumns(List.of("dimensionColumns"))
     *         .joinColumns(List.of("joinColumns"))
     *         .outputConstraints(List.of(AggregationConstraintProperty.builder()
     *                 .columnName("columnName")
     *                 .minimum(123)
     *                 .type("type")
     *                 .build()))
     *         .scalarFunctions(List.of("scalarFunctions"))
     *         // the properties below are optional
     *         .allowedJoinOperators(List.of("allowedJoinOperators"))
     *         .joinRequired("joinRequired")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AnalysisRuleAggregationProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisRuleAggregationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisRuleAggregationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The columns that query runners are allowed to use in aggregation queries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-aggregatecolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-aggregatecolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAggregateColumns();

        /**
         * The columns that query runners are allowed to select, group by, or filter by.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-dimensioncolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-dimensioncolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDimensionColumns();

        /**
         * Columns in configured table that can be used in join statements and/or as aggregate columns.
         * <p>
         * They can never be outputted directly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-joincolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-joincolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getJoinColumns();

        /**
         * Columns that must meet a specific threshold value (after an aggregation function is applied to it) for each output row to be returned.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-outputconstraints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-outputconstraints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutputConstraints();

        /**
         * Set of scalar functions that are allowed to be used on dimension columns and the output of aggregation of metrics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-scalarfunctions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-scalarfunctions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getScalarFunctions();

        /**
         * Which logical operators (if any) are to be used in an INNER JOIN match condition.
         * <p>
         * Default is <code>AND</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-allowedjoinoperators">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-allowedjoinoperators</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedJoinOperators() {
            return null;
        }

        /**
         * Control that requires member who runs query to do a join with their configured table and/or other configured table in query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-joinrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisruleaggregation.html#cfn-cleanrooms-configuredtable-analysisruleaggregation-joinrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJoinRequired() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisRuleAggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisRuleAggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisRuleAggregationProperty> {
            java.lang.Object aggregateColumns;
            java.util.List<java.lang.String> dimensionColumns;
            java.util.List<java.lang.String> joinColumns;
            java.lang.Object outputConstraints;
            java.util.List<java.lang.String> scalarFunctions;
            java.util.List<java.lang.String> allowedJoinOperators;
            java.lang.String joinRequired;

            /**
             * Sets the value of {@link AnalysisRuleAggregationProperty#getAggregateColumns}
             * @param aggregateColumns The columns that query runners are allowed to use in aggregation queries. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregateColumns(software.amazon.awscdk.IResolvable aggregateColumns) {
                this.aggregateColumns = aggregateColumns;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleAggregationProperty#getAggregateColumns}
             * @param aggregateColumns The columns that query runners are allowed to use in aggregation queries. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregateColumns(java.util.List<? extends java.lang.Object> aggregateColumns) {
                this.aggregateColumns = aggregateColumns;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleAggregationProperty#getDimensionColumns}
             * @param dimensionColumns The columns that query runners are allowed to select, group by, or filter by. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionColumns(java.util.List<java.lang.String> dimensionColumns) {
                this.dimensionColumns = dimensionColumns;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleAggregationProperty#getJoinColumns}
             * @param joinColumns Columns in configured table that can be used in join statements and/or as aggregate columns. This parameter is required.
             *                    They can never be outputted directly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinColumns(java.util.List<java.lang.String> joinColumns) {
                this.joinColumns = joinColumns;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleAggregationProperty#getOutputConstraints}
             * @param outputConstraints Columns that must meet a specific threshold value (after an aggregation function is applied to it) for each output row to be returned. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputConstraints(software.amazon.awscdk.IResolvable outputConstraints) {
                this.outputConstraints = outputConstraints;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleAggregationProperty#getOutputConstraints}
             * @param outputConstraints Columns that must meet a specific threshold value (after an aggregation function is applied to it) for each output row to be returned. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputConstraints(java.util.List<? extends java.lang.Object> outputConstraints) {
                this.outputConstraints = outputConstraints;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleAggregationProperty#getScalarFunctions}
             * @param scalarFunctions Set of scalar functions that are allowed to be used on dimension columns and the output of aggregation of metrics. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalarFunctions(java.util.List<java.lang.String> scalarFunctions) {
                this.scalarFunctions = scalarFunctions;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleAggregationProperty#getAllowedJoinOperators}
             * @param allowedJoinOperators Which logical operators (if any) are to be used in an INNER JOIN match condition.
             *                             Default is <code>AND</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedJoinOperators(java.util.List<java.lang.String> allowedJoinOperators) {
                this.allowedJoinOperators = allowedJoinOperators;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleAggregationProperty#getJoinRequired}
             * @param joinRequired Control that requires member who runs query to do a join with their configured table and/or other configured table in query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinRequired(java.lang.String joinRequired) {
                this.joinRequired = joinRequired;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisRuleAggregationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisRuleAggregationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisRuleAggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisRuleAggregationProperty {
            private final java.lang.Object aggregateColumns;
            private final java.util.List<java.lang.String> dimensionColumns;
            private final java.util.List<java.lang.String> joinColumns;
            private final java.lang.Object outputConstraints;
            private final java.util.List<java.lang.String> scalarFunctions;
            private final java.util.List<java.lang.String> allowedJoinOperators;
            private final java.lang.String joinRequired;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregateColumns = software.amazon.jsii.Kernel.get(this, "aggregateColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dimensionColumns = software.amazon.jsii.Kernel.get(this, "dimensionColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.joinColumns = software.amazon.jsii.Kernel.get(this, "joinColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.outputConstraints = software.amazon.jsii.Kernel.get(this, "outputConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scalarFunctions = software.amazon.jsii.Kernel.get(this, "scalarFunctions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedJoinOperators = software.amazon.jsii.Kernel.get(this, "allowedJoinOperators", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.joinRequired = software.amazon.jsii.Kernel.get(this, "joinRequired", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregateColumns = java.util.Objects.requireNonNull(builder.aggregateColumns, "aggregateColumns is required");
                this.dimensionColumns = java.util.Objects.requireNonNull(builder.dimensionColumns, "dimensionColumns is required");
                this.joinColumns = java.util.Objects.requireNonNull(builder.joinColumns, "joinColumns is required");
                this.outputConstraints = java.util.Objects.requireNonNull(builder.outputConstraints, "outputConstraints is required");
                this.scalarFunctions = java.util.Objects.requireNonNull(builder.scalarFunctions, "scalarFunctions is required");
                this.allowedJoinOperators = builder.allowedJoinOperators;
                this.joinRequired = builder.joinRequired;
            }

            @Override
            public final java.lang.Object getAggregateColumns() {
                return this.aggregateColumns;
            }

            @Override
            public final java.util.List<java.lang.String> getDimensionColumns() {
                return this.dimensionColumns;
            }

            @Override
            public final java.util.List<java.lang.String> getJoinColumns() {
                return this.joinColumns;
            }

            @Override
            public final java.lang.Object getOutputConstraints() {
                return this.outputConstraints;
            }

            @Override
            public final java.util.List<java.lang.String> getScalarFunctions() {
                return this.scalarFunctions;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedJoinOperators() {
                return this.allowedJoinOperators;
            }

            @Override
            public final java.lang.String getJoinRequired() {
                return this.joinRequired;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("aggregateColumns", om.valueToTree(this.getAggregateColumns()));
                data.set("dimensionColumns", om.valueToTree(this.getDimensionColumns()));
                data.set("joinColumns", om.valueToTree(this.getJoinColumns()));
                data.set("outputConstraints", om.valueToTree(this.getOutputConstraints()));
                data.set("scalarFunctions", om.valueToTree(this.getScalarFunctions()));
                if (this.getAllowedJoinOperators() != null) {
                    data.set("allowedJoinOperators", om.valueToTree(this.getAllowedJoinOperators()));
                }
                if (this.getJoinRequired() != null) {
                    data.set("joinRequired", om.valueToTree(this.getJoinRequired()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AnalysisRuleAggregationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisRuleAggregationProperty.Jsii$Proxy that = (AnalysisRuleAggregationProperty.Jsii$Proxy) o;

                if (!aggregateColumns.equals(that.aggregateColumns)) return false;
                if (!dimensionColumns.equals(that.dimensionColumns)) return false;
                if (!joinColumns.equals(that.joinColumns)) return false;
                if (!outputConstraints.equals(that.outputConstraints)) return false;
                if (!scalarFunctions.equals(that.scalarFunctions)) return false;
                if (this.allowedJoinOperators != null ? !this.allowedJoinOperators.equals(that.allowedJoinOperators) : that.allowedJoinOperators != null) return false;
                return this.joinRequired != null ? this.joinRequired.equals(that.joinRequired) : that.joinRequired == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregateColumns.hashCode();
                result = 31 * result + (this.dimensionColumns.hashCode());
                result = 31 * result + (this.joinColumns.hashCode());
                result = 31 * result + (this.outputConstraints.hashCode());
                result = 31 * result + (this.scalarFunctions.hashCode());
                result = 31 * result + (this.allowedJoinOperators != null ? this.allowedJoinOperators.hashCode() : 0);
                result = 31 * result + (this.joinRequired != null ? this.joinRequired.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A type of analysis rule that enables the table owner to approve custom SQL queries on their configured tables.
     * <p>
     * It supports differential privacy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * AnalysisRuleCustomProperty analysisRuleCustomProperty = AnalysisRuleCustomProperty.builder()
     *         .allowedAnalyses(List.of("allowedAnalyses"))
     *         // the properties below are optional
     *         .allowedAnalysisProviders(List.of("allowedAnalysisProviders"))
     *         .differentialPrivacy(DifferentialPrivacyProperty.builder()
     *                 .columns(List.of(DifferentialPrivacyColumnProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulecustom.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulecustom.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AnalysisRuleCustomProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisRuleCustomProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisRuleCustomProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the analysis templates that are allowed by the custom analysis rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulecustom.html#cfn-cleanrooms-configuredtable-analysisrulecustom-allowedanalyses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulecustom.html#cfn-cleanrooms-configuredtable-analysisrulecustom-allowedanalyses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowedAnalyses();

        /**
         * The IDs of the AWS accounts that are allowed to query by the custom analysis rule.
         * <p>
         * Required when <code>allowedAnalyses</code> is <code>ANY_QUERY</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulecustom.html#cfn-cleanrooms-configuredtable-analysisrulecustom-allowedanalysisproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulecustom.html#cfn-cleanrooms-configuredtable-analysisrulecustom-allowedanalysisproviders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedAnalysisProviders() {
            return null;
        }

        /**
         * The differential privacy configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulecustom.html#cfn-cleanrooms-configuredtable-analysisrulecustom-differentialprivacy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulecustom.html#cfn-cleanrooms-configuredtable-analysisrulecustom-differentialprivacy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDifferentialPrivacy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisRuleCustomProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisRuleCustomProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisRuleCustomProperty> {
            java.util.List<java.lang.String> allowedAnalyses;
            java.util.List<java.lang.String> allowedAnalysisProviders;
            java.lang.Object differentialPrivacy;

            /**
             * Sets the value of {@link AnalysisRuleCustomProperty#getAllowedAnalyses}
             * @param allowedAnalyses The ARN of the analysis templates that are allowed by the custom analysis rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedAnalyses(java.util.List<java.lang.String> allowedAnalyses) {
                this.allowedAnalyses = allowedAnalyses;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleCustomProperty#getAllowedAnalysisProviders}
             * @param allowedAnalysisProviders The IDs of the AWS accounts that are allowed to query by the custom analysis rule.
             *                                 Required when <code>allowedAnalyses</code> is <code>ANY_QUERY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedAnalysisProviders(java.util.List<java.lang.String> allowedAnalysisProviders) {
                this.allowedAnalysisProviders = allowedAnalysisProviders;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleCustomProperty#getDifferentialPrivacy}
             * @param differentialPrivacy The differential privacy configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder differentialPrivacy(software.amazon.awscdk.IResolvable differentialPrivacy) {
                this.differentialPrivacy = differentialPrivacy;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleCustomProperty#getDifferentialPrivacy}
             * @param differentialPrivacy The differential privacy configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder differentialPrivacy(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.DifferentialPrivacyProperty differentialPrivacy) {
                this.differentialPrivacy = differentialPrivacy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisRuleCustomProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisRuleCustomProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisRuleCustomProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisRuleCustomProperty {
            private final java.util.List<java.lang.String> allowedAnalyses;
            private final java.util.List<java.lang.String> allowedAnalysisProviders;
            private final java.lang.Object differentialPrivacy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedAnalyses = software.amazon.jsii.Kernel.get(this, "allowedAnalyses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedAnalysisProviders = software.amazon.jsii.Kernel.get(this, "allowedAnalysisProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.differentialPrivacy = software.amazon.jsii.Kernel.get(this, "differentialPrivacy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedAnalyses = java.util.Objects.requireNonNull(builder.allowedAnalyses, "allowedAnalyses is required");
                this.allowedAnalysisProviders = builder.allowedAnalysisProviders;
                this.differentialPrivacy = builder.differentialPrivacy;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedAnalyses() {
                return this.allowedAnalyses;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedAnalysisProviders() {
                return this.allowedAnalysisProviders;
            }

            @Override
            public final java.lang.Object getDifferentialPrivacy() {
                return this.differentialPrivacy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowedAnalyses", om.valueToTree(this.getAllowedAnalyses()));
                if (this.getAllowedAnalysisProviders() != null) {
                    data.set("allowedAnalysisProviders", om.valueToTree(this.getAllowedAnalysisProviders()));
                }
                if (this.getDifferentialPrivacy() != null) {
                    data.set("differentialPrivacy", om.valueToTree(this.getDifferentialPrivacy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AnalysisRuleCustomProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisRuleCustomProperty.Jsii$Proxy that = (AnalysisRuleCustomProperty.Jsii$Proxy) o;

                if (!allowedAnalyses.equals(that.allowedAnalyses)) return false;
                if (this.allowedAnalysisProviders != null ? !this.allowedAnalysisProviders.equals(that.allowedAnalysisProviders) : that.allowedAnalysisProviders != null) return false;
                return this.differentialPrivacy != null ? this.differentialPrivacy.equals(that.differentialPrivacy) : that.differentialPrivacy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedAnalyses.hashCode();
                result = 31 * result + (this.allowedAnalysisProviders != null ? this.allowedAnalysisProviders.hashCode() : 0);
                result = 31 * result + (this.differentialPrivacy != null ? this.differentialPrivacy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A type of analysis rule that enables row-level analysis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * AnalysisRuleListProperty analysisRuleListProperty = AnalysisRuleListProperty.builder()
     *         .joinColumns(List.of("joinColumns"))
     *         .listColumns(List.of("listColumns"))
     *         // the properties below are optional
     *         .allowedJoinOperators(List.of("allowedJoinOperators"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AnalysisRuleListProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisRuleListProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisRuleListProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Columns that can be used to join a configured table with the table of the member who can query and other members' configured tables.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html#cfn-cleanrooms-configuredtable-analysisrulelist-joincolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html#cfn-cleanrooms-configuredtable-analysisrulelist-joincolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getJoinColumns();

        /**
         * Columns that can be listed in the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html#cfn-cleanrooms-configuredtable-analysisrulelist-listcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html#cfn-cleanrooms-configuredtable-analysisrulelist-listcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getListColumns();

        /**
         * The logical operators (if any) that are to be used in an INNER JOIN match condition.
         * <p>
         * Default is <code>AND</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html#cfn-cleanrooms-configuredtable-analysisrulelist-allowedjoinoperators">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrulelist.html#cfn-cleanrooms-configuredtable-analysisrulelist-allowedjoinoperators</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedJoinOperators() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisRuleListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisRuleListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisRuleListProperty> {
            java.util.List<java.lang.String> joinColumns;
            java.util.List<java.lang.String> listColumns;
            java.util.List<java.lang.String> allowedJoinOperators;

            /**
             * Sets the value of {@link AnalysisRuleListProperty#getJoinColumns}
             * @param joinColumns Columns that can be used to join a configured table with the table of the member who can query and other members' configured tables. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinColumns(java.util.List<java.lang.String> joinColumns) {
                this.joinColumns = joinColumns;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleListProperty#getListColumns}
             * @param listColumns Columns that can be listed in the output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listColumns(java.util.List<java.lang.String> listColumns) {
                this.listColumns = listColumns;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleListProperty#getAllowedJoinOperators}
             * @param allowedJoinOperators The logical operators (if any) that are to be used in an INNER JOIN match condition.
             *                             Default is <code>AND</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedJoinOperators(java.util.List<java.lang.String> allowedJoinOperators) {
                this.allowedJoinOperators = allowedJoinOperators;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisRuleListProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisRuleListProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisRuleListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisRuleListProperty {
            private final java.util.List<java.lang.String> joinColumns;
            private final java.util.List<java.lang.String> listColumns;
            private final java.util.List<java.lang.String> allowedJoinOperators;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.joinColumns = software.amazon.jsii.Kernel.get(this, "joinColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.listColumns = software.amazon.jsii.Kernel.get(this, "listColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedJoinOperators = software.amazon.jsii.Kernel.get(this, "allowedJoinOperators", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.joinColumns = java.util.Objects.requireNonNull(builder.joinColumns, "joinColumns is required");
                this.listColumns = java.util.Objects.requireNonNull(builder.listColumns, "listColumns is required");
                this.allowedJoinOperators = builder.allowedJoinOperators;
            }

            @Override
            public final java.util.List<java.lang.String> getJoinColumns() {
                return this.joinColumns;
            }

            @Override
            public final java.util.List<java.lang.String> getListColumns() {
                return this.listColumns;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedJoinOperators() {
                return this.allowedJoinOperators;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("joinColumns", om.valueToTree(this.getJoinColumns()));
                data.set("listColumns", om.valueToTree(this.getListColumns()));
                if (this.getAllowedJoinOperators() != null) {
                    data.set("allowedJoinOperators", om.valueToTree(this.getAllowedJoinOperators()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AnalysisRuleListProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisRuleListProperty.Jsii$Proxy that = (AnalysisRuleListProperty.Jsii$Proxy) o;

                if (!joinColumns.equals(that.joinColumns)) return false;
                if (!listColumns.equals(that.listColumns)) return false;
                return this.allowedJoinOperators != null ? this.allowedJoinOperators.equals(that.allowedJoinOperators) : that.allowedJoinOperators == null;
            }

            @Override
            public final int hashCode() {
                int result = this.joinColumns.hashCode();
                result = 31 * result + (this.listColumns.hashCode());
                result = 31 * result + (this.allowedJoinOperators != null ? this.allowedJoinOperators.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A specification about how data from the configured table can be used in a query.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * AnalysisRuleProperty analysisRuleProperty = AnalysisRuleProperty.builder()
     *         .policy(ConfiguredTableAnalysisRulePolicyProperty.builder()
     *                 .v1(ConfiguredTableAnalysisRulePolicyV1Property.builder()
     *                         .aggregation(AnalysisRuleAggregationProperty.builder()
     *                                 .aggregateColumns(List.of(AggregateColumnProperty.builder()
     *                                         .columnNames(List.of("columnNames"))
     *                                         .function("function")
     *                                         .build()))
     *                                 .dimensionColumns(List.of("dimensionColumns"))
     *                                 .joinColumns(List.of("joinColumns"))
     *                                 .outputConstraints(List.of(AggregationConstraintProperty.builder()
     *                                         .columnName("columnName")
     *                                         .minimum(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .scalarFunctions(List.of("scalarFunctions"))
     *                                 // the properties below are optional
     *                                 .allowedJoinOperators(List.of("allowedJoinOperators"))
     *                                 .joinRequired("joinRequired")
     *                                 .build())
     *                         .custom(AnalysisRuleCustomProperty.builder()
     *                                 .allowedAnalyses(List.of("allowedAnalyses"))
     *                                 // the properties below are optional
     *                                 .allowedAnalysisProviders(List.of("allowedAnalysisProviders"))
     *                                 .differentialPrivacy(DifferentialPrivacyProperty.builder()
     *                                         .columns(List.of(DifferentialPrivacyColumnProperty.builder()
     *                                                 .name("name")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .list(AnalysisRuleListProperty.builder()
     *                                 .joinColumns(List.of("joinColumns"))
     *                                 .listColumns(List.of("listColumns"))
     *                                 // the properties below are optional
     *                                 .allowedJoinOperators(List.of("allowedJoinOperators"))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AnalysisRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A policy that describes the associated data usage limitations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrule.html#cfn-cleanrooms-configuredtable-analysisrule-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrule.html#cfn-cleanrooms-configuredtable-analysisrule-policy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPolicy();

        /**
         * The type of analysis rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrule.html#cfn-cleanrooms-configuredtable-analysisrule-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-analysisrule.html#cfn-cleanrooms-configuredtable-analysisrule-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link AnalysisRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisRuleProperty> {
            java.lang.Object policy;
            java.lang.String type;

            /**
             * Sets the value of {@link AnalysisRuleProperty#getPolicy}
             * @param policy A policy that describes the associated data usage limitations. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policy(software.amazon.awscdk.IResolvable policy) {
                this.policy = policy;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleProperty#getPolicy}
             * @param policy A policy that describes the associated data usage limitations. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policy(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.ConfiguredTableAnalysisRulePolicyProperty policy) {
                this.policy = policy;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRuleProperty#getType}
             * @param type The type of analysis rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisRuleProperty {
            private final java.lang.Object policy;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policy = java.util.Objects.requireNonNull(builder.policy, "policy is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getPolicy() {
                return this.policy;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policy", om.valueToTree(this.getPolicy()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.AnalysisRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisRuleProperty.Jsii$Proxy that = (AnalysisRuleProperty.Jsii$Proxy) o;

                if (!policy.equals(that.policy)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.policy.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Controls on the query specifications that can be run on a configured table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ConfiguredTableAnalysisRulePolicyProperty configuredTableAnalysisRulePolicyProperty = ConfiguredTableAnalysisRulePolicyProperty.builder()
     *         .v1(ConfiguredTableAnalysisRulePolicyV1Property.builder()
     *                 .aggregation(AnalysisRuleAggregationProperty.builder()
     *                         .aggregateColumns(List.of(AggregateColumnProperty.builder()
     *                                 .columnNames(List.of("columnNames"))
     *                                 .function("function")
     *                                 .build()))
     *                         .dimensionColumns(List.of("dimensionColumns"))
     *                         .joinColumns(List.of("joinColumns"))
     *                         .outputConstraints(List.of(AggregationConstraintProperty.builder()
     *                                 .columnName("columnName")
     *                                 .minimum(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .scalarFunctions(List.of("scalarFunctions"))
     *                         // the properties below are optional
     *                         .allowedJoinOperators(List.of("allowedJoinOperators"))
     *                         .joinRequired("joinRequired")
     *                         .build())
     *                 .custom(AnalysisRuleCustomProperty.builder()
     *                         .allowedAnalyses(List.of("allowedAnalyses"))
     *                         // the properties below are optional
     *                         .allowedAnalysisProviders(List.of("allowedAnalysisProviders"))
     *                         .differentialPrivacy(DifferentialPrivacyProperty.builder()
     *                                 .columns(List.of(DifferentialPrivacyColumnProperty.builder()
     *                                         .name("name")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .list(AnalysisRuleListProperty.builder()
     *                         .joinColumns(List.of("joinColumns"))
     *                         .listColumns(List.of("listColumns"))
     *                         // the properties below are optional
     *                         .allowedJoinOperators(List.of("allowedJoinOperators"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.ConfiguredTableAnalysisRulePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfiguredTableAnalysisRulePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfiguredTableAnalysisRulePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Controls on the query specifications that can be run on a configured table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicy.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicy-v1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicy.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicy-v1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getV1();

        /**
         * @return a {@link Builder} of {@link ConfiguredTableAnalysisRulePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfiguredTableAnalysisRulePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfiguredTableAnalysisRulePolicyProperty> {
            java.lang.Object v1;

            /**
             * Sets the value of {@link ConfiguredTableAnalysisRulePolicyProperty#getV1}
             * @param v1 Controls on the query specifications that can be run on a configured table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder v1(software.amazon.awscdk.IResolvable v1) {
                this.v1 = v1;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAnalysisRulePolicyProperty#getV1}
             * @param v1 Controls on the query specifications that can be run on a configured table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder v1(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.ConfiguredTableAnalysisRulePolicyV1Property v1) {
                this.v1 = v1;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfiguredTableAnalysisRulePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfiguredTableAnalysisRulePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfiguredTableAnalysisRulePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfiguredTableAnalysisRulePolicyProperty {
            private final java.lang.Object v1;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.v1 = software.amazon.jsii.Kernel.get(this, "v1", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.v1 = java.util.Objects.requireNonNull(builder.v1, "v1 is required");
            }

            @Override
            public final java.lang.Object getV1() {
                return this.v1;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("v1", om.valueToTree(this.getV1()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.ConfiguredTableAnalysisRulePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfiguredTableAnalysisRulePolicyProperty.Jsii$Proxy that = (ConfiguredTableAnalysisRulePolicyProperty.Jsii$Proxy) o;

                return this.v1.equals(that.v1);
            }

            @Override
            public final int hashCode() {
                int result = this.v1.hashCode();
                return result;
            }
        }
    }
    /**
     * Controls on the query specifications that can be run on a configured table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ConfiguredTableAnalysisRulePolicyV1Property configuredTableAnalysisRulePolicyV1Property = ConfiguredTableAnalysisRulePolicyV1Property.builder()
     *         .aggregation(AnalysisRuleAggregationProperty.builder()
     *                 .aggregateColumns(List.of(AggregateColumnProperty.builder()
     *                         .columnNames(List.of("columnNames"))
     *                         .function("function")
     *                         .build()))
     *                 .dimensionColumns(List.of("dimensionColumns"))
     *                 .joinColumns(List.of("joinColumns"))
     *                 .outputConstraints(List.of(AggregationConstraintProperty.builder()
     *                         .columnName("columnName")
     *                         .minimum(123)
     *                         .type("type")
     *                         .build()))
     *                 .scalarFunctions(List.of("scalarFunctions"))
     *                 // the properties below are optional
     *                 .allowedJoinOperators(List.of("allowedJoinOperators"))
     *                 .joinRequired("joinRequired")
     *                 .build())
     *         .custom(AnalysisRuleCustomProperty.builder()
     *                 .allowedAnalyses(List.of("allowedAnalyses"))
     *                 // the properties below are optional
     *                 .allowedAnalysisProviders(List.of("allowedAnalysisProviders"))
     *                 .differentialPrivacy(DifferentialPrivacyProperty.builder()
     *                         .columns(List.of(DifferentialPrivacyColumnProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .list(AnalysisRuleListProperty.builder()
     *                 .joinColumns(List.of("joinColumns"))
     *                 .listColumns(List.of("listColumns"))
     *                 // the properties below are optional
     *                 .allowedJoinOperators(List.of("allowedJoinOperators"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.ConfiguredTableAnalysisRulePolicyV1Property")
    @software.amazon.jsii.Jsii.Proxy(ConfiguredTableAnalysisRulePolicyV1Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfiguredTableAnalysisRulePolicyV1Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Analysis rule type that enables only aggregation queries on a configured table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1-aggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1-aggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregation() {
            return null;
        }

        /**
         * Analysis rule type that enables custom SQL queries on a configured table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1-custom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1-custom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustom() {
            return null;
        }

        /**
         * Analysis rule type that enables only list queries on a configured table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1-list">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1.html#cfn-cleanrooms-configuredtable-configuredtableanalysisrulepolicyv1-list</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfiguredTableAnalysisRulePolicyV1Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfiguredTableAnalysisRulePolicyV1Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfiguredTableAnalysisRulePolicyV1Property> {
            java.lang.Object aggregation;
            java.lang.Object custom;
            java.lang.Object list;

            /**
             * Sets the value of {@link ConfiguredTableAnalysisRulePolicyV1Property#getAggregation}
             * @param aggregation Analysis rule type that enables only aggregation queries on a configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(software.amazon.awscdk.IResolvable aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAnalysisRulePolicyV1Property#getAggregation}
             * @param aggregation Analysis rule type that enables only aggregation queries on a configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.AnalysisRuleAggregationProperty aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAnalysisRulePolicyV1Property#getCustom}
             * @param custom Analysis rule type that enables custom SQL queries on a configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder custom(software.amazon.awscdk.IResolvable custom) {
                this.custom = custom;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAnalysisRulePolicyV1Property#getCustom}
             * @param custom Analysis rule type that enables custom SQL queries on a configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder custom(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.AnalysisRuleCustomProperty custom) {
                this.custom = custom;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAnalysisRulePolicyV1Property#getList}
             * @param list Analysis rule type that enables only list queries on a configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder list(software.amazon.awscdk.IResolvable list) {
                this.list = list;
                return this;
            }

            /**
             * Sets the value of {@link ConfiguredTableAnalysisRulePolicyV1Property#getList}
             * @param list Analysis rule type that enables only list queries on a configured table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder list(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.AnalysisRuleListProperty list) {
                this.list = list;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfiguredTableAnalysisRulePolicyV1Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfiguredTableAnalysisRulePolicyV1Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfiguredTableAnalysisRulePolicyV1Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfiguredTableAnalysisRulePolicyV1Property {
            private final java.lang.Object aggregation;
            private final java.lang.Object custom;
            private final java.lang.Object list;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregation = software.amazon.jsii.Kernel.get(this, "aggregation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.custom = software.amazon.jsii.Kernel.get(this, "custom", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.list = software.amazon.jsii.Kernel.get(this, "list", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregation = builder.aggregation;
                this.custom = builder.custom;
                this.list = builder.list;
            }

            @Override
            public final java.lang.Object getAggregation() {
                return this.aggregation;
            }

            @Override
            public final java.lang.Object getCustom() {
                return this.custom;
            }

            @Override
            public final java.lang.Object getList() {
                return this.list;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregation() != null) {
                    data.set("aggregation", om.valueToTree(this.getAggregation()));
                }
                if (this.getCustom() != null) {
                    data.set("custom", om.valueToTree(this.getCustom()));
                }
                if (this.getList() != null) {
                    data.set("list", om.valueToTree(this.getList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.ConfiguredTableAnalysisRulePolicyV1Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfiguredTableAnalysisRulePolicyV1Property.Jsii$Proxy that = (ConfiguredTableAnalysisRulePolicyV1Property.Jsii$Proxy) o;

                if (this.aggregation != null ? !this.aggregation.equals(that.aggregation) : that.aggregation != null) return false;
                if (this.custom != null ? !this.custom.equals(that.custom) : that.custom != null) return false;
                return this.list != null ? this.list.equals(that.list) : that.list == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregation != null ? this.aggregation.hashCode() : 0;
                result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
                result = 31 * result + (this.list != null ? this.list.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the name of the column that contains the unique identifier of your users, whose privacy you want to protect.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * DifferentialPrivacyColumnProperty differentialPrivacyColumnProperty = DifferentialPrivacyColumnProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-differentialprivacycolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-differentialprivacycolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.DifferentialPrivacyColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(DifferentialPrivacyColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DifferentialPrivacyColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column, such as user_id, that contains the unique identifier of your users, whose privacy you want to protect.
         * <p>
         * If you want to turn on differential privacy for two or more tables in a collaboration, you must configure the same column as the user identifier column in both analysis rules.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-differentialprivacycolumn.html#cfn-cleanrooms-configuredtable-differentialprivacycolumn-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-differentialprivacycolumn.html#cfn-cleanrooms-configuredtable-differentialprivacycolumn-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link DifferentialPrivacyColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DifferentialPrivacyColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DifferentialPrivacyColumnProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link DifferentialPrivacyColumnProperty#getName}
             * @param name The name of the column, such as user_id, that contains the unique identifier of your users, whose privacy you want to protect. This parameter is required.
             *             If you want to turn on differential privacy for two or more tables in a collaboration, you must configure the same column as the user identifier column in both analysis rules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DifferentialPrivacyColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DifferentialPrivacyColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DifferentialPrivacyColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DifferentialPrivacyColumnProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.DifferentialPrivacyColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DifferentialPrivacyColumnProperty.Jsii$Proxy that = (DifferentialPrivacyColumnProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * The analysis method for the configured tables.
     * <p>
     * The only valid value is currently <code>DIRECT_QUERY</code>.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * DifferentialPrivacyProperty differentialPrivacyProperty = DifferentialPrivacyProperty.builder()
     *         .columns(List.of(DifferentialPrivacyColumnProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-differentialprivacy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-differentialprivacy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.DifferentialPrivacyProperty")
    @software.amazon.jsii.Jsii.Proxy(DifferentialPrivacyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DifferentialPrivacyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column, such as user_id, that contains the unique identifier of your users, whose privacy you want to protect.
         * <p>
         * If you want to turn on differential privacy for two or more tables in a collaboration, you must configure the same column as the user identifier column in both analysis rules.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-differentialprivacy.html#cfn-cleanrooms-configuredtable-differentialprivacy-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-differentialprivacy.html#cfn-cleanrooms-configuredtable-differentialprivacy-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumns();

        /**
         * @return a {@link Builder} of {@link DifferentialPrivacyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DifferentialPrivacyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DifferentialPrivacyProperty> {
            java.lang.Object columns;

            /**
             * Sets the value of {@link DifferentialPrivacyProperty#getColumns}
             * @param columns The name of the column, such as user_id, that contains the unique identifier of your users, whose privacy you want to protect. This parameter is required.
             *                If you want to turn on differential privacy for two or more tables in a collaboration, you must configure the same column as the user identifier column in both analysis rules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link DifferentialPrivacyProperty#getColumns}
             * @param columns The name of the column, such as user_id, that contains the unique identifier of your users, whose privacy you want to protect. This parameter is required.
             *                If you want to turn on differential privacy for two or more tables in a collaboration, you must configure the same column as the user identifier column in both analysis rules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DifferentialPrivacyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DifferentialPrivacyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DifferentialPrivacyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DifferentialPrivacyProperty {
            private final java.lang.Object columns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = java.util.Objects.requireNonNull(builder.columns, "columns is required");
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columns", om.valueToTree(this.getColumns()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.DifferentialPrivacyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DifferentialPrivacyProperty.Jsii$Proxy that = (DifferentialPrivacyProperty.Jsii$Proxy) o;

                return this.columns.equals(that.columns);
            }

            @Override
            public final int hashCode() {
                int result = this.columns.hashCode();
                return result;
            }
        }
    }
    /**
     * A reference to a table within an AWS Glue data catalog.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * GlueTableReferenceProperty glueTableReferenceProperty = GlueTableReferenceProperty.builder()
     *         .databaseName("databaseName")
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-gluetablereference.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-gluetablereference.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.GlueTableReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(GlueTableReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlueTableReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the database the AWS Glue table belongs to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-gluetablereference.html#cfn-cleanrooms-configuredtable-gluetablereference-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-gluetablereference.html#cfn-cleanrooms-configuredtable-gluetablereference-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The name of the AWS Glue table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-gluetablereference.html#cfn-cleanrooms-configuredtable-gluetablereference-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-gluetablereference.html#cfn-cleanrooms-configuredtable-gluetablereference-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link GlueTableReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlueTableReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlueTableReferenceProperty> {
            java.lang.String databaseName;
            java.lang.String tableName;

            /**
             * Sets the value of {@link GlueTableReferenceProperty#getDatabaseName}
             * @param databaseName The name of the database the AWS Glue table belongs to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link GlueTableReferenceProperty#getTableName}
             * @param tableName The name of the AWS Glue table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlueTableReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlueTableReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlueTableReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlueTableReferenceProperty {
            private final java.lang.String databaseName;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.GlueTableReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlueTableReferenceProperty.Jsii$Proxy that = (GlueTableReferenceProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.tableName.hashCode());
                return result;
            }
        }
    }
    /**
     * A pointer to the dataset that underlies this table.
     * <p>
     * Currently, this can only be an AWS Glue table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * TableReferenceProperty tableReferenceProperty = TableReferenceProperty.builder()
     *         .glue(GlueTableReferenceProperty.builder()
     *                 .databaseName("databaseName")
     *                 .tableName("tableName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-tablereference.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-tablereference.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.TableReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(TableReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If present, a reference to the AWS Glue table referred to by this table reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-tablereference.html#cfn-cleanrooms-configuredtable-tablereference-glue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-configuredtable-tablereference.html#cfn-cleanrooms-configuredtable-tablereference-glue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGlue();

        /**
         * @return a {@link Builder} of {@link TableReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableReferenceProperty> {
            java.lang.Object glue;

            /**
             * Sets the value of {@link TableReferenceProperty#getGlue}
             * @param glue If present, a reference to the AWS Glue table referred to by this table reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glue(software.amazon.awscdk.IResolvable glue) {
                this.glue = glue;
                return this;
            }

            /**
             * Sets the value of {@link TableReferenceProperty#getGlue}
             * @param glue If present, a reference to the AWS Glue table referred to by this table reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glue(software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.GlueTableReferenceProperty glue) {
                this.glue = glue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableReferenceProperty {
            private final java.lang.Object glue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.glue = software.amazon.jsii.Kernel.get(this, "glue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.glue = java.util.Objects.requireNonNull(builder.glue, "glue is required");
            }

            @Override
            public final java.lang.Object getGlue() {
                return this.glue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("glue", om.valueToTree(this.getGlue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnConfiguredTable.TableReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableReferenceProperty.Jsii$Proxy that = (TableReferenceProperty.Jsii$Proxy) o;

                return this.glue.equals(that.glue);
            }

            @Override
            public final int hashCode() {
                int result = this.glue.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cleanrooms.CfnConfiguredTableProps.Builder();
        }

        /**
         * The columns within the underlying AWS Glue table that can be utilized within collaborations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-allowedcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-allowedcolumns</a>
         * @param allowedColumns The columns within the underlying AWS Glue table that can be utilized within collaborations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedColumns(final java.util.List<java.lang.String> allowedColumns) {
            this.props.allowedColumns(allowedColumns);
            return this;
        }

        /**
         * The analysis method for the configured table.
         * <p>
         * The only valid value is currently <code>DIRECT_QUERY</code>.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysismethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysismethod</a>
         * @param analysisMethod The analysis method for the configured table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analysisMethod(final java.lang.String analysisMethod) {
            this.props.analysisMethod(analysisMethod);
            return this;
        }

        /**
         * A name for the configured table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-name</a>
         * @param name A name for the configured table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The AWS Glue table that this configured table represents.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tablereference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tablereference</a>
         * @param tableReference The AWS Glue table that this configured table represents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableReference(final software.amazon.awscdk.IResolvable tableReference) {
            this.props.tableReference(tableReference);
            return this;
        }
        /**
         * The AWS Glue table that this configured table represents.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tablereference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tablereference</a>
         * @param tableReference The AWS Glue table that this configured table represents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableReference(final software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable.TableReferenceProperty tableReference) {
            this.props.tableReference(tableReference);
            return this;
        }

        /**
         * The entire created analysis rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysisrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysisrules</a>
         * @param analysisRules The entire created analysis rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analysisRules(final software.amazon.awscdk.IResolvable analysisRules) {
            this.props.analysisRules(analysisRules);
            return this;
        }
        /**
         * The entire created analysis rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysisrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-analysisrules</a>
         * @param analysisRules The entire created analysis rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analysisRules(final java.util.List<? extends java.lang.Object> analysisRules) {
            this.props.analysisRules(analysisRules);
            return this;
        }

        /**
         * A description for the configured table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-description</a>
         * @param description A description for the configured table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An optional label that you can assign to a resource when you create it.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-configuredtable.html#cfn-cleanrooms-configuredtable-tags</a>
         * @param tags An optional label that you can assign to a resource when you create it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable build() {
            return new software.amazon.awscdk.services.cleanrooms.CfnConfiguredTable(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
