package software.amazon.awscdk.services.cloudfront;

/**
 * The struct returned from <code>IOrigin.bind</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * IOrigin origin;
 * OriginBindConfig originBindConfig = OriginBindConfig.builder()
 *         .failoverConfig(OriginFailoverConfig.builder()
 *                 .failoverOrigin(origin)
 *                 // the properties below are optional
 *                 .statusCodes(List.of(123))
 *                 .build())
 *         .originProperty(OriginProperty.builder()
 *                 .domainName("domainName")
 *                 .id("id")
 *                 // the properties below are optional
 *                 .connectionAttempts(123)
 *                 .connectionTimeout(123)
 *                 .customOriginConfig(CustomOriginConfigProperty.builder()
 *                         .originProtocolPolicy("originProtocolPolicy")
 *                         // the properties below are optional
 *                         .httpPort(123)
 *                         .httpsPort(123)
 *                         .originKeepaliveTimeout(123)
 *                         .originReadTimeout(123)
 *                         .originSslProtocols(List.of("originSslProtocols"))
 *                         .build())
 *                 .originAccessControlId("originAccessControlId")
 *                 .originCustomHeaders(List.of(OriginCustomHeaderProperty.builder()
 *                         .headerName("headerName")
 *                         .headerValue("headerValue")
 *                         .build()))
 *                 .originPath("originPath")
 *                 .originShield(OriginShieldProperty.builder()
 *                         .enabled(false)
 *                         .originShieldRegion("originShieldRegion")
 *                         .build())
 *                 .s3OriginConfig(S3OriginConfigProperty.builder()
 *                         .originAccessIdentity("originAccessIdentity")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.532Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.OriginBindConfig")
@software.amazon.jsii.Jsii.Proxy(OriginBindConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OriginBindConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The failover configuration for this Origin.
     * <p>
     * Default: - nothing is returned
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginFailoverConfig getFailoverConfig() {
        return null;
    }

    /**
     * The CloudFormation OriginProperty configuration for this Origin.
     * <p>
     * Default: - nothing is returned
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginProperty getOriginProperty() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OriginBindConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OriginBindConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OriginBindConfig> {
        software.amazon.awscdk.services.cloudfront.OriginFailoverConfig failoverConfig;
        software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginProperty originProperty;

        /**
         * Sets the value of {@link OriginBindConfig#getFailoverConfig}
         * @param failoverConfig The failover configuration for this Origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failoverConfig(software.amazon.awscdk.services.cloudfront.OriginFailoverConfig failoverConfig) {
            this.failoverConfig = failoverConfig;
            return this;
        }

        /**
         * Sets the value of {@link OriginBindConfig#getOriginProperty}
         * @param originProperty The CloudFormation OriginProperty configuration for this Origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originProperty(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginProperty originProperty) {
            this.originProperty = originProperty;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OriginBindConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OriginBindConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OriginBindConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginBindConfig {
        private final software.amazon.awscdk.services.cloudfront.OriginFailoverConfig failoverConfig;
        private final software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginProperty originProperty;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.failoverConfig = software.amazon.jsii.Kernel.get(this, "failoverConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginFailoverConfig.class));
            this.originProperty = software.amazon.jsii.Kernel.get(this, "originProperty", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.failoverConfig = builder.failoverConfig;
            this.originProperty = builder.originProperty;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.OriginFailoverConfig getFailoverConfig() {
            return this.failoverConfig;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginProperty getOriginProperty() {
            return this.originProperty;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFailoverConfig() != null) {
                data.set("failoverConfig", om.valueToTree(this.getFailoverConfig()));
            }
            if (this.getOriginProperty() != null) {
                data.set("originProperty", om.valueToTree(this.getOriginProperty()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.OriginBindConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OriginBindConfig.Jsii$Proxy that = (OriginBindConfig.Jsii$Proxy) o;

            if (this.failoverConfig != null ? !this.failoverConfig.equals(that.failoverConfig) : that.failoverConfig != null) return false;
            return this.originProperty != null ? this.originProperty.equals(that.originProperty) : that.originProperty == null;
        }

        @Override
        public final int hashCode() {
            int result = this.failoverConfig != null ? this.failoverConfig.hashCode() : 0;
            result = 31 * result + (this.originProperty != null ? this.originProperty.hashCode() : 0);
            return result;
        }
    }
}
