package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for creating a Public Key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Validating signed URLs or signed cookies with Trusted Key Groups
 * // public key in PEM format
 * String publicKey;
 * PublicKey pubKey = PublicKey.Builder.create(this, "MyPubKey")
 *         .encodedKey(publicKey)
 *         .build();
 * KeyGroup keyGroup = KeyGroup.Builder.create(this, "MyKeyGroup")
 *         .items(List.of(pubKey))
 *         .build();
 * Distribution.Builder.create(this, "Dist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new HttpOrigin("www.example.com"))
 *                 .trustedKeyGroups(List.of(keyGroup))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.553Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.PublicKeyProps")
@software.amazon.jsii.Jsii.Proxy(PublicKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PublicKeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The public key that you can use with signed URLs and signed cookies, or with field-level encryption.
     * <p>
     * The <code>encodedKey</code> parameter must include <code>-----BEGIN PUBLIC KEY-----</code> and <code>-----END PUBLIC KEY-----</code> lines.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEncodedKey();

    /**
     * A comment to describe the public key.
     * <p>
     * Default: - no comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * A name to identify the public key.
     * <p>
     * Default: - generated from the `id`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPublicKeyName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PublicKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PublicKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PublicKeyProps> {
        java.lang.String encodedKey;
        java.lang.String comment;
        java.lang.String publicKeyName;

        /**
         * Sets the value of {@link PublicKeyProps#getEncodedKey}
         * @param encodedKey The public key that you can use with signed URLs and signed cookies, or with field-level encryption. This parameter is required.
         *                   The <code>encodedKey</code> parameter must include <code>-----BEGIN PUBLIC KEY-----</code> and <code>-----END PUBLIC KEY-----</code> lines.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encodedKey(java.lang.String encodedKey) {
            this.encodedKey = encodedKey;
            return this;
        }

        /**
         * Sets the value of {@link PublicKeyProps#getComment}
         * @param comment A comment to describe the public key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link PublicKeyProps#getPublicKeyName}
         * @param publicKeyName A name to identify the public key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicKeyName(java.lang.String publicKeyName) {
            this.publicKeyName = publicKeyName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PublicKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PublicKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PublicKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicKeyProps {
        private final java.lang.String encodedKey;
        private final java.lang.String comment;
        private final java.lang.String publicKeyName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encodedKey = software.amazon.jsii.Kernel.get(this, "encodedKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicKeyName = software.amazon.jsii.Kernel.get(this, "publicKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encodedKey = java.util.Objects.requireNonNull(builder.encodedKey, "encodedKey is required");
            this.comment = builder.comment;
            this.publicKeyName = builder.publicKeyName;
        }

        @Override
        public final java.lang.String getEncodedKey() {
            return this.encodedKey;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getPublicKeyName() {
            return this.publicKeyName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("encodedKey", om.valueToTree(this.getEncodedKey()));
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getPublicKeyName() != null) {
                data.set("publicKeyName", om.valueToTree(this.getPublicKeyName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.PublicKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PublicKeyProps.Jsii$Proxy that = (PublicKeyProps.Jsii$Proxy) o;

            if (!encodedKey.equals(that.encodedKey)) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            return this.publicKeyName != null ? this.publicKeyName.equals(that.publicKeyName) : that.publicKeyName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encodedKey.hashCode();
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.publicKeyName != null ? this.publicKeyName.hashCode() : 0);
            return result;
        }
    }
}
