package software.amazon.awscdk.services.codeartifact;

/**
 * Creates a package group.
 * <p>
 * For more information about creating package groups, including example CLI commands, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/create-package-group.html">Create a package group</a> in the <em>CodeArtifact User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codeartifact.*;
 * CfnPackageGroup cfnPackageGroup = CfnPackageGroup.Builder.create(this, "MyCfnPackageGroup")
 *         .domainName("domainName")
 *         .pattern("pattern")
 *         // the properties below are optional
 *         .contactInfo("contactInfo")
 *         .description("description")
 *         .domainOwner("domainOwner")
 *         .originConfiguration(OriginConfigurationProperty.builder()
 *                 .restrictions(RestrictionsProperty.builder()
 *                         .externalUpstream(RestrictionTypeProperty.builder()
 *                                 .restrictionMode("restrictionMode")
 *                                 // the properties below are optional
 *                                 .repositories(List.of("repositories"))
 *                                 .build())
 *                         .internalUpstream(RestrictionTypeProperty.builder()
 *                                 .restrictionMode("restrictionMode")
 *                                 // the properties below are optional
 *                                 .repositories(List.of("repositories"))
 *                                 .build())
 *                         .publish(RestrictionTypeProperty.builder()
 *                                 .restrictionMode("restrictionMode")
 *                                 // the properties below are optional
 *                                 .repositories(List.of("repositories"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.760Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codeartifact.CfnPackageGroup")
public class CfnPackageGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnPackageGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPackageGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codeartifact.CfnPackageGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPackageGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codeartifact.CfnPackageGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * When you pass the logical ID of this resource, the function returns the Amazon Resource Name (ARN) of the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The domain that contains the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain that contains the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * The pattern of the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPattern() {
        return software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The pattern of the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPattern(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pattern", java.util.Objects.requireNonNull(value, "pattern is required"));
    }

    /**
     * The contact information of the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContactInfo() {
        return software.amazon.jsii.Kernel.get(this, "contactInfo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The contact information of the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContactInfo(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "contactInfo", value);
    }

    /**
     * The description of the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The 12-digit account number of the AWS account that owns the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainOwner() {
        return software.amazon.jsii.Kernel.get(this, "domainOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The 12-digit account number of the AWS account that owns the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainOwner(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainOwner", value);
    }

    /**
     * Details about the package origin configuration of a package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOriginConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "originConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Details about the package origin configuration of a package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "originConfiguration", value);
    }

    /**
     * Details about the package origin configuration of a package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codeartifact.CfnPackageGroup.OriginConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "originConfiguration", value);
    }

    /**
     * A list of tags to be applied to the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of tags to be applied to the package group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The package group origin configuration that determines how package versions can enter repositories.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codeartifact.*;
     * OriginConfigurationProperty originConfigurationProperty = OriginConfigurationProperty.builder()
     *         .restrictions(RestrictionsProperty.builder()
     *                 .externalUpstream(RestrictionTypeProperty.builder()
     *                         .restrictionMode("restrictionMode")
     *                         // the properties below are optional
     *                         .repositories(List.of("repositories"))
     *                         .build())
     *                 .internalUpstream(RestrictionTypeProperty.builder()
     *                         .restrictionMode("restrictionMode")
     *                         // the properties below are optional
     *                         .repositories(List.of("repositories"))
     *                         .build())
     *                 .publish(RestrictionTypeProperty.builder()
     *                         .restrictionMode("restrictionMode")
     *                         // the properties below are optional
     *                         .repositories(List.of("repositories"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-originconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-originconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codeartifact.CfnPackageGroup.OriginConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The origin configuration settings that determine how package versions can enter repositories.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-originconfiguration.html#cfn-codeartifact-packagegroup-originconfiguration-restrictions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-originconfiguration.html#cfn-codeartifact-packagegroup-originconfiguration-restrictions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRestrictions();

        /**
         * @return a {@link Builder} of {@link OriginConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginConfigurationProperty> {
            java.lang.Object restrictions;

            /**
             * Sets the value of {@link OriginConfigurationProperty#getRestrictions}
             * @param restrictions The origin configuration settings that determine how package versions can enter repositories. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.IResolvable restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link OriginConfigurationProperty#getRestrictions}
             * @param restrictions The origin configuration settings that determine how package versions can enter repositories. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.services.codeartifact.CfnPackageGroup.RestrictionsProperty restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginConfigurationProperty {
            private final java.lang.Object restrictions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.restrictions = software.amazon.jsii.Kernel.get(this, "restrictions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.restrictions = java.util.Objects.requireNonNull(builder.restrictions, "restrictions is required");
            }

            @Override
            public final java.lang.Object getRestrictions() {
                return this.restrictions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("restrictions", om.valueToTree(this.getRestrictions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codeartifact.CfnPackageGroup.OriginConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginConfigurationProperty.Jsii$Proxy that = (OriginConfigurationProperty.Jsii$Proxy) o;

                return this.restrictions.equals(that.restrictions);
            }

            @Override
            public final int hashCode() {
                int result = this.restrictions.hashCode();
                return result;
            }
        }
    }
    /**
     * The <code>RestrictionType</code> property type specifies the package group origin configuration restriction mode, and the repositories when the <code>RestrictionMode</code> is set to <code>ALLOW_SPECIFIC_REPOSITORIES</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codeartifact.*;
     * RestrictionTypeProperty restrictionTypeProperty = RestrictionTypeProperty.builder()
     *         .restrictionMode("restrictionMode")
     *         // the properties below are optional
     *         .repositories(List.of("repositories"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictiontype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictiontype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codeartifact.CfnPackageGroup.RestrictionTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(RestrictionTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestrictionTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The package group origin restriction setting.
         * <p>
         * When the value is <code>INHERIT</code> , the value is set to the value of the first parent package group which does not have a value of <code>INHERIT</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictiontype.html#cfn-codeartifact-packagegroup-restrictiontype-restrictionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictiontype.html#cfn-codeartifact-packagegroup-restrictiontype-restrictionmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRestrictionMode();

        /**
         * The repositories to add to the allowed repositories list.
         * <p>
         * The allowed repositories list is used when the <code>RestrictionMode</code> is set to <code>ALLOW_SPECIFIC_REPOSITORIES</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictiontype.html#cfn-codeartifact-packagegroup-restrictiontype-repositories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictiontype.html#cfn-codeartifact-packagegroup-restrictiontype-repositories</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRepositories() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RestrictionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestrictionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestrictionTypeProperty> {
            java.lang.String restrictionMode;
            java.util.List<java.lang.String> repositories;

            /**
             * Sets the value of {@link RestrictionTypeProperty#getRestrictionMode}
             * @param restrictionMode The package group origin restriction setting. This parameter is required.
             *                        When the value is <code>INHERIT</code> , the value is set to the value of the first parent package group which does not have a value of <code>INHERIT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictionMode(java.lang.String restrictionMode) {
                this.restrictionMode = restrictionMode;
                return this;
            }

            /**
             * Sets the value of {@link RestrictionTypeProperty#getRepositories}
             * @param repositories The repositories to add to the allowed repositories list.
             *                     The allowed repositories list is used when the <code>RestrictionMode</code> is set to <code>ALLOW_SPECIFIC_REPOSITORIES</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositories(java.util.List<java.lang.String> repositories) {
                this.repositories = repositories;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestrictionTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestrictionTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RestrictionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestrictionTypeProperty {
            private final java.lang.String restrictionMode;
            private final java.util.List<java.lang.String> repositories;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.restrictionMode = software.amazon.jsii.Kernel.get(this, "restrictionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.repositories = software.amazon.jsii.Kernel.get(this, "repositories", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.restrictionMode = java.util.Objects.requireNonNull(builder.restrictionMode, "restrictionMode is required");
                this.repositories = builder.repositories;
            }

            @Override
            public final java.lang.String getRestrictionMode() {
                return this.restrictionMode;
            }

            @Override
            public final java.util.List<java.lang.String> getRepositories() {
                return this.repositories;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("restrictionMode", om.valueToTree(this.getRestrictionMode()));
                if (this.getRepositories() != null) {
                    data.set("repositories", om.valueToTree(this.getRepositories()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codeartifact.CfnPackageGroup.RestrictionTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestrictionTypeProperty.Jsii$Proxy that = (RestrictionTypeProperty.Jsii$Proxy) o;

                if (!restrictionMode.equals(that.restrictionMode)) return false;
                return this.repositories != null ? this.repositories.equals(that.repositories) : that.repositories == null;
            }

            @Override
            public final int hashCode() {
                int result = this.restrictionMode.hashCode();
                result = 31 * result + (this.repositories != null ? this.repositories.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the configured restrictions of the origin controls of a package group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codeartifact.*;
     * RestrictionsProperty restrictionsProperty = RestrictionsProperty.builder()
     *         .externalUpstream(RestrictionTypeProperty.builder()
     *                 .restrictionMode("restrictionMode")
     *                 // the properties below are optional
     *                 .repositories(List.of("repositories"))
     *                 .build())
     *         .internalUpstream(RestrictionTypeProperty.builder()
     *                 .restrictionMode("restrictionMode")
     *                 // the properties below are optional
     *                 .repositories(List.of("repositories"))
     *                 .build())
     *         .publish(RestrictionTypeProperty.builder()
     *                 .restrictionMode("restrictionMode")
     *                 // the properties below are optional
     *                 .repositories(List.of("repositories"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codeartifact.CfnPackageGroup.RestrictionsProperty")
    @software.amazon.jsii.Jsii.Proxy(RestrictionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestrictionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The package group origin restriction setting for external, upstream repositories.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictions.html#cfn-codeartifact-packagegroup-restrictions-externalupstream">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictions.html#cfn-codeartifact-packagegroup-restrictions-externalupstream</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExternalUpstream() {
            return null;
        }

        /**
         * The package group origin restriction setting for internal, upstream repositories.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictions.html#cfn-codeartifact-packagegroup-restrictions-internalupstream">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictions.html#cfn-codeartifact-packagegroup-restrictions-internalupstream</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInternalUpstream() {
            return null;
        }

        /**
         * The package group origin restriction setting for publishing packages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictions.html#cfn-codeartifact-packagegroup-restrictions-publish">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeartifact-packagegroup-restrictions.html#cfn-codeartifact-packagegroup-restrictions-publish</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublish() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestrictionsProperty> {
            java.lang.Object externalUpstream;
            java.lang.Object internalUpstream;
            java.lang.Object publish;

            /**
             * Sets the value of {@link RestrictionsProperty#getExternalUpstream}
             * @param externalUpstream The package group origin restriction setting for external, upstream repositories.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalUpstream(software.amazon.awscdk.IResolvable externalUpstream) {
                this.externalUpstream = externalUpstream;
                return this;
            }

            /**
             * Sets the value of {@link RestrictionsProperty#getExternalUpstream}
             * @param externalUpstream The package group origin restriction setting for external, upstream repositories.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalUpstream(software.amazon.awscdk.services.codeartifact.CfnPackageGroup.RestrictionTypeProperty externalUpstream) {
                this.externalUpstream = externalUpstream;
                return this;
            }

            /**
             * Sets the value of {@link RestrictionsProperty#getInternalUpstream}
             * @param internalUpstream The package group origin restriction setting for internal, upstream repositories.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder internalUpstream(software.amazon.awscdk.IResolvable internalUpstream) {
                this.internalUpstream = internalUpstream;
                return this;
            }

            /**
             * Sets the value of {@link RestrictionsProperty#getInternalUpstream}
             * @param internalUpstream The package group origin restriction setting for internal, upstream repositories.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder internalUpstream(software.amazon.awscdk.services.codeartifact.CfnPackageGroup.RestrictionTypeProperty internalUpstream) {
                this.internalUpstream = internalUpstream;
                return this;
            }

            /**
             * Sets the value of {@link RestrictionsProperty#getPublish}
             * @param publish The package group origin restriction setting for publishing packages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publish(software.amazon.awscdk.IResolvable publish) {
                this.publish = publish;
                return this;
            }

            /**
             * Sets the value of {@link RestrictionsProperty#getPublish}
             * @param publish The package group origin restriction setting for publishing packages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publish(software.amazon.awscdk.services.codeartifact.CfnPackageGroup.RestrictionTypeProperty publish) {
                this.publish = publish;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestrictionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestrictionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestrictionsProperty {
            private final java.lang.Object externalUpstream;
            private final java.lang.Object internalUpstream;
            private final java.lang.Object publish;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.externalUpstream = software.amazon.jsii.Kernel.get(this, "externalUpstream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.internalUpstream = software.amazon.jsii.Kernel.get(this, "internalUpstream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.publish = software.amazon.jsii.Kernel.get(this, "publish", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.externalUpstream = builder.externalUpstream;
                this.internalUpstream = builder.internalUpstream;
                this.publish = builder.publish;
            }

            @Override
            public final java.lang.Object getExternalUpstream() {
                return this.externalUpstream;
            }

            @Override
            public final java.lang.Object getInternalUpstream() {
                return this.internalUpstream;
            }

            @Override
            public final java.lang.Object getPublish() {
                return this.publish;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExternalUpstream() != null) {
                    data.set("externalUpstream", om.valueToTree(this.getExternalUpstream()));
                }
                if (this.getInternalUpstream() != null) {
                    data.set("internalUpstream", om.valueToTree(this.getInternalUpstream()));
                }
                if (this.getPublish() != null) {
                    data.set("publish", om.valueToTree(this.getPublish()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codeartifact.CfnPackageGroup.RestrictionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestrictionsProperty.Jsii$Proxy that = (RestrictionsProperty.Jsii$Proxy) o;

                if (this.externalUpstream != null ? !this.externalUpstream.equals(that.externalUpstream) : that.externalUpstream != null) return false;
                if (this.internalUpstream != null ? !this.internalUpstream.equals(that.internalUpstream) : that.internalUpstream != null) return false;
                return this.publish != null ? this.publish.equals(that.publish) : that.publish == null;
            }

            @Override
            public final int hashCode() {
                int result = this.externalUpstream != null ? this.externalUpstream.hashCode() : 0;
                result = 31 * result + (this.internalUpstream != null ? this.internalUpstream.hashCode() : 0);
                result = 31 * result + (this.publish != null ? this.publish.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codeartifact.CfnPackageGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codeartifact.CfnPackageGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codeartifact.CfnPackageGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codeartifact.CfnPackageGroupProps.Builder();
        }

        /**
         * The domain that contains the package group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-domainname</a>
         * @param domainName The domain that contains the package group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * The pattern of the package group.
         * <p>
         * The pattern determines which packages are associated with the package group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-pattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-pattern</a>
         * @param pattern The pattern of the package group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pattern(final java.lang.String pattern) {
            this.props.pattern(pattern);
            return this;
        }

        /**
         * The contact information of the package group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-contactinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-contactinfo</a>
         * @param contactInfo The contact information of the package group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactInfo(final java.lang.String contactInfo) {
            this.props.contactInfo(contactInfo);
            return this;
        }

        /**
         * The description of the package group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-description</a>
         * @param description The description of the package group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The 12-digit account number of the AWS account that owns the domain.
         * <p>
         * It does not include dashes or spaces.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-domainowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-domainowner</a>
         * @param domainOwner The 12-digit account number of the AWS account that owns the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainOwner(final java.lang.String domainOwner) {
            this.props.domainOwner(domainOwner);
            return this;
        }

        /**
         * Details about the package origin configuration of a package group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-originconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-originconfiguration</a>
         * @param originConfiguration Details about the package origin configuration of a package group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originConfiguration(final software.amazon.awscdk.IResolvable originConfiguration) {
            this.props.originConfiguration(originConfiguration);
            return this;
        }
        /**
         * Details about the package origin configuration of a package group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-originconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-originconfiguration</a>
         * @param originConfiguration Details about the package origin configuration of a package group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originConfiguration(final software.amazon.awscdk.services.codeartifact.CfnPackageGroup.OriginConfigurationProperty originConfiguration) {
            this.props.originConfiguration(originConfiguration);
            return this;
        }

        /**
         * A list of tags to be applied to the package group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-tags</a>
         * @param tags A list of tags to be applied to the package group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codeartifact.CfnPackageGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codeartifact.CfnPackageGroup build() {
            return new software.amazon.awscdk.services.codeartifact.CfnPackageGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
