package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties for <code>BitBucketSource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISource bbSource = Source.bitBucket(BitBucketSourceProps.builder()
 *         .owner("owner")
 *         .repo("repo")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.795Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.BitBucketSourceProps")
@software.amazon.jsii.Jsii.Proxy(BitBucketSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BitBucketSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codebuild.SourceProps {

    /**
     * The BitBucket account/user that owns the repo.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "awslabs";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOwner();

    /**
     * The name of the repo (without the username).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "aws-cdk";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepo();

    /**
     * The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
     * <p>
     * Default: the default branch's HEAD commit ID is used
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "mybranch";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBranchOrRef() {
        return null;
    }

    /**
     * This parameter is used for the <code>name</code> parameter in the Bitbucket commit status.
     * <p>
     * Can use built-in CodeBuild variables, like $AWS_REGION.
     * <p>
     * Default: "AWS CodeBuild $AWS_REGION ($PROJECT_NAME)"
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "My build #$CODEBUILD_BUILD_NUMBER";
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBuildStatusName() {
        return null;
    }

    /**
     * The URL that the build will report back to the source provider.
     * <p>
     * Can use built-in CodeBuild variables, like $AWS_REGION.
     * <p>
     * Default: - link to the AWS Console for CodeBuild to a particular build execution
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "$CODEBUILD_PUBLIC_BUILD_URL";
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBuildStatusUrl() {
        return null;
    }

    /**
     * The depth of history to download.
     * <p>
     * Minimum value is 0.
     * If this value is 0, greater than 25, or not provided,
     * then the full history is downloaded with each build of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCloneDepth() {
        return null;
    }

    /**
     * Whether to fetch submodules while cloning git repo.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFetchSubmodules() {
        return null;
    }

    /**
     * Whether to send notifications on your build's start and end.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReportBuildStatus() {
        return null;
    }

    /**
     * Whether to create a webhook that will trigger a build every time an event happens in the repository.
     * <p>
     * Default: true if any `webhookFilters` were provided, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWebhook() {
        return null;
    }

    /**
     * A list of webhook filters that can constraint what events in the repository will trigger a build.
     * <p>
     * A build is triggered if any of the provided filter groups match.
     * Only valid if <code>webhook</code> was not provided as false.
     * <p>
     * Default: every push and every Pull Request (create or update) triggers a build
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> getWebhookFilters() {
        return null;
    }

    /**
     * Trigger a batch build from a webhook instead of a standard one.
     * <p>
     * Enabling this will enable batch builds on the CodeBuild project.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWebhookTriggersBatchBuild() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BitBucketSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BitBucketSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BitBucketSourceProps> {
        java.lang.String owner;
        java.lang.String repo;
        java.lang.String branchOrRef;
        java.lang.String buildStatusName;
        java.lang.String buildStatusUrl;
        java.lang.Number cloneDepth;
        java.lang.Boolean fetchSubmodules;
        java.lang.Boolean reportBuildStatus;
        java.lang.Boolean webhook;
        java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters;
        java.lang.Boolean webhookTriggersBatchBuild;
        java.lang.String identifier;

        /**
         * Sets the value of {@link BitBucketSourceProps#getOwner}
         * @param owner The BitBucket account/user that owns the repo. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getRepo}
         * @param repo The name of the repo (without the username). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repo(java.lang.String repo) {
            this.repo = repo;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getBranchOrRef}
         * @param branchOrRef The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchOrRef(java.lang.String branchOrRef) {
            this.branchOrRef = branchOrRef;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getBuildStatusName}
         * @param buildStatusName This parameter is used for the <code>name</code> parameter in the Bitbucket commit status.
         *                        Can use built-in CodeBuild variables, like $AWS_REGION.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildStatusName(java.lang.String buildStatusName) {
            this.buildStatusName = buildStatusName;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getBuildStatusUrl}
         * @param buildStatusUrl The URL that the build will report back to the source provider.
         *                       Can use built-in CodeBuild variables, like $AWS_REGION.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildStatusUrl(java.lang.String buildStatusUrl) {
            this.buildStatusUrl = buildStatusUrl;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getCloneDepth}
         * @param cloneDepth The depth of history to download.
         *                   Minimum value is 0.
         *                   If this value is 0, greater than 25, or not provided,
         *                   then the full history is downloaded with each build of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneDepth(java.lang.Number cloneDepth) {
            this.cloneDepth = cloneDepth;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getFetchSubmodules}
         * @param fetchSubmodules Whether to fetch submodules while cloning git repo.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fetchSubmodules(java.lang.Boolean fetchSubmodules) {
            this.fetchSubmodules = fetchSubmodules;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getReportBuildStatus}
         * @param reportBuildStatus Whether to send notifications on your build's start and end.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportBuildStatus(java.lang.Boolean reportBuildStatus) {
            this.reportBuildStatus = reportBuildStatus;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getWebhook}
         * @param webhook Whether to create a webhook that will trigger a build every time an event happens in the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webhook(java.lang.Boolean webhook) {
            this.webhook = webhook;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getWebhookFilters}
         * @param webhookFilters A list of webhook filters that can constraint what events in the repository will trigger a build.
         *                       A build is triggered if any of the provided filter groups match.
         *                       Only valid if <code>webhook</code> was not provided as false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder webhookFilters(java.util.List<? extends software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters) {
            this.webhookFilters = (java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup>)webhookFilters;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getWebhookTriggersBatchBuild}
         * @param webhookTriggersBatchBuild Trigger a batch build from a webhook instead of a standard one.
         *                                  Enabling this will enable batch builds on the CodeBuild project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webhookTriggersBatchBuild(java.lang.Boolean webhookTriggersBatchBuild) {
            this.webhookTriggersBatchBuild = webhookTriggersBatchBuild;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getIdentifier}
         * @param identifier The source identifier.
         *                   This property is required on secondary sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifier(java.lang.String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BitBucketSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BitBucketSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BitBucketSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BitBucketSourceProps {
        private final java.lang.String owner;
        private final java.lang.String repo;
        private final java.lang.String branchOrRef;
        private final java.lang.String buildStatusName;
        private final java.lang.String buildStatusUrl;
        private final java.lang.Number cloneDepth;
        private final java.lang.Boolean fetchSubmodules;
        private final java.lang.Boolean reportBuildStatus;
        private final java.lang.Boolean webhook;
        private final java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters;
        private final java.lang.Boolean webhookTriggersBatchBuild;
        private final java.lang.String identifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repo = software.amazon.jsii.Kernel.get(this, "repo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.branchOrRef = software.amazon.jsii.Kernel.get(this, "branchOrRef", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildStatusName = software.amazon.jsii.Kernel.get(this, "buildStatusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildStatusUrl = software.amazon.jsii.Kernel.get(this, "buildStatusUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloneDepth = software.amazon.jsii.Kernel.get(this, "cloneDepth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.fetchSubmodules = software.amazon.jsii.Kernel.get(this, "fetchSubmodules", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.reportBuildStatus = software.amazon.jsii.Kernel.get(this, "reportBuildStatus", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.webhook = software.amazon.jsii.Kernel.get(this, "webhook", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.webhookFilters = software.amazon.jsii.Kernel.get(this, "webhookFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class)));
            this.webhookTriggersBatchBuild = software.amazon.jsii.Kernel.get(this, "webhookTriggersBatchBuild", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
            this.repo = java.util.Objects.requireNonNull(builder.repo, "repo is required");
            this.branchOrRef = builder.branchOrRef;
            this.buildStatusName = builder.buildStatusName;
            this.buildStatusUrl = builder.buildStatusUrl;
            this.cloneDepth = builder.cloneDepth;
            this.fetchSubmodules = builder.fetchSubmodules;
            this.reportBuildStatus = builder.reportBuildStatus;
            this.webhook = builder.webhook;
            this.webhookFilters = (java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup>)builder.webhookFilters;
            this.webhookTriggersBatchBuild = builder.webhookTriggersBatchBuild;
            this.identifier = builder.identifier;
        }

        @Override
        public final java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public final java.lang.String getRepo() {
            return this.repo;
        }

        @Override
        public final java.lang.String getBranchOrRef() {
            return this.branchOrRef;
        }

        @Override
        public final java.lang.String getBuildStatusName() {
            return this.buildStatusName;
        }

        @Override
        public final java.lang.String getBuildStatusUrl() {
            return this.buildStatusUrl;
        }

        @Override
        public final java.lang.Number getCloneDepth() {
            return this.cloneDepth;
        }

        @Override
        public final java.lang.Boolean getFetchSubmodules() {
            return this.fetchSubmodules;
        }

        @Override
        public final java.lang.Boolean getReportBuildStatus() {
            return this.reportBuildStatus;
        }

        @Override
        public final java.lang.Boolean getWebhook() {
            return this.webhook;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> getWebhookFilters() {
            return this.webhookFilters;
        }

        @Override
        public final java.lang.Boolean getWebhookTriggersBatchBuild() {
            return this.webhookTriggersBatchBuild;
        }

        @Override
        public final java.lang.String getIdentifier() {
            return this.identifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("owner", om.valueToTree(this.getOwner()));
            data.set("repo", om.valueToTree(this.getRepo()));
            if (this.getBranchOrRef() != null) {
                data.set("branchOrRef", om.valueToTree(this.getBranchOrRef()));
            }
            if (this.getBuildStatusName() != null) {
                data.set("buildStatusName", om.valueToTree(this.getBuildStatusName()));
            }
            if (this.getBuildStatusUrl() != null) {
                data.set("buildStatusUrl", om.valueToTree(this.getBuildStatusUrl()));
            }
            if (this.getCloneDepth() != null) {
                data.set("cloneDepth", om.valueToTree(this.getCloneDepth()));
            }
            if (this.getFetchSubmodules() != null) {
                data.set("fetchSubmodules", om.valueToTree(this.getFetchSubmodules()));
            }
            if (this.getReportBuildStatus() != null) {
                data.set("reportBuildStatus", om.valueToTree(this.getReportBuildStatus()));
            }
            if (this.getWebhook() != null) {
                data.set("webhook", om.valueToTree(this.getWebhook()));
            }
            if (this.getWebhookFilters() != null) {
                data.set("webhookFilters", om.valueToTree(this.getWebhookFilters()));
            }
            if (this.getWebhookTriggersBatchBuild() != null) {
                data.set("webhookTriggersBatchBuild", om.valueToTree(this.getWebhookTriggersBatchBuild()));
            }
            if (this.getIdentifier() != null) {
                data.set("identifier", om.valueToTree(this.getIdentifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.BitBucketSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BitBucketSourceProps.Jsii$Proxy that = (BitBucketSourceProps.Jsii$Proxy) o;

            if (!owner.equals(that.owner)) return false;
            if (!repo.equals(that.repo)) return false;
            if (this.branchOrRef != null ? !this.branchOrRef.equals(that.branchOrRef) : that.branchOrRef != null) return false;
            if (this.buildStatusName != null ? !this.buildStatusName.equals(that.buildStatusName) : that.buildStatusName != null) return false;
            if (this.buildStatusUrl != null ? !this.buildStatusUrl.equals(that.buildStatusUrl) : that.buildStatusUrl != null) return false;
            if (this.cloneDepth != null ? !this.cloneDepth.equals(that.cloneDepth) : that.cloneDepth != null) return false;
            if (this.fetchSubmodules != null ? !this.fetchSubmodules.equals(that.fetchSubmodules) : that.fetchSubmodules != null) return false;
            if (this.reportBuildStatus != null ? !this.reportBuildStatus.equals(that.reportBuildStatus) : that.reportBuildStatus != null) return false;
            if (this.webhook != null ? !this.webhook.equals(that.webhook) : that.webhook != null) return false;
            if (this.webhookFilters != null ? !this.webhookFilters.equals(that.webhookFilters) : that.webhookFilters != null) return false;
            if (this.webhookTriggersBatchBuild != null ? !this.webhookTriggersBatchBuild.equals(that.webhookTriggersBatchBuild) : that.webhookTriggersBatchBuild != null) return false;
            return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.owner.hashCode();
            result = 31 * result + (this.repo.hashCode());
            result = 31 * result + (this.branchOrRef != null ? this.branchOrRef.hashCode() : 0);
            result = 31 * result + (this.buildStatusName != null ? this.buildStatusName.hashCode() : 0);
            result = 31 * result + (this.buildStatusUrl != null ? this.buildStatusUrl.hashCode() : 0);
            result = 31 * result + (this.cloneDepth != null ? this.cloneDepth.hashCode() : 0);
            result = 31 * result + (this.fetchSubmodules != null ? this.fetchSubmodules.hashCode() : 0);
            result = 31 * result + (this.reportBuildStatus != null ? this.reportBuildStatus.hashCode() : 0);
            result = 31 * result + (this.webhook != null ? this.webhook.hashCode() : 0);
            result = 31 * result + (this.webhookFilters != null ? this.webhookFilters.hashCode() : 0);
            result = 31 * result + (this.webhookTriggersBatchBuild != null ? this.webhookTriggersBatchBuild.hashCode() : 0);
            result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
            return result;
        }
    }
}
