package software.amazon.awscdk.services.codebuild;

/**
 * A CodeBuild image running aarch64 Lambda.
 * <p>
 * This class has a bunch of public constants that represent the CodeBuild aarch64 Lambda images.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codebuild.*;
 * IBuildImage linuxArmLambdaBuildImage = LinuxArmLambdaBuildImage.AMAZON_LINUX_2_CORRETTO_11;
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:42:48.874Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.LinuxArmLambdaBuildImage")
public class LinuxArmLambdaBuildImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBuildImage {

    protected LinuxArmLambdaBuildImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LinuxArmLambdaBuildImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON_LINUX_2_CORRETTO_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2_CORRETTO_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_CORRETTO_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2_CORRETTO_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_DOTNET_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2_DOTNET_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_GO_1_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2_GO_1_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_NODE_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2_NODE_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_PYTHON_3_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2_PYTHON_3_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_RUBY_3_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2_RUBY_3_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2023_CORRETTO_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2023_CORRETTO_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2023_DOTNET_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2023_DOTNET_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2023_NODE_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2023_NODE_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2023_PYTHON_3_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmLambdaBuildImage.class, "AMAZON_LINUX_2023_PYTHON_3_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
    }

    /**
     * Make a buildspec to run the indicated script.
     * <p>
     * @param entrypoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec runScriptBuildspec(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint) {
        return software.amazon.jsii.Kernel.call(this, "runScriptBuildspec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(entrypoint, "entrypoint is required") });
    }

    /**
     * Allows the image a chance to validate whether the passed configuration is correct.
     * <p>
     * @param buildEnvironment This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(buildEnvironment, "buildEnvironment is required") }));
    }

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:corretto11</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_CORRETTO_11;

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:corretto17</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_CORRETTO_17;

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:dotnet6</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_DOTNET_6;

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:go1.21</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_GO_1_21;

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:nodejs18</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_NODE_18;

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:python3.11</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_PYTHON_3_11;

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:ruby3.2</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_RUBY_3_2;

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:corretto21</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2023_CORRETTO_21;

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:dotnet8</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2023_DOTNET_8;

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:nodejs20</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2023_NODE_20;

    /**
     * The <code>aws/codebuild/amazonlinux-aarch64-lambda-standard:python3.12</code> build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2023_PYTHON_3_12;

    /**
     * The default <code>ComputeType</code> to use with this image, if one was not specified in <code>BuildEnvironment#computeType</code> explicitly.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
        return software.amazon.jsii.Kernel.get(this, "defaultComputeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ComputeType.class));
    }

    /**
     * The Docker image identifier that the build environment uses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageId() {
        return software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of build environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
